﻿
StiMobileDesigner.prototype.InitializeReportCheckForm_ = function () {
    var jsObject = this;
    var reportCheckForm = this.BaseForm("reportCheckForm", this.loc.Report.ReportChecker, 3, this.HelpLinks["reportCheck"]);
    reportCheckForm.buttonsPanel.style.display = reportCheckForm.buttonsSeparator.style.display = "none";

    var checkPanel = jsObject.InitializeCheckPanel();
    reportCheckForm.container.appendChild(checkPanel);

    reportCheckForm.show = function (checkItems) {
        checkPanel.update(checkItems);
        reportCheckForm.changeVisibleState(true);
    }

    return reportCheckForm;
}


StiMobileDesigner.prototype.InitializeCheckPanel = function () {
    var checkPanel = document.createElement("div");
    checkPanel.className = "stiDesignerCheckPanel";
    var jsObject = checkPanel.jsObject = this;
    checkPanel.controls = {};

    var toolBar = document.createElement("div");
    toolBar.style.textAlign = "right";

    var settingsButton = this.StandartSmallButton(null, null, null, "Settings.png", null, "Down");
    settingsButton.style.display = "inline-block";
    settingsButton.style.margin = "6px";
    toolBar.appendChild(settingsButton);

    checkPanel.appendChild(toolBar);
    checkPanel.appendChild(this.FormSeparator());

    var settingsMenu = this.VerticalMenu("reportCheckSettingsMenu", settingsButton, "Down", [], this.GetStyles("MenuStandartItem"));

    settingsButton.action = function () {
        settingsMenu.changeVisibleState(!settingsMenu.visible);
    }

    //Toolbar
    var buttons = [
        ["Error", this.loc.Report.Errors, "ReportChecker.Error.png"],
        ["Warning", this.loc.Report.Warnings, "ReportChecker.Warning.png"],
        ["Information", this.loc.Report.InformationMessages, "ReportChecker.Information.png"],
        ["ReportRenderingMessage", this.loc.Report.ReportRenderingMessages, "ReportChecker.ReportRenderingMessage.png"]
    ]

    for (var i = 0; i < buttons.length; i++) {
        var button = this.StandartSmallButton(null, null, buttons[i][1], buttons[i][2], null, null, true);
        button.name = buttons[i][0];
        button.style.margin = "4px";
        checkPanel.controls[buttons[i][0] + "Button"] = button;
        settingsMenu.innerContent.appendChild(button);        
        button.setSelected(true);

        button.action = function () {
            this.setSelected(!this.isSelected);
            checkPanel.container.fill(checkPanel.checkItems);
        }
    }

    //Container
    var container = this.ReportCheckContainer(checkPanel);
    checkPanel.container = container;
    checkPanel.appendChild(container);

    checkPanel.update = function (checkItems) {
        this.checkItems = checkItems;

        if (checkItems) {
            container.progress.hide();
            container.fill(checkItems);
        }
        else {
            jsObject.SendCommandGetReportCheckItems(function (answer) {
                checkPanel.checkItems = answer.checkItems;
                container.progress.hide();
                container.fill(answer.checkItems);
            });
        }
    }

    return checkPanel;
}

StiMobileDesigner.prototype.ReportCheckContainer = function (checkPanel) {
    var container = document.createElement("div");
    var jsObject = container.jsObject = this;
    container.className = "stiDesignerCheckContainer";
    this.AddProgressToControl(container);

    container.clear = function () {
        while (this.childNodes[0]) this.removeChild(this.childNodes[0]);
    }

    container.fill = function (checkItems) {
        this.clear();
        if (!checkItems) return;
        var num = 1;

        for (var i = 0; i < checkItems.length; i++) {
            if (checkPanel.controls[checkItems[i].status + "Button"] && checkPanel.controls[checkItems[i].status + "Button"].isSelected) {
                var checkItem = jsObject.ReportCheckContainerItem(num, checkItems[i], checkPanel);
                checkItems[i].index = i;
                num++;
                this.appendChild(checkItem);
            }
        }

        if (this.childNodes.length == 0) {
            var noIssues = document.createElement("div");
            noIssues.innerHTML = jsObject.loc.Report.NoIssues;
            noIssues.style.textAlign = "center";
            noIssues.style.marginTop = "200px";
            this.appendChild(noIssues);
        }
    }

    return container;
}

StiMobileDesigner.prototype.ReportCheckContainerItem = function (num, checkObject, checkPanel) {
    var checkItem = document.createElement("div");
    checkItem.className = "stiDesignerCheckContainerItem";

    var mainTable = this.CreateHTMLTable();
    mainTable.style.width = "100%";
    checkItem.appendChild(mainTable);
    var upTable = this.CreateHTMLTable();
    mainTable.addCell(upTable);

    //Image
    var img = document.createElement("img");
    img.style.marginRight = "12px";
    img.src = this.options.images["ReportChecker." + checkObject.status + "32.png"];
    upTable.addCell(img);

    var shortMessage = checkObject.shortMessage;
    if (!shortMessage) {
        switch (checkObject.status) {
            case "Error": shortMessage = this.loc.Report.Errors; break;
            case "Warning": shortMessage = this.loc.Report.Warnings; break;
            case "Information": shortMessage = this.loc.Report.InformationMessages; break;
            case "ReportRenderingMessage": shortMessage = this.loc.Report.ReportRenderingMessages; break;
        }
    }

    var messageText = num + ". <b>" + shortMessage + "</b><br><br>" + checkObject.longMessage;
    var textCell = upTable.addTextCell(messageText);

    var downTable = this.CreateHTMLTable();
    downTable.style.float = "right";
    mainTable.addCellInNextRow(downTable);

    //Actions
    for (var i = 0; i < checkObject.actions.length; i++) {
        if (checkObject.actions[i].name == "Edit") continue; //Temporary

        var actionButton = this.SmallButton(null, null, checkObject.actions[i].name, null, checkObject.actions[i].description, null, this.GetStyles("FormButton"), true);
        actionButton.actionIndex = i;
        actionButton.style.margin = "12px 0 12px 12px";
        downTable.addCell(actionButton);

        if (checkObject.actions[i].name == "Purchase") {
            actionButton.action = function () {
                this.jsObject.openNewWindow("https://www.stimulsoft.com/" + this.jsObject.options.helpLanguage + "/online-store");
            }
        }
        else {
            actionButton.action = function () {
                var this_ = this;
                this.setEnabled(false);
                this.jsObject.SendCommandActionCheck(checkObject.index, this.actionIndex, function (answer) {
                    this_.setEnabled(true);
                    if (answer.checkItems) {
                        checkPanel.container.fill(answer.checkItems);
                    }

                    if (answer.reportGuid && answer.reportObject) {
                        actionButton.jsObject.options.reportGuid = answer.reportGuid;
                        actionButton.jsObject.LoadReport(actionButton.jsObject.ParseReport(answer.reportObject), true);
                        actionButton.jsObject.options.reportIsModified = true;
                    }
                    actionButton.jsObject.BackToSelectedComponent(answer.selectedObjectName);
                });
            }
        }
    }

    //Clipboard Button    
    var clipboardButton = this.SmallButton(null, null, null, "Copy.png", this.loc.HelpDesigner.CopyToClipboard, null, this.GetStyles("FormButton"), true);
    clipboardButton.style.margin = "12px 0 12px 12px";;
    clipboardButton.action = function () {
        this.jsObject.copyTextToClipboard(num + "." + shortMessage + "\r\n" + checkObject.longMessage);
    }
    downTable.addCell(clipboardButton);

    //View Button
    if (checkObject.previewVisible) {
        var viewButton = this.SmallButton(null, null, null, "View.png", this.loc.Toolbars.TabView, null, this.GetStyles("FormButton"), true);
        viewButton.style.margin = "12px 0 12px 12px";
        downTable.addCell(viewButton);

        viewButton.action = function () {
            viewButton.setEnabled(false);
            if (this.jsObject.options.jsMode) {
                viewButton.setEnabled(true);
                var pageIndex = 0;
                if (checkObject.pageIndex != null) pageIndex = checkObject.pageIndex;
                var pageSvg = this.jsObject.GetSvgPageForCheckPreview(pageIndex, checkObject.elementName);
                var checkPreviewPanel = viewButton.jsObject.InitializeCheckPreviewPanel(viewButton, null);
                checkPreviewPanel.appendChild(pageSvg);
                checkPreviewPanel.show();
            }
            else {
                this.jsObject.SendCommandGetCheckPreview(checkObject.index, function (answer) {
                    viewButton.setEnabled(true);
                    var checkPreviewPanel = viewButton.jsObject.InitializeCheckPreviewPanel(viewButton, answer.previewImage);
                    checkPreviewPanel.show();
                });
            }
        }
    }

    return checkItem;
}

StiMobileDesigner.prototype.InitializeCheckPreviewPanel = function (parentButton, previewImageSrc) {
    var checkPreviewPanel = document.createElement("div");
    if (this.options.checkPreviewPanel) {
        this.options.checkPreviewPanel.hide();
    }

    this.options.checkPreviewPanel = checkPreviewPanel;
    this.options.mainPanel.appendChild(checkPreviewPanel);
    checkPreviewPanel.className = "stiDesignerCheckPreviewPanel";
    checkPreviewPanel.jsObject = this;

    checkPreviewPanel.hide = function () {
        this.jsObject.options.mainPanel.removeChild(this);
        this.jsObject.options.checkPreviewPanel = null;
        parentButton.setSelected(false);
    }

    checkPreviewPanel.show = function () {
        checkPreviewPanel.style.left = (this.jsObject.FindPosX(parentButton, "stiDesignerMainPanel") + parentButton.offsetWidth + 5) + "px";
        var top = (this.jsObject.FindPosY(parentButton, "stiDesignerMainPanel") - checkPreviewPanel.offsetHeight - 5);
        checkPreviewPanel.style.top = (top < 0 ? 0 : top) + "px";
        parentButton.setSelected(true);
    }

    if (previewImageSrc) {
        var previewImage = document.createElement("img");
        previewImage.src = previewImageSrc;
        checkPreviewPanel.appendChild(previewImage);
    }

    return checkPreviewPanel;
}

StiMobileDesigner.prototype.GetSvgPageForCheckPreview = function (pageIndex, elementName, zoom, onlyPage, pageProperties) {
    var oldPaintPanelPadding = this.options.paintPanelPadding;
    this.options.paintPanelPadding = 0;
    var previewZoom = zoom || 0.4;

    var page = this.options.paintPanel.findPageByIndex(pageIndex);

    var pageObject = {
        name: page.properties.name,
        pageIndex: page.properties.pageIndex,
        properties: pageProperties || this.CopyObject(page.properties),
        components: page.components,
        valid: page.valid
    }

    var showGrid = this.options.report.info.showGrid;
    this.options.report.info.showGrid = false;

    var pageSvg = this.CreatePage(pageObject);
    pageSvg.isDashboard = page.isDashboard;
    pageSvg.onmousedown = null;
    pageSvg.ondblclick = null;
    pageSvg.onmousedown = null;
    pageSvg.onmousemove = null;
    pageSvg.onmouseup = null;
    pageSvg.style.display = "";
    pageSvg.className = "";
    pageSvg.style.boxShadow = "";
    pageSvg.repaint();

    this.options.report.info.showGrid = showGrid;

    if (!onlyPage) {
        for (var compName in page.components) {
            var cloneComponent = this.CloneComponent(page.components[compName]);
            cloneComponent.onmousedown = null;
            cloneComponent.ondblclick = null;
            cloneComponent.onmousedown = null;
            cloneComponent.onmousemove = null;
            cloneComponent.onmouseup = null;
            if (compName == elementName) {
                cloneComponent.properties.border = "1,1,1,1!3!255,0,0!0!0!4";
            }
            pageSvg.appendChild(cloneComponent);
            cloneComponent.repaint();
        }
    }

    var width = parseInt(pageSvg.getAttribute("width"));
    var height = parseInt(pageSvg.getAttribute("height"));
    pageSvg.setAttribute("viewBox", "0,0," + width + "," + height);
    pageSvg.setAttribute("width", (previewZoom * width) / this.options.report.zoom);
    pageSvg.setAttribute("height", (previewZoom * height) / this.options.report.zoom);

    this.options.paintPanelPadding = oldPaintPanelPadding;

    return pageSvg
}