﻿
StiMobileDesigner.prototype.InitializeEditTableElementForm_ = function () {
    var form = this.DashboardBaseForm("editTableElementForm", this.loc.Components.StiTable, 1);
    form.isDockableToComponent = true;
    form.buttonsSeparator.style.display = "none";
    form.buttonsPanel.style.display = "none";
    form.container.style.borderTop = "0px";
    form.caption.style.padding = "0px 10px 0 12px";
    var jsObject = this;

    var controlsTable = this.CreateHTMLTable();
    form.container.appendChild(controlsTable);
    form.container.style.padding = "0 0 6px 0";
    
    //Data Container
    var dataContainer = this.TableElementDataContainer(null, 280, true, form);
    dataContainer.style.minWidth = "280px";
    form.addControlRow(controlsTable, null, "dataContainer", dataContainer, "6px 12px 6px 12px");

    //Column Types
    var meterTypes = ["Dimension", "Measure", "DataBars", "ColorScale", "Indicator", "Sparklines"];
    var meterTypesTable = this.CreateHTMLTable();
    meterTypesTable.buttons = {};
    for (var i = 0; i < meterTypes.length; i++) {
        var button = this.SmallImageButtonWithBorder(null, null, "Meters." + meterTypes[i] + ".png", this.loc.Dashboard[meterTypes[i]]);
        button.meterType = meterTypes[i];
        button.style.marginRight = "5px";
        meterTypesTable.addCell(button);
        meterTypesTable.buttons[meterTypes[i]] = button;

        button.action = function () {
            this.select();
            var itemIndex = dataContainer.getSelectedItemIndex()

            form.sendCommand({ command: "ConvertMeter", itemIndex: itemIndex, meterType: this.meterType },
                function (answer) {
                    dataContainer.updateMeters(answer.elementProperties.meters, itemIndex);
                    form.updateSvgContent(answer.elementProperties.svgContent);
                }
            );
        }

        button.select = function () {
            for (var name in meterTypesTable.buttons) {
                meterTypesTable.buttons[name].setSelected(false);
            }
            this.setSelected(true);
        }
    }
    form.addControlRow(controlsTable, this.loc.PropertyMain.Type, "meterTypesTable", meterTypesTable, "6px 12px 6px 0");    

    //Expression
    var expressionControl = this.ExpressionControlWithMenu(null, 150, null, null);
    form.addControlRow(controlsTable, this.loc.PropertyMain.Expression, "expressionControl", expressionControl, "6px 12px 6px 0");
    form.expressionMenu = this.options.menus.tableElementExpressionMenu || this.InitializeTableElementExpressionMenu("tableElementExpressionMenu", expressionControl, dataContainer, form);
    expressionControl.menu = form.expressionMenu;
    form.expressionMenu.parentButton = expressionControl.button;

    expressionControl.action = function () {
        form.setPropertyValue("Exspression", Base64.encode(this.textBox.value));
    }
    
    //SparkLines Types
    var sparklinesTypes = ["Line", "Area", "Column", "WinLoss"];
    var sparklinesTable = this.CreateHTMLTable();
    sparklinesTable.buttons = {};
    for (var i = 0; i < sparklinesTypes.length; i++) {
        var button = this.SmallImageButtonWithBorder(null, null, "Meters.Sparklines" + sparklinesTypes[i] + ".png", this.loc.Chart["Sparklines" + sparklinesTypes[i]]);
        button.sparklinesType = sparklinesTypes[i];
        button.style.marginRight = "5px";
        sparklinesTable.addCell(button);
        sparklinesTable.buttons[sparklinesTypes[i]] = button;

        button.action = function () {
            this.select();
            var itemIndex = dataContainer.getSelectedItemIndex()

            form.sendCommand({ command: "ChangeSparklinesType", itemIndex: itemIndex, sparklinesType: this.sparklinesType },
                function (answer) {
                    dataContainer.updateMeters(answer.elementProperties.meters, itemIndex);
                    form.updateSvgContent(answer.elementProperties.svgContent);
                }
            );
        }

        button.select = function () {
            for (var name in sparklinesTable.buttons) {
                sparklinesTable.buttons[name].setSelected(false);
            }
            this.setSelected(true);
        }
    }
    form.addControlRow(controlsTable, this.loc.Dashboard.Sparklines, "sparklinesTable", sparklinesTable, "6px 12px 6px 0");

    //HighLowPoints
    var highLowPoints = this.CheckBox(null, this.loc.Dashboard.HighLowPoints);
    form.addControlRow(controlsTable, this.loc.Dashboard.HighLowPoints, "highLowPoints", highLowPoints, "10px 12px 10px 0");

    highLowPoints.action = function () {
        form.setPropertyValue("ShowHighLowPoints", this.isChecked);
    }

    //FirstLastPoints
    var firstLastPoints = this.CheckBox(null, this.loc.Dashboard.FirstLastPoints);
    form.addControlRow(controlsTable, this.loc.Dashboard.FirstLastPoints, "firstLastPoints", firstLastPoints, "10px 12px 10px 0");

    firstLastPoints.action = function () {
        form.setPropertyValue("ShowFirstLastPoints", this.isChecked);
    }

    expressionControl.refreshExpressionHint = function () {
        if (meterTypesTable.buttons.Dimension.isSelected)
            expressionControl.textBox.setAttribute("placeholder", "Field");

        else if (meterTypesTable.buttons.Measure.isSelected || meterTypesTable.buttons.DataBars.isSelected || meterTypesTable.buttons.ColorScale.isSelected)
            expressionControl.textBox.setAttribute("placeholder", "Sum(Field)");

        else if (meterTypesTable.buttons.Sparklines.isSelected)
            expressionControl.textBox.setAttribute("placeholder", "Field");

        else if (meterTypesTable.buttons.Indicator.isSelected)
            expressionControl.textBox.setAttribute("placeholder", "Sum(Field) / Sum(Target)");
        else
            expressionControl.textBox.setAttribute("placeholder", "");
    }
                
    form.setPropertyValue = function (propertyName, propertyValue) {
        form.sendCommand(
            {
                command: "SetPropertyValue",
                propertyName: propertyName,
                propertyValue: propertyValue,
                itemIndex: dataContainer.getSelectedItemIndex()
            },
            function (answer) {
                dataContainer.updateMeters(answer.elementProperties.meters, dataContainer.getSelectedItemIndex());
                form.updateSvgContent(answer.elementProperties.svgContent);
            }
        );
    }

    form.onshow = function () {
        form.currentPanelName = form.jsObject.options.propertiesPanel.getCurrentPanelName();
        form.jsObject.options.propertiesPanel.showContainer("Dictionary");
        dataContainer.clear();
        form.sendCommand({ command: "GetTableElementProperties" },
            function (answer) {
                dataContainer.updateMeters(answer.elementProperties.meters, 0);
            }
        );
    }

    form.onhide = function () {
        form.jsObject.options.propertiesPanel.showContainer(form.currentPanelName);
    }

    form.sendCommand = function (updateParameters, callbackFunction) {
        updateParameters.zoom = form.jsObject.options.report.zoom.toString();

        form.jsObject.SendCommandToDesignerServer("UpdateTableElement",
            {
                componentName: form.currentTableElement.properties.name,
                updateParameters: updateParameters
            },
            function (answer) {
                callbackFunction(answer);
            });
    }

    form.updateSvgContent = function (svgContent) {
        this.currentTableElement.properties.svgContent = svgContent;
        this.currentTableElement.repaint();
    }

    return form;
}

StiMobileDesigner.prototype.TableElementDataContainer = function (width, height, showItemImage, form) {
    var dataContainer = this.DataContainer(width, height, showItemImage);

    dataContainer.updateMeters = function (meters, selectedIndex) {
        var oldScrollTop = this.scrollTop;
        this.clear();
        for (var i = 0; i < meters.length; i++) {
            this.addItem(meters[i].label, "Meters." + meters[i].typeIcon + ".png", meters[i]);
        }
        if (selectedIndex != null && selectedIndex >= 0 && selectedIndex < meters.length) {
            this.childNodes[selectedIndex].select();
        }
        this.scrollTop = oldScrollTop;
    }

    dataContainer.onmouseup = function (event) {
        if (event.button == 2) {
            event.stopPropagation();
            var point = this.jsObject.FindMousePosOnMainPanel(event);
            form.expressionMenu.show(point.xPixels + 3, point.yPixels + 3, "Down", "Right");
        }
        else if (this.jsObject.options.itemInDrag) {
            var itemObject = this.jsObject.CopyObject(this.jsObject.options.itemInDrag.originalItem.itemObject);
            if (!itemObject) return;
            var typeItem = itemObject.typeItem;

            if (typeItem == "Meter") {
                var toIndex = this.getOverItemIndex();
                var fromIndex = this.getItemIndex(this.jsObject.options.itemInDrag.originalItem);
                if (toIndex != null && fromIndex != null && fromIndex != toIndex) {
                    form.sendCommand({ command: "MoveMeter", toIndex: toIndex, fromIndex: fromIndex },
                        function (answer) {
                            dataContainer.updateMeters(answer.elementProperties.meters, toIndex);
                            form.updateSvgContent(answer.elementProperties.svgContent);
                        }
                    );

                    var fromIndex = this.getItemIndex(this.jsObject.options.itemInDrag.originalItem);
                }
            }
            else if (typeItem == "Column" || typeItem == "DataSource" || typeItem == "BusinessObject") {
                var draggedItem = {
                    itemObject: itemObject
                };

                if (typeItem == "Column") {
                    var columnParent = this.jsObject.options.dictionaryTree.getCurrentColumnParent();
                    if (columnParent) {
                        draggedItem.currentParentType = columnParent.type;
                        draggedItem.currentParentName = (columnParent.type == "BusinessObject") ? this.jsObject.options.itemInDrag.originalItem.getBusinessObjectFullName() : columnParent.name;
                    }
                }
                else {
                    draggedItem.currentParentType = typeItem;
                    draggedItem.currentParentName = itemObject.name;
                }

                var params = {
                    command: "InsertMeters",
                    draggedItem: draggedItem
                }

                if (typeItem == "Column") {
                    params.insertIndex = dataContainer.getOverItemIndex();
                }

                form.sendCommand(params,
                    function (answer) {
                        dataContainer.updateMeters(answer.elementProperties.meters, params.insertIndex != null ? params.insertIndex : answer.elementProperties.meters.length - 1);
                        form.updateSvgContent(answer.elementProperties.svgContent);
                    }
                );
            }
        }

        return false;
    }

    dataContainer.oncontextmenu = function (event) {
        return false;
    }

    dataContainer.onRemove = function (itemIndex) {
        form.sendCommand({ command: "RemoveMeter", itemIndex: itemIndex },
            function (answer) {
                dataContainer.updateMeters(answer.elementProperties.meters, dataContainer.getSelectedItemIndex());
                form.updateSvgContent(answer.elementProperties.svgContent);
            }
        );
    }

    dataContainer.onAction = function () {
        var controls = form.controls;

        if (this.selectedItem) {
            var itemObject = this.selectedItem.itemObject;

            if (controls.meterTypesTable.buttons[itemObject.type]) {
                controls.meterTypesTable.buttons[itemObject.type].select();
            }
            if (itemObject.type == "Sparklines") {
                if (controls.sparklinesTable.buttons[itemObject.sparklinesType]) {
                    controls.sparklinesTable.buttons[itemObject.sparklinesType].select();
                }
                controls.highLowPoints.setChecked(itemObject.showHighLowPoints);
                controls.firstLastPoints.setChecked(itemObject.showFirstLastPoints);
            }
            controls.expressionControl.textBox.value = Base64.decode(itemObject.expression);
        }

        controls.meterTypesTableRow.style.display = controls.expressionControlRow.style.display = this.selectedItem != null ? "" : "none";
        controls.sparklinesTableRow.style.display = this.selectedItem != null && controls.meterTypesTable.buttons.Sparklines.isSelected ? "" : "none";
        controls.highLowPointsRow.style.display = controls.firstLastPointsRow.style.display =
            this.selectedItem != null && controls.meterTypesTable.buttons.Sparklines.isSelected &&
            (controls.sparklinesTable.buttons.Line.isSelected || controls.sparklinesTable.buttons.Area.isSelected) ? "" : "none";

        controls.expressionControl.refreshExpressionHint();
    }

    return dataContainer;
}