/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiTextFormatState;
import com.stimulsoft.report.components.textFormats.StiBooleanFormatService;
import com.stimulsoft.report.components.textFormats.StiCurrencyFormatService;
import com.stimulsoft.report.components.textFormats.StiCustomFormatService;
import com.stimulsoft.report.components.textFormats.StiDateFormatService;
import com.stimulsoft.report.components.textFormats.StiFormatService;
import com.stimulsoft.report.components.textFormats.StiGeneralFormatService;
import com.stimulsoft.report.components.textFormats.StiNumberFormatService;
import com.stimulsoft.report.components.textFormats.StiPercentageFormatService;
import com.stimulsoft.report.components.textFormats.StiTimeFormatService;
import java.util.ArrayList;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class StiTextFormatHelper {
    private static final Logger LOGGER = Logger.getLogger("com.stimulsoft.webdesigner.helper.StiTextFormatHelper");

    public static HashMap<String, Object> generalTextFormatItem(StiGeneralFormatService service) {
        HashMap<String, Object> textFormatItem = StiTextFormatHelper.commonTextFormatItem((StiFormatService)service);
        return textFormatItem;
    }

    public static HashMap<String, Object> numberTextFormatItem(StiNumberFormatService service) {
        HashMap<String, Object> textFormatItem = StiTextFormatHelper.commonTextFormatItem((StiFormatService)service);
        textFormatItem.put("useGroupSeparator", service.getUseGroupSeparator());
        textFormatItem.put("useLocalSetting", service.getUseLocalSetting());
        textFormatItem.put("decimalDigits", service.getDecimalDigits());
        textFormatItem.put("decimalSeparator", service.getDecimalSeparator());
        textFormatItem.put("groupSeparator", service.getGroupSeparator());
        textFormatItem.put("groupSize", service.getGroupSize());
        textFormatItem.put("numberNegativePattern", service.getNegativePattern());
        textFormatItem.put("state", service.getState().toString());
        return textFormatItem;
    }

    public static HashMap<String, Object> currencyTextFormatItem(StiCurrencyFormatService service) {
        HashMap<String, Object> textFormatItem = StiTextFormatHelper.commonTextFormatItem((StiFormatService)service);
        textFormatItem.put("useGroupSeparator", service.getUseGroupSeparator());
        textFormatItem.put("useLocalSetting", service.getUseLocalSetting());
        textFormatItem.put("decimalDigits", service.getDecimalDigits());
        textFormatItem.put("decimalSeparator", service.getDecimalSeparator());
        textFormatItem.put("groupSeparator", service.getGroupSeparator());
        textFormatItem.put("groupSize", service.getGroupSize());
        textFormatItem.put("currencyPositivePattern", service.getPositivePattern());
        textFormatItem.put("currencyNegativePattern", service.getNegativePattern());
        textFormatItem.put("currencySymbol", service.getSymbol());
        textFormatItem.put("state", service.getState().toString());
        return textFormatItem;
    }

    public static HashMap<String, Object> dateTextFormatItem(StiDateFormatService service) {
        HashMap<String, Object> textFormatItem = StiTextFormatHelper.commonTextFormatItem((StiFormatService)service);
        textFormatItem.put("dateFormat", service.getStringFormat());
        return textFormatItem;
    }

    public static HashMap<String, Object> timeTextFormatItem(StiTimeFormatService service) {
        HashMap<String, Object> textFormatItem = StiTextFormatHelper.commonTextFormatItem((StiFormatService)service);
        textFormatItem.put("timeFormat", service.getStringFormat());
        return textFormatItem;
    }

    public static HashMap<String, Object> percentageTextFormatItem(StiPercentageFormatService service) {
        HashMap<String, Object> textFormatItem = StiTextFormatHelper.commonTextFormatItem((StiFormatService)service);
        textFormatItem.put("useGroupSeparator", service.getUseGroupSeparator());
        textFormatItem.put("useLocalSetting", service.getUseLocalSetting());
        textFormatItem.put("decimalDigits", service.getDecimalDigits());
        textFormatItem.put("decimalSeparator", service.getDecimalSeparator());
        textFormatItem.put("groupSeparator", service.getGroupSeparator());
        textFormatItem.put("groupSize", service.getGroupSize());
        textFormatItem.put("percentagePositivePattern", service.getPositivePattern());
        textFormatItem.put("percentageNegativePattern", service.getNegativePattern());
        textFormatItem.put("percentageSymbol", service.getSymbol());
        textFormatItem.put("state", service.getState().toString());
        return textFormatItem;
    }

    public static HashMap<String, Object> booleanTextFormatItem(StiBooleanFormatService service) {
        HashMap<String, Object> textFormatItem = StiTextFormatHelper.commonTextFormatItem((StiFormatService)service);
        textFormatItem.put("falseValue", service.getFalseValue());
        textFormatItem.put("falseDisplay", service.getFalseDisplay());
        textFormatItem.put("trueValue", service.getTrueValue());
        textFormatItem.put("trueDisplay", service.getTrueDisplay());
        return textFormatItem;
    }

    public static HashMap<String, Object> customTextFormatItem(StiCustomFormatService service) {
        HashMap<String, Object> textFormatItem = StiTextFormatHelper.commonTextFormatItem((StiFormatService)service);
        textFormatItem.put("customFormat", service.getStringFormat());
        return textFormatItem;
    }

    public static HashMap<String, Object> commonTextFormatItem(StiFormatService service) {
        HashMap<String, Object> textFormatItem = new HashMap<String, Object>();
        textFormatItem.put("type", service.getClass().getName().substring(service.getClass().getName().lastIndexOf(46) + 1));
        textFormatItem.put("sample", service.getSample().toString());
        return textFormatItem;
    }

    private static StiEnumSet<StiTextFormatState> getStateProperty(String propertyValue) {
        StiEnumSet value = StiEnumSet.of((Enum)StiTextFormatState.None);
        if (propertyValue.indexOf("DecimalDigits") >= 0) {
            value.add((IStiEnum)StiTextFormatState.DecimalDigits);
        }
        if (propertyValue.indexOf("DecimalSeparator") >= 0) {
            value.add((IStiEnum)StiTextFormatState.DecimalSeparator);
        }
        if (propertyValue.indexOf("GroupSeparator") >= 0) {
            value.add((IStiEnum)StiTextFormatState.GroupSeparator);
        }
        if (propertyValue.indexOf("GroupSize") >= 0) {
            value.add((IStiEnum)StiTextFormatState.GroupSize);
        }
        if (propertyValue.indexOf("PositivePattern") >= 0) {
            value.add((IStiEnum)StiTextFormatState.PositivePattern);
        }
        if (propertyValue.indexOf("NegativePattern") >= 0) {
            value.add((IStiEnum)StiTextFormatState.NegativePattern);
        }
        if (propertyValue.indexOf("CurrencySymbol") >= 0) {
            value.add((IStiEnum)StiTextFormatState.CurrencySymbol);
        }
        if (propertyValue.indexOf("PercentageSymbol") >= 0) {
            value.add((IStiEnum)StiTextFormatState.PercentageSymbol);
        }
        return value;
    }

    public static ArrayList<Object> getCurrencySymbols() {
        ArrayList<Object> currencySymbols = new ArrayList<Object>();
        Currency currency = Currency.getInstance("USD");
        try {
            currency = Currency.getInstance(Locale.getDefault());
        }
        catch (Exception e) {
            LOGGER.warning("the country of the given Locale.getDefault() is not a supported ISO 3166 country code.");
        }
        String cr = currency.getSymbol();
        currencySymbols.add(cr);
        currencySymbols.add(Character.valueOf('$'));
        currencySymbols.add(Character.valueOf('\u20ac'));
        currencySymbols.add(Character.valueOf('\u00a2'));
        currencySymbols.add(Character.valueOf('\u00a3'));
        currencySymbols.add(Character.valueOf('\u00a4'));
        currencySymbols.add(Character.valueOf('\u00a5'));
        currencySymbols.add(Character.valueOf('\u20a3'));
        currencySymbols.add(Character.valueOf('\u20a4'));
        currencySymbols.add(Character.valueOf('\u20a7'));
        currencySymbols.add(Character.valueOf('\u20aa'));
        currencySymbols.add(Character.valueOf('\u20ab'));
        currencySymbols.add(Character.valueOf('\u0e3f'));
        currencySymbols.add(Character.valueOf('\u20a0'));
        currencySymbols.add(Character.valueOf('\u20a1'));
        currencySymbols.add(Character.valueOf('\u20a2'));
        currencySymbols.add(Character.valueOf('\u20a5'));
        currencySymbols.add(Character.valueOf('\u20a6'));
        currencySymbols.add(Character.valueOf('\u20a8'));
        currencySymbols.add(Character.valueOf('\u20a9'));
        currencySymbols.add(Character.valueOf('\u20ab'));
        currencySymbols.add("R$");
        return currencySymbols;
    }

    private static boolean tryGetBoolean(Object obj) {
        try {
            return (Boolean)obj;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static int tryGetInt(Object obj) {
        try {
            return Integer.parseInt((String)obj);
        }
        catch (Exception e) {
            try {
                return Integer.parseInt(obj.toString());
            }
            catch (Exception ee) {
                return 0;
            }
        }
    }

    private static String tryGetString(Object obj) {
        try {
            return obj.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static StiFormatService getFormatService(HashMap<String, Object> properties) throws JSONException {
        String type = (String)properties.get("type");
        if ("StiNumberFormatService".equals(type)) {
            StiNumberFormatService format = new StiNumberFormatService();
            format.setUseGroupSeparator(StiTextFormatHelper.tryGetBoolean(properties.get("useGroupSeparator")));
            format.setUseLocalSetting(StiTextFormatHelper.tryGetBoolean(properties.get("useLocalSetting")));
            format.setDecimalDigits(StiTextFormatHelper.tryGetInt(properties.get("decimalDigits")));
            format.setDecimalSeparator(StiTextFormatHelper.tryGetString(properties.get("decimalSeparator")));
            format.setGroupSeparator(StiTextFormatHelper.tryGetString(properties.get("groupSeparator")));
            format.setGroupSize(StiTextFormatHelper.tryGetInt(properties.get("groupSize")));
            format.setNegativePattern(StiTextFormatHelper.tryGetInt(properties.get("numberNegativePattern")));
            format.setState(StiTextFormatHelper.getStateProperty(StiTextFormatHelper.tryGetString(properties.get("state"))));
            return format;
        }
        if ("StiCurrencyFormatService".equals(type)) {
            StiCurrencyFormatService format = new StiCurrencyFormatService();
            format.setUseGroupSeparator(StiTextFormatHelper.tryGetBoolean(properties.get("useGroupSeparator")));
            format.setUseLocalSetting(StiTextFormatHelper.tryGetBoolean(properties.get("useLocalSetting")));
            format.setDecimalDigits(StiTextFormatHelper.tryGetInt(properties.get("decimalDigits")));
            format.setDecimalSeparator(StiTextFormatHelper.tryGetString(properties.get("decimalSeparator")));
            format.setGroupSeparator(StiTextFormatHelper.tryGetString(properties.get("groupSeparator")));
            format.setGroupSize(StiTextFormatHelper.tryGetInt(properties.get("groupSize")));
            format.setPositivePattern(StiTextFormatHelper.tryGetInt(properties.get("currencyPositivePattern")));
            format.setNegativePattern(StiTextFormatHelper.tryGetInt(properties.get("currencyNegativePattern")));
            format.setSymbol(StiTextFormatHelper.tryGetString(properties.get("currencySymbol")));
            format.setState(StiTextFormatHelper.getStateProperty(StiTextFormatHelper.tryGetString(properties.get("state"))));
            return format;
        }
        if ("StiDateFormatService".equals(type)) {
            StiDateFormatService format = new StiDateFormatService();
            format.setStringFormat(StiTextFormatHelper.tryGetString(properties.get("dateFormat")));
            return format;
        }
        if ("StiTimeFormatService".equals(type)) {
            StiTimeFormatService format = new StiTimeFormatService();
            format.setStringFormat(StiTextFormatHelper.tryGetString(properties.get("timeFormat")));
            return format;
        }
        if ("StiPercentageFormatService".equals(type)) {
            StiPercentageFormatService format = new StiPercentageFormatService();
            format.setUseGroupSeparator(StiTextFormatHelper.tryGetBoolean(properties.get("useGroupSeparator")));
            format.setUseLocalSetting(StiTextFormatHelper.tryGetBoolean(properties.get("useLocalSetting")));
            format.setDecimalDigits(StiTextFormatHelper.tryGetInt(properties.get("decimalDigits")));
            format.setDecimalSeparator(StiTextFormatHelper.tryGetString(properties.get("decimalSeparator")));
            format.setGroupSeparator(StiTextFormatHelper.tryGetString(properties.get("groupSeparator")));
            format.setGroupSize(StiTextFormatHelper.tryGetInt(properties.get("groupSize")));
            format.setPositivePattern(StiTextFormatHelper.tryGetInt(properties.get("percentagePositivePattern")));
            format.setNegativePattern(StiTextFormatHelper.tryGetInt(properties.get("percentageNegativePattern")));
            format.setSymbol(StiTextFormatHelper.tryGetString(properties.get("percentageSymbol")));
            format.setState(StiTextFormatHelper.getStateProperty(StiTextFormatHelper.tryGetString(properties.get("state"))));
            return format;
        }
        if ("StiBooleanFormatService".equals(type)) {
            StiBooleanFormatService format = new StiBooleanFormatService();
            format.setFalseValue(StiTextFormatHelper.tryGetString(properties.get("falseValue")));
            format.setFalseDisplay(StiTextFormatHelper.tryGetString(properties.get("falseDisplay")));
            format.setTrueValue(StiTextFormatHelper.tryGetString(properties.get("trueValue")));
            format.setTrueDisplay(StiTextFormatHelper.tryGetString(properties.get("trueDisplay")));
            return format;
        }
        if ("StiCustomFormatService".equals(type)) {
            StiCustomFormatService format = new StiCustomFormatService();
            format.setStringFormat(StiTextFormatHelper.tryGetString(properties.get("customFormat")));
            return format;
        }
        return new StiGeneralFormatService();
    }

    public static ArrayList<HashMap<String, Object>> getDateAndTimeFormats(String category, StiFormatService service) {
        ArrayList<HashMap<String, Object>> items = new ArrayList<HashMap<String, Object>>();
        Set keys = ((Map)StiLocalization.getLocalization().languageProp.get("Formats")).keySet();
        for (String key : keys) {
            String value;
            if (key.indexOf(category) <= -1 || (value = StiLocalization.getValue((String)"Formats", (String)key)) == null) continue;
            try {
                HashMap<String, String> item = new HashMap<String, String>();
                if (value.length() > 0 && value.charAt(0) == '*') {
                    item.put("key", value.substring(1));
                    item.put("value", '*' + service.format(value.substring(1), service.getSample(), null));
                } else {
                    item.put("key", value);
                    item.put("value", service.format(value, service.getSample(), null));
                }
                items.add(item);
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 20) continue;
                e.printStackTrace();
            }
        }
        return items;
    }

    public static HashMap<String, Object> getTextFormatItem(StiFormatService service) {
        if (service instanceof StiGeneralFormatService) {
            return StiTextFormatHelper.generalTextFormatItem((StiGeneralFormatService)service);
        }
        if (service instanceof StiPercentageFormatService) {
            return StiTextFormatHelper.percentageTextFormatItem((StiPercentageFormatService)service);
        }
        if (service instanceof StiCurrencyFormatService) {
            return StiTextFormatHelper.currencyTextFormatItem((StiCurrencyFormatService)service);
        }
        if (service instanceof StiNumberFormatService) {
            return StiTextFormatHelper.numberTextFormatItem((StiNumberFormatService)service);
        }
        if (service instanceof StiDateFormatService) {
            return StiTextFormatHelper.dateTextFormatItem((StiDateFormatService)service);
        }
        if (service instanceof StiTimeFormatService) {
            return StiTextFormatHelper.timeTextFormatItem((StiTimeFormatService)service);
        }
        if (service instanceof StiBooleanFormatService) {
            return StiTextFormatHelper.booleanTextFormatItem((StiBooleanFormatService)service);
        }
        if (service instanceof StiCustomFormatService) {
            return StiTextFormatHelper.customTextFormatItem((StiCustomFormatService)service);
        }
        return StiTextFormatHelper.commonTextFormatItem(service);
    }

    public static HashMap<String, Object> getTextFormatItems() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        for (StiFormatService service : StiOptions.Services.getFormats()) {
            items.put(service.getClass().getName().substring(service.getClass().getName().lastIndexOf(46) + 1), StiTextFormatHelper.getTextFormatItem(service));
        }
        return items;
    }
}

