/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.StiDeserializationException;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.table.StiTable;
import com.stimulsoft.report.crossTab.StiCrossTab;
import com.stimulsoft.report.enums.StiBrushType;
import com.stimulsoft.report.enums.StiStyleElements;
import com.stimulsoft.report.infographics.gauge.StiGauge;
import com.stimulsoft.report.maps.StiMap;
import com.stimulsoft.report.styles.StiBaseStyle;
import com.stimulsoft.report.styles.StiChartStyle;
import com.stimulsoft.report.styles.StiCrossTabStyle;
import com.stimulsoft.report.styles.StiGaugeStyle;
import com.stimulsoft.report.styles.StiMapStyle;
import com.stimulsoft.report.styles.StiStyle;
import com.stimulsoft.report.styles.StiStylesCollection;
import com.stimulsoft.report.styles.StiStylesCreator;
import com.stimulsoft.report.styles.StiTableStyle;
import com.stimulsoft.report.styles.conditions.StiStyleCondition;
import com.stimulsoft.report.styles.conditions.StiStyleConditionsCollection;
import com.stimulsoft.report.styles.enums.StiNestedFactor;
import com.stimulsoft.report.styles.enums.StiStyleComponentPlacement;
import com.stimulsoft.report.styles.enums.StiStyleComponentType;
import com.stimulsoft.report.styles.enums.StiStyleConditionOperation;
import com.stimulsoft.report.styles.enums.StiStyleConditionType;
import com.stimulsoft.report.styles.enums.StiStyleLocation;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.helper.StiCacheHelper;
import com.stimulsoft.web.proxyee.StiHttpServletRequest;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import com.stimulsoft.webdesigner.helper.StiTextFormatHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.SAXException;

public class StiStylesHelper {
    private static HashMap<String, Object> getStyleProperties(StiBaseStyle style) {
        String[] boolProps;
        String brushType;
        String basicStyleColor;
        String backColor;
        String foreColor;
        String color;
        String horAlignment;
        String font;
        String border;
        String textBrush;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("name", style.getName());
        properties.put("collectionName", style.getCollectionName());
        properties.put("description", style.getDescription());
        properties.put("conditions", StiStylesHelper.getStyleConditionsProprty(style.getConditions()));
        String brush = (String)StiReportEdit.getPropertyValue("Brush", style);
        if (StiValidationUtil.isNotNullOrEmpty((String)brush)) {
            properties.put("brush", brush);
        }
        if (StiValidationUtil.isNotNullOrEmpty((String)(textBrush = (String)StiReportEdit.getPropertyValue("TextBrush", style)))) {
            properties.put("textBrush", textBrush);
        }
        if (StiValidationUtil.isNotNullOrEmpty((String)(border = (String)StiReportEdit.getPropertyValue("Border", style)))) {
            properties.put("border", border);
        }
        if (StiValidationUtil.isNotNullOrEmpty((String)(font = (String)StiReportEdit.getPropertyValue("Font", style)))) {
            properties.put("font", font);
        }
        if (StiValidationUtil.isNotEmpty((String)(horAlignment = (String)StiReportEdit.getPropertyValue("HorAlignment", style)))) {
            properties.put("horAlignment", horAlignment);
        }
        String vertAlignment = (String)StiReportEdit.getPropertyValue("VertAlignment", style);
        if (StiValidationUtil.isNotEmpty((String)horAlignment)) {
            properties.put("vertAlignment", vertAlignment);
        }
        if (StiValidationUtil.isNotNullOrEmpty((String)(color = (String)StiReportEdit.getPropertyValue("Color", style)))) {
            properties.put("color", color);
        }
        if (StiValidationUtil.isNotNullOrEmpty((String)(foreColor = (String)StiReportEdit.getPropertyValue("ForeColor", style)))) {
            properties.put("foreColor", foreColor);
        }
        if (StiValidationUtil.isNotNullOrEmpty((String)(backColor = (String)StiReportEdit.getPropertyValue("BackColor", style)))) {
            properties.put("backColor", backColor);
        }
        if (StiValidationUtil.isNotNullOrEmpty((String)(basicStyleColor = (String)StiReportEdit.getPropertyValue("BasicStyleColor", style)))) {
            properties.put("basicStyleColor", basicStyleColor);
        }
        if (StiValidationUtil.isNotNullOrEmpty((String)(brushType = (String)StiReportEdit.getPropertyValue("BrushType", style)))) {
            properties.put("brushType", brushType);
        }
        for (String propertyName : boolProps = new String[]{"AllowUseBackColor", "AllowUseForeColor", "AllowUseBorderFormatting", "AllowUseBorderSides", "AllowUseBorderSidesFromLocation", "AllowUseBrush", "AllowUseFont", "AllowUseImage", "AllowUseTextBrush", "AllowUseHorAlignment", "AllowUseVertAlignment"}) {
            try {
                String propNameLower = Character.toString(propertyName.charAt(0)).toLowerCase() + propertyName.substring(1);
                properties.put(propNameLower, style.getClass().getMethod("get" + propertyName, new Class[0]).invoke((Object)style, new Object[0]));
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) continue;
                e.printStackTrace();
            }
        }
        if (style instanceof StiCrossTabStyle) {
            StiSolidBrush topBrush = new StiSolidBrush(((StiCrossTabStyle)style).getColor().light(50));
            StiSolidBrush bottomBrush = new StiSolidBrush(((StiCrossTabStyle)style).getColor().light(50));
            properties.put("topColor", StiReportEdit.getStringFromColor(StiColor.fromArgb((int)topBrush.getColor().getA(), (int)topBrush.getColor().getR(), (int)topBrush.getColor().getG(), (int)topBrush.getColor().getB())));
            properties.put("bottomColor", StiReportEdit.getStringFromColor(StiColor.fromArgb((int)bottomBrush.getColor().getA(), (int)bottomBrush.getColor().getR(), (int)bottomBrush.getColor().getG(), (int)bottomBrush.getColor().getB())));
        } else if (style instanceof StiMapStyle) {
            properties.put("borderColor", StiReportEdit.getStringFromColor(((StiMapStyle)style).getBorderColor()));
            properties.put("borderSize", StiReportEdit.doubleToStr(((StiMapStyle)style).getBorderSize()));
            properties.put("colors", StiStylesHelper.getColorsCollectionProperty(((StiMapStyle)style).getColors()));
            properties.put("defaultColor", StiReportEdit.getStringFromColor(((StiMapStyle)style).getDefaultColor()));
            properties.put("heatmapColors", StiStylesHelper.getColorsCollectionProperty(((StiMapStyle)style).getHeatmapColors()));
        } else if (style instanceof StiChartStyle) {
            StiChartStyle chartStyle = (StiChartStyle)style;
            properties.put("gridLinesHorColor", StiReportEdit.getStringFromColor(chartStyle.getGridLinesHorColor()));
            properties.put("gridLinesVertColor", StiReportEdit.getStringFromColor(chartStyle.getGridLinesVertColor()));
            properties.put("chartAreaShowShadow", chartStyle.getChartAreaShowShadow());
            properties.put("chartAreaBrush", StiReportEdit.brushToStr(chartStyle.getChartAreaBrush()));
            properties.put("chartAreaBorderColor", StiReportEdit.getStringFromColor(chartStyle.getChartAreaBorderColor()));
            properties.put("seriesLabelsBorderColor", StiReportEdit.getStringFromColor(chartStyle.getSeriesLabelsBorderColor()));
            properties.put("seriesLabelsColor", StiReportEdit.getStringFromColor(chartStyle.getSeriesLabelsColor()));
            properties.put("seriesLabelsBrush", StiReportEdit.brushToStr(chartStyle.getSeriesLabelsBrush()));
            properties.put("trendLineShowShadow", chartStyle.getTrendLineShowShadow());
            properties.put("trendLineColor", StiReportEdit.getStringFromColor(chartStyle.getTrendLineColor()));
            properties.put("legendBorderColor", StiReportEdit.getStringFromColor(chartStyle.getLegendBorderColor()));
            properties.put("legendBrush", StiReportEdit.brushToStr(chartStyle.getLegendBrush()));
            properties.put("legendLabelsColor", StiReportEdit.getStringFromColor(chartStyle.getLegendLabelsColor()));
            properties.put("legendTitleColor", StiReportEdit.getStringFromColor(chartStyle.getLegendTitleColor()));
            properties.put("axisLabelsColor", StiReportEdit.getStringFromColor(chartStyle.getAxisLabelsColor()));
            properties.put("axisLineColor", StiReportEdit.getStringFromColor(chartStyle.getAxisLineColor()));
            properties.put("axisTitleColor", StiReportEdit.getStringFromColor(chartStyle.getAxisTitleColor()));
            properties.put("interlacingHorBrush", StiReportEdit.brushToStr(chartStyle.getInterlacingHorBrush()));
            properties.put("interlacingVertBrush", StiReportEdit.brushToStr(chartStyle.getInterlacingVertBrush()));
        }
        if (style instanceof StiStyle) {
            properties.put("image", ((StiStyle)style).getImage() != null ? StiReportEdit.imageToBase64(((StiStyle)style).getImage()) : "");
            properties.put("textFormat", StiTextFormatHelper.getTextFormatItem(((StiStyle)style).getTextFormat()));
            properties.put("lineSpacing", StiReportEdit.doubleToStr(((StiStyle)style).getLineSpacing()));
        }
        return properties;
    }

    public static HashMap<String, Object> styleItem(StiBaseStyle style) {
        HashMap<String, Object> styleItem = new HashMap<String, Object>();
        styleItem.put("type", style.getClass().getName().substring(style.getClass().getName().lastIndexOf(".") + 1));
        styleItem.put("properties", StiStylesHelper.getStyleProperties(style));
        return styleItem;
    }

    public static ArrayList<HashMap<String, Object>> getStyles(StiReport report) {
        ArrayList<HashMap<String, Object>> items = new ArrayList<HashMap<String, Object>>();
        for (StiBaseStyle style : report.getStyles()) {
            items.add(StiStylesHelper.styleItem(style));
        }
        return items;
    }

    public static void setConditionTypeProperty(StiStyleCondition styleCondition, String propertyValue) {
        StiEnumSet value = StiEnumSet.noneOf(StiStyleConditionType.class);
        if (propertyValue.indexOf(" ComponentType,") >= 0) {
            value.add((IStiEnum)StiStyleConditionType.ComponentType);
        }
        if (propertyValue.indexOf(" Placement,") >= 0) {
            value.add((IStiEnum)StiStyleConditionType.Placement);
        }
        if (propertyValue.indexOf(" PlacementNestedLevel,") >= 0) {
            value.add((IStiEnum)StiStyleConditionType.PlacementNestedLevel);
        }
        if (propertyValue.indexOf(" ComponentName,") >= 0) {
            value.add((IStiEnum)StiStyleConditionType.ComponentName);
        }
        if (propertyValue.indexOf(" Location,") >= 0) {
            value.add((IStiEnum)StiStyleConditionType.Location);
        }
        styleCondition.setType(value);
    }

    public static void setLocationProperty(StiStyleCondition styleCondition, String propertyValue) {
        StiEnumSet value = StiEnumSet.of((Enum)StiStyleLocation.None);
        if (propertyValue.indexOf(" TopLeft,") >= 0) {
            value.add((IStiEnum)StiStyleLocation.TopLeft);
        }
        if (propertyValue.indexOf(" TopCenter,") >= 0) {
            value.add((IStiEnum)StiStyleLocation.TopCenter);
        }
        if (propertyValue.indexOf(" TopRight,") >= 0) {
            value.add((IStiEnum)StiStyleLocation.TopRight);
        }
        if (propertyValue.indexOf(" MiddleLeft,") >= 0) {
            value.add((IStiEnum)StiStyleLocation.MiddleLeft);
        }
        if (propertyValue.indexOf(" MiddleCenter,") >= 0) {
            value.add((IStiEnum)StiStyleLocation.MiddleCenter);
        }
        if (propertyValue.indexOf(" MiddleRight,") >= 0) {
            value.add((IStiEnum)StiStyleLocation.MiddleRight);
        }
        if (propertyValue.indexOf(" BottomLeft,") >= 0) {
            value.add((IStiEnum)StiStyleLocation.BottomLeft);
        }
        if (propertyValue.indexOf(" BottomCenter,") >= 0) {
            value.add((IStiEnum)StiStyleLocation.BottomCenter);
        }
        if (propertyValue.indexOf(" BottomRight,") >= 0) {
            value.add((IStiEnum)StiStyleLocation.BottomRight);
        }
        if (propertyValue.indexOf(" Left,") >= 0) {
            value.add((IStiEnum)StiStyleLocation.Left);
        }
        if (propertyValue.indexOf(" Right,") >= 0) {
            value.add((IStiEnum)StiStyleLocation.Right);
        }
        if (propertyValue.indexOf(" Top,") >= 0) {
            value.add((IStiEnum)StiStyleLocation.Top);
        }
        if (propertyValue.indexOf(" Bottom,") >= 0) {
            value.add((IStiEnum)StiStyleLocation.Bottom);
        }
        if (propertyValue.indexOf(" CenterHorizontal,") >= 0) {
            value.add((IStiEnum)StiStyleLocation.CenterHorizontal);
        }
        if (propertyValue.indexOf(" CenterVertical,") >= 0) {
            value.add((IStiEnum)StiStyleLocation.CenterVertical);
        }
        styleCondition.setLocation(value);
    }

    public static void setComponentTypeProperty(StiStyleCondition styleCondition, String propertyValue) {
        StiEnumSet value = StiEnumSet.noneOf(StiStyleComponentType.class);
        if (propertyValue.indexOf(" Text,") >= 0) {
            value.add((IStiEnum)StiStyleComponentType.Text);
        }
        if (propertyValue.indexOf(" Primitive,") >= 0) {
            value.add((IStiEnum)StiStyleComponentType.Primitive);
        }
        if (propertyValue.indexOf(" Image,") >= 0) {
            value.add((IStiEnum)StiStyleComponentType.Image);
        }
        if (propertyValue.indexOf(" CrossTab,") >= 0) {
            value.add((IStiEnum)StiStyleComponentType.CrossTab);
        }
        if (propertyValue.indexOf(" Chart,") >= 0) {
            value.add((IStiEnum)StiStyleComponentType.Chart);
        }
        if (propertyValue.indexOf(" CheckBox,") >= 0) {
            value.add((IStiEnum)StiStyleComponentType.CheckBox);
        }
        styleCondition.setComponentType(value);
    }

    public static void setPlacementProperty(StiStyleCondition styleCondition, String propertyValue) {
        StiEnumSet value = StiEnumSet.of((Enum)StiStyleComponentPlacement.None);
        if (propertyValue.indexOf(" ReportTitle,") >= 0) {
            value.add((IStiEnum)StiStyleComponentPlacement.ReportTitle);
        }
        if (propertyValue.indexOf(" ReportSummary,") >= 0) {
            value.add((IStiEnum)StiStyleComponentPlacement.ReportSummary);
        }
        if (propertyValue.indexOf(" PageHeader,") >= 0) {
            value.add((IStiEnum)StiStyleComponentPlacement.PageHeader);
        }
        if (propertyValue.indexOf(" PageFooter,") >= 0) {
            value.add((IStiEnum)StiStyleComponentPlacement.PageFooter);
        }
        if (propertyValue.indexOf(" GroupHeader,") >= 0) {
            value.add((IStiEnum)StiStyleComponentPlacement.GroupHeader);
        }
        if (propertyValue.indexOf(" GroupFooter,") >= 0) {
            value.add((IStiEnum)StiStyleComponentPlacement.GroupFooter);
        }
        if (propertyValue.indexOf(" Header,") >= 0) {
            value.add((IStiEnum)StiStyleComponentPlacement.Header);
        }
        if (propertyValue.indexOf(" Footer,") >= 0) {
            value.add((IStiEnum)StiStyleComponentPlacement.Footer);
        }
        if (propertyValue.indexOf(" ColumnHeader,") >= 0) {
            value.add((IStiEnum)StiStyleComponentPlacement.ColumnHeader);
        }
        if (propertyValue.indexOf(" ColumnFooter,") >= 0) {
            value.add((IStiEnum)StiStyleComponentPlacement.ColumnFooter);
        }
        if (propertyValue.indexOf(" Data,") >= 0) {
            value.add((IStiEnum)StiStyleComponentPlacement.Data);
        }
        if (propertyValue.indexOf(" DataEvenStyle,") >= 0) {
            styleCondition.setPlacement(StiEnumSet.of((Enum)StiStyleComponentPlacement.DataEvenStyle));
            return;
        }
        if (propertyValue.indexOf(" DataOddStyle,") >= 0) {
            styleCondition.setPlacement(StiEnumSet.of((Enum)StiStyleComponentPlacement.DataOddStyle));
            return;
        }
        if (propertyValue.indexOf(" Table,") >= 0) {
            value.add((IStiEnum)StiStyleComponentPlacement.Table);
        }
        if (propertyValue.indexOf(" Hierarchical,") >= 0) {
            value.add((IStiEnum)StiStyleComponentPlacement.Hierarchical);
        }
        if (propertyValue.indexOf(" Child,") >= 0) {
            value.add((IStiEnum)StiStyleComponentPlacement.Child);
        }
        if (propertyValue.indexOf(" Empty,") >= 0) {
            value.add((IStiEnum)StiStyleComponentPlacement.Empty);
        }
        if (propertyValue.indexOf(" Overlay,") >= 0) {
            value.add((IStiEnum)StiStyleComponentPlacement.Overlay);
        }
        if (propertyValue.indexOf(" Panel,") >= 0) {
            value.add((IStiEnum)StiStyleComponentPlacement.Panel);
        }
        if (propertyValue.indexOf(" Page,") >= 0) {
            value.add((IStiEnum)StiStyleComponentPlacement.Page);
        }
        if (propertyValue.indexOf(" Empty,") >= 0) {
            value.add((IStiEnum)StiStyleComponentPlacement.Empty);
        }
        if (propertyValue == " AllExeptStyles,") {
            styleCondition.setPlacement(StiEnumSet.of((Enum)StiStyleComponentPlacement.AllExeptStyles));
        } else {
            styleCondition.setPlacement(value);
        }
    }

    public static void setStyleConditionsProprty(StiBaseStyle style, ArrayList<HashMap<String, Object>> conditions) throws JSONException {
        style.getConditions().clear();
        for (HashMap<String, Object> conditionObject : conditions) {
            StiStyleCondition styleCondition = new StiStyleCondition();
            style.getConditions().add((Object)styleCondition);
            StiStylesHelper.setConditionTypeProperty(styleCondition, (String)conditionObject.get("type"));
            StiStylesHelper.setPlacementProperty(styleCondition, (String)conditionObject.get("placement"));
            styleCondition.setOperationPlacement(StiStyleConditionOperation.valueOf((String)((String)conditionObject.get("operationPlacement"))));
            styleCondition.setPlacementNestedLevel(StiReportEdit.strToInt(conditionObject.get("placementNestedLevel")));
            styleCondition.setOperationPlacementNestedLevel(StiStyleConditionOperation.valueOf((String)((String)conditionObject.get("operationPlacementNestedLevel"))));
            StiStylesHelper.setComponentTypeProperty(styleCondition, (String)conditionObject.get("componentType"));
            styleCondition.setOperationComponentType(StiStyleConditionOperation.valueOf((String)((String)conditionObject.get("operationComponentType"))));
            StiStylesHelper.setLocationProperty(styleCondition, (String)conditionObject.get("location"));
            styleCondition.setOperationLocation(StiStyleConditionOperation.valueOf((String)((String)conditionObject.get("operationLocation"))));
            styleCondition.setComponentName((String)conditionObject.get("componentName"));
            styleCondition.setOperationComponentName(StiStyleConditionOperation.valueOf((String)((String)conditionObject.get("operationComponentName"))));
        }
    }

    public static ArrayList<HashMap<String, String>> getStyleConditionsProprty(StiStyleConditionsCollection conditions) {
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        for (StiStyleCondition condition : conditions) {
            HashMap<String, String> conditionObject = new HashMap<String, String>();
            result.add(conditionObject);
            conditionObject.put("type", condition.getType().toString());
            conditionObject.put("placement", " " + condition.getPlacement().toString() + ",");
            conditionObject.put("operationPlacement", condition.getOperationPlacement().toString());
            conditionObject.put("placementNestedLevel", condition.getOperationPlacementNestedLevel().toString());
            conditionObject.put("operationPlacementNestedLevel", condition.getOperationPlacementNestedLevel().toString());
            conditionObject.put("componentType", " " + condition.getComponentType().toString() + ",");
            conditionObject.put("operationComponentType", condition.getOperationComponentType().toString());
            conditionObject.put("location", " " + condition.getLocation().toString() + ",");
            conditionObject.put("operationLocation", condition.getOperationLocation().toString());
            conditionObject.put("componentName", condition.getComponentName());
            conditionObject.put("operationComponentName", condition.getOperationComponentName().toString());
        }
        return result;
    }

    public static void generateNewName(StiReport report, StiBaseStyle newStyle) {
        boolean fail = true;
        Integer index = 1;
        while (fail) {
            fail = false;
            String name = StiLocalization.getValue((String)"FormStyleDesigner", (String)"Style") + index.toString();
            for (StiBaseStyle st : report.getStyles()) {
                if (!name.equals(st.getName())) continue;
                fail = true;
                break;
            }
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
            newStyle.setName(name);
        }
    }

    public static void generateNewName(StiStylesCollection styles, StiBaseStyle newStyle) {
        boolean fail = true;
        Integer index = 1;
        while (fail) {
            fail = false;
            String name = StiLocalization.Get((String)"FormStyleDesigner", (String)"Style") + index.toString();
            for (StiBaseStyle st : styles) {
                if (!StiValidationUtil.equals((Object)st.getName(), (Object)name)) continue;
                fail = true;
                break;
            }
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
            newStyle.setName(name);
        }
    }

    public static void applyStyleProperties(StiBaseStyle style, HashMap<String, Object> properties, StiReport report) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, JSONException {
        for (String propertyName : properties.keySet()) {
            String propertyNameUpper = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            Object propertyValue = properties.get(propertyName);
            Method pi = StiReportEdit.getSetter(style.getClass(), "set" + propertyNameUpper);
            if (pi == null) continue;
            if (pi.getParameterTypes()[0].equals(Boolean.class) || pi.getParameterTypes()[0].equals(Boolean.TYPE) || pi.getParameterTypes()[0].equals(String.class)) {
                pi.invoke((Object)style, propertyValue);
                continue;
            }
            if (pi.getParameterTypes()[0].equals(StiBrush.class)) {
                pi.invoke((Object)style, StiReportEdit.strToBrush((String)propertyValue));
                continue;
            }
            if (pi.getParameterTypes()[0].equals(StiBorder.class)) {
                pi.invoke((Object)style, StiReportEdit.strToBorder((String)propertyValue));
                continue;
            }
            if (pi.getParameterTypes()[0].equals(StiFont.class)) {
                pi.invoke((Object)style, StiReportEdit.strToFont((String)propertyValue, report));
                continue;
            }
            if (pi.getParameterTypes()[0].equals(StiColor.class)) {
                pi.invoke((Object)style, StiReportEdit.strToColor((String)propertyValue));
                continue;
            }
            if (pi.getParameterTypes()[0].equals(StiTextHorAlignment.class)) {
                pi.invoke((Object)style, StiTextHorAlignment.valueOf((String)((String)propertyValue)));
                continue;
            }
            if (pi.getParameterTypes()[0].equals(StiVertAlignment.class)) {
                pi.invoke((Object)style, StiVertAlignment.valueOf((String)((String)propertyValue)));
                continue;
            }
            if (pi.getParameterTypes()[0].equals(com.stimulsoft.report.components.enums.StiBrushType.class)) {
                pi.invoke((Object)style, com.stimulsoft.report.components.enums.StiBrushType.valueOf((String)((String)propertyValue)));
                continue;
            }
            if (pi.getParameterTypes()[0].equals(StiBrushType.class)) {
                pi.invoke((Object)style, StiBrushType.valueOf((String)((String)propertyValue)));
                continue;
            }
            if (pi.getParameterTypes()[0].equals(StiStyleConditionsCollection.class)) {
                StiStylesHelper.setStyleConditionsProprty(style, (ArrayList)propertyValue);
                continue;
            }
            if (pi.getParameterTypes()[0].equals(Double.class) || pi.getParameterTypes()[0].equals(Double.TYPE)) {
                pi.invoke((Object)style, StiReportEdit.strToDouble((String)propertyValue), null);
                continue;
            }
            if (!pi.getParameterTypes()[0].equals(Float.class) && !pi.getParameterTypes()[0].equals(Float.TYPE)) continue;
            pi.invoke((Object)style, Float.valueOf((float)StiReportEdit.strToDouble((String)propertyValue)));
        }
    }

    public static void writeStylesToReport(StiReport report, List stylesCollection) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, JSONException {
        report.getStyles().clear();
        for (int i = 0; i < stylesCollection.size(); ++i) {
            StiBaseStyle style;
            HashMap styleObject;
            block3: {
                styleObject = (HashMap)stylesCollection.get(i);
                style = null;
                try {
                    style = (StiBaseStyle)Class.forName("com.stimulsoft.report.styles." + (String)styleObject.get("type")).newInstance();
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block3;
                    e.printStackTrace();
                }
            }
            if (style == null) continue;
            StiStylesHelper.generateNewName(report, style);
            report.getStyles().add(style);
            StiStylesHelper.applyStyleProperties(style, (HashMap)styleObject.get("properties"), report);
        }
    }

    private static StiBaseStyle GetStyleFromComponent(StiComponent comp) {
        StiChartStyle style = null;
        if (comp instanceof StiChart) {
            style = new StiChartStyle();
            style.GetStyleFromComponent(comp, StiStyleElements.All);
        } else if (comp instanceof StiCrossTab) {
            style = new StiCrossTabStyle();
            style.GetStyleFromComponent(comp, StiStyleElements.All);
        } else {
            style = new StiStyle();
            style.GetStyleFromComponent(comp, StiStyleElements.All);
            ((StiStyle)style).setAllowUseHorAlignment(false);
            ((StiStyle)style).setAllowUseVertAlignment(false);
        }
        style.setName(comp.getName() + "Style");
        style.setDescription(String.format("Style based on formating of %s component", comp.getName()));
        boolean find = false;
        for (StiBaseStyle baseStyle : comp.getReport().getStyles()) {
            if (!baseStyle.equals((Object)style, false, false)) continue;
            find = true;
            break;
        }
        if (find) {
            return null;
        }
        return style;
    }

    private static ArrayList<String> getColorsCollectionProperty(List<StiColor> colors) {
        ArrayList<String> result = new ArrayList<String>();
        for (StiColor color : colors) {
            result.add(StiReportEdit.getStringFromColor(color));
        }
        return result;
    }

    private static void setColorsCollectionProperty(StiBaseStyle style, ArrayList<String> colorsString) {
        StiChartStyle chartStyle;
        StiChartStyle stiChartStyle = chartStyle = style instanceof StiChartStyle ? (StiChartStyle)style : null;
        if (chartStyle != null) {
            ArrayList<StiColor> colors = new ArrayList<StiColor>();
            for (String colorString : colorsString) {
                colors.add(StiReportEdit.strToColor(colorString));
            }
            chartStyle.setStyleColors(colors.toArray(new StiColor[0]));
        }
    }

    public static void updateStyles(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        if (param.get("reportFile") != null) {
            report.setReportFile((String)param.get("reportFile"));
        }
        if (param.get("stylesCollection") != null) {
            StiStylesHelper.writeStylesToReport(report, (List)param.get("stylesCollection"));
        }
        if (param.get("collectionName") != null) {
            report.applyStyleCollection((String)param.get("collectionName"));
        }
        report.applyStyles();
        report.getInfo().setZoom(StiReportEdit.strToDouble((String)param.get("zoom")));
        callbackResult.put("reportObject", StiReportEdit.writeReportInObject(report));
        if (param.containsKey("selectedObjectName")) {
            callbackResult.put("selectedObjectName", param.get("selectedObjectName"));
        }
        callbackResult.put("reportGuid", param.get("reportGuid"));
    }

    public static void addStyle(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        StiBaseStyle newStyle;
        block3: {
            newStyle = null;
            try {
                Class<?> cl = Class.forName("com.stimulsoft.report.styles." + (String)param.get("type"));
                newStyle = (StiBaseStyle)cl.newInstance();
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) break block3;
                e.printStackTrace();
            }
        }
        if (newStyle != null) {
            callbackResult.put("styleObject", StiStylesHelper.styleItem(newStyle));
        }
    }

    public static void removeStyle(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        boolean canDelete;
        StiBaseStyle style = report.getStyles().get((String)param.get("styleOldName"));
        boolean bl = canDelete = style != null;
        if (canDelete) {
            report.getStyles().remove((Object)style);
        }
        callbackResult.put("deleteResult", canDelete);
        callbackResult.put("itemKey", param.get("itemKey"));
    }

    public static void createStyleCollection(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws JSONException {
        HashMap properties = (HashMap)param.get("styleCollectionProperties");
        StiColor baseColor = StiReportEdit.strToColor((String)properties.get("color"));
        StiStylesCreator creator = new StiStylesCreator(report);
        creator.setShowBorders(((Boolean)properties.get("borders")).booleanValue());
        creator.setMaxNestedLevel(StiReportEdit.strToInt(properties.get("nestedLevel")));
        creator.setNestedFactor(StiNestedFactor.valueOf((String)((String)properties.get("nestedFactor"))));
        creator.setShowReportTitles(((Boolean)properties.get("reportTitle")).booleanValue());
        creator.setShowReportSummaries(((Boolean)properties.get("reportSummary")).booleanValue());
        creator.setShowPageHeaders(((Boolean)properties.get("pageHeader")).booleanValue());
        creator.setShowPageFooters(((Boolean)properties.get("pageFooter")).booleanValue());
        creator.setShowGroupHeaders(((Boolean)properties.get("groupHeader")).booleanValue());
        creator.setShowGroupFooters(((Boolean)properties.get("groupFooter")).booleanValue());
        creator.setShowHeaders(((Boolean)properties.get("header")).booleanValue());
        creator.setShowDatas(((Boolean)properties.get("data")).booleanValue());
        creator.setShowFooters(((Boolean)properties.get("footer")).booleanValue());
        List styles = creator.createStyles((String)properties.get("collectionName"), baseColor);
        ArrayList<HashMap<String, Object>> newStylesCollection = new ArrayList<HashMap<String, Object>>();
        for (StiBaseStyle style : styles) {
            newStylesCollection.add(StiStylesHelper.styleItem(style));
        }
        callbackResult.put("removeExistingStyles", properties.get("removeExistingStyles"));
        callbackResult.put("collectionName", properties.get("collectionName"));
        callbackResult.put("newStylesCollection", newStylesCollection);
    }

    public static void createStyleFromComponents(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        ArrayList<StiChartStyle> stylesList = new ArrayList<StiChartStyle>();
        ArrayList<HashMap<String, Object>> stylesListForJS = new ArrayList<HashMap<String, Object>>();
        List componentsNames = (List)param.get("componentsNames");
        for (String componentName : componentsNames) {
            StiComponent comp = report.GetComponentByName(componentName);
            if (comp == null) continue;
            StiChartStyle style = null;
            if (comp instanceof StiChart) {
                style = new StiChartStyle();
                style.GetStyleFromComponent(comp, StiStyleElements.All);
            } else if (comp instanceof StiCrossTab) {
                style = new StiCrossTabStyle();
                style.GetStyleFromComponent(comp, StiStyleElements.All);
            } else if (comp instanceof StiMap) {
                style = new StiMapStyle();
                style.GetStyleFromComponent(comp, StiStyleElements.All);
            } else if (comp instanceof StiGauge) {
                style = new StiGaugeStyle();
                style.GetStyleFromComponent(comp, StiStyleElements.All);
            } else if (comp instanceof StiTable) {
                style = new StiTableStyle();
                style.GetStyleFromComponent(comp, StiStyleElements.All);
            } else {
                style = new StiStyle();
                style.GetStyleFromComponent(comp, StiStyleElements.All);
                ((StiStyle)style).setAllowUseHorAlignment(false);
                ((StiStyle)style).setAllowUseVertAlignment(false);
            }
            style.setName(comp.getName() + "Style");
            style.setDescription(String.format("Style based on formating of %s component", comp.getName()));
            boolean find = false;
            for (StiBaseStyle stiBaseStyle : stylesList) {
                if (!stiBaseStyle.equals((Object)style, false, false)) continue;
                find = true;
                break;
            }
            if (find) continue;
            stylesList.add(style);
            stylesListForJS.add(StiStylesHelper.styleItem((StiBaseStyle)style));
        }
        callbackResult.put("styles", stylesListForJS);
    }

    public static void openStyle(StiRequestParams requestParams, StiReport report, HashMap<String, Object> callbackResult) throws IOException, SAXException, StiDeserializationException {
        ByteArrayInputStream is = new ByteArrayInputStream(requestParams.data);
        StiStylesCollection styles = new StiStylesCollection();
        styles.load((InputStream)is);
        is.close();
        ArrayList<HashMap<String, Object>> stylesCollectionForJS = new ArrayList<HashMap<String, Object>>();
        for (StiBaseStyle style : styles) {
            if (style == null) continue;
            stylesCollectionForJS.add(StiStylesHelper.styleItem(style));
        }
        callbackResult.put("stylesCollection", stylesCollectionForJS);
    }

    public static void copyStyle(StiHttpServletRequest httpContext, StiRequestParams requestParams, StiReport report, HashMap param, HashMap<String, Object> callbackResult) {
        StiBaseStyle style = report.getStyles().get((String)param.get("styleOldName"));
        if (style != null) {
            StiCacheHelper.saveObjectInternal((Object)style.clone(), (StiRequestParams)requestParams, (String)"clipboard", (StiHttpServletRequest)httpContext);
        }
    }

    public static void pasteStyle(StiHttpServletRequest httpContext, StiRequestParams requestParams, StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        String styleStr = (String)StiCacheHelper.getObjectInternal((StiRequestParams)requestParams, (String)"clipboard", (StiHttpServletRequest)httpContext);
        StiBaseStyle style = StiBaseStyle.loadStyleFromString((String)styleStr);
        if (style != null) {
            StiStylesHelper.generateNewName(report, style);
            report.getStyles().add((Object)style);
            callbackResult.put("styleObject", StiStylesHelper.styleItem(style));
        }
    }

    public static void duplicateStyle(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        StiBaseStyle style = report.getStyles().get((String)param.get("styleOldName"));
        if (style != null) {
            StiBaseStyle newStyle = (StiBaseStyle)style.clone();
            StiStylesHelper.generateNewName(report, newStyle);
            report.getStyles().add((Object)newStyle);
            callbackResult.put("styleObject", StiStylesHelper.styleItem(newStyle));
        }
    }
}

