/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.StiAlignValue;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.StiEmptyBrush;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGlassBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiHatchBrush;
import com.stimulsoft.base.drawing.StiHatchStyle;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiHorAlignment;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.enums.StiContentAlignment;
import com.stimulsoft.base.enums.StiPaperKind;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.helper.StiSvgHelper;
import com.stimulsoft.base.json.JSONArray;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.StiDeserializationException;
import com.stimulsoft.base.serializing.StiDeserializerControler;
import com.stimulsoft.base.serializing.StiSerializerControler;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableRef;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiFontStyle;
import com.stimulsoft.base.system.StiGraphicsUnit;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import com.stimulsoft.lib.base64.StiBase64EncoderUtil;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.StiNameCreation;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiSerializeManager;
import com.stimulsoft.report.barCodes.StiAustraliaPost4StateBarCodeType;
import com.stimulsoft.report.barCodes.StiAztecBarCodeType;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;
import com.stimulsoft.report.barCodes.StiCodabarBarCodeType;
import com.stimulsoft.report.barCodes.StiCode11BarCodeType;
import com.stimulsoft.report.barCodes.StiCode128AutoBarCodeType;
import com.stimulsoft.report.barCodes.StiCode128aBarCodeType;
import com.stimulsoft.report.barCodes.StiCode128bBarCodeType;
import com.stimulsoft.report.barCodes.StiCode128cBarCodeType;
import com.stimulsoft.report.barCodes.StiCode39BarCodeType;
import com.stimulsoft.report.barCodes.StiCode39ExtBarCodeType;
import com.stimulsoft.report.barCodes.StiCode93BarCodeType;
import com.stimulsoft.report.barCodes.StiCode93ExtBarCodeType;
import com.stimulsoft.report.barCodes.StiDataMatrixBarCodeType;
import com.stimulsoft.report.barCodes.StiDutchKIXBarCodeType;
import com.stimulsoft.report.barCodes.StiEAN128AutoBarCodeType;
import com.stimulsoft.report.barCodes.StiEAN128aBarCodeType;
import com.stimulsoft.report.barCodes.StiEAN128bBarCodeType;
import com.stimulsoft.report.barCodes.StiEAN128cBarCodeType;
import com.stimulsoft.report.barCodes.StiEAN13BarCodeType;
import com.stimulsoft.report.barCodes.StiEAN8BarCodeType;
import com.stimulsoft.report.barCodes.StiFIMBarCodeType;
import com.stimulsoft.report.barCodes.StiITF14BarCodeType;
import com.stimulsoft.report.barCodes.StiInterleaved2of5BarCodeType;
import com.stimulsoft.report.barCodes.StiIsbn10BarCodeType;
import com.stimulsoft.report.barCodes.StiIsbn13BarCodeType;
import com.stimulsoft.report.barCodes.StiJan13BarCodeType;
import com.stimulsoft.report.barCodes.StiJan8BarCodeType;
import com.stimulsoft.report.barCodes.StiMaxicodeBarCodeType;
import com.stimulsoft.report.barCodes.StiMsiBarCodeType;
import com.stimulsoft.report.barCodes.StiPdf417BarCodeType;
import com.stimulsoft.report.barCodes.StiPharmacodeBarCodeType;
import com.stimulsoft.report.barCodes.StiPlesseyBarCodeType;
import com.stimulsoft.report.barCodes.StiPostnetBarCodeType;
import com.stimulsoft.report.barCodes.StiQRCodeBarCodeType;
import com.stimulsoft.report.barCodes.StiRoyalMail4StateBarCodeType;
import com.stimulsoft.report.barCodes.StiSSCC18BarCodeType;
import com.stimulsoft.report.barCodes.StiStandard2of5BarCodeType;
import com.stimulsoft.report.barCodes.StiUpcABarCodeType;
import com.stimulsoft.report.barCodes.StiUpcEBarCodeType;
import com.stimulsoft.report.barCodes.StiUpcSup2BarCodeType;
import com.stimulsoft.report.barCodes.StiUpcSup5BarCodeType;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.view.expressions.StiListOfArgumentsExpression;
import com.stimulsoft.report.chart.view.expressions.StiListOfHyperlinksExpression;
import com.stimulsoft.report.chart.view.expressions.StiListOfTagsExpression;
import com.stimulsoft.report.chart.view.expressions.StiListOfToolTipsExpression;
import com.stimulsoft.report.chart.view.expressions.StiListOfValuesExpression;
import com.stimulsoft.report.components.StiBandInteraction;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentHelper;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiDrillDownMode;
import com.stimulsoft.report.components.StiFiltersCollection;
import com.stimulsoft.report.components.StiInteraction;
import com.stimulsoft.report.components.StiMargins;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiParameter;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.bands.StiChildBand;
import com.stimulsoft.report.components.bands.StiColumnFooterBand;
import com.stimulsoft.report.components.bands.StiColumnHeaderBand;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiEmptyBand;
import com.stimulsoft.report.components.bands.StiFooterBand;
import com.stimulsoft.report.components.bands.StiGroupFooterBand;
import com.stimulsoft.report.components.bands.StiGroupHeaderBand;
import com.stimulsoft.report.components.bands.StiHeaderBand;
import com.stimulsoft.report.components.bands.StiHierarchicalBand;
import com.stimulsoft.report.components.bands.StiOverlayBand;
import com.stimulsoft.report.components.bands.StiPageFooterBand;
import com.stimulsoft.report.components.bands.StiPageHeaderBand;
import com.stimulsoft.report.components.bands.StiReportSummaryBand;
import com.stimulsoft.report.components.bands.StiReportTitleBand;
import com.stimulsoft.report.components.bands.StiTableOfContents;
import com.stimulsoft.report.components.complexcomponents.StiClone;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.complexcomponents.StiPanel;
import com.stimulsoft.report.components.complexcomponents.StiSubReport;
import com.stimulsoft.report.components.conditions.StiBaseCondition;
import com.stimulsoft.report.components.conditions.StiColorScaleCondition;
import com.stimulsoft.report.components.conditions.StiCondition;
import com.stimulsoft.report.components.conditions.StiConditionsCollection;
import com.stimulsoft.report.components.conditions.StiDataBarCondition;
import com.stimulsoft.report.components.conditions.StiFilter;
import com.stimulsoft.report.components.conditions.StiIconSetCondition;
import com.stimulsoft.report.components.conditions.StiIconSetItem;
import com.stimulsoft.report.components.conditions.StiMultiCondition;
import com.stimulsoft.report.components.crossBands.StiCrossDataBand;
import com.stimulsoft.report.components.crossBands.StiCrossFooterBand;
import com.stimulsoft.report.components.crossBands.StiCrossGroupFooterBand;
import com.stimulsoft.report.components.crossBands.StiCrossGroupHeaderBand;
import com.stimulsoft.report.components.crossBands.StiCrossHeaderBand;
import com.stimulsoft.report.components.enums.StiAligning;
import com.stimulsoft.report.components.enums.StiAnchorMode;
import com.stimulsoft.report.components.enums.StiAngle;
import com.stimulsoft.report.components.enums.StiBrushType;
import com.stimulsoft.report.components.enums.StiCheckStyle;
import com.stimulsoft.report.components.enums.StiColorScaleType;
import com.stimulsoft.report.components.enums.StiConditionBorderSides;
import com.stimulsoft.report.components.enums.StiConditionPermissions;
import com.stimulsoft.report.components.enums.StiDataBarDirection;
import com.stimulsoft.report.components.enums.StiDockStyle;
import com.stimulsoft.report.components.enums.StiFilterCondition;
import com.stimulsoft.report.components.enums.StiFilterDataType;
import com.stimulsoft.report.components.enums.StiFilterEngine;
import com.stimulsoft.report.components.enums.StiFilterItem;
import com.stimulsoft.report.components.enums.StiFilterMode;
import com.stimulsoft.report.components.enums.StiGroupSortDirection;
import com.stimulsoft.report.components.enums.StiGroupSummaryType;
import com.stimulsoft.report.components.enums.StiIcon;
import com.stimulsoft.report.components.enums.StiIconSet;
import com.stimulsoft.report.components.enums.StiIconSetOperation;
import com.stimulsoft.report.components.enums.StiIconSetValueType;
import com.stimulsoft.report.components.enums.StiImageRotation;
import com.stimulsoft.report.components.enums.StiMaximumType;
import com.stimulsoft.report.components.enums.StiMidType;
import com.stimulsoft.report.components.enums.StiMinimumType;
import com.stimulsoft.report.components.enums.StiPageOrientation;
import com.stimulsoft.report.components.enums.StiPrintOnType;
import com.stimulsoft.report.components.enums.StiRestrictions;
import com.stimulsoft.report.components.enums.StiShiftMode;
import com.stimulsoft.report.components.shapeTypes.StiArrowShapeType;
import com.stimulsoft.report.components.shapeTypes.StiShapeDirection;
import com.stimulsoft.report.components.shapeTypes.StiShapeTypeService;
import com.stimulsoft.report.components.simplecomponents.StiCheckBox;
import com.stimulsoft.report.components.simplecomponents.StiCrossLinePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiEndPointPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiHorizontalLinePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.components.simplecomponents.StiPointPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiRectanglePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiRichText;
import com.stimulsoft.report.components.simplecomponents.StiRoundedRectanglePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiShape;
import com.stimulsoft.report.components.simplecomponents.StiStartPointPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.components.simplecomponents.StiTextInCells;
import com.stimulsoft.report.components.simplecomponents.StiVerticalLinePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiZipCode;
import com.stimulsoft.report.components.table.IStiTableCell;
import com.stimulsoft.report.components.table.StiTable;
import com.stimulsoft.report.components.table.StiTableCell;
import com.stimulsoft.report.components.table.StiTableCellCheckBox;
import com.stimulsoft.report.components.table.StiTableCellImage;
import com.stimulsoft.report.components.table.StiTableCellRichText;
import com.stimulsoft.report.components.table.enums.StiTablceCellType;
import com.stimulsoft.report.components.textFormats.StiFormatService;
import com.stimulsoft.report.crossTab.StiCrossTab;
import com.stimulsoft.report.crossTab.enums.StiCrossHorAlignment;
import com.stimulsoft.report.dictionary.StiDataBuilder;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.StiDataRelationsCollection;
import com.stimulsoft.report.dictionary.StiDictionary;
import com.stimulsoft.report.dictionary.StiResource;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.databases.StiDatabase;
import com.stimulsoft.report.dictionary.databases.StiResourcesCollection;
import com.stimulsoft.report.dictionary.databases.StiXmlDatabase;
import com.stimulsoft.report.enums.StiHtmlPreviewMode;
import com.stimulsoft.report.enums.StiReportUnitType;
import com.stimulsoft.report.events.StiEvent;
import com.stimulsoft.report.export.service.StiRtfExportService;
import com.stimulsoft.report.export.service.StiSvgExportService;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.expressions.StiArgumentExpression;
import com.stimulsoft.report.expressions.StiDataUrlExpression;
import com.stimulsoft.report.expressions.StiExcelValueExpression;
import com.stimulsoft.report.expressions.StiExpression;
import com.stimulsoft.report.expressions.StiGroupConditionExpression;
import com.stimulsoft.report.expressions.StiGroupSummaryExpression;
import com.stimulsoft.report.expressions.StiImageDataExpression;
import com.stimulsoft.report.expressions.StiImageURLExpression;
import com.stimulsoft.report.helpers.StiHyperlinkProcessor;
import com.stimulsoft.report.infographics.gauge.StiGauge;
import com.stimulsoft.report.maps.StiMap;
import com.stimulsoft.report.maps.enums.StiMapID;
import com.stimulsoft.report.options.DesignerOptions;
import com.stimulsoft.report.styles.StiBaseStyle;
import com.stimulsoft.report.styles.StiStylesCollection;
import com.stimulsoft.report.styles.StiStylesCreator;
import com.stimulsoft.report.styles.conditions.StiStyleCondition;
import com.stimulsoft.report.styles.enums.StiStyleComponentPlacement;
import com.stimulsoft.report.viewer.StiPreviewSettings;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.enums.StiDesignerCommand;
import com.stimulsoft.web.helper.StiCacheHelper;
import com.stimulsoft.web.helper.StiEncodingHelper;
import com.stimulsoft.web.helper.StiGalleriesHelper;
import com.stimulsoft.web.helper.StiReportContainer;
import com.stimulsoft.web.helper.StiRequestParamsHelper;
import com.stimulsoft.web.proxyee.StiHttpServletRequest;
import com.stimulsoft.webdesigner.helper.StiChartHelper;
import com.stimulsoft.webdesigner.helper.StiCrossTabHelper;
import com.stimulsoft.webdesigner.helper.StiDesignReportHelper;
import com.stimulsoft.webdesigner.helper.StiGaugeHelper;
import com.stimulsoft.webdesigner.helper.StiGroup;
import com.stimulsoft.webdesigner.helper.StiInsertionComponents;
import com.stimulsoft.webdesigner.helper.StiMapHelper;
import com.stimulsoft.webdesigner.helper.StiPreviewHelper;
import com.stimulsoft.webdesigner.helper.StiStylesHelper;
import com.stimulsoft.webdesigner.helper.StiTextFormatHelper;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class StiReportEdit {
    protected static final Logger LOG = Logger.getLogger(StiReportEdit.class.getName());
    private static String[] SERIES = new String[]{"com.stimulsoft.report.chart.view.series.bubble", "com.stimulsoft.report.chart.view.series.candlestick", "com.stimulsoft.report.chart.view.series.clusteredBar", "com.stimulsoft.report.chart.view.series.clusteredColumn", "com.stimulsoft.report.chart.view.series.doughnut", "com.stimulsoft.report.chart.view.series.fullStackedBar", "com.stimulsoft.report.chart.view.series.fullStackedColumn", "com.stimulsoft.report.chart.view.series.funnel", "com.stimulsoft.report.chart.view.series.gantt", "com.stimulsoft.report.chart.view.series.pie", "com.stimulsoft.report.chart.view.series.radar", "com.stimulsoft.report.chart.view.series.range", "com.stimulsoft.report.chart.view.series.scatter", "com.stimulsoft.report.chart.view.series.stackedBar", "com.stimulsoft.report.chart.view.series.stackedColumn", "com.stimulsoft.report.chart.view.series.stock", "com.stimulsoft.report.chart.view.series"};

    public static Object getPropertyValue(String propertyName, Object owner) {
        Method property;
        block36: {
            if (owner == null) {
                return null;
            }
            property = null;
            String[] propertyArray = propertyName.split("\\.");
            Object parentOwner = null;
            try {
                if (propertyArray.length == 1 || propertyArray.length == 0) {
                    try {
                        property = owner.getClass().getMethod("get" + propertyName, new Class[0]);
                    }
                    catch (NoSuchMethodException n) {
                        property = owner.getClass().getMethod("is" + propertyName, new Class[0]);
                    }
                    break block36;
                }
                for (int i = 0; i < propertyArray.length; ++i) {
                    parentOwner = owner;
                    try {
                        property = owner.getClass().getMethod("get" + propertyArray[i], new Class[0]);
                    }
                    catch (NoSuchMethodException n) {
                        property = owner.getClass().getMethod("is" + propertyArray[i], new Class[0]);
                    }
                    if (property == null) {
                        return null;
                    }
                    owner = property.invoke(owner, new Object[0]);
                }
                owner = parentOwner;
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel >= 20) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        if (property != null) {
            Object value = null;
            try {
                value = property.invoke(owner, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (value == null) {
                return "";
            }
            if (value instanceof String) {
                return "Base64Code;" + StiEncodingHelper.encode((String)((String)value));
            }
            if (value instanceof Boolean) {
                return value;
            }
            if (value instanceof Double || value instanceof Float) {
                return value.toString().replace(",", ".");
            }
            if (value instanceof Integer) {
                return value.toString();
            }
            if (value instanceof StiPenStyle) {
                return ((StiPenStyle)value).name();
            }
            if (value instanceof StiExpression) {
                return "Base64Code;" + StiEncodingHelper.encode((String)((StiExpression)value).getValue());
            }
            if (value instanceof StiArgumentExpression) {
                return "Base64Code;" + StiEncodingHelper.encode((String)((StiArgumentExpression)value).getValue());
            }
            if (value instanceof StiListOfArgumentsExpression) {
                return "Base64Code;" + StiEncodingHelper.encode((String)((StiListOfArgumentsExpression)value).getValue());
            }
            if (value instanceof StiColor) {
                return StiReportEdit.getStringFromColor((StiColor)value);
            }
            if (value instanceof StiBrush) {
                return StiReportEdit.brushToStr((StiBrush)value);
            }
            if (value instanceof StiBorder) {
                return StiReportEdit.borderToStr((StiBorder)value);
            }
            if (value instanceof StiFont) {
                return StiReportEdit.fontToStr((StiFont)value);
            }
            if (value instanceof StiSize) {
                return ((StiSize)value).getWidth() + ";" + ((StiSize)value).getHeight();
            }
            if (value instanceof StiDataRelation) {
                return ((StiDataRelation)value).getNameInSource();
            }
            if (value instanceof StiDataSource) {
                return ((StiDataSource)value).getName();
            }
            if (value instanceof StiBusinessObject) {
                return ((StiBusinessObject)value).GetFullName();
            }
            if (value instanceof StiFiltersCollection) {
                return StiReportEdit.getFiltersProperty(owner);
            }
            if (value instanceof List && "Sort".equals(propertyName)) {
                return StiReportEdit.getSortDataProperty(owner);
            }
            if (value instanceof StiImage) {
                return value != null ? StiReportEdit.imageToBase64((StiImage)value) : "";
            }
            if (value instanceof StiMargins) {
                return String.format("%s;%s;%s;%s", ((StiMargins)value).getLeft(), ((StiMargins)value).getTop(), ((StiMargins)value).getRight(), ((StiMargins)value).getBottom());
            }
            if (value instanceof StiEvent) {
                return ((StiEvent)value).getScript();
            }
            return value.toString();
        }
        return null;
    }

    public static Method getSetter(Class<?> cl, String name) {
        for (Method method : cl.getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public static Method getSetter(Class<?> cl, String name, Class<?> clazz) {
        for (Method method : cl.getMethods()) {
            if (!method.getName().equals(name) || !method.getParameterTypes()[0].equals(clazz)) continue;
            return method;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setPropertyValue(StiReport report, String propertyName, Object owner, Object value) throws Exception {
        Method property = null;
        String[] propertyArray = propertyName.split("\\.");
        Object parentOwner = null;
        if (propertyArray.length <= 1) {
            property = StiReportEdit.getSetter(owner.getClass(), "set" + propertyName);
        } else {
            for (int i = 0; i < propertyArray.length; ++i) {
                parentOwner = owner;
                property = StiReportEdit.getSetter(owner.getClass(), (i == propertyArray.length - 1 ? "set" : "get") + propertyArray[i]);
                if (property == null) return;
                if (i == propertyArray.length - 1) continue;
                owner = property.invoke(owner, new Object[0]);
            }
            owner = parentOwner;
        }
        if (property == null) {
            if (StiOptions.Engine.logLevel < 10) return;
            LOG.warning("setPropertyValue(). Property: " + propertyName + " for class: " + owner.getClass() + " for value: " + value + " not found.");
            return;
        }
        String className = property.getParameterTypes()[0].getName().substring(property.getParameterTypes()[0].getName().lastIndexOf(46) + 1);
        if (property == null) return;
        if (value instanceof String && ((String)value).startsWith("Base64Code;")) {
            value = StiEncodingHelper.decodeString((String)((String)value).replace("Base64Code;", ""));
        }
        if (property.getParameterTypes()[0].equals(String.class) || property.getParameterTypes()[0].equals(Boolean.class) || property.getParameterTypes()[0].equals(Boolean.TYPE)) {
            property.invoke(owner, value);
            return;
        }
        if (property.getParameterTypes()[0].equals(Integer.class) || property.getParameterTypes()[0].equals(Integer.TYPE)) {
            property.invoke(owner, StiReportEdit.strToInt(value));
            return;
        }
        if (property.getParameterTypes()[0].equals(Double.class) || property.getParameterTypes()[0].equals(Double.TYPE)) {
            property.invoke(owner, StiReportEdit.strToDouble((String)value));
            return;
        }
        if (property.getParameterTypes()[0].equals(Float.class) || property.getParameterTypes()[0].equals(Float.TYPE)) {
            property.invoke(owner, Float.valueOf((float)StiReportEdit.strToDouble((String)value)));
            return;
        }
        if (property.getParameterTypes()[0].equals(StiPenStyle.class)) {
            property.invoke(owner, StiPenStyle.forValue((int)StiReportEdit.strToInt(value)));
            return;
        }
        if (value instanceof StiPaperKind) {
            property.invoke(owner, StiPaperKind.forValue((int)StiReportEdit.strToInt(value)));
            return;
        }
        if (value instanceof StiGroupSortDirection) {
            property.invoke(owner, StiGroupSortDirection.forValue((int)StiReportEdit.strToInt(value)));
            return;
        }
        if (value instanceof StiGroupSummaryType) {
            property.invoke(owner, StiGroupSummaryType.forValue((int)StiReportEdit.strToInt(value)));
            return;
        }
        if (property.getParameterTypes()[0].equals(StiColor.class)) {
            property.invoke(owner, StiReportEdit.strToColor((String)value));
            return;
        }
        if (property.getParameterTypes()[0].equals(StiBrush.class)) {
            property.invoke(owner, StiReportEdit.strToBrush((String)value));
            return;
        }
        if (property.getParameterTypes()[0].equals(StiBorder.class)) {
            property.invoke(owner, StiReportEdit.strToBorder((String)value));
            return;
        }
        if (property.getParameterTypes()[0].equals(StiMargins.class)) {
            StiMargins margins = new StiMargins();
            String[] marginsArray = ((String)value).split(";");
            margins.setLeft(StiReportEdit.strToDouble(marginsArray[0]));
            margins.setTop(StiReportEdit.strToDouble(marginsArray[1]));
            margins.setRight(StiReportEdit.strToDouble(marginsArray[2]));
            margins.setBottom(StiReportEdit.strToDouble(marginsArray[3]));
            property.invoke(owner, margins);
            return;
        }
        if (property.getParameterTypes()[0].equals(StiFont.class)) {
            property.invoke(owner, StiReportEdit.strToFont((String)value, report));
            return;
        }
        if (property.getParameterTypes()[0].equals(StiSize.class)) {
            StiSize propertyValue = new StiSize();
            String[] sizes = ((String)value).split(";");
            if (sizes.length == 2) {
                propertyValue.setWidth((double)StiReportEdit.strToInt(sizes[0]));
                propertyValue.setHeight((double)StiReportEdit.strToInt(sizes[1]));
            }
            property.invoke(owner, propertyValue);
            return;
        }
        if (property.getParameterTypes()[0].equals(StiPage.class)) {
            StiPage page = null;
            try {
                page = report.getPages().get(Integer.parseInt((String)value));
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel >= 10) {
                    e.printStackTrace();
                }
                page = report.getPages().get((String)value);
            }
            property.invoke(owner, page);
            return;
        }
        if (className.startsWith("Sti") && className.endsWith("Expression")) {
            StiExpression propertyExpression;
            block69: {
                propertyExpression = null;
                try {
                    propertyExpression = (StiExpression)property.getParameterTypes()[0].newInstance();
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block69;
                    e.printStackTrace();
                }
            }
            if (propertyExpression != null) {
                propertyExpression.setValue((String)value);
            }
            property.invoke(owner, propertyExpression);
            return;
        }
        if (property.getParameterTypes()[0].isEnum()) {
            Class<?> cl = property.getParameterTypes()[0].getClass();
            if (!cl.isEnum()) {
                cl = Class.forName(property.getParameterTypes()[0].getName());
            }
            try {
                property.invoke(owner, Enum.valueOf(cl, (String)value));
                return;
            }
            catch (Exception e) {
                property.invoke(owner, cl.getMethod("forValue", Integer.TYPE).invoke(cl, value != null ? Integer.valueOf(value.toString()) : value));
            }
            return;
        } else if (property.getParameterTypes()[0].equals(StiDataRelation.class)) {
            StiReportEdit.setDataRelationProperty(owner, value);
            return;
        } else if (property.getParameterTypes()[0].equals(StiDataSource.class)) {
            StiReportEdit.setDataSourceProperty(owner, value);
            return;
        } else if (property.getParameterTypes()[0].equals(StiBusinessObject.class)) {
            StiReportEdit.setBusinessObjectProperty(owner, value);
            return;
        } else if (property.getParameterTypes()[0].equals(StiComponent.class)) {
            StiReportEdit.setMasterComponentProperty(owner, value);
            return;
        } else if (property.getParameterTypes()[0].equals(StiFiltersCollection.class)) {
            StiReportEdit.setFiltersProperty(owner, (HashMap)value);
            return;
        } else if (property.getParameterTypes()[0].equals(String[].class) && propertyName.equals("Sort")) {
            StiReportEdit.setSortDataProperty(owner, value);
            return;
        } else if (property.getParameterTypes()[0].equals(String.class) && (propertyName.equals("CustomIcon") || propertyName.equals("Icon"))) {
            property.invoke(owner, StiValidationUtil.isNullOrEmpty((String)((String)value)) ? null : value);
            return;
        } else if (property.getParameterTypes()[0].equals(StiListOfValuesExpression.class)) {
            property.invoke(owner, new StiListOfValuesExpression((String)value));
            return;
        } else if (property.getParameterTypes()[0].equals(StiListOfArgumentsExpression.class)) {
            property.invoke(owner, new StiListOfArgumentsExpression((String)value));
            return;
        } else if (property.getParameterTypes()[0].equals(StiListOfToolTipsExpression.class)) {
            property.invoke(owner, new StiListOfToolTipsExpression((String)value));
            return;
        } else if (property.getParameterTypes()[0].equals(StiListOfTagsExpression.class)) {
            property.invoke(owner, new StiListOfTagsExpression((String)value));
            return;
        } else if (property.getParameterTypes()[0].equals(StiListOfHyperlinksExpression.class)) {
            property.invoke(owner, new StiListOfHyperlinksExpression((String)value));
            return;
        } else if (property.getParameterTypes()[0].equals(StiImage.class)) {
            String propertyValue = (String)value;
            if (StiValidationUtil.isNotNullOrEmpty((String)propertyValue) && propertyValue.startsWith("data:image")) {
                property.invoke(owner, StiReportEdit.base64ToImage(propertyValue));
                return;
            } else {
                try {
                    property.invoke(owner, new Object[]{null});
                    return;
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) return;
                    e.printStackTrace();
                    LOG.severe("Property: " + property + ", owner: " + owner + ",propertyName: " + propertyName + ", value: " + propertyValue);
                }
            }
            return;
        } else if (property.getParameterTypes()[0].equals(StiConditionsCollection.class)) {
            StiReportEdit.setConditionsProperty(owner, value, report);
            return;
        } else if (property.getParameterTypes()[0].equals(StiInteraction.class)) {
            StiReportEdit.setInteractionProperty(owner, value);
            return;
        } else if (property.getParameterTypes()[0].equals(StiFormatService.class)) {
            StiReportEdit.setTextFormatProperty(owner, (HashMap)value);
            return;
        } else {
            if (!property.getParameterTypes()[0].equals(StiStylesCollection.class)) return;
            StiReportEdit.setStylesProperty(owner, value, report);
        }
    }

    public static HashMap<String, Object> getFiltersProperty(Object obj) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("filterData", StiReportEdit.getFilterDataProperty(obj));
        properties.put("filterOn", StiReportEdit.getFilterOnProperty(obj));
        properties.put("filterMode", StiReportEdit.getFilterModeProperty(obj));
        return properties;
    }

    public static void setFiltersProperty(Object obj, HashMap<String, Object> value) throws JSONException {
        StiReportEdit.setFilterDataProperty(obj, (String)value.get("filterData"));
        StiReportEdit.setFilterOnProperty(obj, value.get("filterOn"));
        StiReportEdit.setFilterModeProperty(obj, value.get("filterMode"));
    }

    public static String lowerFirstChar(String text) {
        return text.substring(0, 1).toLowerCase() + text.substring(1);
    }

    public static String upperFirstChar(String text) {
        String[] textArray = text.split("\\.");
        if (textArray.length == 1) {
            return Character.toString(text.charAt(0)).toUpperCase() + text.substring(1);
        }
        String result = "";
        for (String word : textArray) {
            if (!"".equals(result)) {
                result = result + ".";
            }
            result = result + Character.toString(word.charAt(0)).toUpperCase() + word.substring(1);
        }
        return result;
    }

    private static void addPrimitivePoints(StiComponent addedComp, StiPage currentPage) {
        StiCrossLinePrimitive primitive;
        StiCrossLinePrimitive stiCrossLinePrimitive = primitive = addedComp instanceof StiCrossLinePrimitive ? (StiCrossLinePrimitive)addedComp : null;
        if (primitive != null) {
            StiRectangle rect = primitive.getClientRectangle();
            StiStartPointPrimitive startPoint = new StiStartPointPrimitive();
            startPoint.setLeft(rect.getLeft());
            startPoint.setTop(rect.getTop());
            currentPage.getComponents().add((StiComponent)startPoint);
            StiEndPointPrimitive endPoint = new StiEndPointPrimitive();
            if (primitive instanceof StiRectanglePrimitive) {
                endPoint.setLeft(rect.getRight());
            } else {
                endPoint.setLeft(rect.getLeft());
            }
            endPoint.top = rect.getBottom();
            endPoint.width = 0.0;
            endPoint.setHeight(0.0);
            currentPage.getComponents().add((StiComponent)endPoint);
            startPoint.referenceToGuid = primitive.getGuid();
            endPoint.referenceToGuid = primitive.getGuid();
            currentPage.Correct();
        }
    }

    private static void removePrimitivePoints(StiComponent removiedComp) {
        StiCrossLinePrimitive primitive;
        StiCrossLinePrimitive stiCrossLinePrimitive = primitive = removiedComp instanceof StiCrossLinePrimitive ? (StiCrossLinePrimitive)removiedComp : null;
        if (primitive != null) {
            StiEndPointPrimitive endPoint;
            StiStartPointPrimitive startPoint = primitive.getStartPoint();
            if (startPoint != null && startPoint.getParent() != null && startPoint.getParent().getComponents().contains((Object)startPoint)) {
                startPoint.setReferenceToGuid(null);
                startPoint.getParent().getComponents().remove((Object)startPoint);
            }
            if ((endPoint = primitive.getEndPoint()) != null && endPoint.getParent() != null && endPoint.getParent().getComponents().contains((Object)endPoint)) {
                endPoint.setReferenceToGuid(null);
                endPoint.getParent().getComponents().remove((Object)endPoint);
            }
        }
    }

    private static void changeRectPrimitivePoints(StiComponent changedComp, StiRectangle rect) {
        StiCrossLinePrimitive primitive;
        StiCrossLinePrimitive stiCrossLinePrimitive = primitive = changedComp instanceof StiCrossLinePrimitive ? (StiCrossLinePrimitive)changedComp : null;
        if (primitive != null) {
            StiEndPointPrimitive endPoint;
            StiStartPointPrimitive startPoint = primitive.getStartPoint();
            if (startPoint != null) {
                startPoint.setPaintRectangle(new StiRectangle(new StiPoint(rect.getLeft(), rect.getTop()), new StiSize(0, 0)));
            }
            if ((endPoint = primitive.getEndPoint()) != null) {
                endPoint.setPaintRectangle(new StiRectangle(new StiPoint(primitive instanceof StiRectanglePrimitive ? rect.getRight() : rect.getLeft(), rect.getBottom()), new StiSize(0, 0)));
            }
        }
    }

    private static void checkAllPrimitivePoints(StiPage page) {
        HashMap primitiveElements = new HashMap();
        for (StiComponent comp : page.GetComponents()) {
            String guid;
            if (!(comp instanceof StiPointPrimitive) && !(comp instanceof StiCrossLinePrimitive) || StiValidationUtil.isNullOrEmpty((String)(guid = comp instanceof StiPointPrimitive ? ((StiPointPrimitive)comp).getReferenceToGuid() : ((StiCrossLinePrimitive)comp).getGuid()))) continue;
            if (!primitiveElements.containsKey(guid)) {
                primitiveElements.put(guid, new ArrayList());
            }
            ((ArrayList)primitiveElements.get(guid)).add(comp);
        }
        for (String key : primitiveElements.keySet()) {
            ArrayList primitiveComponents = (ArrayList)primitiveElements.get(key);
            if (primitiveComponents.size() >= 3) continue;
            for (StiComponent comp : primitiveComponents) {
                if (comp == null || comp.getParent() == null || !comp.getParent().getComponents().contains((Object)comp)) continue;
                comp.getParent().getComponents().remove((Object)comp);
            }
        }
    }

    private static boolean isAlignedByGrid(StiComponent component) {
        double gridSize = component.getReport().getInfo().getGridSize();
        return component.getLeft() % gridSize == 0.0 && component.top % gridSize == 0.0 && component.width % gridSize == 0.0 && component.getHeight() % gridSize == 0.0;
    }

    private static void addSubReportPage(StiSubReport subReport, HashMap<String, Object> callbackResult) throws Exception {
        if (subReport != null) {
            StiPage page = new StiPage(subReport.getReport());
            page.setSkip(true);
            subReport.getReport().getPages().add(page);
            subReport.setSubReportPage(page);
            page.setName(StiNameCreation.createName((StiReport)subReport.getReport(), (String)StiNameCreation.generateName((StiReport)subReport.getReport(), (String)(subReport.getLocalizedName() + '_'), (String)"subReport_")));
            HashMap<String, Object> subReportPage = new HashMap<String, Object>();
            subReportPage.put("name", page.getName());
            subReportPage.put("pageIndex", String.valueOf(subReport.getReport().getPages().indexOf((Object)page)));
            subReportPage.put("properties", StiReportEdit.getAllProperties((StiComponent)page));
            subReportPage.put("pageIndexes", StiReportEdit.getPageIndexes(subReport.getReport()));
            callbackResult.put("newSubReportPage", subReportPage);
        }
    }

    public static StiImage base64ToImage(String base64String) {
        StiImage image = new StiImage();
        image.setImageBytes(base64String.indexOf(44) > 0 ? base64String.substring(base64String.indexOf(44) + 1) : base64String);
        return image;
    }

    public static String imageToBase64(String img) {
        String mimeType = "data:image/png;base64,";
        if (img != null && img.length() >= 128) {
            byte[] image = StiBase64DecoderUtil.decode((String)img.substring(0, 128));
            if (StiImageHelper.isMetafile((byte[])image)) {
                mimeType = "data:image/x-wmf;base64,";
            } else if (StiImageHelper.isBmp((byte[])image)) {
                mimeType = "data:image/bmp;base64,";
            } else if (StiImageHelper.isJpeg((byte[])image)) {
                mimeType = "data:image/jpeg;base64,";
            } else if (StiImageHelper.isGif((byte[])image)) {
                mimeType = "data:image/gif;base64,";
            } else {
                image = StiBase64DecoderUtil.decode((String)img);
                if (StiSvgHelper.isSvg((byte[])image)) {
                    mimeType = "data:image/svg+xml;base64,";
                }
            }
        }
        return mimeType + img;
    }

    public static String imageToBase64(byte[] img) throws UnsupportedEncodingException {
        String mimeType = "data:image/png;base64,";
        if (img != null && img.length >= 128) {
            if (StiImageHelper.isMetafile((byte[])img)) {
                mimeType = "data:image/x-wmf;base64,";
            } else if (StiImageHelper.isBmp((byte[])img)) {
                mimeType = "data:image/bmp;base64,";
            } else if (StiImageHelper.isJpeg((byte[])img)) {
                mimeType = "data:image/jpeg;base64,";
            } else if (StiImageHelper.isGif((byte[])img)) {
                mimeType = "data:image/gif;base64,";
            } else if (StiSvgHelper.isSvg((byte[])img)) {
                mimeType = "data:image/svg+xml;base64,";
            }
        }
        return mimeType + new String(StiBase64EncoderUtil.encode((byte[])img), "UTF-8");
    }

    public static String imageToBase64(StiImage image) {
        return StiReportEdit.imageToBase64(image.getImageBytesToDraw());
    }

    public static String fontToStr(StiFont font) {
        String fontStr = "";
        if (font != null) {
            fontStr = String.format("%s!%s!%s!%s!%s!%s", font.getName(), font.getSize(), font.bold() ? "1" : "0", font.italic() ? "1" : "0", font.underline() ? "1" : "0", font.strikeout() ? "1" : "0");
        }
        return fontStr;
    }

    public static String brushToStr(StiBrush brush) {
        String brushStr = "none";
        if (brush instanceof StiEmptyBrush) {
            brushStr = "0";
        } else if (brush instanceof StiSolidBrush) {
            StiSolidBrush solid = (StiSolidBrush)brush;
            brushStr = String.format("1!%s", StiReportEdit.getStringFromColor(solid.getColor()));
        } else if (brush instanceof StiHatchBrush) {
            StiHatchBrush hatch = (StiHatchBrush)brush;
            brushStr = String.format("2!%s!%s!%s", StiReportEdit.getStringFromColor(hatch.getForeColor()), StiReportEdit.getStringFromColor(hatch.getBackColor()), hatch.getStyle().getValue());
        } else if (brush instanceof StiGradientBrush) {
            StiGradientBrush gradient = (StiGradientBrush)brush;
            brushStr = String.format("3!%s!%s!%s", StiReportEdit.getStringFromColor(gradient.getStartColor()), StiReportEdit.getStringFromColor(gradient.getEndColor()), gradient.getAngle());
        } else if (brush instanceof StiGlareBrush) {
            StiGlareBrush glare = (StiGlareBrush)brush;
            brushStr = String.format("4!%s!%s!%s!%s!%s", StiReportEdit.getStringFromColor(glare.getStartColor()), StiReportEdit.getStringFromColor(glare.getEndColor()), glare.getAngle(), Float.valueOf(glare.getFocus()), Float.valueOf(glare.getScale()));
        } else if (brush instanceof StiGlassBrush) {
            StiGlassBrush glass = (StiGlassBrush)brush;
            brushStr = String.format("5!%s!%s!%s", StiReportEdit.getStringFromColor(glass.getColor()), Float.valueOf(glass.getBlend()), glass.getDrawHatch() ? "1" : "0");
        }
        return brushStr;
    }

    public static String borderToStr(StiBorder border) {
        String borderStr = "";
        borderStr = String.format("%s,%s,%s,%s!%s!%s!%s!%s!%s!%s!%s", border.isLeftBorderSidePresent() ? "1" : "0", border.isTopBorderSidePresent() ? "1" : "0", border.isRightBorderSidePresent() ? "1" : "0", border.isBottomBorderSidePresent() ? "1" : "0", border.getSize(), StiReportEdit.getStringFromColor(border.getColor()), border.getStyle().getValue(), border.getDropShadow() ? "1" : "0", border.getShadowSize(), StiEncodingHelper.encode((String)StiReportEdit.brushToStr(border.getShadowBrush())), border.getTopmost() ? "1" : "0");
        return borderStr;
    }

    public static String getStringFromColor(StiColor color) {
        if (color.getA() == 0) {
            return "transparent";
        }
        if (color.getA() == 255) {
            return String.format("%s,%s,%s", color.getR(), color.getG(), color.getB());
        }
        return String.format("%s,%s,%s,%s", color.getA(), color.getR(), color.getG(), color.getB());
    }

    public static void addComponentToPage(StiComponent component, StiPage currentPage) {
        currentPage.getComponents().add(component);
        component.setPage(currentPage);
        component.setParent((StiContainer)currentPage);
        component.select();
    }

    public static String getParentName(StiComponent comp) {
        return comp == null || comp.getParent() == null ? "" : comp.getParent().getName();
    }

    public static Integer getParentIndex(StiComponent comp) {
        StiContainer parent;
        int index = 0;
        if (comp instanceof StiCrossLinePrimitive) {
            int index1 = StiReportEdit.getParentIndex((StiComponent)((StiCrossLinePrimitive)comp).getStartPoint());
            int index2 = StiReportEdit.getParentIndex((StiComponent)((StiCrossLinePrimitive)comp).getStartPoint());
            return Math.max(index1, index2);
        }
        StiContainer stiContainer = parent = comp != null ? comp.getParent() : null;
        while (parent != null && !(parent instanceof StiPage)) {
            parent = parent.getParent();
            ++index;
        }
        return index;
    }

    public static Integer getComponentIndex(StiComponent component) {
        StiContainer parent = component.getParent();
        ArrayList componentsList = parent.GetComponentsList();
        int index = 0;
        for (StiComponent comp : componentsList) {
            if (comp == component) {
                return index;
            }
            ++index;
        }
        return index;
    }

    public static String getAllChildComponents(StiComponent component) {
        String allChildComponents = "";
        StiPage currentPage = component.getPage();
        StiComponentsCollection components = currentPage.GetComponents();
        for (StiComponent otherComponent : components) {
            if (otherComponent instanceof StiCrossLinePrimitive) {
                StiStartPointPrimitive startPoint = ((StiCrossLinePrimitive)otherComponent).getStartPoint();
                StiEndPointPrimitive endPoint = ((StiCrossLinePrimitive)otherComponent).getEndPoint();
                if (!StiReportEdit.getParentName((StiComponent)startPoint).equals(component.getName()) && !StiReportEdit.getParentName((StiComponent)endPoint).equals(component.getName())) continue;
                allChildComponents = allChildComponents + otherComponent.getName() + ",";
                continue;
            }
            if (!StiReportEdit.getParentName(otherComponent).equals(component.getName())) continue;
            allChildComponents = allChildComponents + otherComponent.getName() + ",";
        }
        if (StiValidationUtil.isNotNullOrEmpty((String)allChildComponents)) {
            allChildComponents = allChildComponents.substring(0, allChildComponents.length() - 1);
        }
        return allChildComponents;
    }

    public static HashMap<String, Object> getPropsRebuildPage(StiReport report, StiPage currentPage) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        StiComponentsCollection components = currentPage.GetComponents();
        for (StiComponent component : components) {
            HashMap<String, String> compProperties = new HashMap<String, String>();
            props.put(component.getName(), compProperties);
            compProperties.put("componentRect", StiReportEdit.getComponentRect(component));
            compProperties.put("parentName", StiReportEdit.getParentName(component));
            compProperties.put("parentIndex", StiReportEdit.fmt(StiReportEdit.getParentIndex(component).intValue()));
            compProperties.put("componentIndex", String.valueOf(StiReportEdit.getComponentIndex(component)));
            compProperties.put("childs", StiReportEdit.getAllChildComponents(component));
            compProperties.put("clientLeft", StiReportEdit.doubleToStr(component.getLeft()));
            compProperties.put("clientTop", StiReportEdit.doubleToStr(component.getTop()));
        }
        return props;
    }

    public static HashMap<String, Object> getPageIndexes(StiReport report) {
        HashMap<String, Object> pageIndexes = new HashMap<String, Object>();
        Integer index = 0;
        while (index < report.getPages().size()) {
            pageIndexes.put(report.getPages().get(index.intValue()).getName(), index.toString());
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return pageIndexes;
    }

    public static void setComponentRectWithOffset(StiComponent comp, StiRectangle newCompRect, String command, String resizeType, HashMap compProps) {
        StiPage currentPage = comp.getPage();
        StiRectangle currCompRect = currentPage.getUnit().ConvertFromHInches(comp.getPaintRectangle());
        for (StiComponent component : currentPage.GetComponents()) {
            component.setIsSelected(false);
        }
        StiRectangle rect = new StiRectangle();
        if (!StiValidationUtil.isNullOrEmpty((String)resizeType) && resizeType.startsWith("Multi")) {
            rect = new StiRectangle(currCompRect.getLeft() - newCompRect.getLeft(), currCompRect.getTop() - newCompRect.getTop(), newCompRect.width - currCompRect.width, newCompRect.height - currCompRect.height).AlignToGrid(currentPage.getGridSize(), currentPage.getReport().getInfo().getAlignToGrid());
        } else if ("MoveComponent".equals(command)) {
            rect = new StiRectangle(currCompRect.getLeft() - newCompRect.getLeft(), currCompRect.getTop() - newCompRect.getTop(), 0.0, 0.0).AlignToGrid(currentPage.getGridSize(), currentPage.getReport().getInfo().getAlignToGrid());
        } else if ("ResizeComponent".equals(command)) {
            boolean invertHeight;
            boolean invertWidth = compProps.containsKey("invertWidth") && (Boolean)compProps.get("invertWidth") != false;
            boolean bl = invertHeight = compProps.containsKey("invertHeight") && (Boolean)compProps.get("invertHeight") != false;
            if (resizeType.equals("Left")) {
                rect = new StiRectangle(invertWidth ? -(currCompRect.getWidth() + newCompRect.getWidth()) : currCompRect.getLeft() - newCompRect.getLeft(), 0.0, invertWidth ? -(currCompRect.getWidth() + newCompRect.getWidth()) : currCompRect.getLeft() - newCompRect.getLeft(), 0.0).AlignToGrid(currentPage.getGridSize(), currentPage.getReport().getInfo().getAlignToGrid());
            } else if (resizeType.equals("Right") || resizeType.equals("ResizeWidth")) {
                rect = new StiRectangle(0.0, 0.0, invertWidth ? -(currCompRect.getWidth() + newCompRect.getWidth()) : newCompRect.getWidth() - currCompRect.getWidth(), 0.0).AlignToGrid(currentPage.getGridSize(), currentPage.getReport().getInfo().getAlignToGrid());
            } else if (resizeType.equals("Top")) {
                rect = new StiRectangle(0.0, invertHeight ? -(currCompRect.getHeight() + newCompRect.getHeight()) : currCompRect.getTop() - newCompRect.getTop(), 0.0, invertHeight ? -(currCompRect.getHeight() + newCompRect.getHeight()) : currCompRect.getTop() - newCompRect.getTop()).AlignToGrid(currentPage.getGridSize(), currentPage.getReport().getInfo().getAlignToGrid());
            } else if (resizeType.equals("Bottom") || resizeType.equals("ResizeHeight")) {
                rect = new StiRectangle(0.0, 0.0, 0.0, invertHeight ? -(currCompRect.getHeight() + newCompRect.getHeight()) : newCompRect.getHeight() - currCompRect.getHeight()).AlignToGrid(currentPage.getGridSize(), currentPage.getReport().getInfo().getAlignToGrid());
            } else if (resizeType.equals("LeftTop")) {
                rect = new StiRectangle(invertWidth ? -(currCompRect.getWidth() + newCompRect.getWidth()) : currCompRect.getLeft() - newCompRect.getLeft(), invertHeight ? -(currCompRect.getHeight() + newCompRect.getHeight()) : currCompRect.getTop() - newCompRect.getTop(), invertWidth ? -(currCompRect.getWidth() + newCompRect.getWidth()) : currCompRect.getLeft() - newCompRect.getLeft(), invertHeight ? -(currCompRect.getHeight() + newCompRect.getHeight()) : currCompRect.getTop() - newCompRect.getTop()).AlignToGrid(currentPage.getGridSize(), currentPage.getReport().getInfo().getAlignToGrid());
            } else if (resizeType.equals("LeftBottom")) {
                rect = new StiRectangle(invertWidth ? -(currCompRect.getWidth() + newCompRect.getWidth()) : currCompRect.getLeft() - newCompRect.getLeft(), 0.0, invertWidth ? -(currCompRect.getWidth() + newCompRect.getWidth()) : currCompRect.getLeft() - newCompRect.getLeft(), invertHeight ? -(currCompRect.getHeight() + newCompRect.getHeight()) : newCompRect.getHeight() - currCompRect.getHeight()).AlignToGrid(currentPage.getGridSize(), currentPage.getReport().getInfo().getAlignToGrid());
            } else if (resizeType.equals("RightTop")) {
                rect = new StiRectangle(0.0, invertHeight ? -(currCompRect.getHeight() + newCompRect.getHeight()) : currCompRect.getTop() - newCompRect.getTop(), invertWidth ? -(currCompRect.getWidth() + newCompRect.getWidth()) : newCompRect.getWidth() - currCompRect.getWidth(), invertHeight ? -(currCompRect.getHeight() + newCompRect.getHeight()) : currCompRect.getTop() - newCompRect.getTop()).AlignToGrid(currentPage.getGridSize(), currentPage.getReport().getInfo().getAlignToGrid());
            } else if (resizeType.equals("ResizeDiagonal") || resizeType.equals("RightBottom")) {
                rect = new StiRectangle(0.0, 0.0, invertWidth ? -(currCompRect.getWidth() + newCompRect.getWidth()) : newCompRect.getWidth() - currCompRect.getWidth(), invertHeight ? -(currCompRect.getHeight() + newCompRect.getHeight()) : newCompRect.getHeight() - currCompRect.getHeight()).AlignToGrid(currentPage.getGridSize(), currentPage.getReport().getInfo().getAlignToGrid());
            }
        }
        comp.select();
        currentPage.ChangePosition(rect);
        if (comp instanceof StiCrossLinePrimitive) {
            StiReportEdit.changeRectPrimitivePoints(comp, currentPage.getUnit().ConvertFromHInches(comp.getPaintRectangle()));
        }
        if (comp instanceof StiCrossDataBand || comp instanceof StiCrossHeaderBand || comp instanceof StiCrossFooterBand || comp instanceof StiCrossGroupHeaderBand || comp instanceof StiCrossGroupFooterBand) {
            comp.getContainer().getComponents().sortBandsByLeftPosition();
        } else if (comp instanceof StiBand) {
            comp.getContainer().getComponents().sortBandsByTopPosition();
        }
        comp.getPage().Correct("MoveComponent".equals(command) && comp instanceof StiBand);
        comp.getPage().Normalize();
        comp.invert();
    }

    public static void setComponentRect(StiComponent component, StiRectangle rect, boolean alignToGrid) {
        StiReportEdit.setComponentRect(component, rect, alignToGrid, false);
    }

    public static void setComponentRect(StiComponent component, StiRectangle rect, boolean alignToGrid, boolean correctOnlySelect) {
        component.select();
        if (alignToGrid) {
            rect = rect.AlignToGrid(component.getPage().getGridSize(), component.getReport().getInfo().getAlignToGrid());
        }
        if (component instanceof StiCrossLinePrimitive) {
            StiReportEdit.changeRectPrimitivePoints(component, rect);
        }
        component.setPaintRectangle(rect);
        if (component instanceof StiCrossDataBand || component instanceof StiCrossHeaderBand || component instanceof StiCrossFooterBand || component instanceof StiCrossGroupHeaderBand || component instanceof StiCrossGroupFooterBand) {
            component.getContainer().getComponents().sortBandsByLeftPosition();
        } else if (component instanceof StiBand) {
            component.getContainer().getComponents().sortBandsByTopPosition();
        }
        component.getPage().Correct(correctOnlySelect);
    }

    public static String getComponentRect(StiComponent component) {
        StiRectangle rect = component.getPaintRectangle(false, false);
        String componentRect = String.format("%s!%s!%s!%s", StiReportEdit.doubleToStr(rect.getLeft()), StiReportEdit.doubleToStr(rect.getTop()), StiReportEdit.doubleToStr(rect.getWidth()), StiReportEdit.doubleToStr(rect.getHeight()));
        return componentRect;
    }

    public static String getPageSize(StiPage page) {
        String pageRect = String.format("%s!%s", StiReportEdit.doubleToStr(page.getPageWidth()), StiReportEdit.doubleToStr(page.getPageHeight()));
        return pageRect;
    }

    public static String getPageMargins(StiPage page) {
        StiMargins margins = page.getMargins();
        String result = String.format("%s!%s!%s!%s", StiReportEdit.doubleToStr(margins.getLeft()), StiReportEdit.doubleToStr(margins.getTop()), StiReportEdit.doubleToStr(margins.getRight()), StiReportEdit.doubleToStr(margins.getBottom()));
        return result;
    }

    public static String fmt(double d) {
        DecimalFormat df = new DecimalFormat("0.########");
        return df.format(d);
    }

    public static void getAllComponentsPositions(StiReport report, HashMap<String, Object> callbackResult) throws Exception {
        ArrayList compPositions = new ArrayList();
        ArrayList pagePositions = new ArrayList();
        for (StiPage page : report.getPages()) {
            HashMap<String, String> pageObject = new HashMap<String, String>();
            pagePositions.add(pageObject);
            pageObject.put("name", page.getName());
            pageObject.put("size", StiReportEdit.getPageSize(page));
            pageObject.put("margins", StiReportEdit.getPageMargins(page));
            pageObject.put("columnWidth", StiReportEdit.doubleToStr(page.getColumnWidth()));
            pageObject.put("columnGaps", StiReportEdit.doubleToStr(page.getColumnGaps()));
            StiComponentsCollection components = page.GetComponents();
            for (StiComponent component : components) {
                HashMap<String, Object> compObject = new HashMap<String, Object>();
                compPositions.add(compObject);
                compObject.put("pageName", page.getName());
                compObject.put("name", component.getName());
                compObject.put("componentRect", StiReportEdit.getComponentRect(component));
                compObject.put("compPos", StiReportEdit.doubleToStr(component.getLeft()) + "!" + StiReportEdit.doubleToStr(component.top));
                if (component instanceof StiPanel || component instanceof StiDataBand || component instanceof StiHierarchicalBand) {
                    Double columnWidth = StiReportEdit.gp(component, "ColumnWidth") != null ? (Double)StiReportEdit.gp(component, "ColumnWidth") : 0.0;
                    Double columnGaps = StiReportEdit.gp(component, "ColumnGaps") != null ? (Double)StiReportEdit.gp(component, "ColumnGaps") : 0.0;
                    compObject.put("columnWidth", StiReportEdit.doubleToStr(columnWidth));
                    compObject.put("columnGaps", StiReportEdit.doubleToStr(columnGaps));
                }
                if (!(component instanceof StiCrossTab)) continue;
                compObject.put("crossTabFields", StiReportEdit.getCrossTabFieldsProperties((StiCrossTab)component));
            }
        }
        callbackResult.put("compPositions", compPositions);
        callbackResult.put("pagePositions", pagePositions);
    }

    private static Object getIconSetItemObject(StiIconSetItem iconSetItem) {
        if (iconSetItem == null) {
            return null;
        }
        HashMap<String, Object> iconSetItemObject = new HashMap<String, Object>();
        iconSetItemObject.put("Icon", iconSetItem.getIcon());
        iconSetItemObject.put("Operation", iconSetItem.getOperation());
        iconSetItemObject.put("ValueType", iconSetItem.getValueType());
        iconSetItemObject.put("Value", Float.valueOf(iconSetItem.getValue()));
        return iconSetItemObject;
    }

    private static StiIconSetItem getIconSetItemFromObject(Object item) throws JSONException {
        if (item == null) {
            return null;
        }
        HashMap iconSetItem = (HashMap)item;
        return new StiIconSetItem(iconSetItem.containsKey("Icon") ? StiIcon.valueOf((String)((String)iconSetItem.get("Icon"))) : StiIcon.None, iconSetItem.containsKey("Operation") ? StiIconSetOperation.valueOf((String)((String)iconSetItem.get("Operation"))) : StiIconSetOperation.MoreThanOrEqual, iconSetItem.containsKey("ValueType") ? StiIconSetValueType.valueOf((String)((String)iconSetItem.get("ValueType"))) : StiIconSetValueType.Percent, iconSetItem.containsKey("Value") ? new Float(StiReportEdit.strToDouble((String)iconSetItem.get("Value"))).floatValue() : 0.0f);
    }

    public static HashMap<String, Object> getAllProperties(StiComponent component) throws Exception {
        HashMap<String, Object> allProps = new HashMap<String, Object>();
        String typeComponent = component.getClass().getName().substring(component.getClass().getName().lastIndexOf(46) + 1);
        allProps.put("aliasName", StiEncodingHelper.encode((String)component.getAlias()));
        allProps.put("pointerValue", component.getPointer() != null && !StiValidationUtil.isNullOrEmpty((String)component.getPointer().getValue()) ? StiEncodingHelper.encode((String)component.getPointer().getValue()) : "");
        allProps.put("componentStyle", !StiValidationUtil.isNullOrEmpty((String)component.getComponentStyle()) ? component.getComponentStyle() : "[None]");
        allProps.put("events", StiReportEdit.getEventsProperty(component));
        if (!(component instanceof StiPrimitive)) {
            allProps.put("conditions", StiReportEdit.getConditionsProperty(component));
        }
        if (!(component instanceof StiPage)) {
            allProps.put("restrictions", component.getRestrictions().toString());
            allProps.put("locked", component.getLocked());
            allProps.put("linked", component.getLinked());
            allProps.put("useParentStyles", component.getUseParentStyles());
        }
        if (component != null && component instanceof StiBand) {
            allProps.put("headerSize", StiReportEdit.getComponentHeaderSize(component));
        }
        if (!(component instanceof StiTableOfContents)) {
            allProps.put("interaction", StiReportEdit.getInteractionProperty(component.getInteraction()));
        }
        if ("StiPage".equals(typeComponent)) {
            StiPage page = (StiPage)component;
            allProps.put("border", StiReportEdit.borderToStr(((StiPage)component).getBorder()));
            allProps.put("brush", StiReportEdit.brushToStr(((StiPage)component).getBrush()));
            allProps.put("orientation", ((StiPage)component).getOrientation().toString());
            allProps.put("unitWidth", StiReportEdit.doubleToStr(((StiPage)component).getPageWidth()));
            allProps.put("unitHeight", StiReportEdit.doubleToStr(((StiPage)component).getPageHeight()));
            allProps.put("unitMargins", StiReportEdit.getPageMargins((StiPage)component));
            allProps.put("columns", String.valueOf(((StiPage)component).getColumns()));
            allProps.put("columnWidth", StiReportEdit.doubleToStr(((StiPage)component).getColumnWidth()));
            allProps.put("columnGaps", StiReportEdit.doubleToStr(((StiPage)component).getColumnGaps()));
            allProps.put("rightToLeft", ((StiPage)component).getRightToLeft());
            allProps.put("paperSize", String.valueOf(((StiPage)component).getPaperSize().getValue()));
            allProps.put("waterMarkRatio", ((StiPage)component).getWatermark().getAspectRatio());
            allProps.put("waterMarkRightToLeft", ((StiPage)component).getWatermark().getRightToLeft());
            allProps.put("waterMarkEnabled", ((StiPage)component).getWatermark().getEnabled());
            allProps.put("waterMarkEnabledExpression", StiEncodingHelper.encode((String)((StiPage)component).getWatermark().getEnabledExpression()));
            allProps.put("waterMarkAngle", StiReportEdit.doubleToStr(((StiPage)component).getWatermark().getAngle()));
            allProps.put("waterMarkText", StiEncodingHelper.encode((String)((StiPage)component).getWatermark().getText()));
            allProps.put("waterMarkFont", StiReportEdit.fontToStr(((StiPage)component).getWatermark().getFont()));
            allProps.put("waterMarkTextBrush", StiReportEdit.brushToStr(((StiPage)component).getWatermark().getTextBrush()));
            allProps.put("waterMarkTextBehind", ((StiPage)component).getWatermark().getShowBehind());
            allProps.put("waterMarkImageBehind", ((StiPage)component).getWatermark().getShowImageBehind());
            allProps.put("waterMarkImageAlign", ((StiPage)component).getWatermark().getImageAlignment().toString());
            allProps.put("waterMarkMultipleFactor", StiReportEdit.doubleToStr(((StiPage)component).getWatermark().getImageMultipleFactor()));
            allProps.put("waterMarkStretch", ((StiPage)component).getWatermark().getImageStretch());
            allProps.put("waterMarkTiling", ((StiPage)component).getWatermark().getImageTiling());
            allProps.put("waterMarkTransparency", String.valueOf(((StiPage)component).getWatermark().getImageTransparency()));
            allProps.put("watermarkImageSrc", ((StiPage)component).getWatermark().getImageBytes() != null ? StiReportEdit.imageToBase64(((StiPage)component).getWatermark().getImageBytes()) : "");
            allProps.put("watermarkImageHyperlink", ((StiPage)component).getWatermark().getImageHyperlink());
            if (((StiPage)component).getWatermark().getImageBytes() != null) {
                BufferedImage bi = ((StiPage)component).getWatermark().getBufferedImage(component.getReport(), ((StiPage)component).getPaintRectangle());
                allProps.put("watermarkImageSize", bi.getWidth() + ";" + bi.getHeight());
            } else {
                allProps.put("watermarkImageSize", "0;0");
            }
            allProps.put("watermarkImageContentForPaint", StiReportEdit.getWatermarkImageContentForPaint((StiPage)component, allProps));
            allProps.put("stopBeforePrint", String.valueOf(((StiPage)component).getStopBeforePrint()));
            allProps.put("titleBeforeHeader", ((StiPage)component).getTitleBeforeHeader());
            allProps.put("aliasName", StiEncodingHelper.encode((String)((StiPage)component).getAlias()));
            allProps.put("largeHeight", ((StiPage)component).getLargeHeight());
            allProps.put("largeHeightFactor", String.valueOf(((StiPage)component).getLargeHeightFactor()));
            allProps.put("largeHeightAutoFactor", String.valueOf(((StiPage)component).getLargeHeightAutoFactor()));
            allProps.put("resetPageNumber", ((StiPage)component).getResetPageNumber());
            allProps.put("printOnPreviousPage", ((StiPage)component).getPrintOnPreviousPage());
            allProps.put("printHeadersFootersFromPreviousPage", ((StiPage)component).getPrintHeadersFootersFromPreviousPage());
            allProps.put("enabled", ((StiPage)component).getEnabled());
            allProps.put("mirrorMargins", ((StiPage)component).getMirrorMargins());
            allProps.put("segmentPerWidth", String.valueOf(((StiPage)component).segmentPerWidth));
            allProps.put("segmentPerHeight", String.valueOf(((StiPage)component).segmentPerHeight));
            allProps.put("unlimitedHeight", page.getUnlimitedHeight());
            allProps.put("unlimitedBreakable", page.getUnlimitedBreakable());
            allProps.put("numberOfCopies", String.valueOf(page.getNumberOfCopies()));
            allProps.put("pageIcon", page.icon != null ? StiReportEdit.imageToBase64(page.icon) : "");
        } else if ("StiText".equals(typeComponent)) {
            allProps.put("border", StiReportEdit.borderToStr(((StiText)component).getBorder()));
            allProps.put("brush", StiReportEdit.brushToStr(((StiText)component).getBrush()));
            allProps.put("text", StiEncodingHelper.encode((String)((StiText)component).getText().getValue()));
            allProps.put("textBrush", StiReportEdit.brushToStr(((StiText)component).getTextBrush()));
            allProps.put("font", StiReportEdit.fontToStr(((StiText)component).getFont()));
            allProps.put("wordWrap", ((StiText)component).getWordWrap());
            allProps.put("hideZeros", ((StiText)component).getHideZeros());
            allProps.put("maxNumberOfLines", String.valueOf(((StiText)component).getMaxNumberOfLines()));
            allProps.put("onlyText", ((StiText)component).getOnlyText());
            allProps.put("textMargins", String.format("%s;%s;%s;%s", ((StiText)component).getMargins().getLeft(), ((StiText)component).getMargins().getTop(), ((StiText)component).getMargins().getRight(), ((StiText)component).getMargins().getBottom()));
            allProps.put("allowHtmlTags", ((StiText)component).getAllowHtmlTags());
            allProps.put("editableText", ((StiText)component).getEditable());
            allProps.put("textAngle", StiReportEdit.doubleToStr(((StiText)component).getAngle()));
            allProps.put("horAlignment", ((StiText)component).getHorAlignment().toString());
            allProps.put("vertAlignment", ((StiText)component).getVertAlignment().toString());
            allProps.put("textFormat", StiTextFormatHelper.getTextFormatItem(((StiText)component).getTextFormat()));
            allProps.put("canBreak", ((StiText)component).getCanBreak());
            allProps.put("growToHeight", ((StiText)component).getGrowToHeight());
            allProps.put("autoWidth", ((StiText)component).getAutoWidth());
            allProps.put("printOn", ((StiText)component).getPrintOn().toString());
            allProps.put("printable", ((StiText)component).getPrintable());
            allProps.put("clientLeft", StiReportEdit.doubleToStr(component.getLeft()));
            allProps.put("clientTop", StiReportEdit.doubleToStr(component.getTop()));
            allProps.put("trimming", ((StiText)component).getTextOptions().getTrimming().toString());
            allProps.put("textOptionsRightToLeft", ((StiText)component).getTextOptions().getRightToLeft());
            allProps.put("processAt", ((StiText)component).getProcessAt().toString());
            allProps.put("processingDuplicates", ((StiText)component).getProcessingDuplicates().toString());
            allProps.put("shrinkFontToFit", ((StiText)component).getShrinkFontToFit());
            allProps.put("shrinkFontToFitMinimumSize", String.valueOf(((StiText)component).getShrinkFontToFitMinimumSize()));
            allProps.put("textType", ((StiText)component).getType().toString());
            allProps.put("enabled", ((StiText)component).getEnabled());
            allProps.put("canGrow", ((StiText)component).getCanGrow());
            allProps.put("canShrink", ((StiText)component).getCanShrink());
            allProps.put("editable", ((StiText)component).getEditable());
            allProps.put("shiftMode", component.getShiftMode().toString());
            allProps.put("dockStyle", ((StiText)component).getDockStyle().toString());
            allProps.put("anchor", component.getAnchor().toString());
            allProps.put("minSize", StiReportEdit.doubleToStr(component.getMinSize().width) + ";" + StiReportEdit.doubleToStr(component.getMinSize().height));
            allProps.put("maxSize", StiReportEdit.doubleToStr(component.getMaxSize().width) + ";" + StiReportEdit.doubleToStr(component.getMaxSize().height));
            allProps.put("renderTo", ((StiText)component).getRenderTo());
            allProps.put("globalizedName", ((StiText)component).getGlobalizedName());
            allProps.put("excelValue", StiEncodingHelper.encode((String)((StiText)component).getExcelValue().getValue()));
            allProps.put("exportAsImage", ((StiText)component).getExportAsImage());
            allProps.put("lineSpacing", StiReportEdit.doubleToStr(((StiText)component).getLineSpacing()));
        } else if ("StiTextInCells".equals(typeComponent)) {
            allProps.put("border", StiReportEdit.borderToStr(((StiTextInCells)component).getBorder()));
            allProps.put("brush", StiReportEdit.brushToStr(((StiTextInCells)component).getBrush()));
            allProps.put("text", StiEncodingHelper.encode((String)((StiTextInCells)component).getText().getValue()));
            allProps.put("textFormat", StiTextFormatHelper.getTextFormatItem(((StiTextInCells)component).getTextFormat()));
            allProps.put("textBrush", StiReportEdit.brushToStr(((StiTextInCells)component).getTextBrush()));
            allProps.put("font", StiReportEdit.fontToStr(((StiTextInCells)component).getFont()));
            allProps.put("horAlignment", ((StiTextInCells)component).getHorAlignment().toString());
            allProps.put("wordWrap", ((StiTextInCells)component).getWordWrap());
            allProps.put("textMargins", String.format("%s;%s;%s;%s", ((StiTextInCells)component).getMargins().getLeft(), ((StiTextInCells)component).getMargins().getTop(), ((StiTextInCells)component).getMargins().getRight(), ((StiTextInCells)component).getMargins().getBottom()));
            allProps.put("onlyText", ((StiTextInCells)component).getOnlyText());
            allProps.put("cellWidth", StiReportEdit.doubleToStr(((StiTextInCells)component).getCellWidth()));
            allProps.put("cellHeight", StiReportEdit.doubleToStr(((StiTextInCells)component).getCellHeight()));
            allProps.put("horizontalSpacing", StiReportEdit.doubleToStr(((StiTextInCells)component).getHorSpacing()));
            allProps.put("verticalSpacing", StiReportEdit.doubleToStr(((StiTextInCells)component).getVertSpacing()));
            allProps.put("rightToLeft", ((StiTextInCells)component).getRightToLeft());
            allProps.put("editableText", ((StiTextInCells)component).getEditable());
            allProps.put("canBreak", ((StiTextInCells)component).getCanBreak());
            allProps.put("growToHeight", ((StiTextInCells)component).getGrowToHeight());
            allProps.put("printOn", ((StiTextInCells)component).getPrintOn().toString());
            allProps.put("printable", ((StiTextInCells)component).getPrintable());
            allProps.put("hideZeros", ((StiTextInCells)component).getHideZeros());
            allProps.put("continuousText", ((StiTextInCells)component).getContinuousText());
            allProps.put("clientLeft", StiReportEdit.doubleToStr(component.getLeft()));
            allProps.put("clientTop", StiReportEdit.doubleToStr(component.getTop()));
            allProps.put("processAt", ((StiTextInCells)component).getProcessAt().toString());
            allProps.put("textType", ((StiTextInCells)component).getType().toString());
            allProps.put("enabled", ((StiTextInCells)component).getEnabled());
            allProps.put("canGrow", ((StiTextInCells)component).getCanGrow());
            allProps.put("canShrink", ((StiTextInCells)component).getCanShrink());
            allProps.put("shiftMode", component.getShiftMode().toString());
            allProps.put("dockStyle", ((StiTextInCells)component).getDockStyle().toString());
            allProps.put("anchor", component.getAnchor().toString());
            allProps.put("minSize", StiReportEdit.doubleToStr(component.getMinSize().width) + ";" + StiReportEdit.doubleToStr(component.getMinSize().height));
            allProps.put("maxSize", StiReportEdit.doubleToStr(component.getMaxSize().width) + ";" + StiReportEdit.doubleToStr(component.getMaxSize().height));
            allProps.put("globalizedName", ((StiTextInCells)component).getGlobalizedName());
            allProps.put("excelValue", StiEncodingHelper.encode((String)((StiTextInCells)component).getExcelValue().getValue()));
            allProps.put("exportAsImage", ((StiTextInCells)component).getExportAsImage());
            allProps.put("lineSpacing", StiReportEdit.doubleToStr(((StiTextInCells)component).getLineSpacing()));
        } else if ("StiRichText".equals(typeComponent)) {
            allProps.put("border", StiReportEdit.borderToStr(((StiRichText)component).getBorder()));
            allProps.put("backColor", StiReportEdit.getStringFromColor(((StiRichText)component).getBackColor()));
            allProps.put("richText", StiReportEdit.getRichTextProperty((StiRichText)component));
            allProps.put("richTextDataColumn", ((StiRichText)component).getDataColumn() != null ? StiEncodingHelper.encode((String)((StiRichText)component).getDataColumn()) : "");
            allProps.put("richTextUrl", ((StiRichText)component).getDataUrl() != null ? StiEncodingHelper.encode((String)((StiRichText)component).getDataUrl().getValue()) : "");
            allProps.put("editableText", ((StiRichText)component).getEditable());
            allProps.put("textMargins", String.format("%s;%s;%s;%s", ((StiRichText)component).getMargins().getLeft(), ((StiRichText)component).getMargins().getTop(), ((StiRichText)component).getMargins().getRight(), ((StiRichText)component).getMargins().getBottom()));
            allProps.put("onlyText", ((StiRichText)component).getOnlyText());
            allProps.put("wordWrap", ((StiRichText)component).getWordWrap());
            allProps.put("canBreak", ((StiRichText)component).getCanBreak());
            allProps.put("growToHeight", ((StiRichText)component).getGrowToHeight());
            allProps.put("printOn", ((StiRichText)component).getPrintOn().toString());
            allProps.put("printable", ((StiRichText)component).getPrintable());
            allProps.put("clientLeft", StiReportEdit.doubleToStr(component.getLeft()));
            allProps.put("clientTop", StiReportEdit.doubleToStr(component.getTop()));
            allProps.put("processAt", ((StiRichText)component).getProcessAt().toString());
            allProps.put("enabled", ((StiRichText)component).getEnabled());
            allProps.put("canGrow", ((StiRichText)component).getCanGrow());
            allProps.put("canShrink", ((StiRichText)component).getCanShrink());
            allProps.put("editable", ((StiRichText)component).getEditable());
            allProps.put("detectUrls", ((StiRichText)component).getDetectUrls());
            allProps.put("shiftMode", component.getShiftMode().toString());
            allProps.put("dockStyle", ((StiRichText)component).getDockStyle().toString());
            allProps.put("anchor", component.getAnchor().toString());
            allProps.put("minSize", StiReportEdit.doubleToStr(component.getMinSize().width) + ";" + StiReportEdit.doubleToStr(component.getMinSize().height));
            allProps.put("maxSize", StiReportEdit.doubleToStr(component.getMaxSize().width) + ";" + StiReportEdit.doubleToStr(component.getMaxSize().height));
        } else if ("StiImage".equals(typeComponent)) {
            allProps.put("border", StiReportEdit.borderToStr(((StiImage)component).getBorder()));
            allProps.put("brush", StiReportEdit.brushToStr(((StiImage)component).getBrush()));
            allProps.put("horAlignment", ((StiImage)component).getHorAlignment().toString());
            allProps.put("vertAlignment", ((StiImage)component).getVertAlignment().toString());
            allProps.put("stretch", ((StiImage)component).getStretch());
            allProps.put("ratio", ((StiImage)component).getAspectRatio());
            allProps.put("rotation", ((StiImage)component).getImageRotation().toString());
            allProps.put("imageMultipleFactor", StiReportEdit.doubleToStr(((StiImage)component).getMultipleFactor()));
            allProps.put("canBreak", ((StiImage)component).getCanBreak());
            allProps.put("growToHeight", ((StiImage)component).getGrowToHeight());
            allProps.put("printOn", ((StiImage)component).getPrintOn().toString());
            allProps.put("printable", ((StiImage)component).getPrintable());
            allProps.put("clientLeft", StiReportEdit.doubleToStr(component.getLeft()));
            allProps.put("clientTop", StiReportEdit.doubleToStr(component.getTop()));
            allProps.put("imageDataColumn", ((StiImage)component).getDataColumn() != null ? StiEncodingHelper.encode((String)((StiImage)component).getDataColumn()) : "");
            allProps.put("imageSrc", StiValidationUtil.isNotNullOrEmpty((String)((StiImage)component).getImageBytes()) ? StiReportEdit.imageToBase64(((StiImage)component).getImageBytes()) : "");
            allProps.put("imageUrl", ((StiImage)component).getImageURL() != null ? StiEncodingHelper.encode((String)((StiImage)component).getImageURL().getValue()) : "");
            allProps.put("imageFile", ((StiImage)component).getFile() != null ? StiEncodingHelper.encode((String)((StiImage)component).getFile()) : "");
            allProps.put("imageData", ((StiImage)component).getImageData() != null ? StiEncodingHelper.encode((String)((StiImage)component).getImageData().getValue()) : "");
            allProps.put("imageContentForPaint", StiReportEdit.getImageContentForPaint((StiImage)component));
            allProps.put("enabled", ((StiImage)component).getEnabled());
            allProps.put("canGrow", ((StiImage)component).getCanGrow());
            allProps.put("canShrink", ((StiImage)component).getCanShrink());
            allProps.put("shiftMode", component.getShiftMode().toString());
            allProps.put("dockStyle", ((StiImage)component).getDockStyle().toString());
            allProps.put("anchor", component.getAnchor().toString());
            allProps.put("minSize", StiReportEdit.doubleToStr(component.getMinSize().width) + ";" + StiReportEdit.doubleToStr(component.getMinSize().height));
            allProps.put("maxSize", StiReportEdit.doubleToStr(component.getMaxSize().width) + ";" + StiReportEdit.doubleToStr(component.getMaxSize().height));
            allProps.put("globalizedName", ((StiImage)component).getGlobalizedName());
        } else if ("StiBarCode".equals(typeComponent)) {
            allProps.put("border", StiReportEdit.borderToStr(((StiBarCode)component).getBorder()));
            allProps.put("code", ((StiBarCode)component).getCode() != null ? StiEncodingHelper.encode((String)((StiBarCode)component).getCode().getValue()) : "");
            allProps.put("codeType", ((StiBarCode)component).getBarCodeType().getServiceName().substring(((StiBarCode)component).getBarCodeType().getServiceName().lastIndexOf(46) + 1));
            allProps.put("horAlignment", ((StiBarCode)component).getHorAlignment().toString());
            allProps.put("vertAlignment", ((StiBarCode)component).getVertAlignment().toString());
            allProps.put("font", StiReportEdit.fontToStr(((StiBarCode)component).getFont()));
            allProps.put("barCodeAngle", String.valueOf(((StiBarCode)component).getAngle().getValue()));
            allProps.put("autoScale", ((StiBarCode)component).getAutoScale());
            allProps.put("showLabelText", ((StiBarCode)component).getShowLabelText());
            allProps.put("foreColor", StiReportEdit.getStringFromColor(((StiBarCode)component).getForeColor()));
            allProps.put("backColor", StiReportEdit.getStringFromColor(((StiBarCode)component).getBackColor()));
            allProps.put("growToHeight", ((StiBarCode)component).getGrowToHeight());
            allProps.put("printOn", ((StiBarCode)component).getPrintOn().toString());
            allProps.put("printable", ((StiBarCode)component).getPrintable());
            allProps.put("clientLeft", StiReportEdit.doubleToStr(component.getLeft()));
            allProps.put("clientTop", StiReportEdit.doubleToStr(component.getTop()));
            allProps.put("enabled", ((StiBarCode)component).getEnabled());
            allProps.put("shiftMode", component.getShiftMode().toString());
            allProps.put("dockStyle", ((StiBarCode)component).getDockStyle().toString());
            allProps.put("anchor", component.getAnchor().toString());
            allProps.put("minSize", StiReportEdit.doubleToStr(component.getMinSize().width) + ";" + StiReportEdit.doubleToStr(component.getMinSize().height));
            allProps.put("maxSize", StiReportEdit.doubleToStr(component.getMaxSize().width) + ";" + StiReportEdit.doubleToStr(component.getMaxSize().height));
        } else if ("StiShape".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiShape)component).getBrush()));
            allProps.put("shapeType", StiReportEdit.getShapeTypeProperty((StiShape)component));
            allProps.put("shapeBorderStyle", String.valueOf(((StiShape)component).getStyle().getValue()));
            allProps.put("size", StiReportEdit.doubleToStr(((StiShape)component).getSize()));
            allProps.put("shapeBorderColor", StiReportEdit.getStringFromColor(((StiShape)component).getBorderColor()));
            allProps.put("growToHeight", ((StiShape)component).getGrowToHeight());
            allProps.put("printOn", ((StiShape)component).getPrintOn().toString());
            allProps.put("printable", ((StiShape)component).getPrintable());
            allProps.put("clientLeft", StiReportEdit.doubleToStr(component.getLeft()));
            allProps.put("clientTop", StiReportEdit.doubleToStr(component.getTop()));
            allProps.put("enabled", ((StiShape)component).getEnabled());
            allProps.put("shiftMode", component.getShiftMode().toString());
            allProps.put("dockStyle", ((StiShape)component).getDockStyle().toString());
            allProps.put("anchor", component.getAnchor().toString());
            allProps.put("minSize", StiReportEdit.doubleToStr(component.getMinSize().width) + ";" + StiReportEdit.doubleToStr(component.getMinSize().height));
            allProps.put("maxSize", StiReportEdit.doubleToStr(component.getMaxSize().width) + ";" + StiReportEdit.doubleToStr(component.getMaxSize().height));
        } else if ("StiPanel".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiPanel)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiPanel)component).getBorder()));
            allProps.put("columns", String.valueOf(((StiPanel)component).getColumns()));
            allProps.put("columnWidth", StiReportEdit.doubleToStr(((StiPanel)component).getColumnWidth()));
            allProps.put("columnGaps", StiReportEdit.doubleToStr(((StiPanel)component).getColumnGaps()));
            allProps.put("rightToLeft", ((StiPanel)component).getRightToLeft());
            allProps.put("growToHeight", ((StiPanel)component).getGrowToHeight());
            allProps.put("printOn", ((StiPanel)component).getPrintOn().toString());
            allProps.put("printable", ((StiPanel)component).getPrintable());
            allProps.put("clientLeft", StiReportEdit.doubleToStr(component.getLeft()));
            allProps.put("clientTop", StiReportEdit.doubleToStr(component.getTop()));
            allProps.put("enabled", ((StiPanel)component).getEnabled());
            allProps.put("canGrow", ((StiPanel)component).getCanGrow());
            allProps.put("canShrink", ((StiPanel)component).getCanShrink());
            allProps.put("canBreak", ((StiPanel)component).getCanBreak());
            allProps.put("shiftMode", component.getShiftMode().toString());
            allProps.put("dockStyle", ((StiPanel)component).getDockStyle().toString());
            allProps.put("anchor", component.getAnchor().toString());
            allProps.put("minSize", StiReportEdit.doubleToStr(component.getMinSize().width) + ";" + StiReportEdit.doubleToStr(component.getMinSize().height));
            allProps.put("maxSize", StiReportEdit.doubleToStr(component.getMaxSize().width) + ";" + StiReportEdit.doubleToStr(component.getMaxSize().height));
        } else if ("StiClone".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiClone)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiClone)component).getBorder()));
            allProps.put("container", ((StiClone)component).getContainer() != null ? ((StiClone)component).getContainer().getName() : "[Not Assigned]");
            allProps.put("printOn", ((StiClone)component).getPrintOn().toString());
            allProps.put("printable", ((StiClone)component).getPrintable());
            allProps.put("clientLeft", StiReportEdit.doubleToStr(component.getLeft()));
            allProps.put("clientTop", StiReportEdit.doubleToStr(component.getTop()));
            allProps.put("enabled", ((StiClone)component).getEnabled());
            allProps.put("shiftMode", component.getShiftMode().toString());
            allProps.put("dockStyle", ((StiClone)component).getDockStyle().toString());
            allProps.put("minSize", StiReportEdit.doubleToStr(component.getMinSize().width) + ";" + StiReportEdit.doubleToStr(component.getMinSize().height));
            allProps.put("maxSize", StiReportEdit.doubleToStr(component.getMaxSize().width) + ";" + StiReportEdit.doubleToStr(component.getMaxSize().height));
        } else if ("StiCheckBox".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiCheckBox)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiCheckBox)component).getBorder()));
            allProps.put("checked", StiEncodingHelper.encode((String)((StiCheckBox)component).getChecked().getValue()));
            allProps.put("checkStyleForTrue", ((StiCheckBox)component).getCheckStyleForTrue().toString());
            allProps.put("checkStyleForFalse", ((StiCheckBox)component).getCheckStyleForFalse().toString());
            allProps.put("checkValues", ((StiCheckBox)component).getValues());
            allProps.put("editable", ((StiCheckBox)component).getEditable());
            allProps.put("textBrush", StiReportEdit.brushToStr(((StiCheckBox)component).getTextBrush()));
            allProps.put("size", StiReportEdit.doubleToStr(((StiCheckBox)component).getSize()));
            allProps.put("contourColor", StiReportEdit.getStringFromColor(((StiCheckBox)component).getContourColor()));
            allProps.put("growToHeight", ((StiCheckBox)component).getGrowToHeight());
            allProps.put("printOn", ((StiCheckBox)component).getPrintOn().toString());
            allProps.put("printable", ((StiCheckBox)component).getPrintable());
            allProps.put("clientLeft", StiReportEdit.doubleToStr(component.getLeft()));
            allProps.put("clientTop", StiReportEdit.doubleToStr(component.getTop()));
            allProps.put("enabled", ((StiCheckBox)component).getEnabled());
            allProps.put("shiftMode", component.getShiftMode().toString());
            allProps.put("dockStyle", ((StiCheckBox)component).getDockStyle().toString());
            allProps.put("anchor", component.getAnchor().toString());
            allProps.put("minSize", StiReportEdit.doubleToStr(component.getMinSize().width) + ";" + StiReportEdit.doubleToStr(component.getMinSize().height));
            allProps.put("maxSize", StiReportEdit.doubleToStr(component.getMaxSize().width) + ";" + StiReportEdit.doubleToStr(component.getMaxSize().height));
            allProps.put("excelValue", StiEncodingHelper.encode((String)((StiCheckBox)component).getExcelValue().getValue()));
        } else if ("StiSubReport".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiSubReport)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiSubReport)component).getBorder()));
            allProps.put("subReportPage", ((StiSubReport)component).getSubReportPage() != null ? ((StiSubReport)component).getSubReportPage().getName() : "[Not Assigned]");
            allProps.put("subReportUrl", ((StiSubReport)component).getSubReportUrl() != null ? StiEncodingHelper.encode((String)((StiSubReport)component).getSubReportUrl()) : "");
            allProps.put("printOn", ((StiSubReport)component).getPrintOn().toString());
            allProps.put("printable", ((StiSubReport)component).getPrintable());
            allProps.put("clientLeft", StiReportEdit.doubleToStr(component.getLeft()));
            allProps.put("clientTop", StiReportEdit.doubleToStr(component.getTop()));
            allProps.put("enabled", ((StiSubReport)component).getEnabled());
            allProps.put("canGrow", ((StiSubReport)component).getCanGrow());
            allProps.put("canShrink", ((StiSubReport)component).getCanShrink());
            allProps.put("shiftMode", component.getShiftMode().toString());
            allProps.put("dockStyle", ((StiSubReport)component).getDockStyle().toString());
            allProps.put("subReportParameters", StiReportEdit.getSubReportParametersProperty((StiSubReport)component));
            allProps.put("minSize", StiReportEdit.doubleToStr(component.getMinSize().width) + ";" + StiReportEdit.doubleToStr(component.getMinSize().height));
            allProps.put("maxSize", StiReportEdit.doubleToStr(component.getMaxSize().width) + ";" + StiReportEdit.doubleToStr(component.getMaxSize().height));
        } else if ("StiZipCode".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiZipCode)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiZipCode)component).getBorder()));
            allProps.put("code", ((StiZipCode)component).getCode() != null ? StiEncodingHelper.encode((String)((StiZipCode)component).getCode().getValue()) : "");
            allProps.put("size", StiReportEdit.doubleToStr(((StiZipCode)component).getSize()));
            allProps.put("foreColor", StiReportEdit.getStringFromColor(((StiZipCode)component).getForeColor()));
            allProps.put("ratio", ((StiZipCode)component).getRatio());
            allProps.put("growToHeight", ((StiZipCode)component).getGrowToHeight());
            allProps.put("printOn", ((StiZipCode)component).getPrintOn().toString());
            allProps.put("printable", ((StiZipCode)component).getPrintable());
            allProps.put("clientLeft", StiReportEdit.doubleToStr(component.getLeft()));
            allProps.put("clientTop", StiReportEdit.doubleToStr(component.getTop()));
            allProps.put("enabled", ((StiZipCode)component).getEnabled());
            allProps.put("shiftMode", component.getShiftMode().toString());
            allProps.put("dockStyle", ((StiZipCode)component).getDockStyle().toString());
            allProps.put("anchor", component.getAnchor().toString());
            allProps.put("minSize", StiReportEdit.doubleToStr(component.getMinSize().width) + ";" + StiReportEdit.doubleToStr(component.getMinSize().height));
            allProps.put("maxSize", StiReportEdit.doubleToStr(component.getMaxSize().width) + ";" + StiReportEdit.doubleToStr(component.getMaxSize().height));
        } else if ("StiChart".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiChart)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiChart)component).getBorder()));
            allProps.put("growToHeight", ((StiChart)component).getGrowToHeight());
            allProps.put("clientLeft", StiReportEdit.doubleToStr(component.getLeft()));
            allProps.put("clientTop", StiReportEdit.doubleToStr(component.getTop()));
            allProps.put("printOn", ((StiChart)component).getPrintOn().toString());
            allProps.put("printable", ((StiChart)component).getPrintable());
            allProps.put("sortData", StiReportEdit.getSortDataProperty(component));
            allProps.put("filterData", StiEncodingHelper.encode((String)new JSONArray(StiReportEdit.getFiltersObject(((StiChart)component).getFilters())).toString()));
            allProps.put("filterMode", ((StiChart)component).getFilterMode().toString());
            allProps.put("filterOn", ((StiChart)component).getFilterOn());
            allProps.put("dataSource", ((StiChart)component).getDataSource() != null ? ((StiChart)component).getDataSource().getName() : "[Not Assigned]");
            allProps.put("dataRelation", ((StiChart)component).getDataRelation() != null ? ((StiChart)component).getDataRelation().getNameInSource() : "[Not Assigned]");
            allProps.put("masterComponent", ((StiChart)component).getMasterComponent() != null ? ((StiChart)component).getMasterComponent().getName() : "[Not Assigned]");
            allProps.put("countData", String.valueOf(((StiChart)component).getCountData()));
            allProps.put("businessObject", ((StiChart)component).getBusinessObject() != null ? ((StiChart)component).getBusinessObject().GetFullName() : "[Not Assigned]");
            allProps.put("enabled", ((StiChart)component).getEnabled());
            allProps.put("chartStyle", StiChartHelper.getStyle((StiChart)component));
            allProps.put("shiftMode", component.getShiftMode().toString());
            allProps.put("dockStyle", ((StiChart)component).getDockStyle().toString());
            allProps.put("anchor", component.getAnchor().toString());
            allProps.put("minSize", StiReportEdit.doubleToStr(component.getMinSize().width) + ";" + StiReportEdit.doubleToStr(component.getMinSize().height));
            allProps.put("maxSize", StiReportEdit.doubleToStr(component.getMaxSize().width) + ";" + StiReportEdit.doubleToStr(component.getMaxSize().height));
        } else if ("StiGauge".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiGauge)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiGauge)component).getBorder()));
            allProps.put("growToHeight", ((StiGauge)component).getGrowToHeight());
            allProps.put("clientLeft", StiReportEdit.doubleToStr(component.getLeft()));
            allProps.put("clientTop", StiReportEdit.doubleToStr(component.getTop()));
            allProps.put("printOn", ((StiGauge)component).getPrintOn().toString());
            allProps.put("printable", ((StiGauge)component).getPrintable());
            allProps.put("sortData", StiReportEdit.getSortDataProperty(component));
            allProps.put("enabled", ((StiGauge)component).getEnabled());
            allProps.put("shiftMode", component.getShiftMode().toString());
            allProps.put("dockStyle", ((StiGauge)component).getDockStyle().toString());
            allProps.put("gaugeStyle", StiGaugeHelper.getStyle((StiGauge)component));
            allProps.put("anchor", component.getAnchor().toString());
            allProps.put("minSize", StiReportEdit.doubleToStr(component.getMinSize().width) + ";" + StiReportEdit.doubleToStr(component.getMinSize().height));
            allProps.put("maxSize", StiReportEdit.doubleToStr(component.getMaxSize().width) + ";" + StiReportEdit.doubleToStr(component.getMaxSize().height));
        } else if ("StiTableCell".equals(typeComponent)) {
            allProps.put("cellType", ((StiTableCell)component).getCellType().toString());
            allProps.put("cellDockStyle", ((StiTableCell)component).getCellDockStyle().toString());
            allProps.put("fixedWidth", ((StiTableCell)component).getFixedWidth());
            allProps.put("border", StiReportEdit.borderToStr(((StiTableCell)component).getBorder()));
            allProps.put("brush", StiReportEdit.brushToStr(((StiTableCell)component).getBrush()));
            allProps.put("text", StiEncodingHelper.encode((String)((StiTableCell)component).getText().getValue()));
            allProps.put("textBrush", StiReportEdit.brushToStr(((StiTableCell)component).getTextBrush()));
            allProps.put("font", StiReportEdit.fontToStr(((StiTableCell)component).getFont()));
            allProps.put("wordWrap", ((StiTableCell)component).getWordWrap());
            allProps.put("hideZeros", ((StiTableCell)component).getHideZeros());
            allProps.put("maxNumberOfLines", String.valueOf(((StiTableCell)component).getMaxNumberOfLines()));
            allProps.put("onlyText", ((StiTableCell)component).getOnlyText());
            allProps.put("textMargins", String.format("%s;%s;%s;%s", ((StiTableCell)component).getMargins().getLeft(), ((StiTableCell)component).getMargins().getTop(), ((StiTableCell)component).getMargins().getRight(), ((StiTableCell)component).getMargins().getBottom()));
            allProps.put("allowHtmlTags", ((StiTableCell)component).getAllowHtmlTags());
            allProps.put("editableText", ((StiTableCell)component).getEditable());
            allProps.put("textAngle", StiReportEdit.doubleToStr(((StiTableCell)component).getAngle()));
            allProps.put("horAlignment", ((StiTableCell)component).getHorAlignment().toString());
            allProps.put("vertAlignment", ((StiTableCell)component).getVertAlignment().toString());
            allProps.put("textFormat", StiTextFormatHelper.getTextFormatItem(((StiTableCell)component).getTextFormat()));
            allProps.put("canBreak", ((StiTableCell)component).getCanBreak());
            allProps.put("printOn", ((StiTableCell)component).getPrintOn().toString());
            allProps.put("printable", ((StiTableCell)component).getPrintable());
            allProps.put("clientLeft", StiReportEdit.doubleToStr(component.getLeft()));
            allProps.put("clientTop", StiReportEdit.doubleToStr(component.getTop()));
            allProps.put("trimming", ((StiTableCell)component).getTextOptions().getTrimming().toString());
            allProps.put("textOptionsRightToLeft", ((StiTableCell)component).getTextOptions().getRightToLeft());
            allProps.put("processAt", ((StiTableCell)component).getProcessAt().toString());
            allProps.put("processingDuplicates", ((StiTableCell)component).getProcessingDuplicates().toString());
            allProps.put("shrinkFontToFit", ((StiTableCell)component).getShrinkFontToFit());
            allProps.put("shrinkFontToFitMinimumSize", String.valueOf(((StiTableCell)component).getShrinkFontToFitMinimumSize()));
            allProps.put("textType", ((StiTableCell)component).getType().toString());
            allProps.put("enabled", ((StiTableCell)component).getEnabled());
            allProps.put("canGrow", ((StiTableCell)component).getCanGrow());
            allProps.put("canShrink", ((StiTableCell)component).getCanShrink());
            allProps.put("editable", ((StiTableCell)component).getEditable());
            allProps.put("excelValue", StiEncodingHelper.encode((String)((StiTableCell)component).getExcelValue().getValue()));
            allProps.put("exportAsImage", ((StiTableCell)component).getExportAsImage());
            allProps.put("lineSpacing", StiReportEdit.doubleToStr(((StiTableCell)component).getLineSpacing()));
        } else if ("StiTableCellImage".equals(typeComponent)) {
            allProps.put("cellType", ((StiTableCellImage)component).getCellType().toString());
            allProps.put("cellDockStyle", ((StiTableCellImage)component).getCellDockStyle().toString());
            allProps.put("fixedWidth", ((StiTableCellImage)component).getFixedWidth());
            allProps.put("border", StiReportEdit.borderToStr(((StiTableCellImage)component).getBorder()));
            allProps.put("brush", StiReportEdit.brushToStr(((StiTableCellImage)component).getBrush()));
            allProps.put("horAlignment", ((StiTableCellImage)component).getHorAlignment().toString());
            allProps.put("vertAlignment", ((StiTableCellImage)component).getVertAlignment().toString());
            allProps.put("stretch", ((StiTableCellImage)component).getStretch());
            allProps.put("ratio", ((StiTableCellImage)component).getAspectRatio());
            allProps.put("rotation", ((StiTableCellImage)component).getImageRotation().toString());
            allProps.put("imageMultipleFactor", StiReportEdit.doubleToStr(((StiTableCellImage)component).getMultipleFactor()));
            allProps.put("canBreak", ((StiTableCellImage)component).getCanBreak());
            allProps.put("printOn", ((StiTableCellImage)component).getPrintOn().toString());
            allProps.put("printable", ((StiTableCellImage)component).getPrintable());
            allProps.put("clientLeft", StiReportEdit.doubleToStr(component.getLeft()));
            allProps.put("clientTop", StiReportEdit.doubleToStr(component.getTop()));
            allProps.put("imageDataColumn", ((StiTableCellImage)component).getDataColumn() != null ? StiEncodingHelper.encode((String)((StiTableCellImage)component).getDataColumn()) : "");
            allProps.put("imageSrc", ((StiTableCellImage)component).getImageBytes() != null ? StiReportEdit.imageToBase64(((StiTableCellImage)component).getImageBytes()) : "");
            allProps.put("imageUrl", ((StiTableCellImage)component).getImageURL() != null ? StiEncodingHelper.encode((String)((StiTableCellImage)component).getImageURL().getValue()) : "");
            allProps.put("imageFile", ((StiTableCellImage)component).getFile() != null ? StiEncodingHelper.encode((String)((StiTableCellImage)component).getFile()) : "");
            allProps.put("imageData", ((StiTableCellImage)component).getImageData() != null ? StiEncodingHelper.encode((String)((StiTableCellImage)component).getImageData().getValue()) : "");
            allProps.put("enabled", ((StiTableCellImage)component).getEnabled());
            allProps.put("canGrow", ((StiTableCellImage)component).getCanGrow());
            allProps.put("canShrink", ((StiTableCellImage)component).getCanShrink());
        } else if ("StiTableCellCheckBox".equals(typeComponent)) {
            allProps.put("cellType", ((StiTableCellCheckBox)component).getCellType().toString());
            allProps.put("cellDockStyle", ((StiTableCellCheckBox)component).getCellDockStyle().toString());
            allProps.put("fixedWidth", ((StiTableCellCheckBox)component).getFixedWidth());
            allProps.put("brush", StiReportEdit.brushToStr(((StiTableCellCheckBox)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiTableCellCheckBox)component).getBorder()));
            allProps.put("checked", StiEncodingHelper.encode((String)((StiTableCellCheckBox)component).getChecked().getValue()));
            allProps.put("checkStyleForTrue", ((StiTableCellCheckBox)component).getCheckStyleForTrue().toString());
            allProps.put("checkStyleForFalse", ((StiTableCellCheckBox)component).getCheckStyleForFalse().toString());
            allProps.put("checkValues", ((StiTableCellCheckBox)component).getValues());
            allProps.put("editable", ((StiTableCellCheckBox)component).getEditable());
            allProps.put("textBrush", StiReportEdit.brushToStr(((StiTableCellCheckBox)component).getTextBrush()));
            allProps.put("size", StiReportEdit.doubleToStr(((StiTableCellCheckBox)component).getSize()));
            allProps.put("contourColor", StiReportEdit.getStringFromColor(((StiTableCellCheckBox)component).getContourColor()));
            allProps.put("printOn", ((StiTableCellCheckBox)component).getPrintOn().toString());
            allProps.put("printable", ((StiTableCellCheckBox)component).getPrintable());
            allProps.put("clientLeft", StiReportEdit.doubleToStr(component.getLeft()));
            allProps.put("clientTop", StiReportEdit.doubleToStr(component.getTop()));
            allProps.put("enabled", ((StiTableCellCheckBox)component).getEnabled());
            allProps.put("excelValue", StiEncodingHelper.encode((String)((StiTableCellCheckBox)component).getExcelValue().getValue()));
        } else if ("StiTableCellRichText".equals(typeComponent)) {
            allProps.put("cellType", ((StiTableCellRichText)component).getCellType().toString());
            allProps.put("cellDockStyle", ((StiTableCellRichText)component).getCellDockStyle().toString());
            allProps.put("fixedWidth", ((StiTableCellRichText)component).getFixedWidth());
            allProps.put("border", StiReportEdit.borderToStr(((StiTableCellRichText)component).getBorder()));
            allProps.put("richText", StiReportEdit.getRichTextProperty((StiRichText)((StiTableCellRichText)component)));
            allProps.put("richTextDataColumn", ((StiTableCellRichText)component).getDataColumn() != null ? StiEncodingHelper.encode((String)((StiTableCellRichText)component).getDataColumn()) : "");
            allProps.put("richTextUrl", ((StiTableCellRichText)component).getDataUrl() != null ? StiEncodingHelper.encode((String)((StiTableCellRichText)component).getDataUrl().getValue()) : "");
            allProps.put("editableText", ((StiTableCellRichText)component).getEditable());
            allProps.put("textMargins", String.format("%s;%s;%s;%s", ((StiTableCellRichText)component).getMargins().getLeft(), ((StiTableCellRichText)component).getMargins().getTop(), ((StiTableCellRichText)component).getMargins().getRight(), ((StiTableCellRichText)component).getMargins().getBottom()));
            allProps.put("onlyText", ((StiTableCellRichText)component).getOnlyText());
            allProps.put("wordWrap", ((StiTableCellRichText)component).getWordWrap());
            allProps.put("canBreak", ((StiTableCellRichText)component).getCanBreak());
            allProps.put("printOn", ((StiTableCellRichText)component).getPrintOn().toString());
            allProps.put("printable", ((StiTableCellRichText)component).getPrintable());
            allProps.put("clientLeft", StiReportEdit.doubleToStr(component.getLeft()));
            allProps.put("clientTop", StiReportEdit.doubleToStr(component.getTop()));
            allProps.put("processAt", ((StiTableCellRichText)component).getProcessAt().toString());
            allProps.put("enabled", ((StiTableCellRichText)component).getEnabled());
            allProps.put("canGrow", ((StiTableCellRichText)component).getCanGrow());
            allProps.put("canShrink", ((StiTableCellRichText)component).getCanShrink());
            allProps.put("editable", ((StiTableCellRichText)component).getEditable());
        } else if ("StiHorizontalLinePrimitive".equals(typeComponent)) {
            allProps.put("color", StiReportEdit.getStringFromColor(((StiHorizontalLinePrimitive)component).getColor()));
            allProps.put("size", StiReportEdit.doubleToStr(((StiHorizontalLinePrimitive)component).getSize()));
            allProps.put("style", String.valueOf(((StiHorizontalLinePrimitive)component).getStyle().getValue()));
            allProps.put("anchor", component.getAnchor().toString());
            allProps.put("enabled", component.getEnabled());
            allProps.put("printOn", component.getPrintOn().toString());
            allProps.put("printable", component.getPrintable());
            allProps.put("shiftMode", component.getShiftMode().toString());
            allProps.put("isPrimitiveComponent", true);
        } else if ("StiVerticalLinePrimitive".equals(typeComponent)) {
            allProps.put("color", StiReportEdit.getStringFromColor(((StiVerticalLinePrimitive)component).getColor()));
            allProps.put("size", StiReportEdit.doubleToStr(((StiVerticalLinePrimitive)component).getSize()));
            allProps.put("style", String.valueOf(((StiVerticalLinePrimitive)component).getStyle().getValue()));
            allProps.put("anchor", component.getAnchor().toString());
            allProps.put("enabled", component.getEnabled());
            allProps.put("printOn", component.getPrintOn().toString());
            allProps.put("printable", component.getPrintable());
            allProps.put("shiftMode", component.getShiftMode().toString());
            allProps.put("isPrimitiveComponent", true);
        } else if ("StiRectanglePrimitive".equals(typeComponent)) {
            allProps.put("color", StiReportEdit.getStringFromColor(((StiRectanglePrimitive)component).getColor()));
            allProps.put("size", StiReportEdit.doubleToStr(((StiRectanglePrimitive)component).getSize()));
            allProps.put("style", String.valueOf(((StiRectanglePrimitive)component).getStyle().getValue()));
            allProps.put("leftSide", ((StiRectanglePrimitive)component).getLeftSide());
            allProps.put("rightSide", ((StiRectanglePrimitive)component).getRightSide());
            allProps.put("topSide", ((StiRectanglePrimitive)component).getTopSide());
            allProps.put("bottomSide", ((StiRectanglePrimitive)component).getBottomSide());
            allProps.put("anchor", component.getAnchor().toString());
            allProps.put("enabled", component.getEnabled());
            allProps.put("printOn", component.getPrintOn().toString());
            allProps.put("printable", component.getPrintable());
            allProps.put("shiftMode", component.getShiftMode().toString());
            allProps.put("isPrimitiveComponent", true);
        } else if ("StiRoundedRectanglePrimitive".equals(typeComponent)) {
            allProps.put("color", StiReportEdit.getStringFromColor(((StiRoundedRectanglePrimitive)component).getColor()));
            allProps.put("size", StiReportEdit.doubleToStr(((StiRoundedRectanglePrimitive)component).getSize()));
            allProps.put("style", String.valueOf(((StiRoundedRectanglePrimitive)component).getStyle().getValue()));
            allProps.put("round", StiReportEdit.doubleToStr(((StiRoundedRectanglePrimitive)component).getRound()));
            allProps.put("anchor", component.getAnchor().toString());
            allProps.put("enabled", ((StiRoundedRectanglePrimitive)component).getEnabled());
            allProps.put("printOn", ((StiRoundedRectanglePrimitive)component).getPrintOn().toString());
            allProps.put("printable", ((StiRoundedRectanglePrimitive)component).getPrintable());
            allProps.put("shiftMode", component.getShiftMode().toString());
            allProps.put("isPrimitiveComponent", true);
        } else if ("StiPageHeaderBand".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiPageHeaderBand)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiPageHeaderBand)component).getBorder()));
            allProps.put("printOn", ((StiPageHeaderBand)component).getPrintOn().toString());
            allProps.put("resetPageNumber", ((StiPageHeaderBand)component).getResetPageNumber());
            allProps.put("enabled", ((StiPageHeaderBand)component).getEnabled());
            allProps.put("canGrow", ((StiPageHeaderBand)component).getCanGrow());
            allProps.put("canShrink", ((StiPageHeaderBand)component).getCanShrink());
            allProps.put("minHeight", StiReportEdit.doubleToStr(((StiPageHeaderBand)component).getMinHeight()));
            allProps.put("maxHeight", StiReportEdit.doubleToStr(((StiPageHeaderBand)component).getMaxHeight()));
        } else if ("StiPageFooterBand".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiPageFooterBand)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiPageFooterBand)component).getBorder()));
            allProps.put("printOn", ((StiPageFooterBand)component).getPrintOn().toString());
            allProps.put("resetPageNumber", ((StiPageFooterBand)component).getResetPageNumber());
            allProps.put("enabled", ((StiPageFooterBand)component).getEnabled());
            allProps.put("canGrow", ((StiPageFooterBand)component).getCanGrow());
            allProps.put("canShrink", ((StiPageFooterBand)component).getCanShrink());
            allProps.put("minHeight", StiReportEdit.doubleToStr(((StiPageFooterBand)component).getMinHeight()));
            allProps.put("maxHeight", StiReportEdit.doubleToStr(((StiPageFooterBand)component).getMaxHeight()));
        } else if ("StiReportTitleBand".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiReportTitleBand)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiReportTitleBand)component).getBorder()));
            allProps.put("printIfEmpty", ((StiReportTitleBand)component).getPrintIfEmpty());
            allProps.put("resetPageNumber", ((StiReportTitleBand)component).getResetPageNumber());
            allProps.put("enabled", ((StiReportTitleBand)component).getEnabled());
            allProps.put("canGrow", ((StiReportTitleBand)component).getCanGrow());
            allProps.put("canShrink", ((StiReportTitleBand)component).getCanShrink());
            allProps.put("minHeight", StiReportEdit.doubleToStr(((StiReportTitleBand)component).getMinHeight()));
            allProps.put("maxHeight", StiReportEdit.doubleToStr(((StiReportTitleBand)component).getMaxHeight()));
        } else if ("StiGroupHeaderBand".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiGroupHeaderBand)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiGroupHeaderBand)component).getBorder()));
            allProps.put("canBreak", ((StiGroupHeaderBand)component).getCanBreak());
            allProps.put("printOn", ((StiGroupHeaderBand)component).getPrintOn().toString());
            allProps.put("newPageBefore", ((StiGroupHeaderBand)component).getNewPageBefore());
            allProps.put("newPageAfter", ((StiGroupHeaderBand)component).getNewPageAfter());
            allProps.put("newColumnBefore", ((StiGroupHeaderBand)component).getNewColumnBefore());
            allProps.put("newColumnAfter", ((StiGroupHeaderBand)component).getNewColumnAfter());
            allProps.put("breakIfLessThan", StiReportEdit.doubleToStr(((StiGroupHeaderBand)component).getBreakIfLessThan()));
            allProps.put("skipFirst", ((StiGroupHeaderBand)component).getSkipFirst());
            allProps.put("condition", ((StiGroupHeaderBand)component).getCondition() != null ? StiEncodingHelper.encode((String)((StiGroupHeaderBand)component).getCondition().getValue()) : "");
            allProps.put("sortDirection", String.valueOf(((StiGroupHeaderBand)component).getSortDirection().getValue()));
            allProps.put("summarySortDirection", String.valueOf(((StiGroupHeaderBand)component).getSummarySortDirection().getValue()));
            allProps.put("summaryExpression", StiEncodingHelper.encode((String)((StiGroupHeaderBand)component).getSummaryExpression().toString()));
            allProps.put("summaryType", String.valueOf(((StiGroupHeaderBand)component).getSummaryType().getValue()));
            allProps.put("printOnAllPages", ((StiGroupHeaderBand)component).getPrintOnAllPages());
            allProps.put("resetPageNumber", ((StiGroupHeaderBand)component).getResetPageNumber());
            allProps.put("printAtBottom", ((StiGroupHeaderBand)component).getPrintAtBottom());
            allProps.put("keepGroupTogether", ((StiGroupHeaderBand)component).getKeepGroupTogether());
            allProps.put("keepGroupHeaderTogether", ((StiGroupHeaderBand)component).getKeepGroupHeaderTogether());
            allProps.put("enabled", ((StiGroupHeaderBand)component).getEnabled());
            allProps.put("canGrow", ((StiGroupHeaderBand)component).getCanGrow());
            allProps.put("canShrink", ((StiGroupHeaderBand)component).getCanShrink());
            allProps.put("minHeight", StiReportEdit.doubleToStr(((StiGroupHeaderBand)component).getMinHeight()));
            allProps.put("maxHeight", StiReportEdit.doubleToStr(((StiGroupHeaderBand)component).getMaxHeight()));
        } else if ("StiGroupFooterBand".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiGroupFooterBand)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiGroupFooterBand)component).getBorder()));
            allProps.put("canBreak", ((StiGroupFooterBand)component).getCanBreak());
            allProps.put("printOn", ((StiGroupFooterBand)component).getPrintOn().toString());
            allProps.put("newPageBefore", ((StiGroupFooterBand)component).getNewPageBefore());
            allProps.put("newPageAfter", ((StiGroupFooterBand)component).getNewPageAfter());
            allProps.put("newColumnBefore", ((StiGroupFooterBand)component).getNewColumnBefore());
            allProps.put("newColumnAfter", ((StiGroupFooterBand)component).getNewColumnAfter());
            allProps.put("breakIfLessThan", StiReportEdit.doubleToStr(((StiGroupFooterBand)component).getBreakIfLessThan()));
            allProps.put("skipFirst", ((StiGroupFooterBand)component).getSkipFirst());
            allProps.put("resetPageNumber", ((StiGroupFooterBand)component).getResetPageNumber());
            allProps.put("printAtBottom", ((StiGroupFooterBand)component).getPrintAtBottom());
            allProps.put("enabled", ((StiGroupFooterBand)component).getEnabled());
            allProps.put("canGrow", ((StiGroupFooterBand)component).getCanGrow());
            allProps.put("canShrink", ((StiGroupFooterBand)component).getCanShrink());
            allProps.put("minHeight", StiReportEdit.doubleToStr(((StiGroupFooterBand)component).getMinHeight()));
            allProps.put("maxHeight", StiReportEdit.doubleToStr(((StiGroupFooterBand)component).getMaxHeight()));
        } else if ("StiHeaderBand".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiHeaderBand)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiHeaderBand)component).getBorder()));
            allProps.put("canBreak", ((StiHeaderBand)component).getCanBreak());
            allProps.put("printOn", ((StiHeaderBand)component).getPrintOn().toString());
            allProps.put("newPageBefore", ((StiHeaderBand)component).getNewPageBefore());
            allProps.put("newPageAfter", ((StiHeaderBand)component).getNewPageAfter());
            allProps.put("newColumnBefore", ((StiHeaderBand)component).getNewColumnBefore());
            allProps.put("newColumnAfter", ((StiHeaderBand)component).getNewColumnAfter());
            allProps.put("breakIfLessThan", StiReportEdit.doubleToStr(((StiHeaderBand)component).getBreakIfLessThan()));
            allProps.put("skipFirst", ((StiHeaderBand)component).getSkipFirst());
            allProps.put("printIfEmpty", ((StiHeaderBand)component).getPrintIfEmpty());
            allProps.put("printOnAllPages", ((StiHeaderBand)component).getPrintOnAllPages());
            allProps.put("resetPageNumber", ((StiHeaderBand)component).getResetPageNumber());
            allProps.put("printAtBottom", ((StiHeaderBand)component).getPrintAtBottom());
            allProps.put("enabled", ((StiHeaderBand)component).getEnabled());
            allProps.put("canGrow", ((StiHeaderBand)component).getCanGrow());
            allProps.put("canShrink", ((StiHeaderBand)component).getCanShrink());
            allProps.put("minHeight", StiReportEdit.doubleToStr(((StiHeaderBand)component).getMinHeight()));
            allProps.put("maxHeight", StiReportEdit.doubleToStr(((StiHeaderBand)component).getMaxHeight()));
        } else if ("StiFooterBand".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiFooterBand)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiFooterBand)component).getBorder()));
            allProps.put("canBreak", ((StiFooterBand)component).getCanBreak());
            allProps.put("printOn", ((StiFooterBand)component).getPrintOn().toString());
            allProps.put("newPageBefore", ((StiFooterBand)component).getNewPageBefore());
            allProps.put("newPageAfter", ((StiFooterBand)component).getNewPageAfter());
            allProps.put("newColumnBefore", ((StiFooterBand)component).getNewColumnBefore());
            allProps.put("newColumnAfter", ((StiFooterBand)component).getNewColumnAfter());
            allProps.put("breakIfLessThan", StiReportEdit.doubleToStr(((StiFooterBand)component).getBreakIfLessThan()));
            allProps.put("skipFirst", ((StiFooterBand)component).getSkipFirst());
            allProps.put("printIfEmpty", ((StiFooterBand)component).getPrintIfEmpty());
            allProps.put("printOnAllPages", ((StiFooterBand)component).getPrintOnAllPages());
            allProps.put("resetPageNumber", ((StiFooterBand)component).getResetPageNumber());
            allProps.put("printAtBottom", ((StiFooterBand)component).getPrintAtBottom());
            allProps.put("enabled", ((StiFooterBand)component).getEnabled());
            allProps.put("canGrow", ((StiFooterBand)component).getCanGrow());
            allProps.put("canShrink", ((StiFooterBand)component).getCanShrink());
            allProps.put("minHeight", StiReportEdit.doubleToStr(((StiFooterBand)component).getMinHeight()));
            allProps.put("maxHeight", StiReportEdit.doubleToStr(((StiFooterBand)component).getMaxHeight()));
        } else if ("StiColumnHeaderBand".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiColumnHeaderBand)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiColumnHeaderBand)component).getBorder()));
            allProps.put("canBreak", ((StiColumnHeaderBand)component).getCanBreak());
            allProps.put("printOn", ((StiColumnHeaderBand)component).getPrintOn().toString());
            allProps.put("newPageBefore", ((StiColumnHeaderBand)component).getNewPageBefore());
            allProps.put("newPageAfter", ((StiColumnHeaderBand)component).getNewPageAfter());
            allProps.put("newColumnBefore", ((StiColumnHeaderBand)component).getNewColumnBefore());
            allProps.put("newColumnAfter", ((StiColumnHeaderBand)component).getNewColumnAfter());
            allProps.put("breakIfLessThan", StiReportEdit.doubleToStr(((StiColumnHeaderBand)component).getBreakIfLessThan()));
            allProps.put("skipFirst", ((StiColumnHeaderBand)component).getSkipFirst());
            allProps.put("printIfEmpty", ((StiColumnHeaderBand)component).getPrintIfEmpty());
            allProps.put("printOnAllPages", ((StiColumnHeaderBand)component).getPrintOnAllPages());
            allProps.put("resetPageNumber", ((StiColumnHeaderBand)component).getResetPageNumber());
            allProps.put("printAtBottom", ((StiColumnHeaderBand)component).getPrintAtBottom());
            allProps.put("enabled", ((StiColumnHeaderBand)component).getEnabled());
            allProps.put("canGrow", ((StiColumnHeaderBand)component).getCanGrow());
            allProps.put("canShrink", ((StiColumnHeaderBand)component).getCanShrink());
            allProps.put("minHeight", StiReportEdit.doubleToStr(((StiColumnHeaderBand)component).getMinHeight()));
            allProps.put("maxHeight", StiReportEdit.doubleToStr(((StiColumnHeaderBand)component).getMaxHeight()));
        } else if ("StiColumnFooterBand".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiColumnFooterBand)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiColumnFooterBand)component).getBorder()));
            allProps.put("canBreak", ((StiColumnFooterBand)component).getCanBreak());
            allProps.put("printOn", ((StiColumnFooterBand)component).getPrintOn().toString());
            allProps.put("newPageBefore", ((StiColumnFooterBand)component).getNewPageBefore());
            allProps.put("newPageAfter", ((StiColumnFooterBand)component).getNewPageAfter());
            allProps.put("newColumnBefore", ((StiColumnFooterBand)component).getNewColumnBefore());
            allProps.put("newColumnAfter", ((StiColumnFooterBand)component).getNewColumnAfter());
            allProps.put("breakIfLessThan", StiReportEdit.doubleToStr(((StiColumnFooterBand)component).getBreakIfLessThan()));
            allProps.put("skipFirst", ((StiColumnFooterBand)component).getSkipFirst());
            allProps.put("printIfEmpty", ((StiColumnFooterBand)component).getPrintIfEmpty());
            allProps.put("printOnAllPages", ((StiColumnFooterBand)component).getPrintOnAllPages());
            allProps.put("resetPageNumber", ((StiColumnFooterBand)component).getResetPageNumber());
            allProps.put("printAtBottom", ((StiColumnFooterBand)component).getPrintAtBottom());
            allProps.put("enabled", ((StiColumnFooterBand)component).getEnabled());
            allProps.put("canGrow", ((StiColumnFooterBand)component).getCanGrow());
            allProps.put("canShrink", ((StiColumnFooterBand)component).getCanShrink());
            allProps.put("minHeight", StiReportEdit.doubleToStr(((StiColumnFooterBand)component).getMinHeight()));
            allProps.put("maxHeight", StiReportEdit.doubleToStr(((StiColumnFooterBand)component).getMaxHeight()));
        } else if ("StiDataBand".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiDataBand)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiDataBand)component).getBorder()));
            allProps.put("canBreak", ((StiDataBand)component).getCanBreak());
            allProps.put("printOn", ((StiDataBand)component).getPrintOn().toString());
            allProps.put("newPageBefore", ((StiDataBand)component).getNewPageBefore());
            allProps.put("newPageAfter", ((StiDataBand)component).getNewPageAfter());
            allProps.put("newColumnBefore", ((StiDataBand)component).getNewColumnBefore());
            allProps.put("newColumnAfter", ((StiDataBand)component).getNewColumnAfter());
            allProps.put("breakIfLessThan", StiReportEdit.doubleToStr(((StiDataBand)component).getBreakIfLessThan()));
            allProps.put("skipFirst", ((StiDataBand)component).getSkipFirst());
            allProps.put("columns", String.valueOf(((StiDataBand)component).getColumns()));
            allProps.put("columnWidth", StiReportEdit.doubleToStr(((StiDataBand)component).getColumnWidth()));
            allProps.put("columnGaps", StiReportEdit.doubleToStr(((StiDataBand)component).getColumnGaps()));
            allProps.put("rightToLeft", ((StiDataBand)component).getRightToLeft());
            allProps.put("columnDirection", ((StiDataBand)component).getColumnDirection().toString());
            allProps.put("minRowsInColumn", String.valueOf(((StiDataBand)component).getMinRowsInColumn()));
            allProps.put("sortData", StiReportEdit.getSortDataProperty(component));
            allProps.put("filterData", StiEncodingHelper.encode((String)new JSONArray(StiReportEdit.getFiltersObject(((StiDataBand)component).getFilters())).toString()));
            allProps.put("filterMode", ((StiDataBand)component).getFilterMode().toString());
            allProps.put("filterEngine", StiFilterEngine.forValue((int)((StiDataBand)component).getFilterEngine()).toString());
            allProps.put("filterOn", ((StiDataBand)component).getFilterOn());
            allProps.put("dataSource", ((StiDataBand)component).getDataSource() != null ? ((StiDataBand)component).getDataSource().getName() : "[Not Assigned]");
            allProps.put("dataRelation", ((StiDataBand)component).getDataRelation() != null ? ((StiDataBand)component).getDataRelation().getNameInSource() : "[Not Assigned]");
            allProps.put("masterComponent", ((StiDataBand)component).getMasterComponent() != null ? ((StiDataBand)component).getMasterComponent().getName() : "[Not Assigned]");
            allProps.put("countData", String.valueOf(((StiDataBand)component).getCountData()));
            allProps.put("oddStyle", !StiValidationUtil.isNullOrEmpty((String)((StiDataBand)component).getOddStyle()) ? ((StiDataBand)component).getOddStyle() : "[None]");
            allProps.put("evenStyle", !StiValidationUtil.isNullOrEmpty((String)((StiDataBand)component).getEvenStyle()) ? ((StiDataBand)component).getEvenStyle() : "[None]");
            allProps.put("businessObject", ((StiDataBand)component).getBusinessObject() != null ? ((StiDataBand)component).getBusinessObject().GetFullName() : "[Not Assigned]");
            allProps.put("calcInvisible", ((StiDataBand)component).getCalcInvisible());
            allProps.put("printOnAllPages", ((StiDataBand)component).getPrintOnAllPages());
            allProps.put("resetPageNumber", ((StiDataBand)component).getResetPageNumber());
            allProps.put("printAtBottom", ((StiDataBand)component).getPrintAtBottom());
            allProps.put("printIfDetailEmpty", ((StiDataBand)component).getPrintIfDetailEmpty());
            allProps.put("keepGroupTogether", ((StiDataBand)component).getKeepGroupTogether());
            allProps.put("keepDetailsTogether", ((StiDataBand)component).getKeepDetailsTogether());
            allProps.put("enabled", ((StiDataBand)component).getEnabled());
            allProps.put("canGrow", ((StiDataBand)component).getCanGrow());
            allProps.put("canShrink", ((StiDataBand)component).getCanShrink());
            allProps.put("minHeight", StiReportEdit.doubleToStr(((StiDataBand)component).getMinHeight()));
            allProps.put("maxHeight", StiReportEdit.doubleToStr(((StiDataBand)component).getMaxHeight()));
        } else if ("StiTable".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiTable)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiTable)component).getBorder()));
            allProps.put("canBreak", ((StiTable)component).getCanBreak());
            allProps.put("printOn", ((StiTable)component).getPrintOn().toString());
            allProps.put("newPageBefore", ((StiTable)component).getNewPageBefore());
            allProps.put("newPageAfter", ((StiTable)component).getNewPageAfter());
            allProps.put("newColumnBefore", ((StiTable)component).getNewColumnBefore());
            allProps.put("newColumnAfter", ((StiTable)component).getNewColumnAfter());
            allProps.put("breakIfLessThan", StiReportEdit.doubleToStr(((StiTable)component).getBreakIfLessThan()));
            allProps.put("skipFirst", ((StiTable)component).getSkipFirst());
            allProps.put("sortData", StiReportEdit.getSortDataProperty(component));
            allProps.put("filterData", StiEncodingHelper.encode((String)new JSONArray(StiReportEdit.getFiltersObject(((StiTable)component).getFilters())).toString()));
            allProps.put("filterEngine", StiFilterEngine.forValue((int)((StiTable)component).getFilterEngine()).toString());
            allProps.put("filterMode", ((StiTable)component).getFilterMode().toString());
            allProps.put("filterOn", ((StiTable)component).getFilterOn());
            allProps.put("dataSource", ((StiTable)component).getDataSource() != null ? ((StiTable)component).getDataSource().getName() : "[Not Assigned]");
            allProps.put("dataRelation", ((StiTable)component).getDataRelation() != null ? ((StiTable)component).getDataRelation().getNameInSource() : "[Not Assigned]");
            allProps.put("masterComponent", ((StiTable)component).getMasterComponent() != null ? ((StiTable)component).getMasterComponent().getName() : "[Not Assigned]");
            allProps.put("countData", String.valueOf(((StiTable)component).getCountData()));
            allProps.put("oddStyle", !StiValidationUtil.isNullOrEmpty((String)((StiTable)component).getOddStyle()) ? ((StiTable)component).getOddStyle() : "[None]");
            allProps.put("evenStyle", !StiValidationUtil.isNullOrEmpty((String)((StiTable)component).getEvenStyle()) ? ((StiTable)component).getEvenStyle() : "[None]");
            allProps.put("businessObject", ((StiTable)component).getBusinessObject() != null ? ((StiTable)component).getBusinessObject().GetFullName() : "[Not Assigned]");
            allProps.put("calcInvisible", ((StiTable)component).getCalcInvisible());
            allProps.put("printOnAllPages", ((StiTable)component).getPrintOnAllPages());
            allProps.put("resetPageNumber", ((StiTable)component).getResetPageNumber());
            allProps.put("printAtBottom", ((StiTable)component).getPrintAtBottom());
            allProps.put("printIfDetailEmpty", ((StiTable)component).getPrintIfDetailEmpty());
            allProps.put("keepGroupTogether", ((StiTable)component).getKeepGroupTogether());
            allProps.put("keepDetailsTogether", ((StiTable)component).getKeepDetailsTogether());
            allProps.put("enabled", ((StiTable)component).getEnabled());
            allProps.put("canGrow", ((StiTable)component).getCanGrow());
            allProps.put("canShrink", ((StiTable)component).getCanShrink());
            allProps.put("tableAutoWidth", ((StiTable)component).getAutoWidth().toString());
            allProps.put("autoWidthType", ((StiTable)component).getAutoWidthType().toString());
            allProps.put("columnCount", String.valueOf(((StiTable)component).getColumnCount()));
            allProps.put("rowCount", String.valueOf(((StiTable)component).getRowCount()));
            allProps.put("headerRowsCount", String.valueOf(((StiTable)component).getHeaderRowsCount()));
            allProps.put("footerRowsCount", String.valueOf(((StiTable)component).getFooterRowsCount()));
            allProps.put("tableRightToLeft", ((StiTable)component).getRightToLeft());
            allProps.put("dockableTable", ((StiTable)component).getDockableTable());
            allProps.put("headerPrintOn", ((StiTable)component).getHeaderPrintOn().toString());
            allProps.put("headerCanGrow", ((StiTable)component).getHeaderCanGrow());
            allProps.put("headerCanShrink", ((StiTable)component).getHeaderCanShrink());
            allProps.put("headerCanBreak", ((StiTable)component).getHeaderCanBreak());
            allProps.put("headerPrintAtBottom", ((StiTable)component).getHeaderPrintAtBottom());
            allProps.put("headerPrintIfEmpty", ((StiTable)component).getHeaderPrintIfEmpty());
            allProps.put("headerPrintOnAllPages", ((StiTable)component).getHeaderPrintOnAllPages());
            allProps.put("headerPrintOnEvenOddPages", ((StiTable)component).getHeaderPrintOnEvenOddPages());
            allProps.put("footerPrintOn", ((StiTable)component).getFooterPrintOn().toString());
            allProps.put("footerCanGrow", ((StiTable)component).getFooterCanGrow());
            allProps.put("footerCanShrink", ((StiTable)component).getFooterCanShrink());
            allProps.put("footerCanBreak", ((StiTable)component).getFooterCanBreak());
            allProps.put("footerPrintAtBottom", ((StiTable)component).getFooterPrintAtBottom());
            allProps.put("footerPrintIfEmpty", ((StiTable)component).getFooterPrintIfEmpty());
            allProps.put("footerPrintOnAllPages", ((StiTable)component).getFooterPrintOnAllPages());
            allProps.put("footerPrintOnEvenOddPages", ((StiTable)component).getFooterPrintOnEvenOddPages());
        } else if ("StiHierarchicalBand".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiHierarchicalBand)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiHierarchicalBand)component).getBorder()));
            allProps.put("canBreak", ((StiHierarchicalBand)component).getCanBreak());
            allProps.put("printOn", ((StiHierarchicalBand)component).getPrintOn().toString());
            allProps.put("newPageBefore", ((StiHierarchicalBand)component).getNewPageBefore());
            allProps.put("newPageAfter", ((StiHierarchicalBand)component).getNewPageAfter());
            allProps.put("breakIfLessThan", StiReportEdit.doubleToStr(((StiHierarchicalBand)component).getBreakIfLessThan()));
            allProps.put("newColumnBefore", ((StiHierarchicalBand)component).getNewColumnBefore());
            allProps.put("newColumnAfter", ((StiHierarchicalBand)component).getNewColumnAfter());
            allProps.put("skipFirst", ((StiHierarchicalBand)component).getSkipFirst());
            allProps.put("columns", String.valueOf(((StiHierarchicalBand)component).getColumns()));
            allProps.put("columnWidth", StiReportEdit.doubleToStr(((StiHierarchicalBand)component).getColumnWidth()));
            allProps.put("columnGaps", StiReportEdit.doubleToStr(((StiHierarchicalBand)component).getColumnGaps()));
            allProps.put("rightToLeft", ((StiHierarchicalBand)component).getRightToLeft());
            allProps.put("columnDirection", ((StiHierarchicalBand)component).getColumnDirection().toString());
            allProps.put("minRowsInColumn", String.valueOf(((StiHierarchicalBand)component).getMinRowsInColumn()));
            allProps.put("sortData", StiReportEdit.getSortDataProperty(component));
            allProps.put("filterData", StiEncodingHelper.encode((String)new JSONArray(StiReportEdit.getFiltersObject(((StiHierarchicalBand)component).getFilters())).toString()));
            allProps.put("filterEngine", StiFilterEngine.forValue((int)((StiHierarchicalBand)component).getFilterEngine()).toString());
            allProps.put("filterMode", ((StiHierarchicalBand)component).getFilterMode().toString());
            allProps.put("filterOn", ((StiHierarchicalBand)component).getFilterOn());
            allProps.put("dataSource", ((StiHierarchicalBand)component).getDataSource() != null ? ((StiHierarchicalBand)component).getDataSource().getName() : "[Not Assigned]");
            allProps.put("dataRelation", ((StiHierarchicalBand)component).getDataRelation() != null ? ((StiHierarchicalBand)component).getDataRelation().getNameInSource() : "[Not Assigned]");
            allProps.put("masterComponent", ((StiHierarchicalBand)component).getMasterComponent() != null ? ((StiHierarchicalBand)component).getMasterComponent().getName() : "[Not Assigned]");
            allProps.put("countData", String.valueOf(((StiHierarchicalBand)component).getCountData()));
            allProps.put("keyDataColumn", ((StiHierarchicalBand)component).getKeyDataColumn());
            allProps.put("masterKeyDataColumn", ((StiHierarchicalBand)component).getMasterKeyDataColumn());
            allProps.put("parentValue", StiEncodingHelper.encode((String)((StiHierarchicalBand)component).getParentValue()));
            allProps.put("indent", StiReportEdit.doubleToStr(((StiHierarchicalBand)component).getIndent()));
            allProps.put("headers", StiEncodingHelper.encode((String)((StiHierarchicalBand)component).getHeaders()));
            allProps.put("footers", StiEncodingHelper.encode((String)((StiHierarchicalBand)component).getFooters()));
            allProps.put("oddStyle", !StiValidationUtil.isNullOrEmpty((String)((StiHierarchicalBand)component).getOddStyle()) ? ((StiHierarchicalBand)component).getOddStyle() : "[None]");
            allProps.put("evenStyle", !StiValidationUtil.isNullOrEmpty((String)((StiHierarchicalBand)component).getEvenStyle()) ? ((StiHierarchicalBand)component).getEvenStyle() : "[None]");
            allProps.put("businessObject", ((StiHierarchicalBand)component).getBusinessObject() != null ? ((StiHierarchicalBand)component).getBusinessObject().GetFullName() : "[Not Assigned]");
            allProps.put("calcInvisible", ((StiHierarchicalBand)component).getCalcInvisible());
            allProps.put("printOnAllPages", ((StiHierarchicalBand)component).getPrintOnAllPages());
            allProps.put("resetPageNumber", ((StiHierarchicalBand)component).getResetPageNumber());
            allProps.put("printAtBottom", ((StiHierarchicalBand)component).getPrintAtBottom());
            allProps.put("printIfDetailEmpty", ((StiHierarchicalBand)component).getPrintIfDetailEmpty());
            allProps.put("keepGroupTogether", ((StiHierarchicalBand)component).getKeepGroupTogether());
            allProps.put("keepDetailsTogether", ((StiHierarchicalBand)component).getKeepDetailsTogether());
            allProps.put("enabled", ((StiHierarchicalBand)component).getEnabled());
            allProps.put("canGrow", ((StiHierarchicalBand)component).getCanGrow());
            allProps.put("canShrink", ((StiHierarchicalBand)component).getCanShrink());
            allProps.put("minHeight", StiReportEdit.doubleToStr(((StiHierarchicalBand)component).getMinHeight()));
            allProps.put("maxHeight", StiReportEdit.doubleToStr(((StiHierarchicalBand)component).getMaxHeight()));
        } else if ("StiChildBand".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiChildBand)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiChildBand)component).getBorder()));
            allProps.put("canBreak", ((StiChildBand)component).getCanBreak());
            allProps.put("printOn", ((StiChildBand)component).getPrintOn().toString());
            allProps.put("newPageBefore", ((StiChildBand)component).getNewPageBefore());
            allProps.put("newPageAfter", ((StiChildBand)component).getNewPageAfter());
            allProps.put("breakIfLessThan", StiReportEdit.doubleToStr(((StiChildBand)component).getBreakIfLessThan()));
            allProps.put("newColumnBefore", ((StiChildBand)component).getNewColumnBefore());
            allProps.put("newColumnAfter", ((StiChildBand)component).getNewColumnAfter());
            allProps.put("skipFirst", ((StiChildBand)component).getSkipFirst());
            allProps.put("resetPageNumber", ((StiChildBand)component).getResetPageNumber());
            allProps.put("printAtBottom", ((StiChildBand)component).getPrintAtBottom());
            allProps.put("enabled", ((StiChildBand)component).getEnabled());
            allProps.put("canGrow", ((StiChildBand)component).getCanGrow());
            allProps.put("canShrink", ((StiChildBand)component).getCanShrink());
            allProps.put("minHeight", StiReportEdit.doubleToStr(((StiChildBand)component).getMinHeight()));
            allProps.put("maxHeight", StiReportEdit.doubleToStr(((StiChildBand)component).getMaxHeight()));
        } else if ("StiEmptyBand".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiEmptyBand)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiEmptyBand)component).getBorder()));
            allProps.put("printOn", ((StiEmptyBand)component).getPrintOn().toString());
            allProps.put("oddStyle", !StiValidationUtil.isNullOrEmpty((String)((StiEmptyBand)component).getOddStyle()) ? ((StiEmptyBand)component).getOddStyle() : "[None]");
            allProps.put("evenStyle", !StiValidationUtil.isNullOrEmpty((String)((StiEmptyBand)component).getEvenStyle()) ? ((StiEmptyBand)component).getEvenStyle() : "[None]");
            allProps.put("resetPageNumber", ((StiEmptyBand)component).getResetPageNumber());
            allProps.put("enabled", ((StiEmptyBand)component).getEnabled());
            allProps.put("canGrow", ((StiEmptyBand)component).getCanGrow());
            allProps.put("canShrink", ((StiEmptyBand)component).getCanShrink());
            allProps.put("minHeight", StiReportEdit.doubleToStr(((StiEmptyBand)component).getMinHeight()));
            allProps.put("maxHeight", StiReportEdit.doubleToStr(((StiEmptyBand)component).getMaxHeight()));
        } else if ("StiTableOfContents".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiTableOfContents)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiTableOfContents)component).getBorder()));
            allProps.put("tableOfContentsIndent", String.valueOf(((StiTableOfContents)component).getIndent()));
            allProps.put("tableOfContentsNewPageBefore", ((StiTableOfContents)component).getNewPageBefore());
            allProps.put("tableOfContentsNewPageAfter", ((StiTableOfContents)component).getNewPageAfter());
            allProps.put("tableOfContentsRightToLeft", ((StiTableOfContents)component).getRightToLeft());
            allProps.put("enabled", ((StiTableOfContents)component).getEnabled());
            allProps.put("minHeight", StiReportEdit.doubleToStr(((StiTableOfContents)component).getMinHeight()));
            allProps.put("maxHeight", StiReportEdit.doubleToStr(((StiTableOfContents)component).getMaxHeight()));
            allProps.put("tableOfContentsStyles", StiReportEdit.getStylesProperty(component));
            allProps.put("tableOfContentsMargins", String.format("%s);%s);%s);%s", ((StiTableOfContents)component).getMargins().getLeft(), ((StiTableOfContents)component).getMargins().getTop(), ((StiTableOfContents)component).getMargins().getRight(), ((StiTableOfContents)component).getMargins().getBottom()));
            allProps.put("reportPointer", !StiValidationUtil.isNullOrEmpty((String)((StiTableOfContents)component).getReportPointer()) ? StiEncodingHelper.encode((String)((StiTableOfContents)component).getReportPointer()) : "");
        } else if ("StiReportSummaryBand".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiReportSummaryBand)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiReportSummaryBand)component).getBorder()));
            allProps.put("canBreak", ((StiReportSummaryBand)component).getCanBreak());
            allProps.put("gGrowToHeight", ((StiReportSummaryBand)component).getGrowToHeight());
            allProps.put("newPageBefore", ((StiReportSummaryBand)component).getNewPageBefore());
            allProps.put("newPageAfter", ((StiReportSummaryBand)component).getNewPageAfter());
            allProps.put("newColumnBefore", ((StiReportSummaryBand)component).getNewColumnBefore());
            allProps.put("newColumnAfter", ((StiReportSummaryBand)component).getNewColumnAfter());
            allProps.put("breakIfLessThan", StiReportEdit.doubleToStr(((StiReportSummaryBand)component).getBreakIfLessThan()));
            allProps.put("skipFirst", ((StiReportSummaryBand)component).getSkipFirst());
            allProps.put("printIfEmpty", ((StiReportSummaryBand)component).getPrintIfEmpty());
            allProps.put("resetPageNumber", ((StiReportSummaryBand)component).getResetPageNumber());
            allProps.put("printAtBottom", ((StiReportSummaryBand)component).getPrintAtBottom());
            allProps.put("enabled", ((StiReportSummaryBand)component).getEnabled());
            allProps.put("canGrow", ((StiReportSummaryBand)component).getCanGrow());
            allProps.put("canShrink", ((StiReportSummaryBand)component).getCanShrink());
            allProps.put("minHeight", StiReportEdit.doubleToStr(((StiReportSummaryBand)component).getMinHeight()));
            allProps.put("maxHeight", StiReportEdit.doubleToStr(((StiReportSummaryBand)component).getMaxHeight()));
        } else if ("StiOverlayBand".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiOverlayBand)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiOverlayBand)component).getBorder()));
            allProps.put("printOn", ((StiOverlayBand)component).getPrintOn().toString());
            allProps.put("resetPageNumber", ((StiOverlayBand)component).getResetPageNumber());
            allProps.put("enabled", ((StiOverlayBand)component).getEnabled());
            allProps.put("canGrow", ((StiOverlayBand)component).getCanGrow());
            allProps.put("canShrink", ((StiOverlayBand)component).getCanShrink());
            allProps.put("minHeight", StiReportEdit.doubleToStr(((StiOverlayBand)component).getMinHeight()));
            allProps.put("maxHeight", StiReportEdit.doubleToStr(((StiOverlayBand)component).getMaxHeight()));
            allProps.put("vertAlignment", ((StiOverlayBand)component).getVertAlignment().toString());
        } else if ("StiCrossTab".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiCrossTab)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiCrossTab)component).getBorder()));
            allProps.put("growToHeight", ((StiCrossTab)component).getGrowToHeight());
            allProps.put("printOn", ((StiCrossTab)component).getPrintOn().toString());
            allProps.put("printable", ((StiCrossTab)component).getPrintable());
            allProps.put("clientLeft", StiReportEdit.doubleToStr(component.getLeft()));
            allProps.put("clientTop", StiReportEdit.doubleToStr(component.getTop()));
            allProps.put("sortData", StiReportEdit.getSortDataProperty(component));
            allProps.put("filterData", StiEncodingHelper.encode((String)new JSONArray(StiReportEdit.getFiltersObject(((StiCrossTab)component).getFilters())).toString()));
            allProps.put("filterMode", ((StiCrossTab)component).getFilterMode().toString());
            allProps.put("filterOn", ((StiCrossTab)component).getFilterOn());
            allProps.put("filterEngine", ((StiCrossTab)component).getFilterEngine().toString());
            allProps.put("dataSource", ((StiCrossTab)component).getDataSource() != null ? ((StiCrossTab)component).getDataSource().getName() : "[Not Assigned]");
            allProps.put("dataRelation", ((StiCrossTab)component).getDataRelation() != null ? ((StiCrossTab)component).getDataRelation().getNameInSource() : "[Not Assigned]");
            allProps.put("crossTabEmptyValue", StiEncodingHelper.encode((String)((StiCrossTab)component).getEmptyValue()));
            allProps.put("crossTabHorAlign", ((StiCrossTab)component).getHorAlignment().toString());
            allProps.put("printIfEmpty", ((StiCrossTab)component).getPrintIfEmpty());
            allProps.put("rightToLeft", ((StiCrossTab)component).getRightToLeft());
            allProps.put("crossTabWrap", ((StiCrossTab)component).getWrap());
            allProps.put("crossTabWrapGap", StiReportEdit.doubleToStr(((StiCrossTab)component).getWrapGap()));
            allProps.put("crossTabPrintTitle", ((StiCrossTab)component).getPrintTitleOnAllPages());
            allProps.put("enabled", ((StiCrossTab)component).getEnabled());
            allProps.put("canGrow", ((StiCrossTab)component).getCanGrow());
            allProps.put("canShrink", ((StiCrossTab)component).getCanShrink());
            allProps.put("crossTabFields", StiReportEdit.getCrossTabFieldsProperties((StiCrossTab)component));
            allProps.put("dockStyle", ((StiCrossTab)component).getDockStyle().toString());
            allProps.put("summaryDirection", ((StiCrossTab)component).getSummaryDirection().toString());
            allProps.put("minSize", StiReportEdit.doubleToStr(component.getMinSize().width) + ";" + StiReportEdit.doubleToStr(component.getMinSize().height));
            allProps.put("maxSize", StiReportEdit.doubleToStr(component.getMaxSize().width) + ";" + StiReportEdit.doubleToStr(component.getMaxSize().height));
        } else if ("StiCrossGroupHeaderBand".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiCrossGroupHeaderBand)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiCrossGroupHeaderBand)component).getBorder()));
            allProps.put("printOn", ((StiCrossGroupHeaderBand)component).getPrintOn().toString());
            allProps.put("condition", ((StiCrossGroupHeaderBand)component).getCondition() != null ? StiEncodingHelper.encode((String)((StiCrossGroupHeaderBand)component).getCondition().getValue()) : "");
            allProps.put("sortDirection", String.valueOf(((StiCrossGroupHeaderBand)component).getSortDirection().getValue()));
            allProps.put("summarySortDirection", String.valueOf(((StiCrossGroupHeaderBand)component).getSummarySortDirection().getValue()));
            allProps.put("summaryExpression", StiEncodingHelper.encode((String)((StiCrossGroupHeaderBand)component).getSummaryExpression().toString()));
            allProps.put("summaryType", String.valueOf(((StiCrossGroupHeaderBand)component).getSummaryType().getValue()));
            allProps.put("keepGroupTogether", ((StiCrossGroupHeaderBand)component).getKeepGroupTogether());
            allProps.put("keepGroupHeaderTogether", ((StiCrossGroupHeaderBand)component).getKeepGroupHeaderTogether());
            allProps.put("enabled", ((StiCrossGroupHeaderBand)component).getEnabled());
            allProps.put("canGrow", ((StiCrossGroupHeaderBand)component).getCanGrow());
            allProps.put("canShrink", ((StiCrossGroupHeaderBand)component).getCanShrink());
            allProps.put("canBreak", ((StiCrossGroupHeaderBand)component).getCanBreak());
            allProps.put("minWidth", StiReportEdit.doubleToStr(((StiCrossGroupHeaderBand)component).getMinWidth()));
            allProps.put("maxWidth", StiReportEdit.doubleToStr(((StiCrossGroupHeaderBand)component).getMaxWidth()));
        } else if ("StiCrossGroupFooterBand".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiCrossGroupFooterBand)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiCrossGroupFooterBand)component).getBorder()));
            allProps.put("printOn", ((StiCrossGroupFooterBand)component).getPrintOn().toString());
            allProps.put("enabled", ((StiCrossGroupFooterBand)component).getEnabled());
            allProps.put("canGrow", ((StiCrossGroupFooterBand)component).getCanGrow());
            allProps.put("canShrink", ((StiCrossGroupFooterBand)component).getCanShrink());
            allProps.put("canBreak", ((StiCrossGroupFooterBand)component).getCanBreak());
            allProps.put("keepGroupFooterTogether", ((StiCrossGroupFooterBand)component).getKeepGroupFooterTogether());
            allProps.put("minWidth", StiReportEdit.doubleToStr(((StiCrossGroupFooterBand)component).getMinWidth()));
            allProps.put("maxWidth", StiReportEdit.doubleToStr(((StiCrossGroupFooterBand)component).getMaxWidth()));
        } else if ("StiCrossHeaderBand".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiCrossHeaderBand)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiCrossHeaderBand)component).getBorder()));
            allProps.put("enabled", ((StiCrossHeaderBand)component).getEnabled());
            allProps.put("canGrow", ((StiCrossHeaderBand)component).getCanGrow());
            allProps.put("canShrink", ((StiCrossHeaderBand)component).getCanShrink());
            allProps.put("canBreak", ((StiCrossHeaderBand)component).getCanBreak());
            allProps.put("keepHeaderTogether", ((StiCrossHeaderBand)component).getKeepHeaderTogether());
            allProps.put("minWidth", StiReportEdit.doubleToStr(((StiCrossHeaderBand)component).getMinWidth()));
            allProps.put("maxWidth", StiReportEdit.doubleToStr(((StiCrossHeaderBand)component).getMaxWidth()));
        } else if ("StiCrossFooterBand".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiCrossFooterBand)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiCrossFooterBand)component).getBorder()));
            allProps.put("enabled", ((StiCrossFooterBand)component).getEnabled());
            allProps.put("canGrow", ((StiCrossFooterBand)component).getCanGrow());
            allProps.put("canShrink", ((StiCrossFooterBand)component).getCanShrink());
            allProps.put("canBreak", ((StiCrossFooterBand)component).getCanBreak());
            allProps.put("keepFooterTogether", ((StiCrossFooterBand)component).getKeepFooterTogether());
            allProps.put("minWidth", StiReportEdit.doubleToStr(((StiCrossFooterBand)component).getMinWidth()));
            allProps.put("maxWidth", StiReportEdit.doubleToStr(((StiCrossFooterBand)component).getMaxWidth()));
        } else if ("StiCrossDataBand".equals(typeComponent)) {
            allProps.put("brush", StiReportEdit.brushToStr(((StiCrossDataBand)component).getBrush()));
            allProps.put("border", StiReportEdit.borderToStr(((StiCrossDataBand)component).getBorder()));
            allProps.put("sortData", StiReportEdit.getSortDataProperty(component));
            allProps.put("filterData", StiEncodingHelper.encode((String)new JSONArray(StiReportEdit.getFiltersObject(((StiCrossDataBand)component).getFilters())).toString()));
            allProps.put("filterEngine", StiFilterEngine.forValue((int)((StiCrossDataBand)component).getFilterEngine()).toString());
            allProps.put("filterMode", ((StiCrossDataBand)component).getFilterMode().toString());
            allProps.put("filterOn", ((StiCrossDataBand)component).getFilterOn());
            allProps.put("dataSource", ((StiCrossDataBand)component).getDataSource() != null ? ((StiCrossDataBand)component).getDataSource().getName() : "[Not Assigned]");
            allProps.put("dataRelation", ((StiCrossDataBand)component).getDataRelation() != null ? ((StiCrossDataBand)component).getDataRelation().getNameInSource() : "[Not Assigned]");
            allProps.put("masterComponent", ((StiCrossDataBand)component).getMasterComponent() != null ? ((StiCrossDataBand)component).getMasterComponent().getName() : "[Not Assigned]");
            allProps.put("countData", String.valueOf(((StiCrossDataBand)component).getCountData()));
            allProps.put("oddStyle", !StiValidationUtil.isNullOrEmpty((String)((StiCrossDataBand)component).getOddStyle()) ? ((StiCrossDataBand)component).getOddStyle() : "[None]");
            allProps.put("evenStyle", !StiValidationUtil.isNullOrEmpty((String)((StiCrossDataBand)component).getEvenStyle()) ? ((StiCrossDataBand)component).getEvenStyle() : "[None]");
            allProps.put("businessObject", ((StiCrossDataBand)component).getBusinessObject() != null ? ((StiCrossDataBand)component).getBusinessObject().GetFullName() : "[Not Assigned]");
            allProps.put("calcInvisible", ((StiCrossDataBand)component).getCalcInvisible());
            allProps.put("printIfDetailEmpty", ((StiCrossDataBand)component).getPrintIfDetailEmpty());
            allProps.put("keepDetailsTogether", ((StiCrossDataBand)component).getKeepDetailsTogether());
            allProps.put("enabled", ((StiCrossDataBand)component).getEnabled());
            allProps.put("canGrow", ((StiCrossDataBand)component).getCanGrow());
            allProps.put("canShrink", ((StiCrossDataBand)component).getCanShrink());
            allProps.put("canBreak", ((StiCrossDataBand)component).getCanBreak());
            allProps.put("minWidth", StiReportEdit.doubleToStr(((StiCrossDataBand)component).getMinWidth()));
            allProps.put("maxWidth", StiReportEdit.doubleToStr(((StiCrossDataBand)component).getMaxWidth()));
        }
        return allProps;
    }

    private static Object gp(Object obj, String prop) {
        try {
            Method method = obj.getClass().getMethod("get" + prop, new Class[0]);
            return method != null ? method.invoke(obj, new Object[0]) : null;
        }
        catch (Exception e) {
            LOG.fine(e.getMessage() + e.toString());
            if (StiOptions.Engine.logLevel >= 10) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private static Boolean gb(Object obj, String prop, boolean def) {
        boolean res = def;
        Object pi = StiReportEdit.gp(obj, prop);
        if (pi != null) {
            res = (Boolean)pi;
        }
        return res;
    }

    public static String getRichTextProperty(StiRichText component) throws StiException, IOException {
        StiExpression text = component.getText();
        if (text != null && text.getValue() != null && text.getValue().startsWith("stimulsoft-server://")) {
            return StiEncodingHelper.encode((String)text.getValue());
        }
        StiText stitext = new StiText();
        stitext.setDisplayRectangle(component.getDisplayRectangle());
        String htmlText = StiRtfExportService.getRtfFileFromHtmlTags((StiText)stitext, (String)component.getRtfText());
        htmlText = htmlText.replaceAll("  ", "&nbsp;&nbsp;");
        htmlText = htmlText.replaceAll("<SPAN />", "<BR>");
        return StiEncodingHelper.encode((String)htmlText);
    }

    public static String getSortDataProperty(Object object_) {
        ArrayList<HashMap<String, String>> sorts = new ArrayList<HashMap<String, String>>();
        ArrayList sort = (ArrayList)StiReportEdit.gp(object_, "Sort");
        if (sort != null) {
            ArrayList singleSort = null;
            for (int i = 0; i < sort.size(); ++i) {
                if ("ASC".equals(sort.get(i)) || "DESC".equals(sort.get(i)) || i == sort.size() - 1) {
                    if (i == sort.size() - 1) {
                        singleSort.add(sort.get(i));
                    }
                    if (singleSort != null) {
                        sorts.add(StiReportEdit.getSingleSort(object_, singleSort));
                    }
                    singleSort = new ArrayList();
                }
                singleSort.add(sort.get(i));
            }
        }
        return sorts.size() != 0 ? StiEncodingHelper.encode((String)new JSONArray(sorts).toString()) : "";
    }

    private static String getRelationNameByNameInSource(Object object_, String nameInSource) {
        StiDictionary dictionary = null;
        if (object_ instanceof StiComponent) {
            dictionary = ((StiComponent)object_).getReport().getDictionary();
        } else if (object_ instanceof StiDataSource) {
            dictionary = ((StiDataSource)object_).getDictionary();
        }
        if (dictionary != null) {
            StiDataRelationsCollection relations = dictionary.getRelations();
            for (StiDataRelation relation : relations) {
                if (!StiValidationUtil.equals((Object)relation.getNameInSource(), (Object)nameInSource)) continue;
                return relation.getName();
            }
        }
        return "";
    }

    private static HashMap<String, String> getSingleSort(Object object_, ArrayList<String> sortArray) {
        HashMap<String, String> oneSort = new HashMap<String, String>();
        oneSort.put("direction", sortArray.get(0));
        oneSort.put("column", "");
        for (int k = 1; k < sortArray.size() - 1; ++k) {
            oneSort.put("column", (String)oneSort.get("column") + StiReportEdit.getRelationNameByNameInSource(object_, sortArray.get(k)) + ".");
        }
        oneSort.put("column", (String)oneSort.get("column") + sortArray.get(sortArray.size() - 1));
        return oneSort;
    }

    public static List<HashMap<String, String>> getFiltersObject(StiFiltersCollection filters) {
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        if (filters != null) {
            for (StiFilter filter : filters) {
                HashMap<String, String> singleFilter = new HashMap<String, String>();
                result.add(singleFilter);
                singleFilter.put("fieldIs", filter.getItem().toString());
                singleFilter.put("dataType", filter.getDataType().toString());
                singleFilter.put("column", filter.getColumn());
                singleFilter.put("condition", filter.getCondition().toString());
                singleFilter.put("value1", filter.getValue1().toString());
                singleFilter.put("value2", filter.getValue2().toString());
                String expression = filter.getExpression().getValue();
                if (!StiValidationUtil.isNullOrEmpty((String)expression) && expression.startsWith("{") && expression.endsWith("}")) {
                    expression = expression.substring(1, expression.length() - 1);
                }
                singleFilter.put("expression", expression);
            }
        }
        return result;
    }

    public static String getFilterDataProperty(Object component) {
        StiFiltersCollection filters = null;
        List<Object> result = new ArrayList();
        Object pi = StiReportEdit.gp(component, "Filters");
        if (pi != null) {
            filters = (StiFiltersCollection)pi;
        }
        if (filters != null) {
            result = StiReportEdit.getFiltersObject(filters);
        }
        return StiEncodingHelper.encode((String)new JSONArray(result).toString());
    }

    public static boolean getFilterOnProperty(Object component) {
        return StiReportEdit.gb(component, "FilterOn", true);
    }

    public static String getFilterModeProperty(Object component) {
        StiFilterMode filterMode = StiFilterMode.And;
        Object pi = StiReportEdit.gp(component, "FilterMode");
        if (pi != null) {
            filterMode = (StiFilterMode)pi;
        }
        return filterMode.name();
    }

    public static String getSvgContent(StiComponent component, double zoom) throws Exception {
        if (component instanceof StiImage || component.getWidth() == 0.0 || component.getHeight() == 0.0) {
            return "";
        }
        String svgContent = StiSvgExportService.StiSvgHelper.saveComponentToString((StiComponent)component, (StiImageFormat)StiImageFormat.Png, (float)0.75f, (float)((float)(zoom * 100.0)));
        return StiEncodingHelper.encode((String)svgContent);
    }

    public static String getConditionsProperty(Object component) {
        ArrayList<HashMap<String, Object>> conditionsArray = new ArrayList<HashMap<String, Object>>();
        Object conditions = StiReportEdit.gp(component, "Conditions");
        if (conditions != null && conditions instanceof StiConditionsCollection) {
            for (StiBaseCondition condition : (StiConditionsCollection)conditions) {
                if (condition instanceof StiDataBarCondition) {
                    conditionsArray.add(StiReportEdit.getDataBarConditionObject((StiDataBarCondition)condition));
                    continue;
                }
                if (condition instanceof StiIconSetCondition) {
                    conditionsArray.add(StiReportEdit.getIconSetConditionObject((StiIconSetCondition)condition));
                    continue;
                }
                if (condition instanceof StiColorScaleCondition) {
                    conditionsArray.add(StiReportEdit.getColorScaleConditionObject((StiColorScaleCondition)condition));
                    continue;
                }
                if (!(condition instanceof StiCondition)) continue;
                conditionsArray.add(StiReportEdit.getHighlightConditionObject((StiCondition)condition));
            }
        }
        return conditionsArray.size() > 0 ? StiEncodingHelper.encode((String)new JSONArray(conditionsArray).toString()) : "";
    }

    public static HashMap<String, Object> getDataBarConditionObject(StiDataBarCondition condition) {
        HashMap<String, Object> conditionObject = new HashMap<String, Object>();
        conditionObject.put("ConditionType", "StiDataBarCondition");
        conditionObject.put("Column", condition.getColumn());
        conditionObject.put("MaximumType", condition.getMaximumType());
        conditionObject.put("MaximumValue", StiReportEdit.doubleToStr(condition.getMaximumValue()));
        conditionObject.put("MinimumType", condition.getMinimumType());
        conditionObject.put("MinimumValue", StiReportEdit.doubleToStr(condition.getMinimumValue()));
        conditionObject.put("Direction", condition.getDirection());
        conditionObject.put("BrushType", condition.getBrushType());
        conditionObject.put("PositiveColor", StiReportEdit.getStringFromColor(condition.getPositiveColor()));
        conditionObject.put("NegativeColor", StiReportEdit.getStringFromColor(condition.getNegativeColor()));
        conditionObject.put("ShowBorder", condition.getShowBorder());
        conditionObject.put("PositiveBorderColor", StiReportEdit.getStringFromColor(condition.getPositiveBorderColor()));
        conditionObject.put("NegativeBorderColor", StiReportEdit.getStringFromColor(condition.getNegativeBorderColor()));
        return conditionObject;
    }

    public static HashMap<String, Object> getIconSetConditionObject(StiIconSetCondition condition) {
        HashMap<String, Object> conditionObject = new HashMap<String, Object>();
        conditionObject.put("ConditionType", "StiIconSetCondition");
        conditionObject.put("Column", condition.getColumn());
        conditionObject.put("ContentAlignment", condition.getContentAlignment());
        conditionObject.put("IconSet", condition.getIconSet());
        conditionObject.put("IconSetItem1", StiReportEdit.getIconSetItemObject(condition.getIconSetItem1()));
        conditionObject.put("IconSetItem2", StiReportEdit.getIconSetItemObject(condition.getIconSetItem2()));
        conditionObject.put("IconSetItem3", StiReportEdit.getIconSetItemObject(condition.getIconSetItem3()));
        conditionObject.put("IconSetItem4", StiReportEdit.getIconSetItemObject(condition.getIconSetItem4()));
        conditionObject.put("IconSetItem5", StiReportEdit.getIconSetItemObject(condition.getIconSetItem5()));
        return conditionObject;
    }

    public static HashMap<String, Object> getColorScaleConditionObject(StiColorScaleCondition condition) {
        HashMap<String, Object> conditionObject = new HashMap<String, Object>();
        conditionObject.put("ConditionType", "StiColorScaleCondition");
        conditionObject.put("Column", condition.getColumn());
        conditionObject.put("ScaleType", condition.getScaleType());
        conditionObject.put("MaximumType", condition.getMaximumType());
        conditionObject.put("MaximumValue", StiReportEdit.doubleToStr(condition.getMaximumValue()));
        conditionObject.put("MaximumColor", StiReportEdit.getStringFromColor(condition.getMaximumColor()));
        conditionObject.put("MinimumType", condition.getMinimumType());
        conditionObject.put("MinimumValue", StiReportEdit.doubleToStr(condition.getMinimumValue()));
        conditionObject.put("MinimumColor", StiReportEdit.getStringFromColor(condition.getMinimumColor()));
        conditionObject.put("MidType", condition.getMidType());
        conditionObject.put("MidValue", StiReportEdit.doubleToStr(condition.getMidValue()));
        conditionObject.put("MidColor", StiReportEdit.getStringFromColor(condition.getMidColor()));
        return conditionObject;
    }

    public static HashMap<String, Object> getHighlightConditionObject(StiCondition condition) {
        HashMap<String, Object> conditionObject = new HashMap<String, Object>();
        conditionObject.put("ConditionType", "StiHighlightCondition");
        conditionObject.put("BorderSides", condition.getBorderSides().toString());
        conditionObject.put("Permissions", condition.getPermissions().toString());
        conditionObject.put("Style", condition.getStyle().toString());
        conditionObject.put("Font", StiReportEdit.fontToStr(condition.getFont()));
        conditionObject.put("BackColor", StiReportEdit.getStringFromColor(condition.getBackColor()));
        conditionObject.put("TextColor", StiReportEdit.getStringFromColor(condition.getTextColor()));
        conditionObject.put("Enabled", condition.getEnabled());
        conditionObject.put("AssignExpression", StiEncodingHelper.encode((String)condition.getAssignExpression()));
        conditionObject.put("CanAssignExpression", condition.getCanAssignExpression());
        conditionObject.put("BreakIfTrue", condition.getBreakIfTrue());
        if (condition instanceof StiMultiCondition) {
            conditionObject.put("Filters", StiReportEdit.getFilterDataProperty(condition));
            conditionObject.put("FilterMode", StiReportEdit.getFilterModeProperty(condition));
        } else {
            ArrayList filters = new ArrayList();
            HashMap<String, String> filter = new HashMap<String, String>();
            filters.add(filter);
            filter.put("fieldIs", condition.getItem().toString());
            filter.put("dataType", condition.getDataType().toString());
            filter.put("column", condition.getColumn());
            filter.put("condition", condition.getCondition().toString());
            filter.put("value1", condition.getValue1().toString());
            filter.put("value2", condition.getValue2().toString());
            String expression = condition.getExpression().getValue();
            if (!StiValidationUtil.isNullOrEmpty((String)expression) && expression.startsWith("{") && expression.endsWith("}")) {
                expression = expression.substring(1, expression.length() - 1);
            }
            filter.put("expression", expression);
            conditionObject.put("Filters", StiEncodingHelper.encode((String)new JSONArray(filters).toString()));
        }
        return conditionObject;
    }

    public static String getComponentHeaderSize(Object component) {
        Object headerSize = StiReportEdit.getPropertyValue("HeaderSize", component);
        return headerSize != null ? (String)headerSize : "0";
    }

    public static HashMap<String, Object> getInteractionProperty(StiInteraction interaction) {
        HashMap<String, Object> interactionObject = new HashMap<String, Object>();
        if (interaction instanceof StiBandInteraction) {
            StiBandInteraction bandInteraction = (StiBandInteraction)interaction;
            interactionObject.put("isBandInteraction", true);
            interactionObject.put("collapsingEnabled", bandInteraction.getCollapsingEnabled());
            interactionObject.put("collapseGroupFooter", bandInteraction.getCollapseGroupFooter());
            interactionObject.put("collapsedValue", StiEncodingHelper.encode((String)bandInteraction.getCollapsed().getValue()));
            interactionObject.put("selectionEnabled", bandInteraction.getSelectionEnabled());
        }
        interactionObject.put("drillDownEnabled", interaction.getDrillDownEnabled());
        interactionObject.put("drillDownReport", interaction.getDrillDownReport());
        interactionObject.put("drillDownMode", interaction.getDrillDownMode().toString());
        interactionObject.put("drillDownPage", interaction.getDrillDownPage() != null ? interaction.getDrillDownPage().getName() : "");
        interactionObject.put("drillDownParameter1Name", interaction.getDrillDownParameter1().getName());
        interactionObject.put("drillDownParameter1Expression", StiEncodingHelper.encode((String)interaction.getDrillDownParameter1().getExpression().getValue()));
        interactionObject.put("drillDownParameter2Name", interaction.getDrillDownParameter2().getName());
        interactionObject.put("drillDownParameter2Expression", StiEncodingHelper.encode((String)interaction.getDrillDownParameter2().getExpression().getValue()));
        interactionObject.put("drillDownParameter3Name", interaction.getDrillDownParameter3().getName());
        interactionObject.put("drillDownParameter3Expression", StiEncodingHelper.encode((String)interaction.getDrillDownParameter3().getExpression().getValue()));
        interactionObject.put("drillDownParameter4Name", interaction.getDrillDownParameter4().getName());
        interactionObject.put("drillDownParameter4Expression", StiEncodingHelper.encode((String)interaction.getDrillDownParameter4().getExpression().getValue()));
        interactionObject.put("drillDownParameter5Name", interaction.getDrillDownParameter5().getName());
        interactionObject.put("drillDownParameter5Expression", StiEncodingHelper.encode((String)interaction.getDrillDownParameter5().getExpression().getValue()));
        interactionObject.put("sortingEnabled", interaction.getSortingEnabled());
        if (!StiValidationUtil.isNullOrEmpty((String)interaction.getSortingColumn())) {
            String column = interaction.getSortingColumn();
            if (column.startsWith("{")) {
                column = column.substring(1);
            }
            if (column.endsWith("}")) {
                column = column.substring(0, column.length() - 1);
            }
            interactionObject.put("sortingColumn", column);
        } else {
            interactionObject.put("sortingColumn", "");
        }
        interactionObject.put("bookmark", StiEncodingHelper.encode((String)interaction.getBookmark().getValue()));
        String hyperlinkText = interaction.getHyperlink().getValue();
        if (hyperlinkText.startsWith("##")) {
            interactionObject.put("hyperlinkType", "HyperlinkUsingInteractionTag");
            interactionObject.put("hyperlink", StiEncodingHelper.encode((String)hyperlinkText.substring(2)));
        } else if (hyperlinkText.startsWith("#")) {
            interactionObject.put("hyperlinkType", "HyperlinkUsingInteractionBookmark");
            interactionObject.put("hyperlink", StiEncodingHelper.encode((String)hyperlinkText.substring(1)));
        } else {
            interactionObject.put("hyperlinkType", "HyperlinkExternalDocuments");
            interactionObject.put("hyperlink", StiEncodingHelper.encode((String)hyperlinkText));
        }
        interactionObject.put("tag", StiEncodingHelper.encode((String)interaction.getTag().getValue()));
        interactionObject.put("toolTip", StiEncodingHelper.encode((String)interaction.getToolTip().getValue()));
        return interactionObject;
    }

    public static HashMap<String, Object> getCrossTabFieldsProperties(StiCrossTab crossTab) throws Exception {
        StiCrossTabHelper crossTabHelper = new StiCrossTabHelper(crossTab);
        HashMap<String, Object> properties = crossTabHelper.getFieldsPropertiesForJS();
        crossTabHelper.restorePositions();
        crossTabHelper = null;
        return properties;
    }

    public static HashMap<String, String> getEventsProperty(Object object_) {
        String[] eventNames;
        HashMap<String, String> events = new HashMap<String, String>();
        for (String eventName : eventNames = new String[]{"GetExcelValueEvent", "GetCollapsedEvent", "GetTagEvent", "GetToolTipEvent", "GetValueEvent", "ClickEvent", "DoubleClickEvent", "GetDrillDownReportEvent", "MouseEnterEvent", "MouseLeaveEvent", "GetBookmarkEvent", "GetHyperlinkEvent", "AfterPrintEvent", "BeforePrintEvent", "BeginRenderEvent", "ColumnBeginRenderEvent", "ColumnEndRenderEvent", "EndRenderEvent", "RenderingEvent", "ExportedEvent", "ExportingEvent", "PrintedEvent", "PrintingEvent", "ReportCacheProcessingEvent", "GetDataUrlEvent", "GetImageDataEvent", "GetImageURLEvent", "GetBarCodeEvent", "GetCheckedEvent", "FillParametersEvent", "GetZipCodeEvent", "GetSummaryExpressionEvent"}) {
            Object value = StiReportEdit.getPropertyValue(eventName, object_);
            if (value == null) continue;
            events.put(eventName, StiEncodingHelper.encode((String)((String)value)));
        }
        return events;
    }

    public static ArrayList<HashMap<String, String>> getSubReportParametersProperty(StiSubReport subReport) {
        ArrayList<HashMap<String, String>> parameters = new ArrayList<HashMap<String, String>>();
        for (StiParameter parameter : subReport.getParameters()) {
            HashMap<String, String> parameterObject = new HashMap<String, String>();
            parameterObject.put("name", parameter.getName());
            parameterObject.put("expression", parameter.getExpression() != null ? StiEncodingHelper.encode((String)parameter.getExpression().getValue()) : "");
            parameters.add(parameterObject);
        }
        return parameters;
    }

    public static String getShapeTypeProperty(StiShape component) {
        if (component.getShapeType() instanceof StiArrowShapeType) {
            StiArrowShapeType arrowShapeType = new StiArrowShapeType();
            switch (((StiArrowShapeType)component.getShapeType()).getDirection()) {
                case Up: {
                    return "StiArrowShapeTypeUp";
                }
                case Down: {
                    return "StiArrowShapeTypeDown";
                }
                case Right: {
                    return "StiArrowShapeTypeRight";
                }
                case Left: {
                    return "StiArrowShapeTypeLeft";
                }
            }
        }
        return component.getShapeType().getClass().getName().substring(component.getShapeType().getClass().getName().lastIndexOf(46) + 1);
    }

    public static HashMap<String, Object> getPreviewSettingsProperty(StiReport report) {
        HashMap<String, Object> settingsJsObject = new HashMap<String, Object>();
        long repSettings = report.getPreviewSettings();
        settingsJsObject.put("reportPrint", (repSettings & StiPreviewSettings.Print.getValue()) > 0L);
        settingsJsObject.put("reportOpen", (repSettings & StiPreviewSettings.Open.getValue()) > 0L);
        settingsJsObject.put("reportSave", (repSettings & StiPreviewSettings.Save.getValue()) > 0L);
        settingsJsObject.put("reportSendEMail", (repSettings & StiPreviewSettings.SendEMail.getValue()) > 0L);
        settingsJsObject.put("reportPageControl", (repSettings & StiPreviewSettings.PageControl.getValue()) > 0L);
        settingsJsObject.put("reportEditor", (repSettings & StiPreviewSettings.Editor.getValue()) > 0L);
        settingsJsObject.put("reportFind", (repSettings & StiPreviewSettings.Find.getValue()) > 0L);
        settingsJsObject.put("reportPageViewMode", (repSettings & StiPreviewSettings.PageViewMode.getValue()) > 0L);
        settingsJsObject.put("reportZoom", (repSettings & StiPreviewSettings.Zoom.getValue()) > 0L);
        settingsJsObject.put("reportBookmarks", (repSettings & StiPreviewSettings.Bookmarks.getValue()) > 0L);
        settingsJsObject.put("reportParameters", (repSettings & StiPreviewSettings.Parameters.getValue()) > 0L);
        settingsJsObject.put("reportResources", (repSettings & StiPreviewSettings.Resources.getValue()) > 0L);
        settingsJsObject.put("reportStatusBar", (repSettings & StiPreviewSettings.StatusBar.getValue()) > 0L);
        settingsJsObject.put("reportToolbar", (repSettings & StiPreviewSettings.Toolbar.getValue()) > 0L);
        settingsJsObject.put("htmlPreviewMode", report.getHtmlPreviewMode());
        settingsJsObject.put("reportToolbarHorAlignment", report.getPreviewToolBarOptions().getReportToolbarHorAlignment());
        settingsJsObject.put("reportToolbarReverse", report.getPreviewToolBarOptions().isReportToolbarReverse());
        return settingsJsObject;
    }

    public static void setPreviewSettingsProperty(StiReport report, HashMap previewSettings, HashMap callbackResult) {
        long pSettings = 0L;
        if (Func.Convert.toBoolean(previewSettings.get("reportPrint"))) {
            pSettings |= StiPreviewSettings.Print.getValue();
        }
        if (Func.Convert.toBoolean(previewSettings.get("reportOpen"))) {
            pSettings |= StiPreviewSettings.Open.getValue();
        }
        if (Func.Convert.toBoolean(previewSettings.get("reportSave"))) {
            pSettings |= StiPreviewSettings.Save.getValue();
        }
        if (Func.Convert.toBoolean(previewSettings.get("reportSendEMail"))) {
            pSettings |= StiPreviewSettings.SendEMail.getValue();
        }
        if (Func.Convert.toBoolean(previewSettings.get("reportPageControl"))) {
            pSettings |= StiPreviewSettings.PageControl.getValue();
        }
        if (Func.Convert.toBoolean(previewSettings.get("reportEditor"))) {
            pSettings |= StiPreviewSettings.Editor.getValue();
        }
        if (Func.Convert.toBoolean(previewSettings.get("reportFind"))) {
            pSettings |= StiPreviewSettings.Find.getValue();
        }
        if (Func.Convert.toBoolean(previewSettings.get("reportPageViewMode"))) {
            pSettings |= StiPreviewSettings.PageViewMode.getValue();
        }
        if (Func.Convert.toBoolean(previewSettings.get("reportZoom"))) {
            pSettings |= StiPreviewSettings.Zoom.getValue();
        }
        if (Func.Convert.toBoolean(previewSettings.get("reportBookmarks"))) {
            pSettings |= StiPreviewSettings.Bookmarks.getValue();
        }
        if (Func.Convert.toBoolean(previewSettings.get("reportParameters"))) {
            pSettings |= StiPreviewSettings.Parameters.getValue();
        }
        if (Func.Convert.toBoolean(previewSettings.get("reportResources"))) {
            pSettings |= StiPreviewSettings.Resources.getValue();
        }
        if (Func.Convert.toBoolean(previewSettings.get("reportStatusBar"))) {
            pSettings |= StiPreviewSettings.StatusBar.getValue();
        }
        if (Func.Convert.toBoolean(previewSettings.get("reportToolbar"))) {
            pSettings |= StiPreviewSettings.Toolbar.getValue();
        }
        report.setPreviewSettings(pSettings);
        report.setHtmlPreviewMode(StiHtmlPreviewMode.valueOf((String)((String)previewSettings.get("htmlPreviewMode"))));
        report.getPreviewToolBarOptions().setReportToolbarHorAlignment(StiHorAlignment.valueOf((String)previewSettings.get("reportToolbarHorAlignment").toString()));
        report.getPreviewToolBarOptions().setReportToolbarReverse(Func.Convert.toBoolean(previewSettings.get("reportToolbarReverse")));
        callbackResult.put("resultPreviewSettings", StiReportEdit.getPreviewSettingsProperty(report));
    }

    public static void setAllProperties(StiComponent component, ArrayList<HashMap<String, Object>> props) throws Exception {
        StiReport currReport = component.getReport();
        for (int index = 0; index < props.size(); ++index) {
            HashMap<String, Object> prop = props.get(index);
            String propertyName = (String)prop.get("name");
            Object propertyValue = prop.get("value");
            if (propertyValue instanceof String && ((String)propertyValue).indexOf("base64%2C") > 0) {
                propertyValue = URLDecoder.decode((String)propertyValue, "UTF-8");
            }
            if ("ratio".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, component instanceof StiZipCode ? "Ratio" : "AspectRatio", component, propertyValue);
                continue;
            }
            if ("rotation".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "ImageRotation", component, propertyValue);
                continue;
            }
            if ("imageMultipleFactor".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "MultipleFactor", component, propertyValue);
                continue;
            }
            if ("subReportPage".equals(propertyName)) {
                StiReportEdit.setSubReportPageProperty((Object)component, propertyValue);
                continue;
            }
            if ("subReportUrl".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "SubReportUrl", component, !"".equals(propertyValue) ? StiEncodingHelper.decodeString((String)((String)propertyValue)) : null);
                continue;
            }
            if ("contourColor".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "ContourColor", component, propertyValue);
                continue;
            }
            if ("size".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Size", component, propertyValue);
                continue;
            }
            if ("checkValues".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Values", component, propertyValue);
                continue;
            }
            if ("editable".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Editable", component, propertyValue);
                continue;
            }
            if ("checkStyleForFalse".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "CheckStyleForFalse", component, propertyValue);
                continue;
            }
            if ("checkStyleForTrue".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "CheckStyleForTrue", component, propertyValue);
                continue;
            }
            if ("checked".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Checked.Value", component, StiEncodingHelper.decodeString((String)((String)propertyValue)));
                continue;
            }
            if ("container".equals(propertyName)) {
                StiReportEdit.setContainerProperty(component, propertyValue);
                continue;
            }
            if ("columnWidth".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "ColumnWidth", component, propertyValue);
                continue;
            }
            if ("columnGaps".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "ColumnGaps", component, propertyValue);
                continue;
            }
            if ("columns".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Columns", component, propertyValue);
                continue;
            }
            if ("columnDirection".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "ColumnDirection", component, propertyValue);
                continue;
            }
            if ("minRowsInColumn".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "MinRowsInColumn", component, propertyValue);
                continue;
            }
            if ("shapeBorderColor".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "BorderColor", component, propertyValue);
                continue;
            }
            if ("shapeBorderStyle".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Style", component, propertyValue);
                continue;
            }
            if ("shapeType".equals(propertyName)) {
                StiReportEdit.setShapeTypeProperty(component, propertyValue);
                continue;
            }
            if ("backColor".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "BackColor", component, propertyValue);
                continue;
            }
            if ("foreColor".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "ForeColor", component, propertyValue);
                continue;
            }
            if ("autoScale".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "AutoScale", component, propertyValue);
                continue;
            }
            if ("rightToLeft".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "RightToLeft", component, propertyValue);
                continue;
            }
            if ("showLabelText".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "ShowLabelText", component, propertyValue);
                continue;
            }
            if ("showQuietZones".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "ShowQuietZones", component, propertyValue);
                continue;
            }
            if ("barCodeAngle".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Angle", component, propertyValue);
                continue;
            }
            if ("codeType".equals(propertyName)) {
                StiReportEdit.setBarCodeTypeProperty(component, propertyValue);
                continue;
            }
            if ("code".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Code.Value", component, StiEncodingHelper.decodeString((String)((String)propertyValue)));
                continue;
            }
            if ("stretch".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Stretch", component, propertyValue);
                continue;
            }
            if ("componentStyle".equals(propertyName)) {
                component.setComponentStyle(!"[None]".equals(propertyValue) ? (String)propertyValue : "");
                continue;
            }
            if ("unitWidth".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "PageWidth", component, propertyValue);
                continue;
            }
            if ("unitHeight".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "PageHeight", component, propertyValue);
                continue;
            }
            if ("orientation".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Orientation", component, propertyValue);
                continue;
            }
            if ("unitMargins".equals(propertyName)) {
                StiReportEdit.setMarginsProperty(component, propertyValue);
                continue;
            }
            if ("vertAlignment".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "VertAlignment", component, propertyValue);
                continue;
            }
            if ("horAlignment".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "HorAlignment", component, propertyValue);
                continue;
            }
            if ("textAngle".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Angle", component, propertyValue);
                continue;
            }
            if ("textMargins".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Margins", component, propertyValue);
                continue;
            }
            if ("maxNumberOfLines".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "MaxNumberOfLines", component, propertyValue);
                continue;
            }
            if ("cellWidth".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "CellWidth", component, propertyValue);
                continue;
            }
            if ("cellHeight".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "CellHeight", component, propertyValue);
                continue;
            }
            if ("horizontalSpacing".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "HorSpacing", component, propertyValue);
                continue;
            }
            if ("verticalSpacing".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "VertSpacing", component, propertyValue);
                continue;
            }
            if ("wordWrap".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "WordWrap", component, propertyValue);
                continue;
            }
            if ("font".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Font", component, propertyValue);
                continue;
            }
            if ("textBrush".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "TextBrush", component, propertyValue);
                continue;
            }
            if ("text".equals(propertyName)) {
                StiReportEdit.setTextProperty(component, propertyValue);
                continue;
            }
            if ("textFormat".equals(propertyName)) {
                StiReportEdit.setTextFormatProperty(component, (HashMap)propertyValue);
                continue;
            }
            if ("editableText".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Editable", component, propertyValue);
                continue;
            }
            if ("hideZeros".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "HideZeros", component, propertyValue);
                continue;
            }
            if ("continuousText".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "ContinuousText", component, propertyValue);
                continue;
            }
            if ("onlyText".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "OnlyText", component, propertyValue);
                continue;
            }
            if ("allowHtmlTags".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "AllowHtmlTags", component, propertyValue);
                continue;
            }
            if ("border".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Border", component, propertyValue);
                continue;
            }
            if ("brush".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Brush", component, propertyValue);
                continue;
            }
            if ("canGrow".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "CanGrow", component, propertyValue);
                continue;
            }
            if ("canShrink".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "CanShrink", component, propertyValue);
                continue;
            }
            if ("canBreak".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "CanBreak", component, propertyValue);
                continue;
            }
            if ("autoWidth".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "AutoWidth", component, propertyValue);
                continue;
            }
            if ("growToHeight".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "GrowToHeight", component, propertyValue);
                continue;
            }
            if ("enabled".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Enabled", component, propertyValue);
                continue;
            }
            if ("printable".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Printable", component, propertyValue);
                continue;
            }
            if ("printOn".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "PrintOn", component, propertyValue);
                continue;
            }
            if ("paperSize".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "PaperSize", component, propertyValue);
                continue;
            }
            if ("waterMarkRatio".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Watermark.AspectRatio", component, propertyValue);
                continue;
            }
            if ("waterMarkRightToLeft".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Watermark.RightToLeft", component, propertyValue);
                continue;
            }
            if ("waterMarkEnabled".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Watermark.Enabled", component, propertyValue);
                continue;
            }
            if ("waterMarkEnabledExpression".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Watermark.EnabledExpression", component, StiEncodingHelper.decodeString((String)((String)propertyValue)));
                continue;
            }
            if ("waterMarkAngle".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Watermark.Angle", component, propertyValue);
                continue;
            }
            if ("waterMarkText".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Watermark.Text", component, StiEncodingHelper.decodeString((String)((String)propertyValue)));
                continue;
            }
            if ("waterMarkFont".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Watermark.Font", component, propertyValue);
                continue;
            }
            if ("waterMarkTextBrush".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Watermark.TextBrush", component, propertyValue);
                continue;
            }
            if ("waterMarkTextBehind".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Watermark.ShowBehind", component, propertyValue);
                continue;
            }
            if ("waterMarkImageBehind".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Watermark.ShowImageBehind", component, propertyValue);
                continue;
            }
            if ("waterMarkImageAlign".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Watermark.ImageAlignment", component, propertyValue);
                continue;
            }
            if ("waterMarkMultipleFactor".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Watermark.ImageMultipleFactor", component, propertyValue);
                continue;
            }
            if ("waterMarkStretch".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Watermark.ImageStretch", component, propertyValue);
                continue;
            }
            if ("waterMarkTiling".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Watermark.ImageTiling", component, propertyValue);
                continue;
            }
            if ("waterMarkTransparency".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Watermark.ImageTransparency", component, propertyValue);
                continue;
            }
            if ("newPageBefore".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "NewPageBefore", component, propertyValue);
                continue;
            }
            if ("newPageAfter".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "NewPageAfter", component, propertyValue);
                continue;
            }
            if ("newColumnBefore".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "NewColumnBefore", component, propertyValue);
                continue;
            }
            if ("newColumnAfter".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "NewColumnAfter", component, propertyValue);
                continue;
            }
            if ("skipFirst".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "SkipFirst", component, propertyValue);
                continue;
            }
            if ("condition".equals(propertyName)) {
                StiReportEdit.setConditionProperty(component, propertyValue);
                continue;
            }
            if ("sortDirection".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "SortDirection", component, propertyValue);
                continue;
            }
            if ("summarySortDirection".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "SummarySortDirection", component, propertyValue);
                continue;
            }
            if ("summaryExpression".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "SummaryExpression.Value", component, StiEncodingHelper.decodeString((String)((String)propertyValue)));
                continue;
            }
            if ("summaryType".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "SummaryType", component, propertyValue);
                continue;
            }
            if ("sortData".equals(propertyName)) {
                StiReportEdit.setSortDataProperty((Object)component, propertyValue);
                continue;
            }
            if ("dataSource".equals(propertyName)) {
                StiReportEdit.setDataSourceProperty(component, propertyValue);
                continue;
            }
            if ("dataRelation".equals(propertyName)) {
                StiReportEdit.setDataRelationProperty(component, propertyValue);
                continue;
            }
            if ("masterComponent".equals(propertyName)) {
                StiReportEdit.setMasterComponentProperty(component, propertyValue);
                continue;
            }
            if ("businessObject".equals(propertyName)) {
                StiReportEdit.setBusinessObjectProperty(component, propertyValue);
                continue;
            }
            if ("countData".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "CountData", component, propertyValue);
                continue;
            }
            if ("filterEngine".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "FilterEngine", component, propertyValue);
                continue;
            }
            if ("filterData".equals(propertyName)) {
                StiReportEdit.setFilterDataProperty((Object)component, (String)propertyValue);
                continue;
            }
            if ("filterOn".equals(propertyName)) {
                StiReportEdit.setFilterOnProperty(component, propertyValue);
                continue;
            }
            if ("filterMode".equals(propertyName)) {
                StiReportEdit.setFilterModeProperty(component, propertyValue);
                continue;
            }
            if ("imageDataColumn".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "DataColumn", component, StiEncodingHelper.decodeString((String)((String)propertyValue)));
                continue;
            }
            if ("imageSrc".equals(propertyName)) {
                StiReportEdit.setImageProperty(component, (String)propertyValue);
                continue;
            }
            if ("imageUrl".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "ImageURL.Value", component, StiEncodingHelper.decodeString((String)((String)propertyValue)));
                continue;
            }
            if ("imageFile".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "File", component, StiEncodingHelper.decodeString((String)((String)propertyValue)));
                continue;
            }
            if ("imageData".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "ImageData.Value", component, StiEncodingHelper.decodeString((String)((String)propertyValue)));
                continue;
            }
            if ("watermarkImageSrc".equals(propertyName)) {
                StiReportEdit.setWatermarkImageProperty((StiPage)component, (String)propertyValue);
                continue;
            }
            if ("watermarkImageHyperlink".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Watermark.ImageHyperlink", component, propertyValue);
                continue;
            }
            if ("stopBeforePrint".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "StopBeforePrint", component, propertyValue);
                continue;
            }
            if ("titleBeforeHeader".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "TitleBeforeHeader", component, propertyValue);
                continue;
            }
            if ("crossTabEmptyValue".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "EmptyValue", component, StiEncodingHelper.decodeString((String)((String)propertyValue)));
                continue;
            }
            if ("crossTabHorAlign".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "HorAlignment", component, propertyValue);
                continue;
            }
            if ("printIfEmpty".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "PrintIfEmpty", component, propertyValue);
                continue;
            }
            if ("printOnAllPages".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "PrintOnAllPages", component, propertyValue);
                continue;
            }
            if ("crossTabWrap".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Wrap", component, propertyValue);
                continue;
            }
            if ("crossTabWrapGap".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "WrapGap", component, propertyValue);
                continue;
            }
            if ("crossTabPrintTitle".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "PrintTitleOnAllPages", component, propertyValue);
                continue;
            }
            if ("keyDataColumn".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "KeyDataColumn", component, propertyValue);
                continue;
            }
            if ("masterKeyDataColumn".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "MasterKeyDataColumn", component, propertyValue);
                continue;
            }
            if ("parentValue".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "ParentValue", component, StiEncodingHelper.decodeString((String)((String)propertyValue)));
                continue;
            }
            if ("indent".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Indent", component, propertyValue);
                continue;
            }
            if ("headers".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Headers", component, StiEncodingHelper.decodeString((String)((String)propertyValue)));
                continue;
            }
            if ("footers".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Footers", component, StiEncodingHelper.decodeString((String)((String)propertyValue)));
                continue;
            }
            if ("aliasName".equals(propertyName)) {
                component.setAlias(StiEncodingHelper.decodeString((String)((String)propertyValue)));
                continue;
            }
            if ("oddStyle".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "OddStyle", component, !"[None]".equals(propertyValue) ? (String)propertyValue : "");
                continue;
            }
            if ("evenStyle".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "EvenStyle", component, !"[None]".equals(propertyValue) ? (String)propertyValue : "");
                continue;
            }
            if ("largeHeight".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "LargeHeight", component, propertyValue);
                continue;
            }
            if ("largeHeightFactor".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "LargeHeightFactor", component, propertyValue);
                continue;
            }
            if ("calcInvisible".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "CalcInvisible", component, propertyValue);
                continue;
            }
            if ("richText".equals(propertyName)) {
                StiReportEdit.setRichTextProperty(component, propertyValue);
                continue;
            }
            if ("richTextUrl".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "DataUrl.Value", component, StiEncodingHelper.decodeString((String)((String)propertyValue)));
                continue;
            }
            if ("richTextDataColumn".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "DataColumn", component, StiEncodingHelper.decodeString((String)((String)propertyValue)));
                continue;
            }
            if ("restrictions".equals(propertyName)) {
                StiReportEdit.setRestrictionsProperty(component, propertyValue);
                continue;
            }
            if ("conditions".equals(propertyName)) {
                StiReportEdit.setConditionsProperty(component, propertyValue, currReport);
                continue;
            }
            if ("trimming".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "TextOptions.Trimming", component, propertyValue);
                continue;
            }
            if ("textOptionsRightToLeft".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "TextOptions.RightToLeft", component, propertyValue);
                continue;
            }
            if ("processAt".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "ProcessAt", component, propertyValue);
                continue;
            }
            if ("processingDuplicates".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "ProcessingDuplicates", component, propertyValue);
                continue;
            }
            if ("shrinkFontToFit".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "ShrinkFontToFit", component, propertyValue);
                continue;
            }
            if ("shrinkFontToFitMinimumSize".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "ShrinkFontToFitMinimumSize", component, propertyValue);
                continue;
            }
            if ("textType".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Type", component, propertyValue);
                continue;
            }
            if ("resetPageNumber".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "ResetPageNumber", component, propertyValue);
                continue;
            }
            if ("printOnPreviousPage".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "PrintOnPreviousPage", component, propertyValue);
                continue;
            }
            if ("printHeadersFootersFromPreviousPage".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "PrintHeadersFootersFromPreviousPage", component, propertyValue);
                continue;
            }
            if ("printAtBottom".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "PrintAtBottom", component, propertyValue);
                continue;
            }
            if ("printIfDetailEmpty".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "PrintIfDetailEmpty", component, propertyValue);
                continue;
            }
            if ("keepGroupTogether".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "KeepGroupTogether", component, propertyValue);
                continue;
            }
            if ("keepGroupHeaderTogether".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "KeepGroupHeaderTogether", component, propertyValue);
                continue;
            }
            if ("keepGroupFooterTogether".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "KeepGroupFooterTogether", component, propertyValue);
                continue;
            }
            if ("keepHeaderTogether".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "KeepHeaderTogether", component, propertyValue);
                continue;
            }
            if ("keepFooterTogether".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "KeepFooterTogether", component, propertyValue);
                continue;
            }
            if ("keepDetailsTogether".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "KeepDetailsTogether", component, propertyValue);
                continue;
            }
            if ("interaction".equals(propertyName)) {
                StiReportEdit.setInteractionProperty(component, propertyValue);
                continue;
            }
            if ("chartStyle".equals(propertyName)) {
                StiReportEdit.setChartStyleProperty(component, propertyValue);
                continue;
            }
            if ("gaugeStyle".equals(propertyName)) {
                StiReportEdit.setGaugeStyleProperty(component, propertyValue);
                continue;
            }
            if ("mapStyle".equals(propertyName)) {
                StiReportEdit.setMapStyleProperty(component, propertyValue);
                continue;
            }
            if ("crossTabStyle".equals(propertyName)) {
                StiReportEdit.setCrossTabStyleProperty(component, propertyValue);
                continue;
            }
            if ("shiftMode".equals(propertyName)) {
                StiReportEdit.setShiftModeProperty(component, propertyValue);
                continue;
            }
            if ("cellDockStyle".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "CellDockStyle", component, propertyValue);
                continue;
            }
            if ("fixedWidth".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "FixedWidth", component, propertyValue);
                continue;
            }
            if ("tableAutoWidth".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "AutoWidth", component, propertyValue);
                continue;
            }
            if ("autoWidthType".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "AutoWidthType", component, propertyValue);
                continue;
            }
            if ("headerRowsCount".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "HeaderRowsCount", component, propertyValue);
                continue;
            }
            if ("footerRowsCount".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "FooterRowsCount", component, propertyValue);
                continue;
            }
            if ("tableRightToLeft".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "RightToLeft", component, propertyValue);
                continue;
            }
            if ("dockableTable".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "DockableTable", component, propertyValue);
                continue;
            }
            if ("headerPrintOn".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "HeaderPrintOn", component, propertyValue);
                continue;
            }
            if ("headerCanGrow".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "HeaderCanGrow", component, propertyValue);
                continue;
            }
            if ("headerCanShrink".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "HeaderCanShrink", component, propertyValue);
                continue;
            }
            if ("headerCanBreak".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "HeaderCanBreak", component, propertyValue);
                continue;
            }
            if ("headerPrintAtBottom".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "HeaderPrintAtBottom", component, propertyValue);
                continue;
            }
            if ("headerPrintIfEmpty".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "HeaderPrintIfEmpty", component, propertyValue);
                continue;
            }
            if ("headerPrintOnAllPages".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "HeaderPrintOnAllPages", component, propertyValue);
                continue;
            }
            if ("headerPrintOnEvenOddPages".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "HeaderPrintOnEvenOddPages", component, propertyValue);
                continue;
            }
            if ("footerPrintOn".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "FooterPrintOn", component, propertyValue);
                continue;
            }
            if ("footerCanGrow".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "FooterCanGrow", component, propertyValue);
                continue;
            }
            if ("footerCanShrink".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "FooterCanShrink", component, propertyValue);
                continue;
            }
            if ("footerCanBreak".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "FooterCanBreak", component, propertyValue);
                continue;
            }
            if ("footerPrintAtBottom".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "FooterPrintAtBottom", component, propertyValue);
                continue;
            }
            if ("footerPrintIfEmpty".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "FooterPrintIfEmpty", component, propertyValue);
                continue;
            }
            if ("footerPrintOnAllPages".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "FooterPrintOnAllPages", component, propertyValue);
                continue;
            }
            if ("footerPrintOnEvenOddPages".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "FooterPrintOnEvenOddPages", component, propertyValue);
                continue;
            }
            if ("locked".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Locked", component, propertyValue);
                continue;
            }
            if ("linked".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Linked", component, propertyValue);
                continue;
            }
            if ("dockStyle".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "DockStyle", component, propertyValue);
                continue;
            }
            if ("mirrorMargins".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "MirrorMargins", component, propertyValue);
                continue;
            }
            if ("subReportParameters".equals(propertyName)) {
                StiReportEdit.setSubReportParametersProperty(component, (ArrayList)propertyValue);
                continue;
            }
            if ("segmentPerWidth".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "SegmentPerWidth", component, propertyValue);
                continue;
            }
            if ("segmentPerHeight".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "SegmentPerHeight", component, propertyValue);
                continue;
            }
            if ("anchor".equals(propertyName)) {
                StiReportEdit.setAnchorProperty(component, propertyValue);
                continue;
            }
            if ("minSize".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "MinSize", component, propertyValue);
                continue;
            }
            if ("maxSize".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "MaxSize", component, propertyValue);
                continue;
            }
            if ("minHeight".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "MinHeight", component, propertyValue);
                continue;
            }
            if ("maxHeight".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "MaxHeight", component, propertyValue);
                continue;
            }
            if ("minWidth".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "MinWidth", component, propertyValue);
                continue;
            }
            if ("maxWidth".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "MaxWidth", component, propertyValue);
                continue;
            }
            if ("color".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Color", component, propertyValue);
                continue;
            }
            if ("style".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Style", component, propertyValue);
                continue;
            }
            if ("round".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Round", component, propertyValue);
                continue;
            }
            if ("leftSide".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "LeftSide", component, propertyValue);
                continue;
            }
            if ("rightSide".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "RightSide", component, propertyValue);
                continue;
            }
            if ("topSide".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "TopSide", component, propertyValue);
                continue;
            }
            if ("bottomSide".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "BottomSide", component, propertyValue);
                continue;
            }
            if ("startCapColor".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "StartCap.Color", component, propertyValue);
                continue;
            }
            if ("startCapFill".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "StartCap.Fill", component, propertyValue);
                continue;
            }
            if ("startCapWidth".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "StartCap.Width", component, propertyValue);
                continue;
            }
            if ("startCapHeight".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "StartCap.Height", component, propertyValue);
                continue;
            }
            if ("startCapStyle".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "StartCap.Style", component, propertyValue);
                continue;
            }
            if ("useParentStyles".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "UseParentStyles", component, propertyValue);
                continue;
            }
            if ("unlimitedHeight".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "UnlimitedHeight", component, propertyValue);
                continue;
            }
            if ("unlimitedBreakable".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "UnlimitedBreakable", component, propertyValue);
                continue;
            }
            if ("numberOfCopies".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "NumberOfCopies", component, propertyValue);
                continue;
            }
            if ("breakIfLessThan".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "BreakIfLessThan", component, propertyValue);
                continue;
            }
            if ("renderTo".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "RenderTo", component, propertyValue);
                continue;
            }
            if ("globalizedName".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "GlobalizedName", component, propertyValue);
                continue;
            }
            if ("excelValue".equals(propertyName)) {
                StiReportEdit.setExcelValueProperty(component, propertyValue);
                continue;
            }
            if ("exportAsImage".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "ExportAsImage", component, propertyValue);
                continue;
            }
            if ("lineSpacing".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "LineSpacing", component, propertyValue);
                continue;
            }
            if ("elementStyle".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Style", component, propertyValue);
                continue;
            }
            if ("detectUrls".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "DetectUrls", component, propertyValue);
                continue;
            }
            if ("margin".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Margin", component, propertyValue);
                continue;
            }
            if ("padding".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Padding", component, propertyValue);
                continue;
            }
            if ("titleText".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Title.Text", component, StiEncodingHelper.decodeString((String)String.valueOf(propertyValue)));
                continue;
            }
            if ("titleBrush".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Title.Brush", component, propertyValue);
                continue;
            }
            if ("titleTextBrush".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Title.TextBrush", component, propertyValue);
                continue;
            }
            if ("titleFont".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Title.Font", component, propertyValue);
                continue;
            }
            if ("titleHorAlignment".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Title.HorAlignment", component, propertyValue);
                continue;
            }
            if ("titleVisible".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Title.Visible", component, propertyValue);
                continue;
            }
            if ("tableOfContentsIndent".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Indent", component, propertyValue);
                continue;
            }
            if ("tableOfContentsMargins".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Margins", component, propertyValue);
                continue;
            }
            if ("tableOfContentsNewPageBefore".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "NewPageBefore", component, propertyValue);
                continue;
            }
            if ("tableOfContentsNewPageAfter".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "NewPageAfter", component, propertyValue);
                continue;
            }
            if ("tableOfContentsRightToLeft".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "RightToLeft", component, propertyValue);
                continue;
            }
            if ("tableOfContentsStyles".equals(propertyName)) {
                StiReportEdit.setPropertyValue(currReport, "Styles", component, propertyValue);
                continue;
            }
            if (!"pageIcon".equals(propertyName)) continue;
            if (StiValidationUtil.isNotNullOrEmpty((String)((String)propertyValue))) {
                String value = (String)propertyValue;
                StiReportEdit.setPropertyValue(currReport, "Icon", component, value.substring(value.indexOf(",") + 1));
                continue;
            }
            StiReportEdit.setPropertyValue(currReport, "Icon", component, null);
        }
    }

    public static void setSubReportPageProperty(Object component, Object propertyValue) {
        StiSubReport comp = (StiSubReport)component;
        StiReport report = comp.getReport();
        if (!"[Not Assigned]".equals(propertyValue)) {
            comp.setSubReportPage(report.getPages().get((String)propertyValue));
        } else {
            comp.setSubReportPage(null);
        }
    }

    public static StiColor strToColor(String colorStr) {
        StiColor newColor = StiColorEnum.Transparent.color();
        if (!"transparent".equals(colorStr)) {
            String[] colors = colorStr.split(",");
            if (colors.length == 3) {
                int r1 = StiReportEdit.strToInt(colors[0]);
                int g1 = StiReportEdit.strToInt(colors[1]);
                int b1 = StiReportEdit.strToInt(colors[2]);
                newColor = StiColor.fromArgb((int)255, (int)(r1 > 255 ? 255 : r1), (int)(g1 > 255 ? 255 : g1), (int)(b1 > 255 ? 255 : b1));
            } else {
                int a = StiReportEdit.strToInt(colors[0]);
                int r2 = StiReportEdit.strToInt(colors[1]);
                int g2 = StiReportEdit.strToInt(colors[2]);
                int b2 = StiReportEdit.strToInt(colors[3]);
                newColor = StiColor.fromArgb((int)(a > 255 ? 255 : a), (int)(r2 > 255 ? 255 : r2), (int)(g2 > 255 ? 255 : g2), (int)(b2 > 255 ? 255 : b2));
            }
        }
        return newColor;
    }

    public static double strToDouble(String value) {
        double result;
        block2: {
            value = value.replace(',', '.');
            result = 0.0;
            try {
                result = Double.parseDouble(value);
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) break block2;
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String doubleToStr(double value) {
        String str = StiReportEdit.fmt(value);
        return str.replace(",", ".");
    }

    public static int strToInt(Object value) {
        int result;
        block2: {
            result = 0;
            try {
                result = Integer.parseInt(String.valueOf(value));
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) break block2;
                e.printStackTrace();
            }
        }
        return result;
    }

    public static StiHatchStyle strToHatchStyle(String value) {
        return StiHatchStyle.forValue((int)Integer.parseInt(value));
    }

    public static StiBrush strToBrush(String value) {
        String[] brushArray = value.split("!");
        if ("0".equals(brushArray[0])) {
            StiEmptyBrush emptyBrush = new StiEmptyBrush();
            return emptyBrush;
        }
        if ("1".equals(brushArray[0])) {
            StiSolidBrush solidBrush = new StiSolidBrush(StiReportEdit.strToColor(brushArray[1]));
            return solidBrush;
        }
        if ("2".equals(brushArray[0])) {
            StiHatchBrush hatchBrush = new StiHatchBrush(StiReportEdit.strToHatchStyle(brushArray[3]), StiReportEdit.strToColor(brushArray[1]), StiReportEdit.strToColor(brushArray[2]));
            return hatchBrush;
        }
        if ("3".equals(brushArray[0])) {
            StiGradientBrush gradientBrush = new StiGradientBrush(StiReportEdit.strToColor(brushArray[1]), StiReportEdit.strToColor(brushArray[2]), StiReportEdit.strToDouble(brushArray[3]));
            return gradientBrush;
        }
        if ("4".equals(brushArray[0])) {
            StiGlareBrush glareBrush = new StiGlareBrush(StiReportEdit.strToColor(brushArray[1]), StiReportEdit.strToColor(brushArray[2]), StiReportEdit.strToDouble(brushArray[3]), (float)StiReportEdit.strToDouble(brushArray[4]), (float)StiReportEdit.strToDouble(brushArray[5]));
            return glareBrush;
        }
        if ("5".equals(brushArray[0])) {
            StiGlassBrush glassBrush = new StiGlassBrush(StiReportEdit.strToColor(brushArray[1]), "1".equals(brushArray[3]), (float)StiReportEdit.strToDouble(brushArray[2]));
            return glassBrush;
        }
        return new StiEmptyBrush();
    }

    public static StiBorder strToBorder(String value) {
        String[] borderArray = value.split("!");
        String[] borderSides = borderArray[0].split(",");
        StiBorderSides borderLeft = "1".equals(borderSides[0]) ? StiBorderSides.Left : StiBorderSides.None;
        StiBorderSides borderTop = "1".equals(borderSides[1]) ? StiBorderSides.Top : StiBorderSides.None;
        StiBorderSides borderRight = "1".equals(borderSides[2]) ? StiBorderSides.Right : StiBorderSides.None;
        StiBorderSides borderBottom = "1".equals(borderSides[3]) ? StiBorderSides.Bottom : StiBorderSides.None;
        double size = StiReportEdit.strToDouble(borderArray[1]);
        StiColor color = StiReportEdit.strToColor(borderArray[2]);
        StiPenStyle style = StiReportEdit.strToPenStyle(borderArray[3]);
        boolean dropShadow = "1".equals(borderArray[4]);
        double shadowSize = StiReportEdit.strToDouble(borderArray[5]);
        boolean topmost = "1".equals(borderArray[7]);
        StiBorder result = new StiBorder(StiEnumSet.of((Enum)borderLeft, (Enum)borderTop, (Enum)borderRight, (Enum)borderBottom), color, size, style, dropShadow, shadowSize, StiReportEdit.strToBrush(StiEncodingHelper.decodeString((String)borderArray[6])), topmost);
        return result;
    }

    public static StiPenStyle strToPenStyle(String value) {
        return StiPenStyle.forValue((int)StiReportEdit.strToInt(value));
    }

    public static StiFont strToFont(String value, StiReport report) {
        String[] fontArray = value.split("!");
        int style = StiFontStyle.Regular.intValue;
        style += "1".equals(fontArray[2]) ? StiFontStyle.Bold.intValue : 0;
        style += "1".equals(fontArray[3]) ? StiFontStyle.Italic.intValue : 0;
        style += "1".equals(fontArray[4]) ? StiFontStyle.Underline.intValue : 0;
        return new StiFont(fontArray[0], StiReportEdit.strToDouble(fontArray[1]), style += "1".equals(fontArray[5]) ? StiFontStyle.Strikeout.intValue : 0, StiGraphicsUnit.Point);
    }

    public static StiCheckStyle strToCheckStyle(String value) {
        return StiCheckStyle.valueOf((String)value);
    }

    public static StiEnumSet<StiConditionBorderSides> strBordersToConditionBorderSidesObject(String borders) {
        StiEnumSet result = new StiEnumSet((Enum)StiConditionBorderSides.None);
        if (borders.indexOf("All") >= 0 || borders.indexOf("Top") >= 0) {
            result.add((IStiEnum)StiConditionBorderSides.Top);
        }
        if (borders.indexOf("All") >= 0 || borders.indexOf("Left") >= 0) {
            result.add((IStiEnum)StiConditionBorderSides.Left);
        }
        if (borders.indexOf("All") >= 0 || borders.indexOf("Right") >= 0) {
            result.add((IStiEnum)StiConditionBorderSides.Right);
        }
        if (borders.indexOf("All") >= 0 || borders.indexOf("Bottom") >= 0) {
            result.add((IStiEnum)StiConditionBorderSides.Bottom);
        }
        if (result.size() > 1) {
            result.remove((IStiEnum)StiConditionBorderSides.None);
        }
        return result;
    }

    public static StiEnumSet<StiConditionPermissions> strPermissionsToConditionPermissionsObject(String strPermissions) {
        StiEnumSet permissions = new StiEnumSet((Enum)StiConditionPermissions.None);
        if (strPermissions.indexOf("All") >= 0 || "Font".equals(strPermissions) || strPermissions.indexOf("Font,") == 0 || strPermissions.indexOf(", Font,") >= 0 || strPermissions.endsWith("Font")) {
            permissions.add((IStiEnum)StiConditionPermissions.Font);
        }
        if (strPermissions.indexOf("All") >= 0 || strPermissions.indexOf("FontSize") >= 0) {
            permissions.add((IStiEnum)StiConditionPermissions.FontSize);
        }
        if (strPermissions.indexOf("All") >= 0 || strPermissions.indexOf("FontStyleBold") >= 0) {
            permissions.add((IStiEnum)StiConditionPermissions.FontStyleBold);
        }
        if (strPermissions.indexOf("All") >= 0 || strPermissions.indexOf("FontStyleItalic") >= 0) {
            permissions.add((IStiEnum)StiConditionPermissions.FontStyleItalic);
        }
        if (strPermissions.indexOf("All") >= 0 || strPermissions.indexOf("FontStyleUnderline") >= 0) {
            permissions.add((IStiEnum)StiConditionPermissions.FontStyleUnderline);
        }
        if (strPermissions.indexOf("All") >= 0 || strPermissions.indexOf("FontStyleStrikeout") >= 0) {
            permissions.add((IStiEnum)StiConditionPermissions.FontStyleStrikeout);
        }
        if (strPermissions.indexOf("All") >= 0 || strPermissions.indexOf("TextColor") >= 0) {
            permissions.add((IStiEnum)StiConditionPermissions.TextColor);
        }
        if (strPermissions.indexOf("All") >= 0 || strPermissions.indexOf("BackColor") >= 0) {
            permissions.add((IStiEnum)StiConditionPermissions.BackColor);
        }
        if (strPermissions.indexOf("All") >= 0 || strPermissions.indexOf("Borders") >= 0) {
            permissions.add((IStiEnum)StiConditionPermissions.Borders);
        }
        if (permissions.size() > 1) {
            permissions.remove((IStiEnum)StiConditionPermissions.None);
        }
        return permissions;
    }

    public static String getReportFileName(StiReport report) {
        String fileName = "";
        if (report.getReportFile() != null && report.getReportFile().length() > 0) {
            String[] path = report.getReportFile().replaceAll("\\\\", "/").split("/");
            fileName = path[path.length - 1];
        }
        fileName = fileName.replaceAll("<", " ").replaceAll(">", " ").replaceAll("\\\\", "-").replaceAll("/", "-").replaceAll(":", "-");
        fileName = fileName.replaceAll("\\?", ".").replaceAll("\"", "'").replaceAll("\\|", " ").replaceAll("\\*", " ");
        return fileName;
    }

    public static StiComponent createInfographicComponent(String componentTypeArray) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String[] compAttributes = componentTypeArray.split(";");
        String componentType = compAttributes[1];
        if ("StiChart".equals(componentType)) {
            StiChart chart = new StiChart();
            String seriesType = compAttributes[2];
            IStiSeries series = null;
            for (String ser : SERIES) {
                block6: {
                    try {
                        series = (IStiSeries)Class.forName(ser + "." + seriesType).newInstance();
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel < 10) break block6;
                        e.printStackTrace();
                    }
                }
                if (series != null) break;
            }
            chart.getSeries().add(series);
            return chart;
        }
        if ("StiGauge".equals(componentType)) {
            StiGauge gauge = new StiGauge();
            return gauge;
        }
        if ("StiMap".equals(componentType)) {
            StiMap map = new StiMap();
            String mapType = compAttributes[2];
            map.setMapID(StiMapID.valueOf((String)mapType));
            return map;
        }
        return null;
    }

    private static StiComponent createShapeComponent(String componentTypeArray) {
        StiShape comp = new StiShape();
        String[] compAttributes = componentTypeArray.split(";");
        String shapeType = compAttributes[1];
        StiReportEdit.setShapeTypeProperty(comp, shapeType);
        return comp;
    }

    private static StiComponent createBarCodeComponent(String componentTypeArray) {
        StiBarCode comp = new StiBarCode();
        comp.setBackColor(StiColorEnum.Transparent.color());
        String[] compAttributes = componentTypeArray.split(";");
        StiReportEdit.setBarCodeTypeProperty(comp, compAttributes[1]);
        comp.getCode().setValue(comp.getBarCodeType().getDefaultCodeValue());
        return comp;
    }

    private static void applyStyleCollection(StiComponent comp, StiStylesCollection stylesCollection) {
        if (comp instanceof StiPage) {
            return;
        }
        for (StiBaseStyle style : stylesCollection) {
            if (comp instanceof StiDataBand) {
                boolean isOddStyleDataBand = false;
                boolean isEvenStyleDataBand = false;
                for (StiStyleCondition condition : style.getConditions()) {
                    if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.DataOddStyle.getValue()) > 0) {
                        isOddStyleDataBand = true;
                        break;
                    }
                    if ((condition.getPlacement().getValue() & StiStyleComponentPlacement.DataEvenStyle.getValue()) <= 0) continue;
                    isEvenStyleDataBand = true;
                    break;
                }
                if (isOddStyleDataBand) {
                    ((StiDataBand)comp).setOddStyle(style.getName());
                    continue;
                }
                if (isEvenStyleDataBand) {
                    ((StiDataBand)comp).setEvenStyle(style.getName());
                    continue;
                }
                comp.setComponentStyle(style.getName());
                continue;
            }
            comp.setComponentStyle(style.getName());
        }
        StiReportEdit.applyStyles(comp, stylesCollection);
    }

    public static HashMap<String, Object> getComponentMainProperties(StiComponent component, double zoom) throws Exception {
        HashMap<String, Object> mainProps = new HashMap<String, Object>();
        mainProps.put("name", component.getName());
        mainProps.put("typeComponent", component.getClass().getName().substring(component.getClass().getName().lastIndexOf(46) + 1));
        mainProps.put("componentRect", StiReportEdit.getComponentRect(component));
        mainProps.put("parentName", StiReportEdit.getParentName(component));
        mainProps.put("parentIndex", String.valueOf(StiReportEdit.getParentIndex(component)));
        mainProps.put("componentIndex", String.valueOf(StiReportEdit.getComponentIndex(component)));
        mainProps.put("childs", StiReportEdit.getAllChildComponents(component));
        mainProps.put("svgContent", StiReportEdit.getSvgContent(component, zoom));
        mainProps.put("pageName", component.getPage().getName());
        mainProps.put("properties", StiReportEdit.getAllProperties(component));
        return mainProps;
    }

    public static ArrayList<HashMap<String, Object>> getTableCells(StiTable table, double zoom) throws Exception {
        ArrayList<HashMap<String, Object>> components = new ArrayList<HashMap<String, Object>>();
        for (StiComponent component : table.getComponents()) {
            components.add(StiReportEdit.getComponentMainProperties(component, zoom));
        }
        return components;
    }

    public static StiDataColumn getColumnFromColumnPath(String columnPath, StiReport report) {
        String[] pathArray = StiStringUtil.split((String)columnPath, (String)".");
        if (pathArray.length > 1) {
            StiDataColumn column;
            StiDataSource dataSource = report.getDictionary().getDataSources().get(pathArray[pathArray.length - 2]);
            if (dataSource == null && report.getDictionary().getRelations().get(pathArray[pathArray.length - 2]) != null) {
                dataSource = report.getDictionary().getRelations().get(pathArray[pathArray.length - 2]).getParentSource();
            }
            if (dataSource != null && (column = dataSource.getColumns().get(pathArray[pathArray.length - 1])) != null && (column.getType() == StiSystemTypeEnum.SystemDrawingImage || column.getType() == StiSystemTypeEnum.SystemByteArray || column.getType() == StiSystemTypeEnum.SystemString)) {
                return column;
            }
        }
        return null;
    }

    public static String getBase64PngFromMetaFileBytes(byte[] imageBytes, int width, int height) {
        if (imageBytes == null) {
            return null;
        }
        try {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getBase64PngFromMetaFileBytes(byte[] imageBytes) {
        return StiReportEdit.getBase64PngFromMetaFileBytes(imageBytes, 500, 500);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getImageContentForPaint(StiImage imageComp) {
        if (imageComp.getImageBytes() != null) return null;
        try {
            if (imageComp.getImageURL() != null && !StiValidationUtil.isNullOrEmpty((String)imageComp.getImageURL().getValue())) {
                StiResource resource;
                if (StiHyperlinkProcessor.isResourceHyperlink((String)imageComp.getImageURL().getValue()) && (resource = imageComp.getReport().getDictionary().getResources().get(StiHyperlinkProcessor.getResourceNameFromHyperlink((String)imageComp.getImageURL().getValue()))) != null) {
                    if (!StiImageHelper.isMetafile((byte[])resource.getContent())) return StiReportEdit.imageToBase64(resource.getContent());
                    return StiReportEdit.getBase64PngFromMetaFileBytes(resource.getContent());
                }
                if (StiHyperlinkProcessor.isVariableHyperlink((String)imageComp.getImageURL().getValue())) {
                    StiVariable variable = imageComp.getReport().getDictionary().getVariables().get(StiHyperlinkProcessor.getVariableNameFromHyperlink((String)imageComp.getImageURL().getValue()));
                    if (variable == null) return null;
                    return StiReportEdit.imageToBase64((StiImage)variable.getValueObject());
                }
                if (!imageComp.getImageURL().getValue().startsWith("{")) return imageComp.getImageURL().getValue();
                return null;
            }
            if (!StiValidationUtil.isNullOrEmpty((String)imageComp.getDataColumn())) {
                StiDataColumn column = StiReportEdit.getColumnFromColumnPath(imageComp.getDataColumn(), imageComp.getReport());
                if (column == null) return null;
                ArrayList<StiDataSource> sources = new ArrayList<StiDataSource>();
                sources.add(column.getDataSource());
                imageComp.getReport().getDictionary().connect(true, sources);
                StiImage image = StiGalleriesHelper.getImageFromColumn((StiDataColumn)column, (StiReport)imageComp.getReport());
                if (image == null) return null;
                return StiReportEdit.imageToBase64(image);
            }
            if (imageComp.getImageData() == null) return null;
            if (StiValidationUtil.isNullOrEmpty((String)imageComp.getImageData().getValue())) return null;
            String variableName = imageComp.getImageData().getValue().substring(1, imageComp.getImageData().getValue().length() - 1);
            StiVariable variable = imageComp.getReport().getDictionary().getVariables().get(variableName);
            if (variable == null) return null;
            StiImage image = (StiImage)variable.getValueObject();
            if (image == null) return null;
            String string = StiReportEdit.imageToBase64(image);
            return string;
        }
        catch (Exception e) {
            if (StiOptions.Engine.logLevel < 10) return null;
            e.printStackTrace();
            return null;
        }
    }

    public static String getWatermarkImageContentForPaint(StiPage page, HashMap<String, Object> pageProps) {
        if (page.getWatermark() != null) {
            try {
                if (!StiValidationUtil.isNullOrEmpty((String)page.getWatermark().getImageHyperlink())) {
                    StiVariable variable;
                    StiResource resource;
                    if (StiHyperlinkProcessor.isResourceHyperlink((String)page.getWatermark().getImageHyperlink()) && (resource = page.getReport().getDictionary().getResources().get(StiHyperlinkProcessor.getResourceNameFromHyperlink((String)page.getWatermark().getImageHyperlink()))) != null) {
                        BufferedImage gdiImage = StiImageHelper.decodeImage((byte[])resource.content, null);
                        pageProps.put("watermarkImageSize", String.format("%s;%s", gdiImage.getWidth(), gdiImage.getHeight()));
                        return StiReportEdit.imageToBase64(resource.content);
                    }
                    if (StiHyperlinkProcessor.isVariableHyperlink((String)page.getWatermark().getImageHyperlink()) && (variable = page.getReport().getDictionary().getVariables().get(StiHyperlinkProcessor.getVariableNameFromHyperlink((String)page.getWatermark().getImageHyperlink()))) != null) {
                        StiImage image = (StiImage)variable.getValueObject();
                        pageProps.put("watermarkImageSize", String.format("%s;%s", image.getWidth(), image.getHeight()));
                        return StiReportEdit.imageToBase64(image);
                    }
                }
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel >= 10) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        return null;
    }

    public static void applyStyles(StiComponent comp, StiStylesCollection stylesCollection) {
        StiBaseStyle style;
        if (!StiValidationUtil.isNullOrEmpty((String)comp.getComponentStyle()) && (style = stylesCollection.get(comp.getComponentStyle())) != null) {
            style.SetStyleToComponent(comp);
        }
    }

    private static Method findSet(Object obj, String prop, Class<?> cl) {
        while (!cl.equals(Object.class)) {
            try {
                Method method = obj.getClass().getMethod("set" + prop, cl);
                return method;
            }
            catch (Exception e) {
                block14: {
                    if (StiOptions.Engine.logLevel >= 10) {
                        e.printStackTrace();
                    }
                    try {
                        if (cl.equals(Float.class)) {
                            Method method = obj.getClass().getMethod("set" + prop, Float.TYPE);
                            return method;
                        }
                        if (cl.equals(Byte.class)) {
                            Method method = obj.getClass().getMethod("set" + prop, Byte.TYPE);
                            return method;
                        }
                        if (cl.equals(Short.class)) {
                            Method method = obj.getClass().getMethod("set" + prop, Short.TYPE);
                            return method;
                        }
                        if (cl.equals(Integer.class)) {
                            Method method = obj.getClass().getMethod("set" + prop, Integer.TYPE);
                            return method;
                        }
                        if (cl.equals(Long.class)) {
                            Method method = obj.getClass().getMethod("set" + prop, Long.TYPE);
                            return method;
                        }
                        if (cl.equals(Double.class)) {
                            Method method = obj.getClass().getMethod("set" + prop, Double.TYPE);
                            return method;
                        }
                        if (cl.equals(Boolean.class)) {
                            Method method = obj.getClass().getMethod("set" + prop, Boolean.TYPE);
                            return method;
                        }
                        if (cl.equals(Character.class)) {
                            Method method = obj.getClass().getMethod("set" + prop, Character.TYPE);
                            return method;
                        }
                    }
                    catch (Exception e2) {
                        if (StiOptions.Engine.logLevel < 10) break block14;
                        e2.printStackTrace();
                    }
                }
                cl = cl.getSuperclass();
            }
        }
        return null;
    }

    private static Method findSetter(Object obj, String prop, Class<?> cl) {
        Method method = StiReportEdit.findSet(obj, prop, cl);
        if (method == null) {
            if (cl.equals(Float.class) || cl.equals(Float.TYPE)) {
                return StiReportEdit.findSet(obj, prop, new Double(0.0).getClass());
            }
            if (cl.equals(Float.class) || cl.equals(Float.TYPE)) {
                return StiReportEdit.findSet(obj, prop, new Float(0.0f).getClass());
            }
        }
        return method;
    }

    private static void sp(Object obj, String prop, Object value) {
        StiReportEdit.sp(obj, prop, value, null);
    }

    private static void sp(Object obj, String prop, Object value, Class<?> cl) {
        try {
            Method method = StiReportEdit.findSetter(obj, prop, value != null ? value.getClass() : cl);
            if (method != null) {
                method.invoke(obj, value);
            } else {
                LOG.warning("set" + prop + ":" + obj.getClass() + " for " + (value != null ? value.getClass() : "null") + " not found");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void sb(Object obj, String prop, String value) {
        try {
            Method method = StiReportEdit.findSetter(obj, prop, Boolean.TRUE.getClass());
            if (method != null) {
                method.invoke(obj, "1".equals(value));
            } else {
                LOG.warning("set" + prop + ":" + obj.getClass() + " for " + (value != null ? value.getClass() : "null") + " not found");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setAliasNameProperty(Object component, String propertyValue) {
        StiReportEdit.sp(component, "Alias", StiEncodingHelper.decodeString((String)propertyValue));
    }

    public static void setRatioProperty(Object component, String propertyValue) {
        String propertyName = component instanceof StiZipCode ? "Ratio" : "AspectRatio";
        StiReportEdit.sp(component, propertyName, "1".equals(propertyValue));
    }

    public static void setRotationProperty(Object component, String propertyValue) {
        StiImage comp = (StiImage)component;
        comp.setImageRotation(StiImageRotation.valueOf((String)propertyValue));
    }

    public static void setImageMultipleFactorProperty(Object component, String propertyValue) {
        StiImage comp = (StiImage)component;
        comp.setMultipleFactor(StiReportEdit.strToDouble(propertyValue));
    }

    public static void setSubReportPageProperty(Object component, String propertyValue) {
        StiSubReport comp = (StiSubReport)component;
        StiReport report = comp.getReport();
        if (propertyValue != null && propertyValue.toLowerCase().indexOf("notassigned") < 0) {
            comp.setSubReportPage(report.getPages().get(propertyValue));
        } else {
            comp.setSubReportPage(null);
        }
    }

    public static void setContourColorProperty(Object component, String propertyValue) {
        StiCheckBox comp = (StiCheckBox)component;
        comp.setContourColor(StiReportEdit.strToColor(propertyValue));
    }

    public static void setSizeProperty(Object component, String propertyValue) {
        StiReportEdit.sp(component, "Size", Float.valueOf((float)StiReportEdit.strToDouble(propertyValue)));
    }

    public static void setCheckBoxValuesProperty(Object component, String propertyValue) {
        StiCheckBox comp = (StiCheckBox)component;
        comp.setValues(propertyValue);
    }

    public static void setEditableProperty(Object component, String propertyValue) {
        StiCheckBox comp = (StiCheckBox)component;
        comp.setEditable("1".equals(propertyValue));
    }

    public static void setContainerProperty(Object component, Object propertyValue) {
        StiClone comp = (StiClone)component;
        if (!"[Not Assigned]".equals(propertyValue)) {
            StiReport report = comp.getReport();
            comp.setContainer((StiContainer)report.GetComponentByName((String)propertyValue));
        } else {
            comp.setContainer(null);
        }
    }

    public static void setColumnWidthProperty(Object component, String propertyValue) {
        StiReportEdit.sp(component, "ColumnWidth", StiReportEdit.strToDouble(propertyValue));
    }

    public static void setColumnGapsProperty(Object component, String propertyValue) {
        StiReportEdit.sp(component, "ColumnGaps", StiReportEdit.strToDouble(propertyValue));
    }

    public static void setColumnsProperty(Object component, String propertyValue) {
        StiReportEdit.sp(component, "Columns", StiReportEdit.strToInt(propertyValue));
    }

    public static void setCalcInvisibleProperty(Object component, String propertyValue) {
        StiReportEdit.sp(component, "CalcInvisible", "1".equals(propertyValue));
    }

    public static void setShapeBorderColorProperty(Object component, String propertyValue) {
        StiShape comp = (StiShape)component;
        comp.setBorderColor(StiReportEdit.strToColor(propertyValue));
    }

    public static void setShapeBorderStyleProperty(Object component, String propertyValue) {
        StiShape comp = (StiShape)component;
        comp.setStyle(StiReportEdit.strToPenStyle(propertyValue));
    }

    public static void setShapeTypeProperty(Object component, Object propertyValue) {
        StiShape comp = (StiShape)component;
        String shapeType = (String)propertyValue;
        if (shapeType.startsWith("StiArrowShapeType")) {
            StiArrowShapeType arrowShapeType = new StiArrowShapeType();
            if ("StiArrowShapeTypeUp".equals(shapeType)) {
                arrowShapeType.setDirection(StiShapeDirection.Up);
            } else if ("StiArrowShapeTypeDown".equals(shapeType)) {
                arrowShapeType.setDirection(StiShapeDirection.Down);
            } else if ("StiArrowShapeTypeRight".equals(shapeType)) {
                arrowShapeType.setDirection(StiShapeDirection.Right);
            } else if ("StiArrowShapeTypeLeft".equals(shapeType)) {
                arrowShapeType.setDirection(StiShapeDirection.Left);
            }
            comp.setShapeType((StiShapeTypeService)arrowShapeType);
        } else {
            try {
                comp.setShapeType((StiShapeTypeService)Class.forName("com.stimulsoft.report.components.shapeTypes." + (String)propertyValue).newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void setBackColorProperty(Object component, Object propertyValue) {
        StiBarCode comp = (StiBarCode)component;
        comp.setBackColor(StiReportEdit.strToColor((String)propertyValue));
    }

    public static void setForeColorProperty(Object component, String propertyValue) {
        StiReportEdit.sp(component, "ForeColor", StiReportEdit.strToColor(propertyValue));
    }

    public static void setAutoScaleProperty(Object component, String propertyValue) {
        StiBarCode comp = (StiBarCode)component;
        comp.setAutoScale("1".equals(propertyValue));
    }

    public static void setRightToLeftProperty(Object component, String propertyValue) {
        StiReportEdit.sp(component, "RightToLeft", "1".equals(propertyValue));
    }

    public static void setShowLabelTextProperty(Object component, String propertyValue) {
        StiBarCode comp = (StiBarCode)component;
        comp.setShowLabelText("1".equals(propertyValue));
    }

    public static void setBarCodeAngleProperty(Object component, String propertyValue) {
        StiBarCode comp = (StiBarCode)component;
        comp.setAngle(StiAngle.forValue((int)StiReportEdit.strToInt(propertyValue)));
    }

    public static void setBarCodeTypeProperty(Object component, Object propertyValue) {
        StiBarCode comp = (StiBarCode)component;
        String barCodeType = (String)propertyValue;
        if (barCodeType.equals("StiAustraliaPost4StateBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiAustraliaPost4StateBarCodeType());
        } else if (barCodeType.equals("StiCode11BarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiCode11BarCodeType());
        } else if (barCodeType.equals("StiCode128aBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiCode128aBarCodeType());
        } else if (barCodeType.equals("StiCode128bBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiCode128bBarCodeType());
        } else if (barCodeType.equals("StiCode128cBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiCode128cBarCodeType());
        } else if (barCodeType.equals("StiCode128AutoBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiCode128AutoBarCodeType());
        } else if (barCodeType.equals("StiCode39BarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiCode39BarCodeType());
        } else if (barCodeType.equals("StiCode39ExtBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiCode39ExtBarCodeType());
        } else if (barCodeType.equals("StiCode93BarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiCode93BarCodeType());
        } else if (barCodeType.equals("StiCode93ExtBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiCode93ExtBarCodeType());
        } else if (barCodeType.equals("StiCodabarBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiCodabarBarCodeType());
        } else if (barCodeType.equals("StiDataMatrixBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiDataMatrixBarCodeType());
        } else if (barCodeType.equals("StiEAN128aBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiEAN128aBarCodeType());
        } else if (barCodeType.equals("StiEAN128bBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiEAN128bBarCodeType());
        } else if (barCodeType.equals("StiEAN128cBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiEAN128cBarCodeType());
        } else if (barCodeType.equals("StiEAN128AutoBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiEAN128AutoBarCodeType());
        } else if (barCodeType.equals("StiEAN13BarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiEAN13BarCodeType());
        } else if (barCodeType.equals("StiEAN8BarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiEAN8BarCodeType());
        } else if (barCodeType.equals("StiFIMBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiFIMBarCodeType());
        } else if (barCodeType.equals("StiIsbn10BarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiIsbn10BarCodeType());
        } else if (barCodeType.equals("StiIsbn13BarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiIsbn13BarCodeType());
        } else if (barCodeType.equals("StiITF14BarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiITF14BarCodeType());
        } else if (barCodeType.equals("StiJan13BarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiJan13BarCodeType());
        } else if (barCodeType.equals("StiJan8BarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiJan8BarCodeType());
        } else if (barCodeType.equals("StiMsiBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiMsiBarCodeType());
        } else if (barCodeType.equals("StiPdf417BarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiPdf417BarCodeType());
        } else if (barCodeType.equals("StiAztecBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiAztecBarCodeType());
        } else if (barCodeType.equals("StiPharmacodeBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiPharmacodeBarCodeType());
        } else if (barCodeType.equals("StiMaxicodeBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiMaxicodeBarCodeType());
        } else if (barCodeType.equals("StiPlesseyBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiPlesseyBarCodeType());
        } else if (barCodeType.equals("StiPostnetBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiPostnetBarCodeType());
        } else if (barCodeType.equals("StiQRCodeBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiQRCodeBarCodeType());
        } else if (barCodeType.equals("StiDutchKIXBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiDutchKIXBarCodeType());
        } else if (barCodeType.equals("StiRoyalMail4StateBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiRoyalMail4StateBarCodeType());
        } else if (barCodeType.equals("StiSSCC18BarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiSSCC18BarCodeType());
        } else if (barCodeType.equals("StiUpcABarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiUpcABarCodeType());
        } else if (barCodeType.equals("StiUpcEBarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiUpcEBarCodeType());
        } else if (barCodeType.equals("StiUpcSup2BarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiUpcSup2BarCodeType());
        } else if (barCodeType.equals("StiUpcSup5BarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiUpcSup5BarCodeType());
        } else if (barCodeType.equals("StiInterleaved2of5BarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiInterleaved2of5BarCodeType());
        } else if (barCodeType.equals("StiStandard2of5BarCodeType")) {
            comp.setBarCodeType((StiBarCodeTypeService)new StiStandard2of5BarCodeType());
        }
    }

    public static void setCodeProperty(Object component, String propertyValue) {
        propertyValue = StiEncodingHelper.decodeString((String)propertyValue);
        if (component.getClass().getName().contains("StiZipCode")) {
            StiZipCode comp = (StiZipCode)component;
            comp.getCode().setValue(propertyValue);
        } else if (component.getClass().getName().contains("StiBarCode")) {
            StiBarCode comp = (StiBarCode)component;
            comp.getCode().setValue(propertyValue);
        }
    }

    public static void setStretchProperty(Object component, String propertyValue) {
        StiImage comp = (StiImage)component;
        comp.setStretch("1".equals(propertyValue));
    }

    public static void setComponentStyleProperty(Object component, String propertyValue) {
        StiComponent comp = (StiComponent)component;
        comp.setComponentStyle(!"[None]".equals(propertyValue) ? propertyValue : "");
    }

    public static void setOddStyleProperty(Object component, String propertyValue) {
        StiReportEdit.sp(component, "OddStyle", !"[None]".equals(propertyValue) ? propertyValue : "");
    }

    public static void setEvenStyleProperty(Object component, String propertyValue) {
        StiReportEdit.sp(component, "EvenStyle", !"[None]".equals(propertyValue) ? propertyValue : "");
    }

    public static void setPageOrientationProperty(Object component, String propertyValue) {
        StiPage comp = (StiPage)component;
        comp.setOrientation("Portrait".equals(propertyValue) ? StiPageOrientation.Portrait : StiPageOrientation.Landscape);
    }

    public static void setPaperSizeProperty(Object component, String propertyValue) {
        StiPage comp = (StiPage)component;
        comp.setPaperSize(StiPaperKind.forValue((int)StiReportEdit.strToInt(propertyValue)));
    }

    public static void setPageWidthProperty(Object component, String propertyValue) {
        StiPage comp = (StiPage)component;
        comp.setPageWidth(StiReportEdit.strToDouble(propertyValue));
    }

    public static void setPageHeightProperty(Object component, String propertyValue) {
        StiPage comp = (StiPage)component;
        comp.setPageHeight(StiReportEdit.strToDouble(propertyValue));
    }

    public static void setLargeHeightProperty(Object component, String propertyValue) {
        StiPage comp = (StiPage)component;
        comp.setLargeHeight("1".equals(propertyValue));
    }

    public static void setLargeHeightFactorProperty(Object component, Object propertyValue) {
        StiPage comp = (StiPage)component;
        comp.setLargeHeightFactor(StiReportEdit.strToInt(propertyValue));
    }

    public static void setStopBeforePrintProperty(Object component, String propertyValue) {
        StiPage comp = (StiPage)component;
        comp.setStopBeforePrint(StiReportEdit.strToInt(propertyValue));
    }

    public static void setTitleBeforeHeaderProperty(Object component, String propertyValue) {
        StiPage comp = (StiPage)component;
        comp.setTitleBeforeHeader("1".equals(propertyValue));
    }

    public static void setMarginsProperty(Object component, Object propertyValue) {
        StiPage comp = (StiPage)component;
        String[] margins = ((String)propertyValue).split("!");
        comp.getMargins().setLeft(StiReportEdit.strToDouble(margins[0]));
        comp.getMargins().setTop(StiReportEdit.strToDouble(margins[1]));
        comp.getMargins().setRight(StiReportEdit.strToDouble(margins[2]));
        comp.getMargins().setBottom(StiReportEdit.strToDouble(margins[3]));
    }

    public static void setVertAlignmentProperty(Object component, String propertyValue) {
        StiReportEdit.sp(component, "VertAlignment", StiVertAlignment.valueOf((String)propertyValue));
    }

    public static void setBrushTypeProperty(Object component, String propertyValue) {
        block5: {
            StiBrushType brushType;
            block4: {
                try {
                    brushType = StiBrushType.valueOf((String)propertyValue);
                    StiReportEdit.sp(component, "BrushType", brushType);
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel < 10) break block4;
                    e.printStackTrace();
                }
            }
            try {
                brushType = com.stimulsoft.report.enums.StiBrushType.valueOf((String)propertyValue);
                StiReportEdit.sp(component, "BrushType", brushType);
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) break block5;
                e.printStackTrace();
            }
        }
    }

    public static void setHorAlignmentProperty(Object component, String propertyValue) {
        if (component.getClass().getName().contains("StiText") || component.getClass().getName().contains("StiTableCell") || component.getClass().getName().contains("StiTextInCells")) {
            StiReportEdit.sp(component, "HorAlignment", StiTextHorAlignment.valueOf((String)propertyValue));
        } else {
            StiReportEdit.sp(component, "HorAlignment", StiHorAlignment.valueOf((String)propertyValue));
        }
    }

    public static void setTextAngleProperty(Object component, String propertyValue) {
        StiReportEdit.sp(component, "Angle", Float.valueOf((float)StiReportEdit.strToDouble(propertyValue)));
    }

    public static void setTextBrushProperty(Object component, String propertyValue) {
        StiReportEdit.sp(component, "TextBrush", StiReportEdit.strToBrush(propertyValue));
    }

    public static void setTextProperty(Object component, Object propertyValue) {
        propertyValue = StiEncodingHelper.decodeString((String)((String)propertyValue)).replaceAll("\n", "\r\n");
        StiExpression text = new StiExpression((String)propertyValue);
        StiReportEdit.sp(component, "Text", text);
    }

    public static void setRichTextProperty(Object component, Object propertyValue) {
        if (!StiHyperlinkProcessor.isServerHyperlink((String)((String)(propertyValue = StiEncodingHelper.decodeString((String)((String)propertyValue)))))) {
            // empty if block
        }
    }

    public static void setRichTextDataUrlProperty(Object component, String propertyValue) {
        StiRichText comp = (StiRichText)component;
        String dataUrl = StiEncodingHelper.decodeString((String)propertyValue);
        StiDataUrlExpression url = new StiDataUrlExpression();
        url.setValue(dataUrl);
        comp.setDataUrl(url);
    }

    public static void setTextFormatProperty(Object component, HashMap<String, Object> propertyValue) throws JSONException {
        StiReportEdit.sp(component, "TextFormat", StiTextFormatHelper.getFormatService(propertyValue));
    }

    public static void setCellWidthProperty(Object component, String propertyValue) {
        StiTextInCells comp = (StiTextInCells)component;
        comp.setCellWidth((float)StiReportEdit.strToDouble(propertyValue));
    }

    public static void setCellHeightProperty(Object component, String propertyValue) {
        StiTextInCells comp = (StiTextInCells)component;
        comp.setCellHeight((float)StiReportEdit.strToDouble(propertyValue));
    }

    public static void setHorizontalSpacingProperty(Object component, String propertyValue) {
        StiTextInCells comp = (StiTextInCells)component;
        comp.setHorSpacing((float)StiReportEdit.strToDouble(propertyValue));
    }

    public static void setVerticalSpacingProperty(Object component, String propertyValue) {
        StiTextInCells comp = (StiTextInCells)component;
        comp.setVertSpacing((float)StiReportEdit.strToDouble(propertyValue));
    }

    public static void setMaxNumberOfLinesProperty(Object component, String propertyValue) {
        StiText comp = (StiText)component;
        comp.setMaxNumberOfLines(StiReportEdit.strToInt(propertyValue));
    }

    public static void setWordWrapProperty(Object component, String propertyValue) {
        StiReportEdit.sp(component, "WordWrap", "1".equals(propertyValue));
    }

    public static void setTextMarginsProperty(Object component, String propertyValue) {
        String[] marginsArray = propertyValue.split(";");
        StiMargins margins = new StiMargins(StiReportEdit.strToDouble(marginsArray[0]), StiReportEdit.strToDouble(marginsArray[1]), StiReportEdit.strToDouble(marginsArray[2]), StiReportEdit.strToDouble(marginsArray[3]));
        StiReportEdit.sp(component, "Margins", margins);
    }

    public static void setAllowHtmlTagsProperty(Object component, String propertyValue) {
        StiReportEdit.sb(component, "AllowHtmlTags", propertyValue);
    }

    public static void setOnlyTextProperty(Object component, String propertyValue) {
        StiReportEdit.sb(component, "OnlyText", propertyValue);
    }

    public static void setEditableTextProperty(Object component, String propertyValue) {
        StiReportEdit.sb(component, "Editable", propertyValue);
    }

    public static void setHideZerosProperty(Object component, String propertyValue) {
        StiReportEdit.sb(component, "HideZeros", propertyValue);
    }

    public static void setContinuousTextProperty(Object component, String propertyValue) {
        StiTextInCells comp = (StiTextInCells)component;
        comp.setContinuousText("1".equals(propertyValue));
    }

    public static void setBorderProperty(Object component, String propertyValue) {
        StiReportEdit.sp(component, "Border", StiReportEdit.strToBorder(propertyValue));
    }

    public static void setBrushProperty(Object component, String propertyValue) {
        StiReportEdit.sp(component, "Brush", StiReportEdit.strToBrush(propertyValue));
    }

    public static void setCanGrowProperty(Object component, String propertyValue) {
        StiReportEdit.sb(component, "CanGrow", propertyValue);
    }

    public static void setCanShrinkProperty(Object component, String propertyValue) {
        StiReportEdit.sb(component, "CanShrink", propertyValue);
    }

    public static void setCanBreakProperty(Object component, String propertyValue) {
        StiReportEdit.sb(component, "CanBreak", propertyValue);
    }

    public static void setAutoWidthProperty(Object component, String propertyValue) {
        StiText comp = (StiText)component;
        comp.setAutoWidth("1".equals(propertyValue));
    }

    public static void setGrowToHeightProperty(Object component, String propertyValue) {
        StiReportEdit.sb(component, "GrowToHeight", propertyValue);
    }

    public static void setEnabledProperty(Object component, String propertyValue) {
        StiReportEdit.sb(component, "Enabled", propertyValue);
    }

    public static void setPrintableProperty(Object component, String propertyValue) {
        StiReportEdit.sb(component, "Printable", propertyValue);
    }

    public static void setPrintOnProperty(Object component, String propertyValue) {
        StiReportEdit.sp(component, "PrintOn", StiPrintOnType.forValue((int)StiReportEdit.strToInt(propertyValue)));
    }

    public static void setWaterMarkRatioProperty(Object component, String propertyValue) {
        StiPage comp = (StiPage)component;
        comp.getWatermark().setAspectRatio("1".equals(propertyValue));
    }

    public static void setWaterMarkRightToLeftProperty(Object component, String propertyValue) {
        StiPage comp = (StiPage)component;
        comp.getWatermark().setRightToLeft("1".equals(propertyValue));
    }

    public static void setWaterMarkEnabledProperty(Object component, String propertyValue) {
        StiPage comp = (StiPage)component;
        comp.getWatermark().setEnabled("1".equals(propertyValue));
    }

    public static void setWaterMarkAngleProperty(Object component, String propertyValue) {
        StiPage comp = (StiPage)component;
        comp.getWatermark().setAngle((double)((float)StiReportEdit.strToDouble(propertyValue)));
    }

    public static void setWaterMarkTextProperty(Object component, String propertyValue) {
        propertyValue = StiEncodingHelper.decodeString((String)propertyValue);
        StiPage comp = (StiPage)component;
        comp.getWatermark().setText(propertyValue);
    }

    public static void setWaterMarkTextBrushProperty(Object component, String propertyValue) {
        StiPage comp = (StiPage)component;
        comp.getWatermark().setTextBrush(StiReportEdit.strToBrush(propertyValue));
    }

    public static void setWaterMarkTextBehindProperty(Object component, String propertyValue) {
        StiPage comp = (StiPage)component;
        comp.getWatermark().setShowBehind("1".equals(propertyValue));
    }

    public static void setWaterMarkImageBehindProperty(Object component, String propertyValue) {
        StiPage comp = (StiPage)component;
        comp.getWatermark().setShowImageBehind("1".equals(propertyValue));
    }

    public static void setWaterMarkImageAlignProperty(Object component, String propertyValue) {
        StiPage comp = (StiPage)component;
        comp.getWatermark().setImageAlignment(StiContentAlignment.valueOf((String)propertyValue));
    }

    public static void setWaterMarkMultipleFactorProperty(Object component, String propertyValue) {
        StiPage comp = (StiPage)component;
        comp.getWatermark().setImageMultipleFactor(StiReportEdit.strToDouble(propertyValue));
    }

    public static void setWaterMarkStretchProperty(Object component, String propertyValue) {
        StiPage comp = (StiPage)component;
        comp.getWatermark().setImageStretch("1".equals(propertyValue));
    }

    public static void setWaterMarkTilingProperty(Object component, String propertyValue) {
        StiPage comp = (StiPage)component;
        comp.getWatermark().setImageTiling("1".equals(propertyValue));
    }

    public static void setWaterMarkTransparencyProperty(Object component, String propertyValue) {
        StiPage comp = (StiPage)component;
        comp.getWatermark().setImageTransparency(StiReportEdit.strToInt(propertyValue));
    }

    public static void setNewPageBeforeProperty(Object component, String propertyValue) {
        StiReportEdit.sb(component, "NewPageBefore", propertyValue);
    }

    public static void setNewPageAfterProperty(Object component, String propertyValue) {
        StiReportEdit.sb(component, "NewPageAfter", propertyValue);
    }

    public static void setNewColumnBeforeProperty(Object component, String propertyValue) {
        StiReportEdit.sb(component, "NewColumnBefore", propertyValue);
    }

    public static void setNewColumnAfterProperty(Object component, String propertyValue) {
        StiReportEdit.sb(component, "NewColumnAfter", propertyValue);
    }

    public static void setSkipFirstProperty(Object component, String propertyValue) {
        StiReportEdit.sb(component, "SkipFirst", propertyValue);
    }

    public static void setConditionProperty(Object component, Object propValue) {
        String propertyValue = (String)propValue;
        propertyValue = StiEncodingHelper.decodeString((String)propertyValue);
        StiGroupHeaderBand comp = (StiGroupHeaderBand)component;
        StiGroupConditionExpression condExpr = new StiGroupConditionExpression(propertyValue);
        comp.setCondition(condExpr);
    }

    private static String getCorrectName(String value) {
        String result = "";
        if (StiValidationUtil.isEmpty((String)value)) {
            return "";
        }
        if (value.startsWith("{") && value.endsWith("}")) {
            value = value.substring(1, value.length() - 1);
            String[] valueArray = value.split("\\.");
            for (int i = 0; i < valueArray.length; ++i) {
                if (!"".equals(result)) {
                    result = result + ".";
                }
                result = result + StiNameValidator.CorrectName((String)valueArray[i]);
            }
            return "{" + result + "}";
        }
        return value;
    }

    public static void setSortDirectionProperty(Object component, String propertyValue) {
        StiGroupHeaderBand comp = (StiGroupHeaderBand)component;
        comp.setSortDirection(StiGroupSortDirection.forValue((int)StiReportEdit.strToInt(propertyValue)));
    }

    public static void setSummarySortDirectionProperty(Object component, String propertyValue) {
        StiGroupHeaderBand comp = (StiGroupHeaderBand)component;
        comp.setSummarySortDirection(StiGroupSortDirection.forValue((int)StiReportEdit.strToInt(propertyValue)));
    }

    public static void setSummaryExpressionProperty(Object component, String propertyValue) {
        propertyValue = StiEncodingHelper.decodeString((String)propertyValue);
        StiGroupHeaderBand comp = (StiGroupHeaderBand)component;
        StiGroupSummaryExpression summExpr = new StiGroupSummaryExpression(propertyValue);
        comp.setSummaryExpression(summExpr);
    }

    public static void setSummaryTypeProperty(Object component, String propertyValue) {
        StiGroupHeaderBand comp = (StiGroupHeaderBand)component;
        comp.setSummaryType(StiGroupSummaryType.forValue((int)StiReportEdit.strToInt(propertyValue)));
    }

    public static void setDataSourceProperty(Object component, Object propValue) throws JSONException {
        String propertyValue = "[Not Assigned]".equals(propValue) ? "" : (String)propValue;
        Object pi = StiReportEdit.gp(component, "DataSourceName");
        if (pi != null) {
            String oldDataSourceName = (String)pi;
            if (!oldDataSourceName.equals(propertyValue)) {
                StiReportEdit.setSortDataProperty(component, "");
            }
            StiReportEdit.sp(component, "DataSourceName", propertyValue);
        }
    }

    public static void setDataRelationProperty(Object component, Object propValue) {
        String propertyValue = "[Not Assigned]".equals(propValue) ? null : (String)propValue;
        StiReportEdit.sp(component, "DataRelationName", propertyValue, String.class);
    }

    public static void setMasterComponentProperty(Object component, Object propertyValue) {
        StiComponent comp = (StiComponent)component;
        StiComponent masterComponent = !"[Not Assigned]".equals(propertyValue) ? comp.getReport().GetComponentByName((String)propertyValue) : null;
        StiReportEdit.sp(component, "MasterComponent", masterComponent, StiComponent.class);
    }

    public static void setBusinessObjectProperty(Object component, Object propertyValue) {
    }

    public static void setCountDataProperty(Object component, String propertyValue) {
        StiReportEdit.sp(component, "CountData", StiReportEdit.strToInt(propertyValue));
    }

    public static void setFilterEngineProperty(Object component, String propertyValue) {
        StiFilterEngine filterEngine = StiFilterEngine.ReportEngine;
        if (!"ReportEngine".equals(propertyValue)) {
            filterEngine = StiFilterEngine.SQLQuery;
        }
        StiReportEdit.sp(component, "FilterEngine", filterEngine.getValue(), Integer.class);
    }

    public static void setSortDataProperty(Object component, ArrayList<HashMap<String, Object>> sortArray) throws JSONException {
        List<String> result = new ArrayList<String>();
        for (int i = 0; i < sortArray.size(); ++i) {
            HashMap<String, Object> oneSort = sortArray.get(i);
            result = StiReportEdit.getSortArray(component, oneSort, result);
        }
        StiReportEdit.sp(component, "Sort", result);
    }

    public static void setSortDataProperty(Object component, Object propertyValue) throws JSONException {
        List<String> result = new ArrayList<String>();
        if (StiValidationUtil.isNotNullOrEmpty((String)((String)propertyValue))) {
            String pv = StiEncodingHelper.decodeString((String)((String)propertyValue));
            JSONObject obj = new JSONObject(String.format("{obj:%s}", pv));
            HashMap objs = StiRequestParamsHelper.parseParameters((Object)obj, new HashMap(), null);
            ArrayList sortArray = (ArrayList)objs.get("obj");
            for (int i = 0; i < sortArray.size(); ++i) {
                HashMap oneSort = (HashMap)sortArray.get(i);
                result = StiReportEdit.getSortArray(component, oneSort, result);
            }
        }
        StiReportEdit.sp(component, "Sort", result);
    }

    private static List<String> getSortArray(Object component, HashMap<String, Object> sort, List<String> result) throws JSONException {
        StiDataSource dataSource = null;
        Object pi1 = StiReportEdit.gp(component, "DataSource");
        if (pi1 != null) {
            dataSource = (StiDataSource)pi1;
        }
        if (dataSource != null) {
            result.add((String)sort.get("direction"));
            String column = (String)sort.get("column");
            if (column.startsWith("{") && column.endsWith("}")) {
                result.add(column);
            } else {
                String[] columnPath = column.split("\\.");
                result = StiReportEdit.getColumnPathArray(dataSource, columnPath, result);
            }
        }
        return result;
    }

    private static List<String> getColumnPathArray(StiDataSource dataSource, String[] columnPath, List<String> result) {
        if (columnPath.length == 1) {
            result.add(columnPath[0]);
        } else {
            StiDataRelationsCollection relations = dataSource.GetParentRelations();
            for (int level = 0; level < columnPath.length - 1; ++level) {
                StiDataRelation relation = StiReportEdit.getChildRelation(relations, columnPath[level]);
                if (relation == null) continue;
                result.add(relation.getNameInSource());
                relations = relation.getParentSource().GetParentRelations();
            }
            result.add(columnPath[columnPath.length - 1]);
        }
        return result;
    }

    private static StiDataRelation getChildRelation(StiDataRelationsCollection relations, String relationName) {
        for (StiDataRelation relation : relations) {
            if (!StiValidationUtil.equals((Object)StiNameValidator.CorrectName((String)relation.getName()), (Object)relationName)) continue;
            return relation;
        }
        return null;
    }

    public static void setFilterDataProperty(Object component, ArrayList<HashMap<String, Object>> filters) throws JSONException {
        StiFiltersCollection filtersCollection = new StiFiltersCollection();
        for (int i = 0; i < filters.size(); ++i) {
            HashMap<String, Object> filter = filters.get(i);
            filtersCollection.add((Object)StiReportEdit.filterFromObject(filter));
        }
        StiReportEdit.sp(component, "Filters", filtersCollection);
    }

    public static void setFilterDataProperty(Object component, String propertyValue) throws JSONException {
        HashMap objs = StiRequestParamsHelper.parseParameters((Object)new JSONObject(String.format("{obj:%s}", StiEncodingHelper.decodeString((String)propertyValue))), new HashMap(), null);
        ArrayList filtersObject = (ArrayList)objs.get("obj");
        StiFiltersCollection filters = new StiFiltersCollection();
        Integer i = 0;
        while (i < filtersObject.size()) {
            filters.add((Object)StiReportEdit.filterFromObject((HashMap)filtersObject.get(i)));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        StiReportEdit.sp(component, "Filters", filters);
    }

    private static StiFilter filterFromObject(HashMap<String, Object> filterObject) throws JSONException {
        StiFilter filter = new StiFilter();
        filter.setItem("Value".equals(filterObject.get("fieldIs")) ? StiFilterItem.Value : StiFilterItem.Expression);
        filter.setDataType(StiReportEdit.strToFilterDataType((String)filterObject.get("dataType")));
        filter.setColumn((String)filterObject.get("column"));
        filter.setCondition(StiReportEdit.strToFilterCondition((String)filterObject.get("condition")));
        filter.setValue1((String)filterObject.get("value1"));
        filter.setValue2((String)filterObject.get("value2"));
        filter.getExpression().setValue(StiValidationUtil.isNotNullOrEmpty((String)((String)filterObject.get("expression"))) ? "{" + (String)filterObject.get("expression") + "}" : "");
        return filter;
    }

    private static StiFilterDataType strToFilterDataType(String dataType) {
        return StiFilterDataType.valueOf((String)dataType);
    }

    private static StiFilterCondition strToFilterCondition(String condition) {
        return StiFilterCondition.valueOf((String)condition);
    }

    public static void setFilterOnProperty(Object component, Object propertyValue) {
        StiReportEdit.sp(component, "FilterOn", Boolean.parseBoolean(propertyValue.toString()));
    }

    public static void setFilterModeProperty(Object component, Object propertyValue) {
        StiReportEdit.sp(component, "FilterMode", "And".equals(propertyValue) ? StiFilterMode.And : StiFilterMode.Or);
    }

    public static void setShiftModeProperty(Object component, Object propValue) {
        StiComponent comp = (StiComponent)component;
        String propertyValue = (String)propValue;
        StiEnumSet value = StiEnumSet.of((Enum)StiShiftMode.None);
        if (propertyValue.indexOf("IncreasingSize") >= 0) {
            value.add((IStiEnum)StiShiftMode.IncreasingSize);
        }
        if (propertyValue.indexOf("DecreasingSize") >= 0) {
            value.add((IStiEnum)StiShiftMode.DecreasingSize);
        }
        if (propertyValue.indexOf("OnlyInWidthOfComponent") >= 0) {
            value.add((IStiEnum)StiShiftMode.OnlyInWidthOfComponent);
        }
        if (propertyValue.indexOf("All") >= 0) {
            value = StiEnumSet.of((Enum)StiShiftMode.IncreasingSize, (Enum)StiShiftMode.DecreasingSize, (Enum)StiShiftMode.OnlyInWidthOfComponent);
        }
        comp.setShiftMode(value);
    }

    public static void setDataColumnProperty(Object component, String propertyValue) {
        propertyValue = StiEncodingHelper.decodeString((String)propertyValue);
        StiReportEdit.sp(component, "DataColumn", propertyValue);
    }

    public static void setImageUrlProperty(Object component, String propertyValue) {
        StiImage comp = (StiImage)component;
        String imageUrl = StiEncodingHelper.decodeString((String)propertyValue);
        StiImageURLExpression image = new StiImageURLExpression();
        image.setValue(imageUrl);
        comp.setImageURL(image);
    }

    public static void setImageSrcProperty(Object component, String propertyValue) {
        propertyValue = StiEncodingHelper.decodeString((String)propertyValue);
        StiImage comp = (StiImage)component;
        if (!"".equals(propertyValue) && propertyValue.startsWith("data:image")) {
            comp.setImageBytes(propertyValue.substring(propertyValue.indexOf("base64,") + 7).replace(' ', '+'));
        } else {
            comp.setImageBytes(StiReportEdit.getNull());
        }
    }

    public static void setImageFileProperty(Object component, String propertyValue) {
        StiImage comp = (StiImage)component;
        String imageFile = StiEncodingHelper.decodeString((String)propertyValue);
        comp.setFile(imageFile);
    }

    public static void setImageDataProperty(Object component, String propertyValue) {
        propertyValue = StiEncodingHelper.decodeString((String)propertyValue);
        StiImageDataExpression imageData = new StiImageDataExpression(propertyValue);
        StiReportEdit.sp(component, "ImageData", imageData);
    }

    private static String getNull() {
        return null;
    }

    public static void setWatermarkImageSrcProperty(Object component, String propertyValue) {
        propertyValue = StiEncodingHelper.decodeString((String)propertyValue);
        StiPage comp = (StiPage)component;
        if (!"".equals(propertyValue) && propertyValue.startsWith("data:image")) {
            comp.getWatermark().setImageBytes(propertyValue.substring(propertyValue.indexOf("base64,") + 7).replace(' ', '+'));
            return;
        }
        comp.getWatermark().setImageBytes(null);
    }

    public static void setCrossTabEmptyValueProperty(Object component, String propertyValue) {
        StiCrossTab comp = (StiCrossTab)component;
        comp.setEmptyValue(StiEncodingHelper.decodeString((String)propertyValue));
    }

    public static void setCrossTabWrapGapProperty(Object component, String propertyValue) {
        StiCrossTab comp = (StiCrossTab)component;
        comp.setWrapGap(StiReportEdit.strToDouble(propertyValue));
    }

    public static void setCrossTabWrapProperty(Object component, String propertyValue) {
        StiCrossTab comp = (StiCrossTab)component;
        comp.setWrap("1".equals(propertyValue));
    }

    public static void setCrossTabPrintTitleProperty(Object component, String propertyValue) {
        StiCrossTab comp = (StiCrossTab)component;
        comp.setPrintTitleOnAllPages("1".equals(propertyValue));
    }

    public static void setCrossTabHorAlignProperty(Object component, String propertyValue) {
        StiCrossTab comp = (StiCrossTab)component;
        comp.setHorAlignment(StiCrossHorAlignment.valueOf((String)propertyValue));
    }

    public static void setPrintIfEmptyProperty(Object component, String propertyValue) {
        StiReportEdit.sp(component, "PrintIfEmpty", "1".equals(propertyValue));
    }

    public static void setPrintOnAllPagesProperty(Object component, String propertyValue) {
        StiReportEdit.sp(component, "PrintOnAllPages", "1".equals(propertyValue));
    }

    public static void setKeyDataColumnProperty(Object component, String propertyValue) {
        StiHierarchicalBand comp = (StiHierarchicalBand)component;
        comp.setKeyDataColumn(propertyValue);
    }

    public static void setMasterKeyDataColumnProperty(Object component, String propertyValue) {
        StiHierarchicalBand comp = (StiHierarchicalBand)component;
        comp.setMasterKeyDataColumn(propertyValue);
    }

    public static void setParentValueProperty(Object component, String propertyValue) {
        StiHierarchicalBand comp = (StiHierarchicalBand)component;
        comp.setParentValue(StiEncodingHelper.decodeString((String)propertyValue));
    }

    public static void setIndentProperty(Object component, String propertyValue) {
        StiHierarchicalBand comp = (StiHierarchicalBand)component;
        comp.setIndent(StiReportEdit.strToDouble(propertyValue));
    }

    public static void setHeadersProperty(Object component, String propertyValue) {
        StiHierarchicalBand comp = (StiHierarchicalBand)component;
        comp.setHeaders(StiEncodingHelper.decodeString((String)propertyValue));
    }

    public static void setFootersProperty(Object component, String propertyValue) {
        StiHierarchicalBand comp = (StiHierarchicalBand)component;
        comp.setFooters(StiEncodingHelper.decodeString((String)propertyValue));
    }

    public static void setRestrictionsProperty(Object component, Object propValue) {
        StiComponent comp = (StiComponent)component;
        String propertyValue = (String)propValue;
        StiEnumSet value = new StiEnumSet((Enum)StiRestrictions.None);
        if (propertyValue.indexOf("AllowMove") >= 0) {
            value.add((IStiEnum)StiRestrictions.AllowMove);
        }
        if (propertyValue.indexOf("AllowResize") >= 0) {
            value.add((IStiEnum)StiRestrictions.AllowResize);
        }
        if (propertyValue.indexOf("AllowSelect") >= 0) {
            value.add((IStiEnum)StiRestrictions.AllowSelect);
        }
        if (propertyValue.indexOf("AllowChange") >= 0) {
            value.add((IStiEnum)StiRestrictions.AllowChange);
        }
        if (propertyValue.indexOf("AllowDelete") >= 0) {
            value.add((IStiEnum)StiRestrictions.AllowDelete);
        }
        if ("All".equalsIgnoreCase(propertyValue)) {
            value.add((IStiEnum)StiRestrictions.All);
        }
        if (value.size() > 1) {
            value.remove((IStiEnum)StiRestrictions.None);
        }
        comp.setRestrictions(value);
    }

    public static void setConditionsProperty(Object component, Object propertyValue, StiReport report) throws JSONException {
        StiConditionsCollection conditions = new StiConditionsCollection();
        if (StiValidationUtil.isNotNullOrEmpty((String)((String)propertyValue))) {
            String pv = StiEncodingHelper.decodeString((String)((String)propertyValue));
            JSONObject obj = new JSONObject(String.format("{obj:%s}", pv));
            HashMap objs = StiRequestParamsHelper.parseParameters((Object)obj, new HashMap(), null);
            ArrayList conditionsArray = (ArrayList)objs.get("obj");
            for (int i = 0; i < conditionsArray.size(); ++i) {
                StiBaseCondition highlightCondition;
                HashMap conditionObject = (HashMap)conditionsArray.get(i);
                String conditionType = (String)conditionObject.get("ConditionType");
                if ("StiDataBarCondition".equals(conditionType)) {
                    conditions.add((Object)StiReportEdit.createDataBarCondition(conditionObject));
                    continue;
                }
                if ("StiIconSetCondition".equals(conditionType)) {
                    conditions.add((Object)StiReportEdit.createIconSetCondition(conditionObject));
                    continue;
                }
                if ("StiColorScaleCondition".equals(conditionType)) {
                    conditions.add((Object)StiReportEdit.createColorScaleCondition(conditionObject));
                    continue;
                }
                if (!"StiHighlightCondition".equals(conditionType) || (highlightCondition = StiReportEdit.createHighlightCondition(conditionObject, report)) == null) continue;
                conditions.add((Object)highlightCondition);
            }
        }
        StiReportEdit.sp(component, "Conditions", conditions);
    }

    public static StiBaseCondition createHighlightCondition(HashMap<String, Object> conditionObject, StiReport report) throws JSONException {
        String co = StiEncodingHelper.decodeString((String)((String)conditionObject.get("Filters")));
        JSONObject obj = new JSONObject(String.format("{obj:%s}", co));
        HashMap objs = StiRequestParamsHelper.parseParameters((Object)obj, new HashMap(), null);
        ArrayList filters = (ArrayList)objs.get("obj");
        if (filters.size() > 1) {
            StiMultiCondition condition = new StiMultiCondition();
            StiReportEdit.setFilterDataProperty((Object)condition, filters);
            if (conditionObject.containsKey("FilterMode")) {
                StiReportEdit.setFilterModeProperty(condition, conditionObject.get("FilterMode"));
            }
            condition.setTextColor(StiReportEdit.strToColor((String)conditionObject.get("TextColor")));
            condition.setBackColor(StiReportEdit.strToColor((String)conditionObject.get("BackColor")));
            condition.setFont(StiReportEdit.strToFont((String)conditionObject.get("Font"), report));
            condition.setEnabled(((Boolean)conditionObject.get("Enabled")).booleanValue());
            condition.setCanAssignExpression(((Boolean)conditionObject.get("CanAssignExpression")).booleanValue());
            condition.setAssignExpression(StiEncodingHelper.decodeString((String)((String)conditionObject.get("AssignExpression"))));
            condition.setBorderSides(StiReportEdit.strBordersToConditionBorderSidesObject((String)conditionObject.get("BorderSides")));
            condition.setPermissions(StiReportEdit.strPermissionsToConditionPermissionsObject((String)conditionObject.get("Permissions")));
            condition.setStyle((String)conditionObject.get("Style"));
            condition.setBreakIfTrue((Boolean)conditionObject.get("BreakIfTrue"));
            return condition;
        }
        if (filters.size() == 1) {
            StiCondition condition = new StiCondition();
            StiFilter filter = StiReportEdit.filterFromObject((HashMap)filters.get(0));
            condition.setItem(filter.getItem());
            condition.setDataType(filter.getDataType());
            condition.setColumn(filter.getColumn());
            condition.setCondition(filter.getCondition());
            condition.setValue1(filter.getValue1());
            condition.setValue2(filter.getValue2());
            condition.setExpression(filter.getExpression());
            condition.setBreakIfTrue((Boolean)conditionObject.get("BreakIfTrue"));
            condition.setTextColor(StiReportEdit.strToColor((String)conditionObject.get("TextColor")));
            condition.setBackColor(StiReportEdit.strToColor((String)conditionObject.get("BackColor")));
            condition.setFont(StiReportEdit.strToFont((String)conditionObject.get("Font"), report));
            condition.setEnabled(((Boolean)conditionObject.get("Enabled")).booleanValue());
            condition.setCanAssignExpression(((Boolean)conditionObject.get("CanAssignExpression")).booleanValue());
            condition.setAssignExpression(StiEncodingHelper.decodeString((String)((String)conditionObject.get("AssignExpression"))));
            condition.setBorderSides(StiReportEdit.strBordersToConditionBorderSidesObject((String)conditionObject.get("BorderSides")));
            condition.setPermissions(StiReportEdit.strPermissionsToConditionPermissionsObject((String)conditionObject.get("Permissions")));
            condition.setStyle((String)conditionObject.get("Style"));
            return condition;
        }
        return null;
    }

    public static StiBaseCondition createDataBarCondition(HashMap<String, Object> conditionObject) throws JSONException {
        StiDataBarCondition condition = new StiDataBarCondition((String)conditionObject.get("Column"), StiBrushType.valueOf((String)((String)conditionObject.get("BrushType"))), StiReportEdit.strToColor((String)conditionObject.get("PositiveColor")), StiReportEdit.strToColor((String)conditionObject.get("NegativeColor")), ((Boolean)conditionObject.get("ShowBorder")).booleanValue(), StiReportEdit.strToColor((String)conditionObject.get("PositiveBorderColor")), StiReportEdit.strToColor((String)conditionObject.get("NegativeBorderColor")), StiDataBarDirection.valueOf((String)((String)conditionObject.get("Direction"))), StiMinimumType.valueOf((String)((String)conditionObject.get("MinimumType"))), (float)StiReportEdit.strToDouble((String)conditionObject.get("MinimumValue")), StiMaximumType.valueOf((String)((String)conditionObject.get("MaximumType"))), new Float(StiReportEdit.strToDouble((String)conditionObject.get("MaximumValue"))).floatValue());
        return condition;
    }

    public static StiBaseCondition createColorScaleCondition(HashMap<String, Object> conditionObject) throws JSONException {
        StiColorScaleCondition condition = new StiColorScaleCondition((String)conditionObject.get("Column"), StiColorScaleType.valueOf((String)((String)conditionObject.get("ScaleType"))), StiReportEdit.strToColor((String)conditionObject.get("MinimumColor")), StiReportEdit.strToColor((String)conditionObject.get("MidColor")), StiReportEdit.strToColor((String)conditionObject.get("MaximumColor")), StiMinimumType.valueOf((String)((String)conditionObject.get("MinimumType"))), new Float(StiReportEdit.strToDouble((String)conditionObject.get("MinimumValue"))).floatValue(), StiMidType.valueOf((String)((String)conditionObject.get("MidType"))), new Float(StiReportEdit.strToDouble((String)conditionObject.get("MidValue"))).floatValue(), StiMaximumType.valueOf((String)((String)conditionObject.get("MaximumType"))), new Float(StiReportEdit.strToDouble((String)conditionObject.get("MaximumValue"))).floatValue());
        return condition;
    }

    public static StiBaseCondition createIconSetCondition(HashMap<String, Object> conditionObject) throws JSONException {
        StiIconSetCondition condition = new StiIconSetCondition((String)conditionObject.get("Column"), StiIconSet.valueOf((String)((String)conditionObject.get("IconSet"))), com.stimulsoft.report.components.conditions.StiContentAlignment.valueOf((String)((String)conditionObject.get("ContentAlignment"))), StiReportEdit.getIconSetItemFromObject(conditionObject.get("IconSetItem1")), StiReportEdit.getIconSetItemFromObject(conditionObject.get("IconSetItem2")), StiReportEdit.getIconSetItemFromObject(conditionObject.get("IconSetItem3")), StiReportEdit.getIconSetItemFromObject(conditionObject.get("IconSetItem4")), StiReportEdit.getIconSetItemFromObject(conditionObject.get("IconSetItem5")));
        return condition;
    }

    public static void setInteractionProperty(Object component, Object propertyValue) throws JSONException {
        HashMap interactionObject = (HashMap)propertyValue;
        StiInteraction interaction = ((StiComponent)component).getInteraction();
        if (interaction instanceof StiBandInteraction) {
            ((StiBandInteraction)interaction).setCollapsingEnabled(((Boolean)interactionObject.get("collapsingEnabled")).booleanValue());
            ((StiBandInteraction)interaction).setCollapseGroupFooter(((Boolean)interactionObject.get("collapseGroupFooter")).booleanValue());
            ((StiBandInteraction)interaction).getCollapsed().setValue(StiEncodingHelper.decodeString((String)((String)interactionObject.get("collapsedValue"))));
            ((StiBandInteraction)interaction).setSelectionEnabled(((Boolean)interactionObject.get("selectionEnabled")).booleanValue());
        }
        interaction.setDrillDownEnabled(((Boolean)interactionObject.get("drillDownEnabled")).booleanValue());
        interaction.setDrillDownReport((String)interactionObject.get("drillDownReport"));
        interaction.setDrillDownMode(StiDrillDownMode.valueOf((String)((String)interactionObject.get("drillDownMode"))));
        interaction.setDrillDownPage(((StiComponent)component).getReport().getPages().get((String)interactionObject.get("drillDownPage")));
        interaction.getDrillDownParameter1().setName((String)interactionObject.get("drillDownParameter1Name"));
        interaction.getDrillDownParameter1().getExpression().setValue(StiEncodingHelper.decodeString((String)((String)interactionObject.get("drillDownParameter1Expression"))));
        interaction.getDrillDownParameter2().setName((String)interactionObject.get("drillDownParameter2Name"));
        interaction.getDrillDownParameter2().getExpression().setValue(StiEncodingHelper.decodeString((String)((String)interactionObject.get("drillDownParameter2Expression"))));
        interaction.getDrillDownParameter3().setName((String)interactionObject.get("drillDownParameter3Name"));
        interaction.getDrillDownParameter3().getExpression().setValue(StiEncodingHelper.decodeString((String)((String)interactionObject.get("drillDownParameter3Expression"))));
        interaction.getDrillDownParameter4().setName((String)interactionObject.get("drillDownParameter4Name"));
        interaction.getDrillDownParameter4().getExpression().setValue(StiEncodingHelper.decodeString((String)((String)interactionObject.get("drillDownParameter4Expression"))));
        interaction.getDrillDownParameter5().setName((String)interactionObject.get("drillDownParameter5Name"));
        interaction.getDrillDownParameter5().getExpression().setValue(StiEncodingHelper.decodeString((String)((String)interactionObject.get("drillDownParameter5Expression"))));
        interaction.setSortingEnabled(((Boolean)interactionObject.get("sortingEnabled")).booleanValue());
        interaction.setSortingColumn(StiValidationUtil.isNullOrEmpty((String)((String)interactionObject.get("sortingColumn"))) ? "" : (String)interactionObject.get("sortingColumn"));
        interaction.getBookmark().setValue(StiEncodingHelper.decodeString((String)((String)interactionObject.get("bookmark"))));
        interaction.getTag().setValue(StiEncodingHelper.decodeString((String)((String)interactionObject.get("tag"))));
        interaction.getToolTip().setValue(StiEncodingHelper.decodeString((String)((String)interactionObject.get("toolTip"))));
        String hyperLinkType = (String)interactionObject.get("hyperlinkType");
        if ("HyperlinkUsingInteractionBookmark".equals(hyperLinkType)) {
            interaction.getHyperlink().setValue("#" + StiEncodingHelper.decodeString((String)((String)interactionObject.get("hyperlink"))));
        } else if ("HyperlinkUsingInteractionTag".equals(hyperLinkType)) {
            interaction.getHyperlink().setValue("##" + StiEncodingHelper.decodeString((String)((String)interactionObject.get("hyperlink"))));
        } else if ("HyperlinkExternalDocuments".equals(hyperLinkType)) {
            interaction.getHyperlink().setValue(StiEncodingHelper.decodeString((String)((String)interactionObject.get("hyperlink"))));
        }
    }

    public static void setChartStyleProperty(Object component, Object propertyValue) throws ParserConfigurationException, IOException, TransformerException, JSONException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("componentName", ((StiComponent)component).getName());
        param.put("styleType", ((HashMap)propertyValue).get("type"));
        param.put("styleName", ((HashMap)propertyValue).get("name"));
        StiChartHelper.setChartStyle(((StiComponent)component).getReport(), param, new HashMap<String, Object>());
    }

    public static void setGaugeStyleProperty(Object component, Object propertyValue) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("componentName", ((StiComponent)component).getName());
        param.put("styleType", ((HashMap)propertyValue).get("type"));
        param.put("styleName", ((HashMap)propertyValue).get("name"));
        StiGaugeHelper.setGaugeStyle(((StiComponent)component).getReport(), param, new HashMap<String, Object>());
    }

    public static void setMapStyleProperty(Object component, Object propertyValue) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("componentName", ((StiComponent)component).getName());
        param.put("styleType", ((HashMap)propertyValue).get("type"));
        param.put("styleName", ((HashMap)propertyValue).get("name"));
        StiMapHelper.setMapStyle(((StiComponent)component).getReport(), param, new HashMap<String, Object>());
    }

    public static void setCrossTabStyleProperty(Object component, Object propertyValue) throws NumberFormatException, JSONException {
        HashMap parameters = (HashMap)propertyValue;
        StiCrossTab crossTab = (StiCrossTab)component;
        if (parameters.containsKey("crossTabStyleIndex")) {
            crossTab.setCrossTabStyle("");
            crossTab.setCrossTabStyleIndex(Integer.parseInt(String.valueOf(parameters.get("crossTabStyleIndex"))));
        } else {
            crossTab.setCrossTabStyleIndex(-1);
            crossTab.setCrossTabStyle((String)parameters.get("crossTabStyle"));
            crossTab.UpdateStyles();
        }
        crossTab.UpdateStyles();
    }

    public static void setSubReportParametersProperty(Object component, ArrayList<HashMap<String, Object>> propertyValue) throws JSONException {
        StiSubReport subReport = (StiSubReport)component;
        subReport.getParameters().clear();
        for (int i = 0; i < propertyValue.size(); ++i) {
            HashMap<String, Object> parameterObject = propertyValue.get(i);
            subReport.getParameters().add((Object)new StiParameter((String)parameterObject.get("name"), new StiExpression(StiEncodingHelper.decodeString((String)((String)parameterObject.get("expression"))))));
        }
    }

    public static void setTrimmingProperty(Object component, String propertyValue) throws Exception {
    }

    public static void setTextOptionsRightToLeftProperty(Object component, String propertyValue) throws Exception {
        StiReportEdit.setPropertyValue(((StiComponent)component).getReport(), "TextOptions.RightToLeft", component, propertyValue.equals("1"));
    }

    public static void setProcessAtProperty(Object component, String propertyValue) throws Exception {
        StiReportEdit.setPropertyValue(((StiComponent)component).getReport(), "ProcessAt", component, propertyValue);
    }

    public static void setProcessingDuplicatesProperty(Object component, String propertyValue) throws Exception {
        StiReportEdit.setPropertyValue(((StiComponent)component).getReport(), "ProcessingDuplicates", component, propertyValue);
    }

    public static void setShrinkFontToFitProperty(Object component, String propertyValue) throws Exception {
        StiReportEdit.setPropertyValue(((StiComponent)component).getReport(), "ShrinkFontToFit", component, propertyValue.equals("1"));
    }

    public static void setShrinkFontToFitMinimumSizeProperty(Object component, String propertyValue) throws Exception {
        StiReportEdit.setPropertyValue(((StiComponent)component).getReport(), "ShrinkFontToFitMinimumSize", component, propertyValue);
    }

    public static void setTextTypeProperty(Object component, String propertyValue) throws Exception {
        StiReportEdit.setPropertyValue(((StiComponent)component).getReport(), "Type", component, propertyValue);
    }

    public static void setAnchorProperty(Object component, Object propValue) {
        StiComponent comp = (StiComponent)component;
        String propertyValue = (String)propValue;
        StiEnumSet value = StiEnumSet.noneOf(StiAnchorMode.class);
        if (propertyValue.indexOf("Top") >= 0) {
            value.add((IStiEnum)StiAnchorMode.Top);
        }
        if (propertyValue.indexOf("Bottom") >= 0) {
            value.add((IStiEnum)StiAnchorMode.Bottom);
        }
        if (propertyValue.indexOf("Left") >= 0) {
            value.add((IStiEnum)StiAnchorMode.Left);
        }
        if (propertyValue.indexOf("Right") >= 0) {
            value.add((IStiEnum)StiAnchorMode.Right);
        }
        comp.setAnchor(value);
    }

    public static void setImageProperty(StiComponent component, String propValue) throws UnsupportedEncodingException {
        if (StiValidationUtil.isNullOrEmpty((String)propValue)) {
            ((StiImage)component).resetImage();
        } else {
            ((StiImage)component).putImage(propValue.getBytes("UTF-8"));
        }
    }

    public static void setWatermarkImageProperty(StiPage page, String propValue) throws UnsupportedEncodingException {
        if (StiValidationUtil.isNullOrEmpty((String)propValue)) {
            page.getWatermark().resetImage();
        } else {
            page.getWatermark().putImage(propValue.substring(propValue.indexOf("base64,") + 7));
        }
    }

    public static void setStylesProperty(Object component, Object propertyValue, StiReport report) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InstantiationException, ClassNotFoundException, JSONException {
        ArrayList stylesJS = propertyValue instanceof ArrayList ? (ArrayList)propertyValue : null;
        StiStylesCollection stylesProperty = (StiStylesCollection)component.getClass().getMethod("getStyles", new Class[0]).invoke(component, new Object[0]);
        if (stylesJS != null && stylesProperty != null) {
            stylesProperty.clear();
            for (HashMap styleObject : stylesJS) {
                HashMap properties;
                StiBaseStyle style = (StiBaseStyle)Class.forName("com.stimulsoft.report.styles." + styleObject.get("type")).newInstance();
                if (style == null) continue;
                HashMap hashMap = properties = styleObject.get("properties") instanceof HashMap ? (HashMap)styleObject.get("properties") : null;
                if (properties != null && !StiValidationUtil.isNullOrEmpty((String)((String)properties.get("name")))) {
                    style.setName((String)properties.get("name"));
                } else {
                    StiStylesHelper.generateNewName(stylesProperty, style);
                }
                StiStylesHelper.applyStyleProperties(style, properties, report);
                stylesProperty.add((Object)style);
            }
        }
    }

    public static void setExcelValueProperty(Object component, Object propertyValue) {
        block2: {
            propertyValue = StiEncodingHelper.decodeString((String)((String)propertyValue)).replaceAll("\n", "\r\n");
            StiExcelValueExpression excelValue = new StiExcelValueExpression((String)propertyValue);
            try {
                Method method = component.getClass().getMethod("setExcelValue", StiExcelValueExpression.class);
                method.invoke(component, excelValue);
            }
            catch (Exception e) {
                if (StiLoggingUtil.getLogLevel() < 10) break block2;
                e.printStackTrace();
            }
        }
    }

    public static String writeReportInObject(StiReport report) throws Exception {
        StiDesignReportHelper reportHelper = new StiDesignReportHelper(report);
        HashMap<String, Object> reportObject = reportHelper.getReportToObject();
        String result = new JSONObject(reportObject).toString();
        report.getInfo().setZoom(1.0);
        return result;
    }

    public static String writeReportInObject(StiReport report, HashMap attachedItems) throws Exception {
        StiDesignReportHelper reportHelper = new StiDesignReportHelper(report);
        HashMap<String, Object> reportObject = reportHelper.getReportToObject();
        if (reportObject.containsKey("dictionary")) {
            ((HashMap)reportObject.get("dictionary")).put("attachedItems", attachedItems != null ? attachedItems : new HashMap());
        }
        String result = new JSONObject(reportObject).toString();
        report.getInfo().setZoom(1.0);
        return result;
    }

    public static void createComponent(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        report.setIsModified(true);
        String currentPageName = (String)param.get("pageName");
        String typeComponent = (String)param.get("typeComponent");
        String[] componentRect = ((String)param.get("componentRect")).split("!");
        double zoom = StiReportEdit.strToDouble((String)param.get("zoom"));
        StiText newComponent = null;
        if ("StiText".equals(typeComponent)) {
            newComponent = new StiText();
        } else if ("StiTextInCells".equals(typeComponent)) {
            newComponent = new StiTextInCells();
        } else if ("StiRichText".equals(typeComponent)) {
            newComponent = new StiRichText();
        } else if ("StiImage".equals(typeComponent)) {
            newComponent = new StiImage();
        } else if ("StiBarCode".equals(typeComponent)) {
            newComponent = new StiBarCode();
        } else if ("StiShape".equals(typeComponent)) {
            newComponent = new StiShape();
        } else if ("StiPanel".equals(typeComponent)) {
            newComponent = new StiPanel();
        } else if ("StiClone".equals(typeComponent)) {
            newComponent = new StiClone();
        } else if ("StiCheckBox".equals(typeComponent)) {
            newComponent = new StiCheckBox();
        } else if ("StiSubReport".equals(typeComponent)) {
            newComponent = new StiSubReport();
        } else if ("StiZipCode".equals(typeComponent)) {
            newComponent = new StiZipCode();
        } else if ("StiChart".equals(typeComponent)) {
            newComponent = new StiChart();
        } else if ("StiTableCell".equals(typeComponent)) {
            newComponent = new StiTableCell();
        } else if ("StiTableCellImage".equals(typeComponent)) {
            newComponent = new StiTableCellImage();
        } else if ("StiTableCellCheckBox".equals(typeComponent)) {
            newComponent = new StiTableCellCheckBox();
        } else if ("StiTableCellRichText".equals(typeComponent)) {
            newComponent = new StiTableCellRichText();
        } else if ("StiRectanglePrimitive".equals(typeComponent)) {
            newComponent = new StiRectanglePrimitive();
        } else if ("StiRoundedRectanglePrimitive".equals(typeComponent)) {
            newComponent = new StiRoundedRectanglePrimitive();
        } else if ("StiHorizontalLinePrimitive".equals(typeComponent)) {
            newComponent = new StiHorizontalLinePrimitive();
        } else if ("StiVerticalLinePrimitive".equals(typeComponent)) {
            newComponent = new StiVerticalLinePrimitive();
        } else if ("StiReportTitleBand".equals(typeComponent)) {
            newComponent = new StiReportTitleBand();
        } else if ("StiReportSummaryBand".equals(typeComponent)) {
            newComponent = new StiReportSummaryBand();
        } else if ("StiPageHeaderBand".equals(typeComponent)) {
            newComponent = new StiPageHeaderBand();
        } else if ("StiPageFooterBand".equals(typeComponent)) {
            newComponent = new StiPageFooterBand();
        } else if ("StiGroupHeaderBand".equals(typeComponent)) {
            newComponent = new StiGroupHeaderBand();
        } else if ("StiGroupFooterBand".equals(typeComponent)) {
            newComponent = new StiGroupFooterBand();
        } else if ("StiHeaderBand".equals(typeComponent)) {
            newComponent = new StiHeaderBand();
        } else if ("StiFooterBand".equals(typeComponent)) {
            newComponent = new StiFooterBand();
        } else if ("StiColumnHeaderBand".equals(typeComponent)) {
            newComponent = new StiColumnHeaderBand();
        } else if ("StiColumnFooterBand".equals(typeComponent)) {
            newComponent = new StiColumnFooterBand();
        } else if ("StiDataBand".equals(typeComponent)) {
            newComponent = new StiDataBand();
        } else if ("StiTable".equals(typeComponent)) {
            newComponent = new StiTable();
            if (param.containsKey("additionalParams") && param.get("additionalParams") != null) {
                HashMap additionalParams = (HashMap)param.get("additionalParams");
                ((StiTable)newComponent).setRowCount(((Integer)additionalParams.get("rowCount")).intValue());
                ((StiTable)newComponent).setColumnCount(((Integer)additionalParams.get("columnCount")).intValue());
            }
        } else if ("StiHierarchicalBand".equals(typeComponent)) {
            newComponent = new StiHierarchicalBand();
        } else if ("StiChildBand".equals(typeComponent)) {
            newComponent = new StiChildBand();
        } else if ("StiEmptyBand".equals(typeComponent)) {
            newComponent = new StiEmptyBand();
        } else if ("StiOverlayBand".equals(typeComponent)) {
            newComponent = new StiOverlayBand();
        } else if ("StiTableOfContents".equals(typeComponent)) {
            newComponent = new StiTableOfContents();
        } else if ("StiCrossTab".equals(typeComponent)) {
            newComponent = new StiCrossTab();
        } else if ("StiCrossGroupHeaderBand".equals(typeComponent)) {
            newComponent = new StiCrossGroupHeaderBand();
        } else if ("StiCrossGroupFooterBand".equals(typeComponent)) {
            newComponent = new StiCrossGroupFooterBand();
        } else if ("StiCrossHeaderBand".equals(typeComponent)) {
            newComponent = new StiCrossHeaderBand();
        } else if ("StiCrossFooterBand".equals(typeComponent)) {
            newComponent = new StiCrossFooterBand();
        } else if ("StiCrossDataBand".equals(typeComponent)) {
            newComponent = new StiCrossDataBand();
        }
        if (typeComponent.startsWith("Infographic")) {
            newComponent = StiReportEdit.createInfographicComponent(typeComponent);
            if (newComponent != null) {
                typeComponent = newComponent.getClass().getName().substring(newComponent.getClass().getName().lastIndexOf(46) + 1);
            }
        } else if (typeComponent.startsWith("StiShape;")) {
            newComponent = StiReportEdit.createShapeComponent(typeComponent);
            if (newComponent != null) {
                typeComponent = newComponent.getClass().getName().substring(newComponent.getClass().getName().lastIndexOf(".") + 1);
            }
        } else if (typeComponent.startsWith("StiBarCode;") && (newComponent = StiReportEdit.createBarCodeComponent(typeComponent)) != null) {
            typeComponent = newComponent.getClass().getName().substring(newComponent.getClass().getName().lastIndexOf(".") + 1);
        }
        if (newComponent == null) {
            return;
        }
        StiPage currentPage = null;
        for (StiPage page : report.getPages()) {
            if (!StiValidationUtil.equals((Object)page.getName(), (Object)currentPageName)) continue;
            currentPage = page;
        }
        StiReportEdit.addComponentToPage((StiComponent)newComponent, currentPage);
        double compWidth = StiReportEdit.strToDouble(componentRect[2]);
        double compHeight = StiReportEdit.strToDouble(componentRect[3]);
        if (report.getUnit().ConvertToHInches(compWidth) < 10.0 && report.getUnit().ConvertToHInches(compHeight) < 10.0) {
            compWidth = report.getUnit().ConvertFromHInches(newComponent.getDefaultClientRectangle().getSize().getWidth());
            compHeight = report.getUnit().ConvertFromHInches(newComponent.getDefaultClientRectangle().getSize().getHeight());
        }
        StiRectangle compRect = new StiRectangle(StiReportEdit.strToDouble(componentRect[0]), StiReportEdit.strToDouble(componentRect[1]), compWidth, compHeight);
        StiReportEdit.setComponentRect((StiComponent)newComponent, compRect, true);
        if (newComponent instanceof StiCrossLinePrimitive) {
            StiReportEdit.addPrimitivePoints((StiComponent)newComponent, currentPage);
        }
        if (newComponent instanceof StiSubReport) {
            StiReportEdit.addSubReportPage((StiSubReport)newComponent, callbackResult);
        }
        if (param.containsKey("lastStyleProperties") && param.get("lastStyleProperties") != null) {
            StiReportEdit.setAllProperties((StiComponent)newComponent, (ArrayList)param.get("lastStyleProperties"));
        }
        callbackResult.put("name", newComponent.getName());
        callbackResult.put("typeComponent", typeComponent);
        callbackResult.put("componentRect", StiReportEdit.getComponentRect((StiComponent)newComponent));
        callbackResult.put("parentName", StiReportEdit.getParentName((StiComponent)newComponent));
        callbackResult.put("parentIndex", StiReportEdit.fmt(StiReportEdit.getParentIndex((StiComponent)newComponent).intValue()));
        callbackResult.put("componentIndex", StiReportEdit.getComponentIndex((StiComponent)newComponent).toString());
        callbackResult.put("childs", StiReportEdit.getAllChildComponents((StiComponent)newComponent));
        callbackResult.put("svgContent", StiReportEdit.getSvgContent((StiComponent)newComponent, zoom));
        callbackResult.put("pageName", currentPage.getName());
        callbackResult.put("properties", StiReportEdit.getAllProperties((StiComponent)newComponent));
        callbackResult.put("rebuildProps", StiReportEdit.getPropsRebuildPage(report, currentPage));
        callbackResult.put("largeHeightAutoFactor", String.valueOf(currentPage.getLargeHeightAutoFactor()));
        if (newComponent instanceof StiTable) {
            callbackResult.put("tableCells", StiReportEdit.getTableCells((StiTable)newComponent, zoom));
        }
    }

    public static void removeComponent(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws JSONException {
        ArrayList componentNames = (ArrayList)param.get("components");
        report.setIsModified(true);
        StiPage currPage = null;
        for (int i = 0; i < componentNames.size(); ++i) {
            StiComponent currentComponent = report.GetComponentByName((String)componentNames.get(i));
            if (currentComponent == null) continue;
            if (currentComponent instanceof StiCrossLinePrimitive) {
                StiReportEdit.removePrimitivePoints(currentComponent);
            }
            currentComponent.getParent().getComponents().remove((Object)currentComponent);
            currPage = currentComponent.getPage();
            StiReportEdit.checkAllPrimitivePoints(currPage);
        }
        callbackResult.put("rebuildProps", StiReportEdit.getPropsRebuildPage(report, currPage));
        callbackResult.put("pageName", currPage.getName());
        callbackResult.put("largeHeightAutoFactor", String.valueOf(currPage.getLargeHeightAutoFactor()));
    }

    public static void changeRectComponent(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        report.setIsModified(true);
        StiPage currentPage = null;
        for (StiPage page : report.getPages()) {
            if (!StiValidationUtil.equals((Object)page.getName(), (Object)param.get("pageName"))) continue;
            currentPage = page;
        }
        double zoom = StiReportEdit.strToDouble((String)param.get("zoom"));
        ArrayList components = (ArrayList)param.get("components");
        ArrayList componentsResultArray = new ArrayList();
        ArrayList<StiComponent> changedComponents = new ArrayList<StiComponent>();
        String command = (String)param.get("command");
        for (int i = 0; i < components.size(); ++i) {
            HashMap compProps = (HashMap)components.get(i);
            StiComponent currentComponent = report.GetComponentByName((String)compProps.get("componentName"));
            changedComponents.add(currentComponent);
            String[] currentComponentRect = ((String)compProps.get("componentRect")).split("!");
            StiRectangle compRect = new StiRectangle(StiReportEdit.strToDouble(currentComponentRect[0]), StiReportEdit.strToDouble(currentComponentRect[1]), StiReportEdit.strToDouble(currentComponentRect[2]), StiReportEdit.strToDouble(currentComponentRect[3]));
            if (currentComponent instanceof StiTableCell || !report.getInfo().getAlignToGrid() || param.get("runFromProperty") != null) {
                StiReportEdit.setComponentRect(currentComponent, compRect, param.get("isUnplacedComponent") != null ? report.getInfo().getAlignToGrid() : false, "MoveComponent".equals(command) && currentComponent instanceof StiBand);
            } else {
                StiReportEdit.setComponentRectWithOffset(currentComponent, compRect, (String)param.get("command"), (String)param.get("resizeType"), compProps);
            }
            HashMap<String, String> resultProps = new HashMap<String, String>();
            resultProps.put("componentName", currentComponent.getName());
            if ("ResizeComponent".equals(command) || currentComponent.getDockStyle() != StiDockStyle.None) {
                resultProps.put("svgContent", StiReportEdit.getSvgContent(currentComponent, zoom));
            }
            componentsResultArray.add(resultProps);
        }
        if (param.containsKey("moveAfterCopyPaste") && param.get("moveAfterCopyPaste") != null) {
            for (StiComponent component : changedComponents) {
                component.setDockable(true);
            }
        }
        callbackResult.put("components", componentsResultArray);
        callbackResult.put("pageName", currentPage.getName());
        callbackResult.put("rebuildProps", StiReportEdit.getPropsRebuildPage(report, currentPage));
        callbackResult.put("largeHeightAutoFactor", String.valueOf(currentPage.getLargeHeightAutoFactor()));
        callbackResult.put("isMultiResize", param.containsKey("resizeType") && param.get("resizeType") != null && ((String)param.get("resizeType")).startsWith("Multi"));
    }

    public static void addPage(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        report.setIsModified(true);
        StiPage newPage = new StiPage(report);
        int currentPageIndex = Integer.parseInt(String.valueOf(param.get("pageIndex")));
        if (currentPageIndex + 1 == report.getPages().size()) {
            report.getPages().addPage(newPage);
        } else {
            report.getPages().add(currentPageIndex + 1, (Object)newPage);
            newPage.setName(StiNameCreation.createName((StiReport)report, (String)StiNameCreation.generateName((StiComponent)newPage)));
        }
        callbackResult.put("name", newPage.getName());
        callbackResult.put("pageIndex", StiReportEdit.fmt(report.getPages().indexOf((Object)newPage)));
        callbackResult.put("properties", StiReportEdit.getAllProperties((StiComponent)newPage));
        callbackResult.put("pageIndexes", StiReportEdit.getPageIndexes(report));
    }

    public static void removePage(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        report.setIsModified(true);
        StiPage currentPage = null;
        for (StiPage page : report.getPages()) {
            if (!StiValidationUtil.equals((Object)page.getName(), (Object)param.get("pageName"))) continue;
            currentPage = page;
        }
        report.getPages().remove(currentPage);
        callbackResult.put("pageName", currentPage.getName());
        callbackResult.put("pageIndexes", StiReportEdit.getPageIndexes(report));
    }

    public static void readAllPropertiesFromString(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        boolean updateAllControls = (Boolean)param.get("updateAllControls");
        double zoom = StiReportEdit.strToDouble((String)param.get("zoom"));
        StiPage page = null;
        String svgContent = "";
        ArrayList components = (ArrayList)param.get("components");
        ArrayList resultComponents = new ArrayList();
        HashMap<Object, Object> resultProperties = new HashMap();
        for (int i = 0; i < components.size(); ++i) {
            HashMap componentProps = (HashMap)components.get(i);
            String componentType = (String)componentProps.get("typeComponent");
            String componentName = (String)componentProps.get("componentName");
            ArrayList allProperties = (ArrayList)componentProps.get("properties");
            if ("StiPage".equals(componentType)) {
                page = report.getPages().get(componentName);
                if (!componentProps.containsKey("cannotChange")) {
                    StiReportEdit.setAllProperties((StiComponent)page, allProperties);
                }
                resultProperties = StiReportEdit.getAllProperties((StiComponent)page);
                callbackResult.put("rebuildProps", StiReportEdit.getPropsRebuildPage(report, page));
            } else {
                StiComponent component = report.GetComponentByName(componentName);
                if (!componentProps.containsKey("cannotChange")) {
                    StiReportEdit.setAllProperties(component, allProperties);
                }
                if (page == null) {
                    page = component.getPage();
                }
                for (int j = 0; j < allProperties.size(); ++j) {
                    HashMap property = (HashMap)allProperties.get(j);
                    if (!"dockStyle".equals(property.get("name"))) continue;
                    callbackResult.put("rebuildProps", StiReportEdit.getPropsRebuildPage(report, page));
                    break;
                }
                resultProperties = StiReportEdit.getAllProperties(component);
                svgContent = StiReportEdit.getSvgContent(component, zoom);
            }
            HashMap<String, Object> resultCompProps = new HashMap<String, Object>();
            resultComponents.add(resultCompProps);
            resultCompProps.put("typeComponent", componentType);
            resultCompProps.put("componentName", componentName);
            resultCompProps.put("svgContent", svgContent);
            resultCompProps.put("properties", resultProperties);
        }
        callbackResult.put("components", resultComponents);
        callbackResult.put("largeHeightAutoFactor", String.valueOf(page.getLargeHeightAutoFactor()));
        callbackResult.put("pageName", page.getName());
        callbackResult.put("updateAllControls", updateAllControls);
    }

    public static void changeUnit(StiReport report, String unitName) {
        report.setIsModified(true);
        if ("cm".equals(unitName)) {
            report.setReportUnit(StiReportUnitType.Centimeters);
        }
        if ("hi".equals(unitName)) {
            report.setReportUnit(StiReportUnitType.HundredthsOfInch);
        }
        if ("in".equals(unitName)) {
            report.setReportUnit(StiReportUnitType.Inches);
        }
        if ("mm".equals(unitName)) {
            report.setReportUnit(StiReportUnitType.Millimeters);
        }
    }

    public static void getPreviewPages(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws StiException, IOException, SAXException, StiDeserializationException, JSONException {
        try {
            StiReport cloneReport = StiReportEdit.cloneReport(report, false);
            cloneReport.Render(false);
            int countPages = cloneReport.getRenderedPages().size();
            double zoom = StiReportEdit.strToDouble((String)param.get("zoom"));
            int pageNumber = StiReportEdit.strToInt(param.get("pageNumber"));
            if (pageNumber > countPages - 1) {
                pageNumber = countPages - 1;
            }
            callbackResult.put("pageNumber", StiReportEdit.fmt(pageNumber));
            callbackResult.put("countPages", StiReportEdit.fmt(countPages));
            callbackResult.put("pagesArray", StiPreviewHelper.getPages(cloneReport, pageNumber, zoom));
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackResult.put("error", StiLoggingUtil.getHtmlError((String)(e.getClass() + " " + e.getMessage()), (Exception)e));
        }
    }

    private static void loadResourcesToReport(StiReport report, StiResourcesCollection resources) {
        report.dictionary.getResources().clear();
        for (StiResource resource : resources) {
            report.dictionary.getResources().add((Object)resource);
        }
    }

    public static StiReport cloneReport(StiReport report, boolean onlyCompiledReport) throws IOException, SAXException, StiDeserializationException {
        if (onlyCompiledReport) {
            // empty if block
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        StiSerializeManager.serializeReport((StiReport)report, (OutputStream)stream);
        ByteArrayInputStream bis = new ByteArrayInputStream(stream.toByteArray());
        StiReport cloneReport = StiSerializeManager.deserializeReport((InputStream)bis);
        cloneReport.setIsRendered(report.getIsRendered());
        cloneReport.getCustomFunctions().addAll(report.getCustomFunctions());
        stream.close();
        bis.close();
        cloneReport.getInfo().setForceDesigningMode(false);
        try {
            cloneReport.handlerBeginRender.addAll((Collection)report.handlerBeginRender);
            cloneReport.handlerEndRender.addAll((Collection)report.handlerEndRender);
            cloneReport.handlerRendering.addAll((Collection)report.handlerRendering);
            cloneReport.handlerRefreshPreview.addAll((Collection)report.handlerRefreshPreview);
            cloneReport.handlerRefreshViewer.addAll((Collection)report.handlerRefreshViewer);
            cloneReport.handlerExported.addAll((Collection)report.handlerExported);
            cloneReport.handlerExporting.addAll((Collection)report.handlerExporting);
            cloneReport.handlerPaint.addAll((Collection)report.handlerPaint);
            cloneReport.handlerPrinted.addAll((Collection)report.handlerPrinted);
            cloneReport.handlerStatusChanged.addAll((Collection)report.handlerStatusChanged);
            cloneReport.handlerDesignerEvents.addAll((Collection)report.handlerDesignerEvents);
            for (int i = 0; i < report.pages.size(); ++i) {
                cloneReport.getPages().get((int)i).handlerBeginRender.addAll((Collection)report.getPages().get((int)i).handlerBeginRender);
                cloneReport.getPages().get((int)i).handlerRendering.addAll((Collection)report.getPages().get((int)i).handlerRendering);
                cloneReport.getPages().get((int)i).handlerEndRender.addAll((Collection)report.getPages().get((int)i).handlerEndRender);
                cloneReport.getPages().get((int)i).handlerOnColumnBeginRender.addAll((Collection)report.getPages().get((int)i).handlerOnColumnBeginRender);
                cloneReport.getPages().get((int)i).handlerOnColumnEndRender.addAll((Collection)report.getPages().get((int)i).handlerOnColumnEndRender);
                cloneReport.getPages().get((int)i).handlerOnGetExcelSheet.addAll((Collection)report.getPages().get((int)i).handlerOnGetExcelSheet);
            }
            StiComponentsCollection clonedComponents = cloneReport.GetComponents();
            for (StiComponent component : report.GetComponents()) {
                if (!(component instanceof StiSubReport)) continue;
                StiSubReport subReport = (StiSubReport)component;
                ((StiSubReport)clonedComponents.get((String)subReport.getName())).handlerBeforeRenderSubReport.addAll((Collection)subReport.handlerBeforeRenderSubReport);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cloneReport;
    }

    public static StiPage getPageByName(StiReport report, String name) {
        for (StiPage page : report.getPages()) {
            if (!StiValidationUtil.equals((Object)name, (Object)page.getName())) continue;
            return page;
        }
        return null;
    }

    public static void getAllSvgContents(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        StiPage currentPage = StiReportEdit.getPageByName(report, (String)param.get("pageName"));
        String[] componentsArray = ((String)param.get("components")).split(";");
        double zoom = StiReportEdit.strToDouble((String)param.get("zoom"));
        String svgContent = "";
        HashMap<String, String> svgContents = new HashMap<String, String>();
        StiComponentsCollection components = currentPage.GetComponents();
        for (int i = 0; i < componentsArray.length; ++i) {
            StiComponent component = components.get(componentsArray[i]);
            if (component == null) continue;
            svgContent = StiReportEdit.getSvgContent(component, zoom);
            svgContents.put(component.getName(), svgContent.startsWith(StiEncodingHelper.encode((String)"SVG")) ? "" : svgContent);
        }
        callbackResult.put("svgContents", svgContents);
        callbackResult.put("pageName", currentPage.getName());
    }

    public static void copyReportDictionary(StiReport reportFrom, StiReport reportTo) {
        reportTo.getDictionary().getDataStore().clear();
        reportTo.getDictionary().getDataSources().clear();
        reportTo.getDictionary().getDatabases().clear();
        reportTo.getDictionary().getRelations().clear();
        reportTo.getDictionary().getVariables().clear();
        reportTo.getDictionary().getRestrictions().Clear();
        if (DesignerOptions.NewReport.getAllowRegisterDatabasesFromOldReportInNewReport()) {
            for (StiDatabase db : reportFrom.getDictionary().getDatabases()) {
                if (db instanceof StiXmlDatabase) {
                    StiResource resource;
                    StiXmlDatabase xmlDB = (StiXmlDatabase)db;
                    if (StiValidationUtil.isNotNullOrEmpty((String)xmlDB.getPathData()) && xmlDB.getPathData().indexOf("resource") >= 0 && (resource = reportFrom.getDictionary().getResources().get(StiHyperlinkProcessor.getResourceNameFromHyperlink((String)xmlDB.getPathData()))) != null) {
                        reportTo.getDictionary().getResources().add((Object)resource);
                    }
                    if (StiValidationUtil.isNotNullOrEmpty((String)xmlDB.getPathSchema()) && xmlDB.getPathSchema().indexOf("resource") >= 0 && (resource = reportFrom.getDictionary().getResources().get(StiHyperlinkProcessor.getResourceNameFromHyperlink((String)xmlDB.getPathSchema()))) != null) {
                        reportTo.getDictionary().getResources().add((Object)resource);
                    }
                }
                reportTo.getDictionary().getDatabases().add((Object)db);
            }
        }
        if (DesignerOptions.NewReport.getAllowRegisterDataSourcesFromOldReportInNewReport()) {
            for (StiDataSource dataSource : reportFrom.getDictionary().getDataSources()) {
                dataSource.setDictionary(reportTo.getDictionary());
                reportTo.getDictionary().getDataSources().add((Object)dataSource);
            }
        }
        if (DesignerOptions.NewReport.getAllowRegisterRelationsFromOldReportInNewReport()) {
            for (StiDataRelation relation : reportFrom.getDictionary().getRelations()) {
                relation.setDictionary(reportTo.getDictionary());
                reportTo.getDictionary().getRelations().add(relation);
            }
        }
        if (DesignerOptions.NewReport.getAllowRegisterVariablesFromOldReportInNewReport()) {
            reportTo.getDictionary().getVariables().addAll((Collection)reportFrom.getDictionary().getVariables());
        }
        if (DesignerOptions.NewReport.getAllowRegisterRestrictionsFromOldReportInNewReport()) {
            reportTo.getDictionary().setRestrictions(reportFrom.getDictionary().getRestrictions());
        }
        reportTo.tag = reportFrom.tag;
    }

    public static void setToClipboard(StiHttpServletRequest httpContext, StiRequestParams requestParams, StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws JSONException {
        ArrayList componentNames = (ArrayList)param.get("components");
        StiPage currentPage = report.getPages().get((String)param.get("pageName"));
        Iterator iterator = report.getComponents().iterator();
        while (iterator.hasNext()) {
            StiComponent component;
            component.setIsSelected(componentNames.contains((component = (StiComponent)iterator.next()).getName()));
        }
        StiGroup group = StiGroup.getGroupFromPage(currentPage);
        StiCacheHelper.saveObjectInternal((Object)group.toString("StiReport Clipboard"), (StiRequestParams)requestParams, (String)"clipboard", (StiHttpServletRequest)httpContext);
        for (StiComponent component : report.getComponents()) {
            component.setIsSelected(false);
        }
    }

    public static void getFromClipboard(StiHttpServletRequest httpContext, StiRequestParams requestParams, StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        String text = (String)StiCacheHelper.getObjectInternal((StiRequestParams)requestParams, (String)"clipboard", (StiHttpServletRequest)httpContext);
        StiGroup group = StiGroup.createFromString(text, "StiReport Clipboard");
        StiPage currentPage = report.getPages().get((String)param.get("pageName"));
        double zoom = StiReportEdit.strToDouble((String)param.get("zoom"));
        StiInsertionComponents.insertGroups(currentPage, group);
        ArrayList components = new ArrayList();
        for (StiComponent component : group.GetComponents()) {
            if (component instanceof StiCrossLinePrimitive) {
                StiReportEdit.addPrimitivePoints(component, currentPage);
            }
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("name", component.getName());
            attributes.put("typeComponent", component.getClass().getName().substring(component.getClass().getName().lastIndexOf(46) + 1));
            attributes.put("componentRect", StiReportEdit.getComponentRect(component));
            attributes.put("parentName", StiReportEdit.getParentName(component));
            attributes.put("parentIndex", StiReportEdit.getParentIndex(component).toString());
            attributes.put("componentIndex", StiReportEdit.getComponentIndex(component).toString());
            attributes.put("childs", StiReportEdit.getAllChildComponents(component));
            attributes.put("svgContent", StiReportEdit.getSvgContent(component, zoom));
            attributes.put("pageName", currentPage.getName());
            attributes.put("properties", StiReportEdit.getAllProperties(component));
            attributes.put("largeHeightAutoFactor", String.valueOf(currentPage.getLargeHeightAutoFactor()));
            components.add(attributes);
        }
        callbackResult.put("rebuildProps", StiReportEdit.getPropsRebuildPage(report, currentPage));
        callbackResult.put("components", components);
    }

    public static void addReportToUndoArray(StiHttpServletRequest httpContext, StiRequestParams requestParams, StiReport report) throws IOException, SAXException, StiDeserializationException {
        StiReportEdit.addReportToUndoArray(httpContext, requestParams, report, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addReportToUndoArray(StiHttpServletRequest httpContext, StiRequestParams requestParams, StiReport report, boolean withResources) throws IOException, SAXException, StiDeserializationException {
        try {
            ArrayList<Integer> undoArray = (ArrayList<Integer>)StiCacheHelper.getObjectInternal((StiRequestParams)requestParams, (String)"undo", (StiHttpServletRequest)httpContext);
            if (undoArray == null || undoArray.size() == 0) {
                undoArray = new ArrayList<Integer>();
                undoArray.add(1);
                undoArray.add(null);
            }
            ArrayList<Integer> arrayList = undoArray;
            synchronized (arrayList) {
                StiReport cloneReport = StiReportEdit.cloneReport(report, withResources);
                Integer currentPos = (Integer)undoArray.get(0);
                undoArray.add(currentPos, (Integer)new StiReportContainer(cloneReport, withResources, requestParams.designer.command));
                Integer n = currentPos;
                Integer n2 = currentPos = Integer.valueOf(currentPos + 1);
                undoArray.set(0, currentPos);
                if (undoArray.size() > currentPos + 1) {
                    undoArray.removeAll(undoArray.subList(currentPos, undoArray.size()));
                    undoArray.add(null);
                }
                if (undoArray.size() > requestParams.designer.undoMaxLevel + 2) {
                    undoArray.remove(1);
                    if (currentPos != 1) {
                        undoArray.remove(0);
                        undoArray.add(0, currentPos - 1);
                    }
                }
                StiCacheHelper.saveObjectInternal(undoArray, (StiRequestParams)requestParams, (String)"undo", (StiHttpServletRequest)httpContext);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void clearUndoArray(StiHttpServletRequest httpContext, StiRequestParams requestParams) {
        StiCacheHelper.saveObjectInternal(new ArrayList(), (StiRequestParams)requestParams, (String)"undo", (StiHttpServletRequest)httpContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StiReport getUndoStep(StiHttpServletRequest httpContext, StiRequestParams requestParams, StiReport currentReport, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        List undoArray = (List)StiCacheHelper.getObjectInternal((StiRequestParams)requestParams, (String)"undo", (StiHttpServletRequest)httpContext);
        if (undoArray != null) {
            List list = undoArray;
            synchronized (list) {
                int currentPos = (Integer)undoArray.get(0);
                if (currentPos == undoArray.size() - 1) {
                    undoArray.remove(currentPos);
                    undoArray.add(currentPos, new StiReportContainer(StiReportEdit.cloneReport(currentReport, true), true, StiDesignerCommand.Undo));
                }
                if (currentPos > 1) {
                    --currentPos;
                }
                StiReportContainer reportContainer = (StiReportContainer)undoArray.get(currentPos);
                StiReport report = reportContainer.report;
                report.getInfo().setZoom(StiReportEdit.strToDouble((String)param.get("zoom")));
                report.getInfo().setForceDesigningMode(true);
                if (param.containsKey("reportFile") && param.get("reportFile") != null) {
                    report.setReportFile((String)param.get("reportFile"));
                }
                if (!reportContainer.resourcesIncluded) {
                    StiReportEdit.loadResourcesToReport(report, currentReport.getDictionary().getResources());
                }
                currentReport = report;
                callbackResult.put("reportObject", StiReportEdit.writeReportInObject(report));
                callbackResult.put("reportGuid", requestParams.cache.clientGuid);
                callbackResult.put("enabledUndoButton", currentPos > 1);
                undoArray.remove(0);
                undoArray.add(0, currentPos);
                StiCacheHelper.saveObjectInternal((Object)undoArray, (StiRequestParams)requestParams, (String)"undo", (StiHttpServletRequest)httpContext);
            }
        }
        callbackResult.put("selectedObjectName", param.get("selectedObjectName"));
        return currentReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StiReport getRedoStep(StiHttpServletRequest httpContext, StiRequestParams requestParams, StiReport currentReport, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        List undoArray = (List)StiCacheHelper.getObjectInternal((StiRequestParams)requestParams, (String)"undo", (StiHttpServletRequest)httpContext);
        if (undoArray != null) {
            List list = undoArray;
            synchronized (list) {
                int currentPos = (Integer)undoArray.get(0);
                if (currentPos + 1 < undoArray.size()) {
                    ++currentPos;
                }
                StiReportContainer reportContainer = (StiReportContainer)undoArray.get(currentPos);
                StiReport report = reportContainer.report;
                report.getInfo().setZoom(StiReportEdit.strToDouble((String)param.get("zoom")));
                report.getInfo().setForceDesigningMode(true);
                if (param.containsKey("reportFile") && param.get("reportFile") != null) {
                    report.setReportFile((String)param.get("reportFile"));
                }
                if (!reportContainer.resourcesIncluded) {
                    // empty if block
                }
                callbackResult.put("reportObject", StiReportEdit.writeReportInObject(report));
                callbackResult.put("enabledRedoButton", currentPos + 1 < undoArray.size());
                currentReport = report;
                callbackResult.put("reportGuid", requestParams.cache.clientGuid);
                undoArray.remove(0);
                undoArray.add(0, currentPos);
                StiCacheHelper.saveObjectInternal((Object)undoArray, (StiRequestParams)requestParams, (String)"undo", (StiHttpServletRequest)httpContext);
            }
        }
        callbackResult.put("selectedObjectName", param.get("selectedObjectName"));
        return currentReport;
    }

    public static void renameComponent(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        String typeComponent = (String)param.get("typeComponent");
        String oldName = (String)param.get("oldName");
        String newName = (String)param.get("newName");
        if ("StiPage".equals(typeComponent)) {
            StiPage page = StiReportEdit.getPageByName(report, oldName);
            if (StiReportEdit.getPageByName(report, newName) == null) {
                page.setName(newName);
                callbackResult.put("rebuildProps", StiReportEdit.getPropsRebuildPage(report, page));
            } else {
                newName = oldName;
            }
        } else {
            StiComponent component = report.GetComponentByName(oldName);
            if (report.GetComponentByName(newName) == null) {
                component.setName(newName);
                callbackResult.put("rebuildProps", StiReportEdit.getPropsRebuildPage(report, component.getPage()));
                newName = component.getName();
            } else {
                newName = oldName;
            }
        }
        callbackResult.put("typeComponent", typeComponent);
        callbackResult.put("oldName", oldName);
        callbackResult.put("newName", newName);
    }

    public static void saveComponentClone(StiHttpServletRequest httpContext, StiRequestParams requestParams, StiComponent component) {
        StiComponent cloneComponent = StiComponentHelper.clone((StiComponent)component);
        cloneComponent.setParent(null);
        cloneComponent.setPage(null);
        if (cloneComponent instanceof StiCrossTab) {
            StiCrossTab crossTab = (StiCrossTab)cloneComponent;
            for (StiComponent field : crossTab.getComponents()) {
                field.setPage(null);
                field.setParent(null);
            }
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        component.setReference(0);
        StiSerializerControler.serializeDocument((IStiSerializableRef)component, (OutputStream)bos);
        byte[] res = bos.toByteArray();
        StiCacheHelper.saveObjectInternal((Object)new String(res, Charset.forName("UTF-8")), (StiRequestParams)requestParams, (String)"clone", (StiHttpServletRequest)httpContext);
    }

    public static void canceledEditComponent(StiHttpServletRequest httpContext, StiRequestParams requestParams, StiReport currentReport, HashMap param) {
        StiComponent currentComponent = currentReport.GetComponentByName((String)param.get("componentName"));
        if (currentComponent == null) {
            return;
        }
        StiChart cloneComponent = null;
        if (currentComponent instanceof StiChart) {
            cloneComponent = new StiChart();
        } else if (currentComponent instanceof StiCrossTab) {
            cloneComponent = new StiCrossTab();
        } else if (currentComponent instanceof StiGauge) {
            cloneComponent = new StiGauge();
        } else if (currentComponent instanceof StiMap) {
            cloneComponent = new StiMap();
        }
        if (cloneComponent == null) {
            return;
        }
        String com = (String)StiCacheHelper.getObjectInternal((StiRequestParams)requestParams, (String)"clone", (StiHttpServletRequest)httpContext);
        cloneComponent = (StiComponent)StiDeserializerControler.deserializeDocument((InputStream)new ByteArrayInputStream(com.getBytes(Charset.forName("UTF-8"))), cloneComponent.getClass());
        cloneComponent.setReference(-1);
        cloneComponent.setParent(currentComponent.getParent());
        cloneComponent.setPage(currentComponent.getPage());
        if (cloneComponent instanceof StiCrossTab) {
            StiCrossTab crossTab = (StiCrossTab)cloneComponent;
            crossTab.getComponents().SetParent((StiContainer)crossTab);
            for (StiComponent field : crossTab.getComponents()) {
                field.setPage(currentComponent.getPage());
            }
        }
        StiContainer parent = currentComponent.getParent();
        currentComponent.getParent().getComponents().remove((Object)currentComponent);
        parent.getComponents().add((StiComponent)cloneComponent);
    }

    public static void createTextComponentFromDictionary(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        int countComponents;
        report.setIsModified(true);
        String currentPageName = (String)param.get("pageName");
        double zoom = StiReportEdit.strToDouble((String)param.get("zoom"));
        HashMap point = (HashMap)param.get("point");
        HashMap itemObject = (HashMap)param.get("itemObject");
        ArrayList newComponents = new ArrayList();
        boolean isParameter = "Parameter".equals(itemObject.get("typeItem"));
        boolean createLabel = param.containsKey("createLabel") && param.get("createLabel") != null && (Boolean)param.get("createLabel") != false;
        StiPage currentPage = report.getPages().get(currentPageName);
        StiText sampleComp = new StiText();
        double compWidth = report.getUnit().ConvertFromHInches(sampleComp.getDefaultClientRectangle().getSize().width);
        double compHeight = report.getUnit().ConvertFromHInches(sampleComp.getDefaultClientRectangle().getSize().height);
        double comp1XPos = StiReportEdit.strToDouble((String)point.get("x"));
        double comp2XPos = comp1XPos + compWidth * 2.0;
        double compYPos = StiReportEdit.strToDouble((String)point.get("y"));
        int n = countComponents = isParameter || !createLabel ? 1 : 2;
        if (countComponents == 1) {
            if (comp1XPos + currentPage.getMargins().getLeft() + compWidth * 2.0 > currentPage.getPageWidth()) {
                comp1XPos = currentPage.getPageWidth() - currentPage.getMargins().getLeft() - compWidth * 2.0;
            }
        } else if (countComponents == 2 && comp2XPos + currentPage.getMargins().getLeft() + compWidth > currentPage.getPageWidth()) {
            comp2XPos = currentPage.getPageWidth() - currentPage.getMargins().getLeft() - compWidth;
            comp1XPos = comp2XPos - compWidth * 2.0;
        }
        for (int i = 0; i < countComponents; ++i) {
            StiText newComponent = new StiText();
            StiReportEdit.addComponentToPage((StiComponent)newComponent, currentPage);
            StiRectangle compRect = new StiRectangle(new StiPoint(i == 0 ? comp1XPos : comp2XPos, compYPos), new StiSize(i == 0 ? compWidth * 2.0 : compWidth, compHeight));
            StiReportEdit.setComponentRect((StiComponent)newComponent, compRect, true);
            newComponent.setText(isParameter || !createLabel || createLabel && i != 0 ? StiEncodingHelper.decodeString((String)((String)itemObject.get("fullName"))) : (String)itemObject.get("name"));
            if (param.get("lastStyleProperties") != null) {
                StiReportEdit.setAllProperties((StiComponent)newComponent, (ArrayList)param.get("lastStyleProperties"));
            }
            HashMap<String, Object> componentProps = new HashMap<String, Object>();
            componentProps.put("name", newComponent.getName());
            componentProps.put("typeComponent", "StiText");
            componentProps.put("componentRect", StiReportEdit.getComponentRect((StiComponent)newComponent));
            componentProps.put("parentName", StiReportEdit.getParentName((StiComponent)newComponent));
            componentProps.put("parentIndex", StiReportEdit.getParentIndex((StiComponent)newComponent));
            componentProps.put("componentIndex", StiReportEdit.getComponentIndex((StiComponent)newComponent).toString());
            componentProps.put("childs", StiReportEdit.getAllChildComponents((StiComponent)newComponent));
            componentProps.put("svgContent", StiReportEdit.getSvgContent((StiComponent)newComponent, zoom));
            componentProps.put("pageName", currentPage.getName());
            componentProps.put("properties", StiReportEdit.getAllProperties((StiComponent)newComponent));
            componentProps.put("rebuildProps", StiReportEdit.getPropsRebuildPage(report, currentPage));
            newComponents.add(componentProps);
        }
        callbackResult.put("newComponents", newComponents);
    }

    public static void createComponentFromResource(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        report.setIsModified(true);
        String currentPageName = (String)param.get("pageName");
        double zoom = StiReportEdit.strToDouble((String)param.get("zoom"));
        HashMap point = (HashMap)param.get("point");
        HashMap itemObject = (HashMap)param.get("itemObject");
        StiPage currentPage = report.getPages().get(currentPageName);
        StiSubReport newComponent = null;
        String typeItem = (String)itemObject.get("typeItem");
        String typeResource = (String)itemObject.get("type");
        if ("Resource".equals(typeItem) && ("Report".equals(typeResource) || "ReportSnapshot".equals(typeResource))) {
            newComponent = new StiSubReport();
            newComponent.setSubReportUrl(StiHyperlinkProcessor.createResourceName((String)((String)itemObject.get("name"))));
        } else if ("Resource".equals(typeItem) && "Rtf".equals(typeResource)) {
            newComponent = new StiRichText();
        } else {
            newComponent = new StiImage();
            if ("Variable".equals(typeItem) && itemObject.get("name") != null) {
                ((StiImage)newComponent).setImageData(new StiImageDataExpression("{" + itemObject.get("name") + "}"));
            } else if (typeItem == "Column" && itemObject.get("fullName") != null) {
                String dataColumn = StiEncodingHelper.decodeString((String)((String)itemObject.get("fullName")));
                if (dataColumn.startsWith("{") && dataColumn.endsWith("}")) {
                    dataColumn = dataColumn.substring(1, dataColumn.length() - 1);
                }
                ((StiImage)newComponent).setDataColumn(dataColumn);
            } else {
                ((StiImage)newComponent).setImageURL(new StiImageURLExpression(StiHyperlinkProcessor.createResourceName((String)((String)itemObject.get("name")))));
            }
        }
        double compWidth = report.getUnit().ConvertFromHInches(newComponent.getDefaultClientRectangle().getSize().getWidth());
        double compHeight = report.getUnit().ConvertFromHInches(newComponent.getDefaultClientRectangle().getSize().getHeight());
        double compXPos = StiReportEdit.strToDouble((String)point.get("x"));
        double compYPos = StiReportEdit.strToDouble((String)point.get("y"));
        if (compXPos + currentPage.getMargins().getLeft() + compWidth * 2.0 > currentPage.getPageWidth()) {
            compXPos = currentPage.getPageWidth() - currentPage.getMargins().getLeft() - compWidth * 2.0;
        }
        StiReportEdit.addComponentToPage((StiComponent)newComponent, currentPage);
        StiRectangle compRect = new StiRectangle(new StiPoint(compXPos, compYPos), new StiSize(compWidth, compHeight));
        StiReportEdit.setComponentRect((StiComponent)newComponent, compRect, true);
        if (param.get("lastStyleProperties") != null) {
            StiReportEdit.setAllProperties((StiComponent)newComponent, (ArrayList)param.get("lastStyleProperties"));
        }
        HashMap<String, Object> componentProps = new HashMap<String, Object>();
        componentProps.put("name", newComponent.getName());
        componentProps.put("typeComponent", newComponent.getClass().getName().substring(newComponent.getClass().getName().lastIndexOf(".") + 1));
        componentProps.put("componentRect", StiReportEdit.getComponentRect((StiComponent)newComponent));
        componentProps.put("parentName", StiReportEdit.getParentName((StiComponent)newComponent));
        componentProps.put("parentIndex", StiReportEdit.getParentIndex((StiComponent)newComponent).toString());
        componentProps.put("componentIndex", StiReportEdit.getComponentIndex((StiComponent)newComponent).toString());
        componentProps.put("childs", StiReportEdit.getAllChildComponents((StiComponent)newComponent));
        componentProps.put("svgContent", StiReportEdit.getSvgContent((StiComponent)newComponent, zoom));
        componentProps.put("pageName", currentPage.getName());
        componentProps.put("properties", StiReportEdit.getAllProperties((StiComponent)newComponent));
        componentProps.put("rebuildProps", StiReportEdit.getPropsRebuildPage(report, currentPage));
        callbackResult.put("newComponent", componentProps);
    }

    private static double alignToMaxGrid(StiPage page, double value, boolean converted) {
        if (converted) {
            value = page.getUnit().ConvertFromHInches(value);
        }
        return StiAlignValue.alignToMaxGrid((double)value, (double)page.getGridSize(), (boolean)page.getReport().getInfo().getAlignToGrid());
    }

    private static double alignToGrid(StiPage page, double value, boolean converted) {
        if (converted) {
            value = page.getUnit().ConvertFromHInches(value);
        }
        return StiAlignValue.alignToGrid((double)value, (double)page.getGridSize(), (boolean)page.getReport().getInfo().getAlignToGrid());
    }

    public static void createDataComponentFromDictionary(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        report.setIsModified(true);
        String currentPageName = (String)param.get("pageName");
        HashMap point = (HashMap)param.get("point");
        HashMap dataSource = (HashMap)param.get("dataSource");
        HashMap settings = (HashMap)param.get("settings");
        ArrayList columns = (ArrayList)param.get("columns");
        StiPage currentPage = report.getPages().get(currentPageName);
        StiPoint cursorPoint = new StiPoint(StiReportEdit.strToDouble((String)point.get("x")), StiReportEdit.strToDouble((String)point.get("y")));
        if (((Boolean)settings.get("data")).booleanValue() || columns.size() == 0) {
            StiDataBand dataBand = new StiDataBand();
            String dataSourceName = (String)dataSource.get("name");
            dataBand.setName("Data" + StiNameValidator.CorrectName((String)dataSourceName));
            dataBand.setName(StiNameCreation.createName((StiReport)report, (String)dataBand.getName(), (boolean)false, (boolean)false, (boolean)true));
            StiReportEdit.addComponentToPage((StiComponent)dataBand, currentPage);
            double compWidth = report.getUnit().ConvertFromHInches(dataBand.getDefaultClientRectangle().getSize().getWidth());
            double compHeight = report.getUnit().ConvertFromHInches(dataBand.getDefaultClientRectangle().getSize().getHeight());
            StiRectangle compRect = new StiRectangle(cursorPoint.x, cursorPoint.y, compWidth, compHeight);
            StiReportEdit.setComponentRect((StiComponent)dataBand, compRect, true);
            if ("DataSource".equals(dataSource.get("typeItem"))) {
                StiReportEdit.setDataSourceProperty(dataBand, dataSourceName);
            } else {
                StiReportEdit.setBusinessObjectProperty(dataBand, dataSource.get("fullName"));
            }
            double width = dataBand.getParent() instanceof StiPage ? dataBand.getPage().getColumnWidth2() : dataBand.getParent().getWidth();
            StiHeaderBand headerBand = null;
            if (((Boolean)settings.get("header")).booleanValue()) {
                headerBand = new StiHeaderBand();
                String baseName = dataBand.getReport().getInfo().getGenerateLocalizedName() ? headerBand.getLocalizedName() + dataSourceName : "Header" + dataSourceName;
                headerBand.setName(StiNameCreation.createName((StiReport)dataBand.getReport(), (String)StiNameValidator.CorrectName((String)baseName), (boolean)false, (boolean)false, (boolean)true));
                headerBand.setHeight(StiReportEdit.alignToMaxGrid(dataBand.getPage(), 30.0, true));
                int index = dataBand.getParent().getComponents().indexOf((Object)dataBand);
                dataBand.getParent().getComponents().add(index, (StiComponent)headerBand);
            }
            StiFooterBand footerBand = null;
            if (((Boolean)settings.get("footer")).booleanValue()) {
                footerBand = new StiFooterBand();
                String baseName = dataBand.getReport().getInfo().getGenerateLocalizedName() ? footerBand.getLocalizedName() + dataSourceName : "Footer" + dataSourceName;
                footerBand.setName(StiNameCreation.createName((StiReport)dataBand.getReport(), (String)StiNameValidator.CorrectName((String)baseName), (boolean)false, (boolean)false, (boolean)true));
                footerBand.setHeight(StiReportEdit.alignToMaxGrid(dataBand.getPage(), 30.0, true));
                int index = dataBand.getParent().getComponents().indexOf((Object)dataBand);
                dataBand.getParent().getComponents().add(index + 1, (StiComponent)footerBand);
            }
            double columnWidth = StiReportEdit.alignToGrid(dataBand.getPage(), width / (double)columns.size(), false);
            if (!(dataBand.getParent() instanceof StiPage)) {
                columnWidth = StiReportEdit.alignToGrid(dataBand.getPage(), width / (double)columns.size(), false);
            }
            double pos = 0.0;
            int indexNode = 1;
            for (int i = 0; i < columns.size(); ++i) {
                String baseName2;
                StiDataColumn dataColumn;
                HashMap columnObject = (HashMap)columns.get(i);
                String columnName = (String)columnObject.get("fullName");
                if (indexNode == columns.size() && (columnWidth = StiReportEdit.alignToGrid(dataBand.getPage(), width - pos, false)) <= 0.0) {
                    columnWidth = dataBand.getPage().getGridSize();
                }
                if (((Boolean)settings.get("header")).booleanValue()) {
                    StiText headerText = new StiText();
                    headerText.setVertAlignment(StiVertAlignment.Center);
                    headerText.setFont(new StiFont("Arial", 10.0, StiFontStyle.Bold));
                    String baseName = dataBand.getReport().getInfo().getGenerateLocalizedName() ? headerBand.getLocalizedName() + columnName : "Header" + columnName;
                    headerText.setName(StiNameCreation.createName((StiReport)dataBand.getReport(), (String)StiNameValidator.CorrectName((String)baseName), (boolean)false, (boolean)false, (boolean)true));
                    headerText.setTop(0.0);
                    headerText.setLeft(pos);
                    headerText.setWidth(columnWidth);
                    headerText.setHeight(headerBand.getHeight());
                    headerText.setWordWrap(true);
                    int index = columnName.lastIndexOf(46);
                    StiDataColumn column = StiDataBuilder.getColumnFromPath((String)columnName, (StiDictionary)dataBand.getReport().getDictionary());
                    if (column != null) {
                        headerText.setText(column.getAlias());
                    } else if (index == -1) {
                        headerText.setText(columnName);
                    } else {
                        headerText.setText(columnName.substring(index + 1));
                    }
                    headerBand.getComponents().add((StiComponent)headerText);
                }
                if ((dataColumn = StiDataBuilder.getColumnFromPath((String)columnName, (StiDictionary)dataBand.getReport().getDictionary())) != null && (dataColumn.getType() == StiSystemTypeEnum.SystemDrawingBitmap || dataColumn.getType() == StiSystemTypeEnum.SystemDrawingImage || dataColumn.getType() == StiSystemTypeEnum.SystemByteArray)) {
                    StiImage dataImage = new StiImage();
                    baseName2 = dataBand.getReport().getInfo().getGenerateLocalizedName() ? dataBand.getLocalizedName() + columnName : "Data" + columnName;
                    dataImage.setName(StiNameCreation.createName((StiReport)dataBand.getReport(), (String)StiNameValidator.CorrectName((String)baseName2), (boolean)false, (boolean)false, (boolean)true));
                    dataImage.setTop(0.0);
                    dataImage.setLeft(pos);
                    dataImage.setWidth(columnWidth);
                    dataImage.setHeight(dataBand.getHeight());
                    dataImage.setDataColumn(columnName);
                    dataImage.setCanGrow(true);
                    dataBand.getComponents().add((StiComponent)dataImage);
                } else if (dataColumn != null && dataColumn.getType() == StiSystemTypeEnum.SystemBoolean) {
                    StiCheckBox dataCheck = new StiCheckBox();
                    baseName2 = dataBand.getReport().getInfo().getGenerateLocalizedName() ? dataBand.getLocalizedName() + columnName : "Data" + columnName;
                    dataCheck.setName(StiNameCreation.createName((StiReport)dataBand.getReport(), (String)StiNameValidator.CorrectName((String)baseName2), (boolean)false, (boolean)false, (boolean)true));
                    dataCheck.setTop(0.0);
                    dataCheck.setLeft(pos);
                    dataCheck.setWidth(columnWidth);
                    dataCheck.setHeight(dataBand.getHeight());
                    dataCheck.getChecked().setValue("{" + columnName + "}");
                    dataBand.getComponents().add((StiComponent)dataCheck);
                } else {
                    StiText dataText = new StiText();
                    baseName2 = dataBand.getReport().getInfo().getGenerateLocalizedName() ? dataBand.getLocalizedName() + columnName : "Data" + columnName;
                    dataText.setName(StiNameCreation.createName((StiReport)dataBand.getReport(), (String)StiNameValidator.CorrectName((String)baseName2), (boolean)false, (boolean)false, (boolean)true));
                    dataText.setVertAlignment(StiVertAlignment.Center);
                    dataText.setTop(0.0);
                    dataText.setLeft(pos);
                    dataText.setWidth(columnWidth);
                    dataText.setHeight(dataBand.getHeight());
                    dataText.setText("{" + columnName + "}");
                    dataText.setCanGrow(true);
                    dataText.setWordWrap(true);
                    dataBand.getComponents().add((StiComponent)dataText);
                }
                if (((Boolean)settings.get("footer")).booleanValue()) {
                    StiText footerText = new StiText();
                    footerText.setVertAlignment(StiVertAlignment.Center);
                    footerText.setHorAlignment(StiTextHorAlignment.Right);
                    footerText.setFont(new StiFont("Arial", 10.0, StiFontStyle.Bold));
                    footerText.setName(StiNameCreation.createName((StiReport)dataBand.getReport(), (String)StiNameValidator.CorrectName((String)("Footer" + columnName)), (boolean)false, (boolean)false, (boolean)true));
                    footerText.setTop(0.0);
                    footerText.setLeft(pos);
                    footerText.setWidth(columnWidth);
                    footerText.setHeight(footerBand.getHeight());
                    footerText.setWordWrap(true);
                    footerBand.getComponents().add((StiComponent)footerText);
                }
                pos += columnWidth;
                ++indexNode;
            }
            if (param.get("theme") != null && param.get("theme") != null) {
                HashMap themeProps = (HashMap)param.get("theme");
                StiStylesCollection stylesCollection = new StiStylesCollection();
                if ("Default".equals(themeProps.get("type"))) {
                    String[] themeArray = ((String)themeProps.get("name")).split("_");
                    StiColor colorBase = new StiColor();
                    String themeName = "";
                    String themeColor = themeArray[0];
                    int themePercent = Integer.parseInt(themeArray[1]);
                    if ("Red".equals(themeArray[0])) {
                        colorBase = StiColor.fromArgb((int)144, (int)60, (int)57);
                        themeName = StiLocalization.Get((String)"PropertyColor", (String)"Red");
                    } else if ("Green".equals(themeArray[0])) {
                        colorBase = StiColor.fromArgb((int)117, (int)140, (int)72);
                        themeName = StiLocalization.Get((String)"PropertyColor", (String)"Green");
                    } else if ("Blue".equals(themeArray[0])) {
                        colorBase = StiColor.fromArgb((int)69, (int)98, (int)135);
                        themeName = StiLocalization.Get((String)"PropertyColor", (String)"Blue");
                    } else if ("Gray".equals(themeArray[0])) {
                        colorBase = StiColor.fromArgb((int)75, (int)75, (int)75);
                        themeName = StiLocalization.Get((String)"PropertyColor", (String)"Gray");
                    }
                    StiStylesCreator creator = new StiStylesCreator(report);
                    String text = themeName + " " + themeArray[1] + "%";
                    StiColor color = StiColorUtils.light((StiColor)colorBase, (int)((byte)(Math.abs((themePercent - 100) / 25) * 45)));
                    List styles = creator.createStyles(text, color);
                    for (StiBaseStyle style : styles) {
                        stylesCollection.add((Object)style);
                    }
                } else if ("User".equals(themeProps.get("type"))) {
                    for (StiBaseStyle style : report.getStyles()) {
                        if (!style.getCollectionName().equals(themeProps.get("name"))) continue;
                        stylesCollection.add((Object)style);
                    }
                }
                if (dataBand != null && stylesCollection != null) {
                    for (StiBaseStyle style : stylesCollection) {
                        if (dataBand.getReport().getStyles().contains((Object)style)) continue;
                        dataBand.getReport().getStyles().add((Object)style);
                    }
                    StiReportEdit.applyStyleCollection((StiComponent)dataBand, stylesCollection);
                    for (StiComponent component : dataBand.GetComponents()) {
                        StiReportEdit.applyStyleCollection(component, stylesCollection);
                    }
                }
                if (headerBand != null) {
                    StiReportEdit.applyStyleCollection((StiComponent)headerBand, stylesCollection);
                    for (StiComponent component : headerBand.GetComponents()) {
                        StiReportEdit.applyStyleCollection(component, stylesCollection);
                    }
                }
                if (footerBand != null) {
                    StiReportEdit.applyStyleCollection((StiComponent)footerBand, stylesCollection);
                    for (StiComponent component : footerBand.GetComponents()) {
                        StiReportEdit.applyStyleCollection(component, stylesCollection);
                    }
                }
            }
        } else {
            String dataSourceName = (String)dataSource.get("name");
            StiTable table = new StiTable();
            StiReportEdit.addComponentToPage((StiComponent)table, currentPage);
            if ("DataSource".equals(dataSource.get("typeItem"))) {
                StiReportEdit.setDataSourceProperty(table, dataSourceName);
            } else {
                StiReportEdit.setBusinessObjectProperty(table, dataSource.get("fullName"));
            }
            String baseName = table.getReport().getInfo().getGenerateLocalizedName() ? table.getLocalizedName() + dataSourceName : "Table" + dataSourceName;
            table.setName(StiNameCreation.createName((StiReport)table.getReport(), (String)StiNameValidator.CorrectName((String)baseName), (boolean)false, (boolean)false, (boolean)true));
            double width = table.getParent() instanceof StiPage ? table.getPage().getColumnWidth2() : table.getParent().getWidth();
            int countRows = 1;
            if (((Boolean)settings.get("header")).booleanValue()) {
                ++countRows;
            }
            if (((Boolean)settings.get("footer")).booleanValue()) {
                ++countRows;
            }
            table.setRowCount(countRows);
            table.setColumnCount(columns.size());
            table.setHeaderRowsCount((Boolean)settings.get("header") != false ? 1 : 0);
            table.setFooterRowsCount((Boolean)settings.get("footer") != false ? 1 : 0);
            table.setHeight(table.getPage().getGridSize() * 4.0 * (double)countRows);
            table.setWidth(width);
            int indexHeader = 0;
            int indexData = (Boolean)settings.get("header") != false ? columns.size() : 0;
            for (int i = 0; i < columns.size(); ++i) {
                StiTableCell dataCell;
                StiDataColumn dataColumn;
                HashMap columnObject = (HashMap)columns.get(i);
                String columnName = (String)columnObject.get("fullName");
                if (((Boolean)settings.get("header")).booleanValue()) {
                    StiTableCell headerCell = (StiTableCell)table.getComponents().get(indexHeader);
                    int index = columnName.lastIndexOf(46);
                    StiDataColumn column = StiDataBuilder.getColumnFromPath((String)columnName, (StiDictionary)table.getReport().getDictionary());
                    if (column != null) {
                        headerCell.setText(column.getAlias());
                    } else if (index == -1) {
                        headerCell.setText(columnName);
                    } else {
                        headerCell.setText(columnName.substring(index + 1));
                    }
                    ++indexHeader;
                }
                if ((dataColumn = StiDataBuilder.getColumnFromPath((String)columnName, (StiDictionary)table.getReport().getDictionary())) != null && (dataColumn.getType() == StiSystemTypeEnum.SystemDrawingBitmap || dataColumn.getType() == StiSystemTypeEnum.SystemDrawingImage || dataColumn.getType() == StiSystemTypeEnum.SystemByteArray)) {
                    ((IStiTableCell)table.getComponents().get(indexData)).setCellType(StiTablceCellType.Image);
                    dataCell = (StiTableCellImage)table.getComponents().get(indexData);
                    dataCell.setDataColumn(columnName);
                    ++indexData;
                    continue;
                }
                if (dataColumn != null && dataColumn.getType() == StiSystemTypeEnum.SystemBoolean) {
                    ((IStiTableCell)table.getComponents().get(indexData)).setCellType(StiTablceCellType.CheckBox);
                    dataCell = (StiTableCellCheckBox)table.getComponents().get(indexData);
                    dataCell.getChecked().setValue("{" + columnName + "}");
                    ++indexData;
                    continue;
                }
                dataCell = (StiTableCell)table.getComponents().get(indexData);
                dataCell.setText("{" + columnName + "}");
                ++indexData;
            }
        }
        StiDesignReportHelper reportHelper = new StiDesignReportHelper(report);
        callbackResult.put("pageComponents", new JSONObject(reportHelper.getPage(report.getPages().indexOf((Object)currentPage))).toString());
        callbackResult.put("pageName", currentPageName);
        callbackResult.put("rebuildProps", StiReportEdit.getPropsRebuildPage(report, currentPage));
    }

    public static void setReportProperties(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        HashMap allProperties = (HashMap)param.get("properties");
        for (String propertyName : allProperties.keySet()) {
            Object propertyValue = allProperties.get(propertyName);
            if ("reportUnit".equals(propertyName)) {
                StiReportEdit.changeUnit(report, propertyName);
                continue;
            }
            StiReportEdit.setPropertyValue(report, StiReportEdit.upperFirstChar(propertyName), report, propertyValue);
        }
        callbackResult.put("properties", StiReportEdit.getReportProperties(report));
    }

    public static ArrayList<HashMap<String, Object>> getStylesProperty(Object component) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        StiStylesCollection styles;
        ArrayList<HashMap<String, Object>> items = new ArrayList<HashMap<String, Object>>();
        Method pi = component.getClass().getMethod("getStyles", new Class[0]);
        if (pi != null && (styles = (StiStylesCollection)pi.invoke(component, new Object[0])) != null) {
            for (StiBaseStyle s : styles) {
                items.add(StiStylesHelper.styleItem(s));
            }
        }
        return items;
    }

    public static HashMap<String, Object> getReportProperties(StiReport report) {
        String[] propertyNames;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("reportUnit", report.getUnit().getShortName());
        properties.put("reportFile", StiReportEdit.getReportFileName(report));
        properties.put("events", StiReportEdit.getEventsProperty(report));
        properties.put("previewSettings", StiReportEdit.getPreviewSettingsProperty(report));
        for (String propertyName : propertyNames = new String[]{"ReportName", "ReportAlias", "ReportAuthor", "ReportDescription", "AutoLocalizeReportOnRun", "CacheAllData", "CacheTotals", "CalculationMode", "ConvertNulls", "Collate", "Culture", "EngineVersion", "NumberOfPass", "PreviewMode", "ReportCacheMode", "ParametersOrientation", "RequestParameters", "ScriptLanguage", "StopBeforePage", "StoreImagesInResources", "RetrieveOnlyUsedData", "RefreshTime"}) {
            Object value = StiReportEdit.getPropertyValue(propertyName, report);
            if (value == null) continue;
            properties.put(StiReportEdit.lowerFirstChar(propertyName), value);
        }
        return properties;
    }

    public static void pageMove(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        report.setIsModified(true);
        int pageIndex = StiReportEdit.strToInt(param.get("pageIndex"));
        String direction = (String)param.get("direction");
        if ("Left".equals(direction) && pageIndex > 0) {
            StiPage page = report.getPages().get(pageIndex - 1);
            report.getPages().remove(pageIndex - 1);
            report.getPages().add(pageIndex, (Object)page);
        } else if ("Right".equals(direction) && pageIndex < report.getPages().size() - 1) {
            StiPage page = report.getPages().get(pageIndex);
            report.getPages().remove(pageIndex);
            report.getPages().add(pageIndex + 1, (Object)page);
        }
        callbackResult.put("pageIndexes", StiReportEdit.getPageIndexes(report));
    }

    public static void alignToGridComponents(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws JSONException {
        report.setIsModified(true);
        StiPage currentPage = report.getPages().get((String)param.get("pageName"));
        ArrayList componentNames = (ArrayList)param.get("components");
        for (int i = 0; i < componentNames.size(); ++i) {
            StiComponent component = report.GetComponentByName((String)componentNames.get(i));
            StiRectangle rect = component.getPaintRectangle(false, false);
            rect = rect.AlignToGrid(component.getPage().getGridSize(), true);
            StiReportEdit.setComponentRect(component, rect, true);
        }
        callbackResult.put("pageName", currentPage.getName());
        callbackResult.put("rebuildProps", StiReportEdit.getPropsRebuildPage(report, currentPage));
    }

    public static void changeArrangeComponents(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws JSONException {
        report.setIsModified(true);
        StiPage currentPage = report.getPages().get((String)param.get("pageName"));
        ArrayList componentNames = (ArrayList)param.get("components");
        for (StiComponent component : currentPage.GetComponents()) {
            component.setIsSelected(false);
        }
        for (int i = 0; i < componentNames.size(); ++i) {
            StiComponent component;
            component = report.GetComponentByName((String)componentNames.get(i));
            if (component == null) continue;
            component.select();
        }
        String arrangeCommand = (String)param.get("arrangeCommand");
        if ("BringToFront".equals(arrangeCommand)) {
            currentPage.BringToFront();
        } else if ("SendToBack".equals(arrangeCommand)) {
            currentPage.SendToBack();
        } else if ("MoveForward".equals(arrangeCommand)) {
            currentPage.MoveForward();
        } else if ("MoveBackward".equals(arrangeCommand)) {
            currentPage.MoveBackward();
        } else if ("AlignLeft".equals(arrangeCommand)) {
            currentPage.AlignTo(StiAligning.Left);
        } else if ("AlignCenter".equals(arrangeCommand)) {
            currentPage.AlignTo(StiAligning.Center);
        } else if ("AlignRight".equals(arrangeCommand)) {
            currentPage.AlignTo(StiAligning.Right);
        } else if ("AlignTop".equals(arrangeCommand)) {
            currentPage.AlignTo(StiAligning.Top);
        } else if ("AlignMiddle".equals(arrangeCommand)) {
            currentPage.AlignTo(StiAligning.Middle);
        } else if ("AlignBottom".equals(arrangeCommand)) {
            currentPage.AlignTo(StiAligning.Bottom);
        } else if ("MakeHorizontalSpacingEqual".equals(arrangeCommand)) {
            currentPage.MakeHorizontalSpacingEqual();
        } else if ("MakeVerticalSpacingEqual".equals(arrangeCommand)) {
            currentPage.MakeVerticalSpacingEqual();
        } else if ("CenterHorizontally".equals(arrangeCommand)) {
            currentPage.SetCenterHorizontally();
        } else if ("CenterVertically".equals(arrangeCommand)) {
            currentPage.SetCenterVertically();
        }
        currentPage.Correct();
        callbackResult.put("pageName", currentPage.getName());
        callbackResult.put("rebuildProps", StiReportEdit.getPropsRebuildPage(report, currentPage));
    }

    public static void duplicatePage(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        int pageIndex = Integer.parseInt(String.valueOf(param.get("pageIndex")));
        StiReport newReport = StiReportEdit.cloneReport(report, false);
        StiPage newPage = newReport.getPages().get(pageIndex);
        newPage.setName("tempName");
        newPage.setReport(report);
        newPage.setName(StiNameCreation.createName((StiReport)report, (String)StiNameCreation.generateName((StiReport)report, (String)newPage.getLocalizedName(), (String)newPage.getClass().getName().substring(newPage.getClass().getName().lastIndexOf(46) + 1))));
        newPage.NewGuid();
        report.getPages().add(pageIndex + 1, (Object)newPage);
        StiComponentsCollection comps = newPage.GetComponents();
        for (StiComponent comp : comps) {
            comp.setName(StiNameCreation.createName((StiReport)report, (String)StiNameCreation.generateName((StiReport)report, (String)comp.getLocalizedName(), (String)comp.getClass().getName().substring(comp.getClass().getName().lastIndexOf(46) + 1))));
        }
        if (param.get("reportFile") != null) {
            report.setReportFile((String)param.get("reportFile"));
        }
        callbackResult.put("reportGuid", param.get("reportGuid"));
        callbackResult.put("reportObject", StiReportEdit.writeReportInObject(report));
        callbackResult.put("selectedPageIndex", pageIndex + 1);
    }

    public static void updateEvents(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws JSONException {
        ArrayList eventsResult = new ArrayList();
        ArrayList components = (ArrayList)param.get("components");
        for (int i = 0; i < components.size(); ++i) {
            HashMap componentParams = (HashMap)components.get(i);
            Object object_ = null;
            object_ = "StiReport".equals(componentParams.get("typeComponent")) ? report : ("StiPage".equals(componentParams.get("typeComponent")) ? report.getPages().get((String)componentParams.get("name")) : report.GetComponentByName((String)componentParams.get("name")));
            if (object_ == null) continue;
            HashMap<String, HashMap<String, String>> eventObject = new HashMap<String, HashMap<String, String>>();
            eventObject.put("properties", StiReportEdit.getEventsProperty(object_));
            eventsResult.add(eventObject);
        }
        callbackResult.put("eventsResult", eventsResult);
    }

    public static void setEventValue(StiReport report, HashMap<String, Object> param, HashMap callbackResult) throws Exception {
        ArrayList components = (ArrayList)param.get("components");
        for (int i = 0; i < components.size(); ++i) {
            HashMap componentParams = (HashMap)components.get(i);
            Object object_ = null;
            object_ = "StiReport".equals(componentParams.get("typeComponent")) ? report : ("StiPage".equals(componentParams.get("typeComponent")) ? report.getPages().get((String)componentParams.get("name")) : report.GetComponentByName((String)componentParams.get("name")));
            if (object_ == null) continue;
            StiReportEdit.setPropertyValue(report, (String)param.get("eventName") + ".Script", object_, StiEncodingHelper.decodeString((String)((String)param.get("eventValue"))));
        }
    }

    public static void changeSizeComponents(StiReport report, HashMap param, HashMap callbackResult) throws Exception {
        report.setIsModified(true);
        StiPage currentPage = report.getPages().get((String)param.get("pageName"));
        ArrayList componentNames = (ArrayList)param.get("components");
        double zoom = StiReportEdit.strToDouble((String)param.get("zoom"));
        StiComponentsCollection currentComponents = new StiComponentsCollection();
        for (StiComponent component : currentPage.GetComponents()) {
            component.setIsSelected(false);
        }
        for (int i = 0; i < componentNames.size(); ++i) {
            String componentName = (String)componentNames.get(i);
            StiComponent component = report.GetComponentByName(componentName);
            if (component == null) continue;
            component.select();
            currentComponents.add(component);
        }
        if (currentComponents.size() > 0) {
            if ("MakeSameSize".equals(param.get("actionName"))) {
                currentPage.MakeSameSize(new StiSize(((StiComponent)currentComponents.get((int)0)).width, ((StiComponent)currentComponents.get(0)).getHeight()));
            } else if ("MakeSameWidth".equals(param.get("actionName"))) {
                currentPage.MakeSameWidth(((StiComponent)currentComponents.get(0)).getWidth());
            } else if ("MakeSameHeight".equals(param.get("actionName"))) {
                currentPage.MakeSameHeight(((StiComponent)currentComponents.get(0)).getHeight());
            }
            currentPage.Correct();
        }
        callbackResult.put("pageName", currentPage.getName());
        HashMap<String, Object> rebuildProps = StiReportEdit.getPropsRebuildPage(report, currentPage);
        for (StiComponent component : currentComponents) {
            if (!rebuildProps.containsKey(component.getName())) continue;
            ((HashMap)rebuildProps.get(component.getName())).put("svgContent", StiReportEdit.getSvgContent(component, zoom));
        }
        callbackResult.put("rebuildProps", rebuildProps);
    }

    public static void createMovingCopyComponent(StiHttpServletRequest httpContext, StiRequestParams requestParams, StiReport report, HashMap param, HashMap callbackResult) throws Exception {
        StiReportEdit.setToClipboard(httpContext, requestParams, report, param, callbackResult);
        String text = (String)StiCacheHelper.getObjectInternal((StiRequestParams)requestParams, (String)"clipboard", (StiHttpServletRequest)httpContext);
        StiGroup group = StiGroup.createFromString(text, "StiReport Clipboard");
        StiPage currentPage = report.getPages().get((String)param.get("pageName"));
        double zoom = StiReportEdit.strToDouble((String)param.get("zoom"));
        StiInsertionComponents.insertGroups(currentPage, group);
        ArrayList components = new ArrayList();
        StiComponentsCollection groupComponents = group.GetComponents();
        if (groupComponents.size() > 0) {
            StiComponent compSource;
            String[] componentRect = ((String)param.get("componentRect")).split("!");
            StiRectangle compRect = new StiRectangle(new StiPoint(StiReportEdit.strToDouble(componentRect[0]), StiReportEdit.strToDouble(componentRect[1])), new StiSize(StiReportEdit.strToDouble(componentRect[2]), StiReportEdit.strToDouble(componentRect[3])));
            boolean ignoreOffset = false;
            ArrayList componentNames = (ArrayList)param.get("components");
            callbackResult.put("oldComponentNames", componentNames);
            if (componentNames.size() > 0 && (compSource = report.GetComponentByName((String)componentNames.get(0))) != null && StiReportEdit.isAlignedByGrid(compSource)) {
                ignoreOffset = true;
            }
            if (ignoreOffset) {
                StiReportEdit.setComponentRect((StiComponent)groupComponents.get(0), compRect, true);
            } else {
                StiReportEdit.setComponentRect((StiComponent)groupComponents.get(0), compRect, false);
                StiReportEdit.setComponentRectWithOffset((StiComponent)groupComponents.get(0), compRect, "MoveComponent", null, null);
            }
        }
        for (StiComponent component : group.GetComponents()) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("name", component.getName());
            attributes.put("typeComponent", component.getClass().getName().substring(component.getClass().getName().lastIndexOf(".") + 1));
            attributes.put("componentRect", StiReportEdit.getComponentRect(component));
            attributes.put("parentName", StiReportEdit.getParentName(component));
            attributes.put("parentIndex", StiReportEdit.getParentIndex(component).toString());
            attributes.put("componentIndex", StiReportEdit.getComponentIndex(component).toString());
            attributes.put("childs", StiReportEdit.getAllChildComponents(component));
            attributes.put("svgContent", StiReportEdit.getSvgContent(component, zoom));
            attributes.put("pageName", currentPage.getName());
            attributes.put("properties", StiReportEdit.getAllProperties(component));
            attributes.put("largeHeightAutoFactor", String.valueOf(currentPage.getLargeHeightAutoFactor()));
            components.add(attributes);
            component.setDockable(true);
        }
        callbackResult.put("components", components);
        callbackResult.put("rebuildProps", StiReportEdit.getPropsRebuildPage(report, currentPage));
        callbackResult.put("isLastCommand", param.get("isLastCommand"));
    }

    public static void updateReportAliases(StiRequestParams requestParams, StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        if (report != null) {
            callbackResult.put("reportObject", StiReportEdit.writeReportInObject(report));
            callbackResult.put("reportGuid", requestParams.cache.clientGuid);
            callbackResult.put("selectedObjectName", param.get("selectedObjectName"));
        }
    }

    public static void openPage(StiRequestParams requestParams, StiReport report, HashMap<String, Object> callbackResult) throws Exception {
        report.setIsModified(true);
        StiPage page = new StiPage();
        StiDeserializerControler.deserializeFromString((String)new String(requestParams.data, "UTF-8"), (IStiSerializable)page);
        page.setReport(report);
        report.getPages().add(page);
        page.getComponents().SortByPriority();
        report.getPages().remove((Object)page);
        StiPage tempPage = new StiPage(report);
        tempPage.setName("#%#TempPageForStoreComponents#%#");
        report.getPages().add(tempPage);
        StiComponentsCollection compcoll = new StiComponentsCollection();
        tempPage.setComponents(compcoll);
        page.setName(StiNameCreation.createName((StiReport)report, (String)"Page", (boolean)true, (boolean)false, (boolean)true));
        StiComponentsCollection comps = page.GetComponents();
        for (StiComponent comp : comps) {
            if (!StiNameCreation.isValidName((StiReport)report, (String)comp.getName())) {
                comp.setName(StiNameCreation.createName((StiReport)report, (String)StiNameCreation.generateName((StiComponent)comp)));
            }
            tempPage.getComponents().add(comp);
        }
        report.getPages().remove((Object)tempPage);
        report.getPages().add(page);
        if (page.isPage() && page.getReportUnit() != null) {
            page.convert(page.getReportUnit(), page.getReport().getUnit());
            page.setReportUnit(null);
        }
        StiDesignReportHelper reportHelper = new StiDesignReportHelper(report);
        HashMap<String, Object> pageProps = reportHelper.getPage(report.getPages().indexOf((Object)page));
        pageProps.put("pageIndexes", StiReportEdit.getPageIndexes(report));
        callbackResult.put("pageProps", pageProps);
    }
}

