/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.webdesigner.helper.StiGroup;
import java.util.Collection;

public class StiInsertionComponents {
    public static void insertGroups(StiPage currentPage, StiGroup group) {
        for (StiComponent component : group.getComponents()) {
            component.setDockable(false);
        }
        group.insertIntoPage(currentPage);
        StiInsertionComponents.insert(currentPage);
    }

    public static void insertComponents(StiPage currentPage, StiComponentsCollection comps) {
        StiInsertionComponents.insertComponents(currentPage, comps, false);
    }

    public static void insertComponents(StiPage currentPage, StiComponentsCollection comps, boolean alignToGrid) {
        currentPage.ResetSelection();
        for (StiComponent comp : comps) {
            comp.select();
            comp.setDockable(false);
        }
        currentPage.getComponents().addAll((Collection)comps);
        StiInsertionComponents.insert(currentPage, alignToGrid);
    }

    public static void insert(StiPage currentPage) {
        StiInsertionComponents.insert(currentPage, false);
    }

    public static void insert(StiPage currentPage, boolean alignToGrid) {
        currentPage.getReport().getInfo().setIsComponentsMoving(true);
        StiPoint pos = new StiPoint(0.0, 0.0);
        double minX = 0.0;
        double minY = 0.0;
        StiComponentsCollection comps = currentPage.GetSelectedComponents();
        if (comps.size() > 0) {
            minX = ((StiComponent)comps.get(0)).getLeft();
            minY = ((StiComponent)comps.get(0)).getTop();
        }
        for (StiComponent component : comps) {
            if (!component.getIsSelected()) continue;
            if (alignToGrid) {
                component.setClientRectangle(component.getClientRectangle().AlignToGrid(currentPage.getGridSize(), currentPage.getReport().getInfo().getAlignToGrid()));
            }
            minX = Math.min(component.getLeft(), minX);
            minY = Math.min(component.getTop(), minY);
        }
        for (StiComponent component : comps) {
            if (!component.getIsSelected()) continue;
            component.setLeft(component.getLeft() - minX - pos.x);
            component.top -= minY - pos.y;
        }
    }
}

