/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.webdesigner.helper.StiDictionaryHelper;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import com.stimulsoft.webdesigner.helper.StiStylesHelper;
import com.stimulsoft.webdesigner.helper.StiWebDesignerBase;
import java.util.ArrayList;
import java.util.HashMap;

public class StiDesignReportHelper {
    private StiReport report = null;

    public StiDesignReportHelper(StiReport report) {
        this.report = report;
    }

    public HashMap<String, Object> getReportToObject() throws Exception {
        HashMap<String, Object> reportObject = new HashMap<String, Object>();
        reportObject.put("zoom", StiReportEdit.doubleToStr(this.report.getInfo().getZoom()));
        reportObject.put("gridSize", StiReportEdit.doubleToStr(this.report.getUnit().ConvertToHInches(this.report.getInfo().getGridSize())));
        reportObject.put("dictionary", StiDictionaryHelper.getDictionaryTree(this.report));
        reportObject.put("stylesCollection", StiStylesHelper.getStyles(this.report));
        reportObject.put("pages", this.getPages());
        reportObject.put("properties", StiReportEdit.getReportProperties(this.report));
        reportObject.put("info", this.getReportInfo());
        reportObject.put("isJsonReport", this.report.isJsonReport());
        return reportObject;
    }

    public ArrayList<HashMap<String, Object>> getPages() throws Exception {
        ArrayList<HashMap<String, Object>> pages = new ArrayList<HashMap<String, Object>>();
        for (int pageIndex = 0; pageIndex < this.report.getPages().size(); ++pageIndex) {
            HashMap<String, Object> page = this.getPage(pageIndex);
            if (page == null) continue;
            pages.add(page);
        }
        return pages;
    }

    public HashMap<String, Object> getPage(int pageIndex) throws Exception {
        StiPage page = this.report.getPages().get(pageIndex);
        page.Correct(true);
        HashMap<String, Object> pageObject = new HashMap<String, Object>();
        pageObject.put("name", page.getName());
        pageObject.put("pageIndex", String.valueOf(pageIndex));
        pageObject.put("properties", StiReportEdit.getAllProperties((StiComponent)page));
        if (((HashMap)pageObject.get("properties")).keySet().size() == 0) {
            return null;
        }
        pageObject.put("components", this.getComponents(page));
        return pageObject;
    }

    private ArrayList<HashMap<String, Object>> getComponents(StiPage page) throws Exception {
        ArrayList<HashMap<String, Object>> components = new ArrayList<HashMap<String, Object>>();
        StiComponentsCollection comps = page.GetComponents();
        for (int index = 0; index < comps.size(); ++index) {
            StiComponent comp = (StiComponent)comps.get(index);
            components.add(this.getComponent(comp));
        }
        return components;
    }

    private HashMap<String, Object> getComponent(StiComponent component) throws Exception {
        HashMap<String, Object> compObject = new HashMap<String, Object>();
        compObject.put("name", component.getName());
        compObject.put("typeComponent", component.getClass().getName().substring(component.getClass().getName().lastIndexOf(".") + 1));
        compObject.put("componentRect", StiReportEdit.getComponentRect(component));
        compObject.put("parentName", StiReportEdit.getParentName(component));
        compObject.put("parentIndex", String.valueOf(StiReportEdit.getParentIndex(component)));
        compObject.put("componentIndex", StiReportEdit.getComponentIndex(component).toString());
        compObject.put("childs", StiReportEdit.getAllChildComponents(component));
        compObject.put("svgContent", StiReportEdit.getSvgContent(component, 1.0));
        compObject.put("pageName", component.getPage().getName());
        compObject.put("properties", StiReportEdit.getAllProperties(component));
        return compObject;
    }

    private HashMap<String, Object> getReportInfo() {
        String[] propNames;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String propName : propNames = new String[]{"ShowHeaders", "ShowRulers", "ShowOrder", "RunDesignerAfterInsert", "UseLastFormat", "ShowDimensionLines", "GenerateLocalizedName", "AlignToGrid", "ShowGrid", "GridMode", "GridSizeInch", "GridSizeHundredthsOfInch", "GridSizeCentimetres", "GridSizeMillimeters", "GridSizePixels", "QuickInfoType", "QuickInfoOverlay", "AutoSaveInterval", "EnableAutoSaveMode"}) {
            Object value = StiReportEdit.getPropertyValue(propName, this.report.getInfo());
            if (value == null) continue;
            properties.put(StiReportEdit.lowerFirstChar(propName), value);
        }
        return properties;
    }

    public static void applyParamsToReport(StiReport report, StiRequestParams requestParams) {
        if (report != null) {
            report.getInfo().setForceDesigningMode(true);
            report.getInfo().setZoom(1.0);
            if (requestParams != null) {
                if (report.designer == null) {
                    report.designer = new StiWebDesignerBase();
                }
                if (requestParams.all.get("useAliases") != null) {
                    report.designer.setUseAliases(((Boolean)requestParams.all.get("useAliases")).booleanValue());
                }
            }
        }
    }
}

