/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.helper;

import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.enums.StiHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;
import com.stimulsoft.report.barCodes.StiITF14BarCodeType;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.export.service.StiSvgExportService;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import java.util.ArrayList;
import java.util.HashMap;

public class StiBarCodeHelper {
    public static HashMap<String, Object> getBarCodeJSObject(StiBarCode barCode) throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("name", barCode.getName());
        properties.put("codeType", barCode.getBarCodeType().getClass().getName().substring(barCode.getBarCodeType().getClass().getName().lastIndexOf(".") + 1));
        properties.put("sampleImage", StiBarCodeHelper.getBarCodeSampleImage(barCode));
        properties.put("properties", StiBarCodeHelper.getBarCodeProperties(barCode));
        return properties;
    }

    public static HashMap<String, Object> getBarCodeProperties(StiBarCode barCode) {
        String[] propNamesAdditional;
        String[] propNamesCommon;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        HashMap<String, Object> propertiesCommon = new HashMap<String, Object>();
        for (String propName : propNamesCommon = new String[]{"Code", "Angle", "AutoScale", "ForeColor", "BackColor", "Font", "HorAlignment", "VertAlignment", "ShowLabelText", "ShowQuietZones"}) {
            Object value = StiReportEdit.getPropertyValue(propName, barCode);
            if (value == null) continue;
            propertiesCommon.put(StiReportEdit.lowerFirstChar(propName), value);
        }
        properties.put("common", propertiesCommon);
        HashMap<String, Object> propertiesAdditional = new HashMap<String, Object>();
        for (String propName : propNamesAdditional = new String[]{"Module", "Checksum", "CheckSum", "CheckSum1", "CheckSum2", "Height", "Ratio", "EncodingType", "MatrixSize", "UseRectangularSymbols", "SupplementCode", "ShowQuietZoneIndicator", "SupplementType", "AddClearZone", "PrintVerticalBars", "AspectRatio", "AutoDataColumns", "AutoDataRows", "DataColumns", "DataRows", "EncodingMode", "ErrorsCorrectionLevel", "RatioY", "Space", "ErrorCorrectionLevel", "CompanyPrefix", "ExtensionDigit", "SerialNumber", "Mode", "ProcessTilde", "StructuredAppendPosition", "StructuredAppendTotal", "TrimExcessData"}) {
            Object value = StiReportEdit.getPropertyValue(propName, barCode.getBarCodeType());
            if (value == null) continue;
            propertiesAdditional.put(StiReportEdit.lowerFirstChar(propName), value);
        }
        properties.put("additional", propertiesAdditional);
        return properties;
    }

    public static void applyBarCodeProperties(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        StiComponent component = report.GetComponentByName((String)param.get("componentName"));
        if (component != null) {
            StiBarCode barCode = (StiBarCode)component;
            ArrayList properties = (ArrayList)param.get("properties");
            for (HashMap property : properties) {
                String propertyName = (String)property.get("name");
                if ("codeType".equals(propertyName)) {
                    StiReportEdit.setBarCodeTypeProperty(barCode, property.get("value"));
                    continue;
                }
                StiReportEdit.setPropertyValue(report, StiReportEdit.upperFirstChar(propertyName), barCode, property.get("value"));
            }
            callbackResult.put("barCode", StiBarCodeHelper.getBarCodeJSObject(barCode));
        }
    }

    public static String getBarCodeSampleImage(StiBarCode barCode) throws Exception {
        StiBarCode tempBarCode = (StiBarCode)barCode.clone();
        tempBarCode.setWidth(barCode.getReport().getUnit().ConvertFromHInches(440.0));
        tempBarCode.setHeight(barCode.getReport().getUnit().ConvertFromHInches(200.0));
        tempBarCode.setHorAlignment(StiHorAlignment.Center);
        tempBarCode.setVertAlignment(StiVertAlignment.Center);
        return StiSvgExportService.StiSvgHelper.saveComponentToString((StiComponent)tempBarCode, (StiImageFormat)StiImageFormat.Png, (float)0.75f, (float)150.0f);
    }

    public static void getBarCodeSamples(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) throws Exception {
        ArrayList barCodeSamples = new ArrayList();
        StiComponent barCode = report.GetComponentByName((String)param.get("componentName"));
        StiBarCode tempBarCode = (StiBarCode)barCode.clone();
        tempBarCode.setReport(report);
        tempBarCode.setHorAlignment(StiHorAlignment.Center);
        tempBarCode.setVertAlignment(StiVertAlignment.Center);
        tempBarCode.setAutoScale(true);
        tempBarCode.setBackColor(StiColorEnum.Transparent.color());
        for (Class serviceClass : StiOptions.Services.getBarCodes()) {
            StiBarCodeTypeService service = (StiBarCodeTypeService)serviceClass.newInstance();
            tempBarCode.setBarCodeType(service);
            tempBarCode.getCode().setValue(service.getDefaultCodeValue());
            tempBarCode.setWidth(report.getUnit().ConvertFromHInches(150.0));
            tempBarCode.setHeight(report.getUnit().ConvertFromHInches(60.0));
            if (tempBarCode.getBarCodeType() instanceof StiITF14BarCodeType) {
                ((StiITF14BarCodeType)tempBarCode.getBarCodeType()).setModule(10.0);
            }
            HashMap<String, Object> sampleObj = new HashMap<String, Object>();
            sampleObj.put("image", StiSvgExportService.StiSvgHelper.saveComponentToString((StiComponent)tempBarCode, (StiImageFormat)StiImageFormat.Png, (float)0.75f, (float)100.0f));
            sampleObj.put("type", service.getServiceName());
            sampleObj.put("width", 150);
            sampleObj.put("height", 60);
            barCodeSamples.add(sampleObj);
        }
        callbackResult.put("barCodeSamples", barCodeSamples);
    }
}

