/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner;

import com.stimulsoft.base.StiEncryption;
import com.stimulsoft.base.enums.StiPaperKind;
import com.stimulsoft.base.json.JSONArray;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.serializing.StiSerializerControler;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.zip.StiGZipHelper;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiSerializeManager;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.check.StiCheck;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentHelper;
import com.stimulsoft.report.components.table.StiTable;
import com.stimulsoft.report.components.textFormats.StiFormatService;
import com.stimulsoft.report.crossTab.StiCrossTab;
import com.stimulsoft.report.dictionary.enums.StiResourceType;
import com.stimulsoft.report.enums.StiCalculationMode;
import com.stimulsoft.report.enums.StiReportUnitType;
import com.stimulsoft.report.infographics.gauge.StiGauge;
import com.stimulsoft.report.maps.StiMap;
import com.stimulsoft.web.cache.StiCacheOptions;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.enums.StiDesignerCommand;
import com.stimulsoft.web.helper.StiCacheHelper;
import com.stimulsoft.web.helper.StiGalleriesHelper;
import com.stimulsoft.web.helper.StiRequestParamsHelper;
import com.stimulsoft.web.helper.StiWebActionResult;
import com.stimulsoft.web.proxyee.StiHttpServletRequest;
import com.stimulsoft.webdesigner.StiWebDesigerHandler;
import com.stimulsoft.webdesigner.StiWebDesigner;
import com.stimulsoft.webdesigner.StiWebDesignerOptions;
import com.stimulsoft.webdesigner.helper.StiBarCodeHelper;
import com.stimulsoft.webdesigner.helper.StiChartHelper;
import com.stimulsoft.webdesigner.helper.StiCrossTabHelper;
import com.stimulsoft.webdesigner.helper.StiCultureHelper;
import com.stimulsoft.webdesigner.helper.StiDesignReportHelper;
import com.stimulsoft.webdesigner.helper.StiDesignerResourcesHelper;
import com.stimulsoft.webdesigner.helper.StiDictionaryHelper;
import com.stimulsoft.webdesigner.helper.StiGaugeHelper;
import com.stimulsoft.webdesigner.helper.StiMapHelper;
import com.stimulsoft.webdesigner.helper.StiReportCheckHelper;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import com.stimulsoft.webdesigner.helper.StiReportResourcesHelper;
import com.stimulsoft.webdesigner.helper.StiShapeHelper;
import com.stimulsoft.webdesigner.helper.StiStylesHelper;
import com.stimulsoft.webdesigner.helper.StiTableHelper;
import com.stimulsoft.webdesigner.helper.StiTableOfContentsHelper;
import com.stimulsoft.webdesigner.helper.StiTextFormatHelper;
import com.stimulsoft.webdesigner.helper.StiWebDesignerOptionsHelper;
import com.stimulsoft.webdesigner.helper.StiWizardHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public class StiWebDesignerCommands {
    private static Logger LOG = Logger.getLogger("com.stimulsoft.webdesigner.StiWebDesignerCommands");

    public static StiReport getReportForDesigner(StiRequestParams requestParams, StiReport currentReport, StiHttpServletRequest httpContext) throws Exception {
        if (currentReport == null) {
            currentReport = StiWebDesignerCommands.getNewReport(requestParams);
        }
        HashMap<String, Object> designerOptions = StiWebDesignerOptionsHelper.getDesignerOptions(httpContext);
        StiWebDesignerOptionsHelper.applyDesignerOptionsToReport(designerOptions, currentReport);
        currentReport.getInfo().setZoom(1.0);
        if (StiValidationUtil.isNullOrEmpty((String)currentReport.getReportFile())) {
            currentReport.setReportFile(!StiValidationUtil.isNullOrEmpty((String)currentReport.getReportName()) ? currentReport.getReportName() + ".mrt" : "Report.mrt");
        }
        return currentReport;
    }

    public static StiReport getNewReport(StiRequestParams requestParams) throws JSONException {
        StiReport newReport = StiReport.newInstance();
        if (requestParams != null) {
            newReport.setReportUnit((StiReportUnitType)requestParams.getEnum("defaultUnit", StiReportUnitType.class, (Enum)StiReportUnitType.Centimeters));
        }
        newReport.getPages().get(0).setPaperSize(StiPaperKind.Custom);
        newReport.getPages().get(0).setPageWidth(newReport.getUnit().ConvertFromHInches(827.0));
        newReport.getPages().get(0).setPageHeight(newReport.getUnit().ConvertFromHInches(1169.0));
        newReport.getInfo().setZoom(1.0);
        return newReport;
    }

    public static StiReport loadReportFromContent(StiRequestParams requestParams) throws Exception {
        StiReport report = null;
        byte[] bytes = requestParams.data;
        if (requestParams.designer.password != null) {
            if ((char)bytes[0] != 'm' || (char)bytes[1] != 'r' || (char)bytes[2] != 'x') {
                throw new Exception("This file is a not '.mrx' format.");
            }
            int[] dest = new int[bytes.length - 3];
            for (int i = 3; i < bytes.length; ++i) {
                dest[i - 3] = bytes[i] >= 0 ? bytes[i] : 256 + bytes[i];
            }
            dest = StiEncryption.decrypt((int[])dest, (String)requestParams.designer.password);
            try {
                byte[] dest2 = new byte[dest.length];
                for (int i = 0; i < dest.length; ++i) {
                    dest2[i] = (byte)dest[i];
                }
                byte[] unpacked = StiGZipHelper.unpack((byte[])dest2);
                report = StiSerializeManager.deserializeReport((InputStream)new ByteArrayInputStream(unpacked));
            }
            catch (Exception ee) {
                throw new Exception("File decryption error: wrong key.");
            }
        } else if (StiWebDesignerCommands.isPackedFile(bytes)) {
            byte[] unpacked = StiGZipHelper.unpack((byte[])bytes);
            report = StiSerializeManager.deserializeReport((InputStream)new ByteArrayInputStream(unpacked));
        } else {
            report = StiSerializeManager.deserializeReport((InputStream)new ByteArrayInputStream(bytes));
        }
        StiWebDesigner.setupDesign(report);
        report.getInfo().setZoom(1.0);
        if (requestParams.designer.fileName != null) {
            report.setReportFile(requestParams.designer.fileName);
        }
        report.setCalculationMode(StiCalculationMode.Interpretation);
        return report;
    }

    private static boolean isPackedFile(byte[] bytes) {
        if (bytes == null || bytes.length < 3) {
            return false;
        }
        return StiWebDesignerCommands.isPackedFile(bytes[0], bytes[1], bytes[2]);
    }

    private static boolean isPackedFile(int first, int second, int third) {
        if (first == 31 && second == 139 && third == 8) {
            return true;
        }
        return first == 80 && second == 75 && third == 3;
    }

    public static StiWebActionResult commandResult(StiRequestParams requestParams, StiReport currentReport, StiHttpServletRequest httpContext) throws UnsupportedEncodingException {
        HashMap<String, Object> callbackResult = new HashMap<String, Object>();
        StiDesignReportHelper.applyParamsToReport(currentReport, requestParams);
        try {
            HashMap param = requestParams.all;
            StiDesignerCommand command = requestParams.designer.command;
            callbackResult.put("command", command);
            if (param.get("callbackFunctionId") != null) {
                callbackResult.put("callbackFunctionId", param.get("callbackFunctionId"));
            }
            if (currentReport == null && command != StiDesignerCommand.CloseReport && command != StiDesignerCommand.CreateReport && command != StiDesignerCommand.GetReportFromData && command != StiDesignerCommand.OpenReport && command != StiDesignerCommand.WizardResult && command != StiDesignerCommand.UpdateCache && command != StiDesignerCommand.GetReportForDesigner && command != StiDesignerCommand.UpdateImagesArray && command != StiDesignerCommand.Synchronization) {
                param.put("command", "SessionCompleted");
                callbackResult.put("command", "SessionCompleted");
            }
            if (command == StiDesignerCommand.Synchronization) {
                if (currentReport == null) {
                    callbackResult.put("command", "SynchronizationError");
                } else {
                    callbackResult.put("reportObject", StiReportEdit.writeReportInObject(currentReport));
                }
            } else if (command == StiDesignerCommand.UpdateCache) {
                callbackResult.put("command", "UpdateCache");
            } else if (command == StiDesignerCommand.GetReportForDesigner) {
                HashMap attachedItems = null;
                if (currentReport != null) {
                    callbackResult.put("reportObject", StiReportEdit.writeReportInObject(currentReport, attachedItems));
                }
            } else if (command == StiDesignerCommand.CreateReport) {
                StiWebDesignerOptionsHelper.applyDesignerOptionsToReport(StiWebDesignerOptionsHelper.getDesignerOptions(httpContext), currentReport);
                Object handler = StiCacheOptions.cache.getObject(httpContext, requestParams.id + "webdesigner_handler");
                if (handler != null) {
                    String className = handler instanceof StiWebDesigerHandler ? "javax.servlet.http.HttpServletRequest" : "jakarta.servlet.http.HttpServletRequest";
                    Method method = handler.getClass().getMethod("onNewReportTemplate", StiReport.class, Class.forName(className));
                    method.setAccessible(true);
                    method.invoke(handler, currentReport, httpContext.getRequest());
                }
                callbackResult.put("reportGuid", requestParams.cache.clientGuid);
                callbackResult.put("reportObject", StiReportEdit.writeReportInObject(currentReport));
                callbackResult.put("needClearAfterOldReport", param.get("needClearAfterOldReport"));
                StiReportEdit.clearUndoArray(httpContext, requestParams);
            } else if (command == StiDesignerCommand.OpenReport) {
                try {
                    String reportObjectStr;
                    currentReport.getInfo().setForceDesigningMode(true);
                    StiWebDesignerOptionsHelper.applyDesignerOptionsToReport(StiWebDesignerOptionsHelper.getDesignerOptions(httpContext), currentReport);
                    Object handler = StiCacheOptions.cache.getObject(httpContext, requestParams.id + "webdesigner_handler");
                    if (handler != null) {
                        String className = handler instanceof StiWebDesigerHandler ? "javax.servlet.http.HttpServletRequest" : "jakarta.servlet.http.HttpServletRequest";
                        Method method = handler.getClass().getMethod("onOpenReportTemplate", StiReport.class, Class.forName(className));
                        method.setAccessible(true);
                        method.invoke(handler, currentReport, httpContext.getRequest());
                    }
                    if ((reportObjectStr = StiReportEdit.writeReportInObject(currentReport)) != null) {
                        callbackResult.put("reportObject", reportObjectStr);
                        callbackResult.put("reportGuid", requestParams.cache.clientGuid);
                    } else {
                        callbackResult.put("errorMessage", "Loading report error: Json parser error!");
                    }
                    if (requestParams.designer.password != null) {
                        callbackResult.put("encryptedPassword", requestParams.designer.password);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    callbackResult.put("reportGuid", null);
                    callbackResult.put("reportObject", null);
                    callbackResult.put("error", "Loading report error. " + e.getMessage());
                }
                StiReportEdit.clearUndoArray(httpContext, requestParams);
            } else if (command == StiDesignerCommand.CloseReport) {
                currentReport = null;
            } else if (command == StiDesignerCommand.SaveAsReport || command == StiDesignerCommand.SaveReport) {
                Object handler = StiWebDesigner.getHandler(httpContext, requestParams);
                String className = handler instanceof StiWebDesigerHandler ? "javax.servlet.http.HttpServletRequest" : "jakarta.servlet.http.HttpServletRequest";
                Method method = handler.getClass().getMethod("onSaveReportTemplate", StiReport.class, StiRequestParams.class, Class.forName(className));
                method.setAccessible(true);
                method.invoke(handler, currentReport, requestParams, httpContext.getRequest());
            } else if (command == StiDesignerCommand.MoveComponent || command == StiDesignerCommand.ResizeComponent) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiReportEdit.changeRectComponent(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.CreateComponent) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiReportEdit.createComponent(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.RemoveComponent) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiReportEdit.removeComponent(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.AddPage) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiReportEdit.addPage(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.RemovePage) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiReportEdit.removePage(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.SendProperties) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiReportEdit.readAllPropertiesFromString(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.ChangeUnit) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiReportEdit.changeUnit(currentReport, (String)param.get("reportUnit"));
                callbackResult.put("reportUnit", param.get("reportUnit"));
                callbackResult.put("gridSize", currentReport.getInfo().getGridSize());
                StiReportEdit.getAllComponentsPositions(currentReport, callbackResult);
            } else if (command == StiDesignerCommand.RebuildPage) {
                callbackResult.put("pageName", param.get("pageName"));
                callbackResult.put("rebuildProps", StiReportEdit.getPropsRebuildPage(currentReport, currentReport.getPages().get((String)param.get("pageName"))));
            } else if (command == StiDesignerCommand.LoadReportToViewer) {
                requestParams.report.getInfo().setForceDesigningMode(false);
                requestParams.report.designer = null;
                if (requestParams.designer.checkReportBeforePreview) {
                    try {
                        List<StiCheck> checks = StiReportCheckHelper.checkReport(httpContext, requestParams, requestParams.report, false);
                        callbackResult.put("checkItems", StiReportCheckHelper.getChecksJSCollection(checks));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                String viewerClientGuid = String.format("%s_%s", requestParams.id + "Viewer", param.get("viewerClientGuid"));
                String viewerReportGuid = String.format("%s_%s", viewerClientGuid, "template");
                StiCacheHelper.removeReport((String)viewerClientGuid, (StiHttpServletRequest)httpContext);
                StiCacheHelper.saveReport((StiReport)requestParams.report, (String)viewerReportGuid, (StiHttpServletRequest)httpContext);
            } else if (command == StiDesignerCommand.SetToClipboard) {
                StiReportEdit.setToClipboard(httpContext, requestParams, currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.GetFromClipboard) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiReportEdit.getFromClipboard(httpContext, requestParams, currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.Undo) {
                currentReport = StiReportEdit.getUndoStep(httpContext, requestParams, currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.Redo) {
                currentReport = StiReportEdit.getRedoStep(httpContext, requestParams, currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.RenameComponent) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiReportEdit.renameComponent(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.WizardResult) {
                HashMap wizardResult = (HashMap)param.get("wizardResult");
                currentReport = StiWizardHelper.getReportFromWizardOptions(currentReport, (HashMap)wizardResult.get("reportOptions"), (HashMap)wizardResult.get("dataSources"));
                StiWebDesignerOptionsHelper.applyDesignerOptionsToReport(StiWebDesignerOptionsHelper.getDesignerOptions(httpContext), currentReport);
                callbackResult.put("reportGuid", requestParams.cache.clientGuid);
                HashMap attachedItems = null;
                callbackResult.put("reportObject", StiReportEdit.writeReportInObject(currentReport, attachedItems));
                StiReportEdit.clearUndoArray(httpContext, requestParams);
            } else if (command == StiDesignerCommand.GetConnectionTypes) {
                StiDictionaryHelper.getConnectionTypes(currentReport, param, callbackResult, (StiWebDesignerOptions)StiCacheHelper.getOptions((StiRequestParams)requestParams, (StiHttpServletRequest)httpContext));
            } else if (command == StiDesignerCommand.CreateOrEditConnection) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.createOrEditConnection(currentReport, param, callbackResult, (StiWebDesignerOptions)StiCacheHelper.getOptions((StiRequestParams)requestParams, (StiHttpServletRequest)httpContext));
            } else if (command == StiDesignerCommand.DeleteConnection) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.deleteConnection(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.CreateOrEditRelation) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.createOrEditRelation(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.DeleteRelation) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.deleteRelation(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.CreateOrEditColumn) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.createOrEditColumn(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.DeleteColumn) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.deleteColumn(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.CreateOrEditParameter) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.createOrEditParameter(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.DeleteParameter) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.deleteParameter(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.CreateOrEditDataSource) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.createOrEditDataSource(currentReport, param, callbackResult, (StiWebDesignerOptions)StiCacheHelper.getOptions((StiRequestParams)requestParams, (StiHttpServletRequest)httpContext));
            } else if (command == StiDesignerCommand.DeleteDataSource) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.deleteDataSource(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.CreateOrEditBusinessObject) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.createOrEditBusinessObject(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.DeleteBusinessObject) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.deleteBusinessObject(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.DeleteBusinessObjectCategory) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.deleteBusinessObjectCategory(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.EditBusinessObjectCategory) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.editBusinessObjectCategory(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.CreateOrEditVariable) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.createOrEditVariable(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.DeleteVariable) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.deleteVariable(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.DeleteVariablesCategory) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.deleteVariablesCategory(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.EditVariablesCategory) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.editVariablesCategory(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.CreateVariablesCategory) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiDictionaryHelper.createVariablesCategory(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.CreateOrEditResource) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport, true);
                StiDictionaryHelper.createOrEditResource(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.DeleteResource) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport, true);
                StiDictionaryHelper.deleteResource(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.SynchronizeDictionary) {
                StiDictionaryHelper.synchronizeDictionary(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.NewDictionary) {
                StiDictionaryHelper.newDictionary(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.GetAllConnections) {
                StiDictionaryHelper.getAllConnections(currentReport, param, callbackResult, (StiWebDesignerOptions)StiCacheHelper.getOptions((StiRequestParams)requestParams, (StiHttpServletRequest)httpContext));
            } else if (command == StiDesignerCommand.RetrieveColumns) {
                StiDictionaryHelper.retrieveColumns(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.UpdateStyles) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiStylesHelper.updateStyles(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.SetPreviewSettings) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiReportEdit.setPreviewSettingsProperty(currentReport, (HashMap)param.get("previewSettings"), callbackResult);
            } else if (command == StiDesignerCommand.AddStyle) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiStylesHelper.addStyle(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.CreateStyleCollection) {
                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                StiStylesHelper.createStyleCollection(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.StartEditChartComponent) {
                StiComponent component = currentReport.GetComponentByName((String)param.get("componentName"));
                if (component != null) {
                    StiReportEdit.saveComponentClone(httpContext, requestParams, component);
                    callbackResult.put("properties", StiChartHelper.getChartProperties((StiChart)component));
                }
            } else if (command == StiDesignerCommand.StartEditMapComponent) {
                StiComponent component = currentReport.GetComponentByName((String)param.get("componentName"));
                if (component != null) {
                    StiReportEdit.saveComponentClone(httpContext, requestParams, component);
                    callbackResult.put("properties", StiMapHelper.getMapProperties((StiMap)component));
                    callbackResult.put("svgContent", StiReportEdit.getSvgContent(component, StiReportEdit.strToDouble((String)param.get("zoom"))));
                }
            } else if (command == StiDesignerCommand.CanceledEditComponent) {
                StiReportEdit.canceledEditComponent(httpContext, requestParams, currentReport, param);
            } else if (command == StiDesignerCommand.AddSeries) {
                StiChartHelper.addSeries(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.RemoveSeries) {
                StiChartHelper.removeSeries(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.SeriesMove) {
                StiChartHelper.seriesMove(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.AddConstantLineOrStrip) {
                StiChartHelper.addConstantLineOrStrip(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.RemoveConstantLineOrStrip) {
                StiChartHelper.removeConstantLineOrStrip(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.ConstantLineOrStripMove) {
                StiChartHelper.constantLineOrStripMove(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.GetLabelsContent) {
                StiChartHelper.getLabelsContent(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.GetStylesContent) {
                StiChartHelper.getStylesContent(currentReport, param, callbackResult, false);
            } else if (command == StiDesignerCommand.SetLabelsType) {
                StiChartHelper.setLabelsType(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.SetChartStyle) {
                StiChartHelper.setChartStyle(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.SetChartPropertyValue) {
                StiChartHelper.setChartPropertyValue(currentReport, param, callbackResult);
            } else if (command == StiDesignerCommand.SendContainerValue) {
                StiChartHelper.setContainerValue(currentReport, param, callbackResult);
            } else if (command != StiDesignerCommand.GetReportFromData) {
                if (command == StiDesignerCommand.ItemResourceSave) {
                    if (currentReport != null) {
                        // empty if block
                    }
                } else if (command == StiDesignerCommand.CloneItemResourceSave) {
                    if (currentReport != null) {
                        // empty if block
                    }
                } else if (command == StiDesignerCommand.GetDatabaseData) {
                    StiDictionaryHelper.getDatabaseData(currentReport, (HashMap<String, Object>)param, callbackResult);
                } else if (command == StiDesignerCommand.ApplySelectedData) {
                    StiDictionaryHelper.applySelectedData(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.CreateTextComponent) {
                    StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                    StiReportEdit.createTextComponentFromDictionary(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.CreateDataComponent) {
                    StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                    StiReportEdit.createDataComponentFromDictionary(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.SetReportProperties) {
                    StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                    StiReportEdit.setReportProperties(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.PageMove) {
                    StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                    StiReportEdit.pageMove(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.TestConnection) {
                    StiDictionaryHelper.testConnection(currentReport, param, callbackResult, (StiWebDesignerOptions)StiCacheHelper.getOptions((StiRequestParams)requestParams, (StiHttpServletRequest)httpContext));
                } else if (command == StiDesignerCommand.RunQueryScript) {
                    StiDictionaryHelper.runQueryScript(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.ViewData) {
                    StiDictionaryHelper.viewData(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.ApplyDesignerOptions) {
                    currentReport.getInfo().setZoom(StiReportEdit.strToDouble((String)param.get("zoom")));
                    StiWebDesignerOptionsHelper.applyDesignerOptionsToReport((HashMap)param.get("designerOptions"), currentReport);
                    if (param.get("reportFile") != null) {
                        currentReport.setReportFile((String)param.get("reportFile"));
                    }
                    callbackResult.put("reportObject", StiReportEdit.writeReportInObject(currentReport));
                    callbackResult.put("selectedObjectName", param.get("selectedObjectName"));
                } else if (command == StiDesignerCommand.GetSqlParameterTypes) {
                    StiDictionaryHelper.getSqlParameterTypes(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.AlignToGridComponents) {
                    StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                    StiReportEdit.alignToGridComponents(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.ChangeArrangeComponents) {
                    StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                    StiReportEdit.changeArrangeComponents(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.UpdateSampleTextFormat) {
                    StiFormatService service = StiTextFormatHelper.getFormatService((HashMap)param.get("textFormat"));
                    if (!service.getIsFormatStringFromVariable()) {
                        callbackResult.put("sampleText", service.Format(service.getSample(), null));
                    }
                    service = null;
                } else if (command == StiDesignerCommand.StartEditCrossTabComponent) {
                    StiComponent component = currentReport.GetComponentByName((String)param.get("componentName"));
                    if (component != null) {
                        StiReportEdit.saveComponentClone(httpContext, requestParams, component);
                    }
                } else if (command == StiDesignerCommand.UpdateCrossTabComponent) {
                    StiComponent component = currentReport.GetComponentByName((String)param.get("componentName"));
                    if (component != null && component instanceof StiCrossTab) {
                        StiCrossTabHelper crossTabHelper = new StiCrossTabHelper((StiCrossTab)component);
                        crossTabHelper.executeJSCommand((HashMap)param.get("updateParameters"), callbackResult);
                        crossTabHelper.restorePositions();
                        crossTabHelper = null;
                    }
                } else if (command == StiDesignerCommand.GetCrossTabColorStyles) {
                    callbackResult.put("colorStyles", StiCrossTabHelper.getColorStyles());
                } else if (command == StiDesignerCommand.DuplicatePage) {
                    StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                    StiReportEdit.duplicatePage(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.SetEventValue) {
                    StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                    StiReportEdit.setEventValue(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.GetChartStylesContent) {
                    StiChartHelper.getStylesContent(currentReport, param, callbackResult, true);
                } else if (command == StiDesignerCommand.GetGaugeStylesContent) {
                    StiGaugeHelper.getStylesContent(currentReport, param, callbackResult, true);
                } else if (command == StiDesignerCommand.GetMapStylesContent) {
                    StiMapHelper.getStylesContent(currentReport, param, callbackResult);
                } else if (command == StiDesignerCommand.GetCrossTabStylesContent) {
                    callbackResult.put("stylesContent", StiCrossTabHelper.getColorStyles());
                } else if (command == StiDesignerCommand.GetTableStylesContent) {
                    callbackResult.put("stylesContent", StiTableHelper.getTableStyles());
                } else if (command == StiDesignerCommand.ChangeTableComponent) {
                    StiComponent table = currentReport.GetComponentByName((String)param.get("tableName"));
                    if (table != null && table instanceof StiTable) {
                        StiTableHelper tableHelper = new StiTableHelper((StiTable)table, StiReportEdit.strToDouble((String)param.get("zoom")));
                        tableHelper.executeJSCommand((HashMap)param.get("changeParameters"), callbackResult);
                        tableHelper = null;
                    }
                } else {
                    if (command == StiDesignerCommand.UpdateImagesArray) {
                        callbackResult.put("images", StiDesignerResourcesHelper.getImagesArray(requestParams, null));
                        return StiWebActionResult.jsonResult((StiRequestParams)requestParams, callbackResult);
                    }
                    if (command == StiDesignerCommand.OpenStyle) {
                        StiStylesHelper.openStyle(requestParams, currentReport, callbackResult);
                    } else if (command == StiDesignerCommand.ChangeSizeComponents) {
                        StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                        StiReportEdit.changeSizeComponents(currentReport, param, callbackResult);
                    } else if (command == StiDesignerCommand.CreateFieldOnDblClick) {
                        StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                        StiDictionaryHelper.createFieldOnDblClick(currentReport, param, callbackResult);
                    } else if (command == StiDesignerCommand.GetParamsFromQueryString) {
                        StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                        StiDictionaryHelper.getParamsFromQueryString(currentReport, param, callbackResult);
                    } else if (command == StiDesignerCommand.CreateMovingCopyComponent) {
                        StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                        StiReportEdit.createMovingCopyComponent(httpContext, requestParams, currentReport, param, callbackResult);
                    } else if (command == StiDesignerCommand.GetReportCheckItems) {
                        List<StiCheck> checks = StiReportCheckHelper.checkReport(httpContext, requestParams, currentReport, true);
                        callbackResult.put("checkItems", StiReportCheckHelper.getChecksJSCollection(checks));
                    } else if (command == StiDesignerCommand.GetCheckPreview) {
                        StiReportCheckHelper.getCheckPreview(httpContext, requestParams, currentReport, param, callbackResult);
                    } else if (command == StiDesignerCommand.ActionCheck) {
                        StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                        StiReportCheckHelper.actionCheck(httpContext, requestParams, currentReport, param, callbackResult);
                    } else if (command == StiDesignerCommand.CheckExpression) {
                        StiReportCheckHelper.checkExpression(currentReport, param, callbackResult);
                    } else if (command == StiDesignerCommand.GetGlobalizationStrings) {
                        callbackResult.put("globalizationStrings", StiCultureHelper.getReportGlobalizationStrings(currentReport));
                        callbackResult.put("cultures", StiCultureHelper.getItems());
                    } else if (command == StiDesignerCommand.AddGlobalizationStrings) {
                        StiCultureHelper.addReportGlobalizationStrings(currentReport, param, callbackResult);
                    } else if (command == StiDesignerCommand.RemoveGlobalizationStrings) {
                        StiCultureHelper.removeReportGlobalizationStrings(currentReport, param, callbackResult);
                    } else if (command == StiDesignerCommand.GetCultureSettingsFromReport) {
                        StiCultureHelper.getCultureSettingsFromReport(currentReport, param, callbackResult);
                    } else if (command == StiDesignerCommand.SetCultureSettingsToReport) {
                        StiCultureHelper.setCultureSettingsToReport(currentReport, param, callbackResult);
                    } else if (command == StiDesignerCommand.ApplyGlobalizationStrings) {
                        StiCultureHelper.applyGlobalizationStrings(currentReport, param, callbackResult);
                    } else if (command == StiDesignerCommand.StartEditGaugeComponent) {
                        StiComponent component = currentReport.GetComponentByName((String)param.get("componentName"));
                        if (component != null) {
                            StiReportEdit.saveComponentClone(httpContext, requestParams, component);
                            callbackResult.put("properties", StiGaugeHelper.GetGaugeProperties((StiGauge)component));
                        }
                    } else if (command == StiDesignerCommand.GetResourceContent) {
                        StiReportResourcesHelper.getResourceContent(currentReport, param, callbackResult);
                    } else if (command == StiDesignerCommand.ConvertResourceContent) {
                        StiResourceType type = StiResourceType.valueOf((String)((String)param.get("type")));
                        callbackResult.put("content", StiReportResourcesHelper.getStringContentForJSFromResourceContent(type, requestParams.data));
                    } else if (command == StiDesignerCommand.GetResourceText) {
                        StiReportResourcesHelper.getResourceText(currentReport, param, callbackResult);
                    } else if (command == StiDesignerCommand.SetResourceText) {
                        StiReportResourcesHelper.setResourceText(currentReport, param, callbackResult);
                    } else if (command == StiDesignerCommand.GetResourceViewData) {
                        StiReportResourcesHelper.getResourceViewData(currentReport, param, callbackResult);
                    } else if (command == StiDesignerCommand.UpdateGaugeComponent) {
                        StiComponent component = currentReport.GetComponentByName((String)param.get("componentName"));
                        if (component != null && component instanceof StiGauge) {
                            StiGaugeHelper.executeJSCommand((StiGauge)component, (HashMap)param.get("updateParameters"), callbackResult);
                        }
                    } else if (command == StiDesignerCommand.GetImagesGallery) {
                        StiDictionaryHelper.getImagesGallery(currentReport, param, callbackResult);
                    } else if (command == StiDesignerCommand.CreateComponentFromResource) {
                        StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                        StiReportEdit.createComponentFromResource(currentReport, param, callbackResult);
                    } else if (command == StiDesignerCommand.GetSampleConnectionString) {
                        StiDictionaryHelper.getSampleConnectionString(currentReport, param, callbackResult, (StiWebDesignerOptions)StiCacheHelper.getOptions((StiRequestParams)requestParams, (StiHttpServletRequest)httpContext));
                    } else if (command == StiDesignerCommand.CreateDatabaseFromResource) {
                        StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                        StiDictionaryHelper.createDatabaseFromResource(currentReport, param, callbackResult);
                    } else if (command == StiDesignerCommand.GetRichTextGallery) {
                        StiDictionaryHelper.getRichTextGallery(currentReport, param, callbackResult);
                    } else if (command == StiDesignerCommand.GetRichTextContent) {
                        callbackResult.put("content", StiGalleriesHelper.getHtmlStringFromRichTextItem((StiReport)currentReport, (HashMap)((HashMap)param.get("itemObject"))));
                    } else if (command == StiDesignerCommand.DeleteAllDataSources) {
                        StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                        StiDictionaryHelper.deleteAllDataSources(currentReport, param, callbackResult);
                    } else if (command != StiDesignerCommand.LoadReportFromCloud) {
                        if (command == StiDesignerCommand.StartEditBarCodeComponent) {
                            StiComponent component = currentReport.GetComponentByName((String)param.get("componentName"));
                            if (component != null) {
                                StiReportEdit.saveComponentClone(httpContext, requestParams, component);
                                callbackResult.put("barCode", StiBarCodeHelper.getBarCodeJSObject((StiBarCode)component));
                            }
                        } else if (command == StiDesignerCommand.ApplyBarCodeProperties) {
                            StiBarCodeHelper.applyBarCodeProperties(currentReport, param, callbackResult);
                        } else {
                            if (command == StiDesignerCommand.DownloadReport) {
                                String reportFile = !StiValidationUtil.isNullOrEmpty((String)requestParams.designer.fileName) ? requestParams.designer.fileName : "Report.mrt";
                                String password = requestParams.designer.password;
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                if (password != null) {
                                    if (reportFile.toLowerCase().endsWith(".mrt")) {
                                        reportFile = reportFile.substring(0, reportFile.length() - 4) + ".mrx";
                                    } else if (!reportFile.toLowerCase().endsWith(".mrx")) {
                                        reportFile = reportFile + ".mrx";
                                    }
                                    StiSerializeManager.serializeReport((StiReport)currentReport, (OutputStream)baos, (String)password);
                                } else if ("json".equals(requestParams.designer.saveType)) {
                                    StiSerializeManager.serializeReportToJson((StiReport)currentReport, (OutputStream)baos);
                                } else if ("xml".equals(requestParams.designer.saveType)) {
                                    StiSerializeManager.serializeReport((StiReport)currentReport, (OutputStream)baos, (boolean)true);
                                } else {
                                    StiSerializeManager.serializeReport((StiReport)currentReport, (OutputStream)baos, (boolean)true);
                                }
                                return new StiWebActionResult(baos.toByteArray(), reportFile, "application/octet-stream");
                            }
                            if (command == StiDesignerCommand.DownloadStyles) {
                                StiReport tempReport = new StiReport();
                                String styles = requestParams.getString("stylesCollection");
                                if (styles != null) {
                                    ArrayList stylesCollection = new ArrayList();
                                    StiRequestParamsHelper.parseParameters((Object)new JSONArray(styles), null, stylesCollection);
                                    StiStylesHelper.writeStylesToReport(tempReport, stylesCollection);
                                    return new StiWebActionResult(tempReport.getStyles().saveToString(), "application/octet-stream", "Styles.sts");
                                }
                            } else if (command == StiDesignerCommand.GetVariableItemsFromDataColumn) {
                                StiDictionaryHelper.getVariableItemsFromDataColumn(currentReport, param, callbackResult);
                            } else if (command == StiDesignerCommand.MoveDictionaryItem) {
                                StiDictionaryHelper.moveDictionaryItem(currentReport, param, callbackResult);
                            } else if (command == StiDesignerCommand.UpdateReportAliases) {
                                StiReportEdit.updateReportAliases(requestParams, currentReport, param, callbackResult);
                            } else if (command == StiDesignerCommand.MoveConnectionDataToResource) {
                                StiDictionaryHelper.moveConnectionDataToResource(currentReport, param, callbackResult);
                            } else if (command == StiDesignerCommand.GetShapeSampleImage) {
                                StiShapeHelper.getShapeSampleImage(currentReport, param, callbackResult);
                            } else if (command == StiDesignerCommand.SetMapProperties) {
                                StiMapHelper.setMapProperties(currentReport, param, callbackResult);
                            } else if (command == StiDesignerCommand.UpdateMapData) {
                                StiMapHelper.updateMapData(currentReport, param, callbackResult);
                            } else if (command == StiDesignerCommand.OpenPage) {
                                StiReportEdit.openPage(requestParams, currentReport, callbackResult);
                            } else if (command == StiDesignerCommand.DuplicateDictionaryElement) {
                                StiReportEdit.addReportToUndoArray(httpContext, requestParams, currentReport);
                                StiDictionaryHelper.duplicateDictionaryElement(currentReport, param, callbackResult);
                            } else if (command == StiDesignerCommand.DownloadPage) {
                                long pageIndex = Func.Convert.toInt32(param.get("pageIndex"));
                                if ((long)currentReport.getPages().size() > pageIndex) {
                                    StiComponent cloneComponent = StiComponentHelper.clone((StiComponent)currentReport.getPages().get((int)pageIndex));
                                    cloneComponent.setParent(null);
                                    String pageStr = StiSerializerControler.serializedObjectAsString((IStiSerializable)cloneComponent, (String)"Page");
                                    return new StiWebActionResult(pageStr.getBytes("UTF-8"), "application/octet-stream", "Page.pg");
                                }
                            } else if (command == StiDesignerCommand.GetTableOfContentsIdents) {
                                StiTableOfContentsHelper.getIdentsCollection(currentReport, param, callbackResult);
                            } else if (command == StiDesignerCommand.UpdateComponentsPointerValues) {
                                StiTableOfContentsHelper.updateComponentsPointerValues(currentReport, param, callbackResult);
                            }
                        }
                    }
                }
            }
            if (currentReport != null) {
                requestParams.cache.helper.saveReportInternal(requestParams, currentReport, httpContext);
            } else {
                requestParams.cache.helper.removeReportInternal(requestParams, httpContext);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackResult.put("error", e.getMessage() != null ? e.getMessage() : e.toString());
            return StiWebActionResult.jsonResult((StiRequestParams)requestParams, callbackResult);
        }
        return StiWebActionResult.jsonResult((StiRequestParams)requestParams, callbackResult);
    }
}

