/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.fmt;

import com.spotify.fmt.FormattingConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class FormattingConfigurationBuilder {
    private boolean debug;
    private String style;
    private List<File> directoriesToFormat;
    private boolean verbose;
    private String filesNamePattern;
    private String filesPathPattern;
    private boolean skipSortingImports;
    private boolean writeReformattedFiles;
    private String processingLabel;

    public FormattingConfigurationBuilder() {
    }

    private FormattingConfigurationBuilder(FormattingConfiguration v) {
        this.debug = v.debug();
        this.style = v.style();
        List<File> _directoriesToFormat = v.directoriesToFormat();
        this.directoriesToFormat = _directoriesToFormat == null ? null : new ArrayList<File>(_directoriesToFormat);
        this.verbose = v.verbose();
        this.filesNamePattern = v.filesNamePattern();
        this.filesPathPattern = v.filesPathPattern();
        this.skipSortingImports = v.skipSortingImports();
        this.writeReformattedFiles = v.writeReformattedFiles();
        this.processingLabel = v.processingLabel();
    }

    private FormattingConfigurationBuilder(FormattingConfigurationBuilder v) {
        this.debug = v.debug();
        this.style = v.style();
        this.directoriesToFormat = new ArrayList<File>(v.directoriesToFormat());
        this.verbose = v.verbose();
        this.filesNamePattern = v.filesNamePattern();
        this.filesPathPattern = v.filesPathPattern();
        this.skipSortingImports = v.skipSortingImports();
        this.writeReformattedFiles = v.writeReformattedFiles();
        this.processingLabel = v.processingLabel();
    }

    public boolean debug() {
        return this.debug;
    }

    public FormattingConfigurationBuilder debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public String style() {
        return this.style;
    }

    public FormattingConfigurationBuilder style(String style) {
        if (style == null) {
            throw new NullPointerException("style");
        }
        this.style = style;
        return this;
    }

    public List<File> directoriesToFormat() {
        if (this.directoriesToFormat == null) {
            this.directoriesToFormat = new ArrayList<File>();
        }
        return this.directoriesToFormat;
    }

    public FormattingConfigurationBuilder directoriesToFormat(List<? extends File> directoriesToFormat) {
        return this.directoriesToFormat((Collection<? extends File>)directoriesToFormat);
    }

    public FormattingConfigurationBuilder directoriesToFormat(Collection<? extends File> directoriesToFormat) {
        if (directoriesToFormat == null) {
            throw new NullPointerException("directoriesToFormat");
        }
        for (File file : directoriesToFormat) {
            if (file != null) continue;
            throw new NullPointerException("directoriesToFormat: null item");
        }
        this.directoriesToFormat = new ArrayList<File>(directoriesToFormat);
        return this;
    }

    public FormattingConfigurationBuilder directoriesToFormat(Iterable<? extends File> directoriesToFormat) {
        if (directoriesToFormat == null) {
            throw new NullPointerException("directoriesToFormat");
        }
        if (directoriesToFormat instanceof Collection) {
            return this.directoriesToFormat((Collection)directoriesToFormat);
        }
        return this.directoriesToFormat(directoriesToFormat.iterator());
    }

    public FormattingConfigurationBuilder directoriesToFormat(Iterator<? extends File> directoriesToFormat) {
        if (directoriesToFormat == null) {
            throw new NullPointerException("directoriesToFormat");
        }
        this.directoriesToFormat = new ArrayList<File>();
        while (directoriesToFormat.hasNext()) {
            File item = directoriesToFormat.next();
            if (item == null) {
                throw new NullPointerException("directoriesToFormat: null item");
            }
            this.directoriesToFormat.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final FormattingConfigurationBuilder directoriesToFormat(File ... directoriesToFormat) {
        if (directoriesToFormat == null) {
            throw new NullPointerException("directoriesToFormat");
        }
        return this.directoriesToFormat(Arrays.asList(directoriesToFormat));
    }

    public boolean verbose() {
        return this.verbose;
    }

    public FormattingConfigurationBuilder verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public String filesNamePattern() {
        return this.filesNamePattern;
    }

    public FormattingConfigurationBuilder filesNamePattern(String filesNamePattern) {
        if (filesNamePattern == null) {
            throw new NullPointerException("filesNamePattern");
        }
        this.filesNamePattern = filesNamePattern;
        return this;
    }

    public String filesPathPattern() {
        return this.filesPathPattern;
    }

    public FormattingConfigurationBuilder filesPathPattern(String filesPathPattern) {
        if (filesPathPattern == null) {
            throw new NullPointerException("filesPathPattern");
        }
        this.filesPathPattern = filesPathPattern;
        return this;
    }

    public boolean skipSortingImports() {
        return this.skipSortingImports;
    }

    public FormattingConfigurationBuilder skipSortingImports(boolean skipSortingImports) {
        this.skipSortingImports = skipSortingImports;
        return this;
    }

    public boolean writeReformattedFiles() {
        return this.writeReformattedFiles;
    }

    public FormattingConfigurationBuilder writeReformattedFiles(boolean writeReformattedFiles) {
        this.writeReformattedFiles = writeReformattedFiles;
        return this;
    }

    public String processingLabel() {
        return this.processingLabel;
    }

    public FormattingConfigurationBuilder processingLabel(String processingLabel) {
        if (processingLabel == null) {
            throw new NullPointerException("processingLabel");
        }
        this.processingLabel = processingLabel;
        return this;
    }

    public FormattingConfiguration build() {
        List<File> _directoriesToFormat = this.directoriesToFormat != null ? Collections.unmodifiableList(new ArrayList<File>(this.directoriesToFormat)) : Collections.emptyList();
        return new Value(this.debug, this.style, _directoriesToFormat, this.verbose, this.filesNamePattern, this.filesPathPattern, this.skipSortingImports, this.writeReformattedFiles, this.processingLabel);
    }

    public static FormattingConfigurationBuilder from(FormattingConfiguration v) {
        return new FormattingConfigurationBuilder(v);
    }

    public static FormattingConfigurationBuilder from(FormattingConfigurationBuilder v) {
        return new FormattingConfigurationBuilder(v);
    }

    private static final class Value
    implements FormattingConfiguration {
        private final boolean debug;
        private final String style;
        private final List<File> directoriesToFormat;
        private final boolean verbose;
        private final String filesNamePattern;
        private final String filesPathPattern;
        private final boolean skipSortingImports;
        private final boolean writeReformattedFiles;
        private final String processingLabel;

        private Value(boolean debug, String style, List<File> directoriesToFormat, boolean verbose, String filesNamePattern, String filesPathPattern, boolean skipSortingImports, boolean writeReformattedFiles, String processingLabel) {
            if (style == null) {
                throw new NullPointerException("style");
            }
            if (filesNamePattern == null) {
                throw new NullPointerException("filesNamePattern");
            }
            if (filesPathPattern == null) {
                throw new NullPointerException("filesPathPattern");
            }
            if (processingLabel == null) {
                throw new NullPointerException("processingLabel");
            }
            this.debug = debug;
            this.style = style;
            this.directoriesToFormat = directoriesToFormat != null ? directoriesToFormat : Collections.emptyList();
            this.verbose = verbose;
            this.filesNamePattern = filesNamePattern;
            this.filesPathPattern = filesPathPattern;
            this.skipSortingImports = skipSortingImports;
            this.writeReformattedFiles = writeReformattedFiles;
            this.processingLabel = processingLabel;
        }

        @Override
        public boolean debug() {
            return this.debug;
        }

        @Override
        public String style() {
            return this.style;
        }

        @Override
        public List<File> directoriesToFormat() {
            return this.directoriesToFormat;
        }

        @Override
        public boolean verbose() {
            return this.verbose;
        }

        @Override
        public String filesNamePattern() {
            return this.filesNamePattern;
        }

        @Override
        public String filesPathPattern() {
            return this.filesPathPattern;
        }

        @Override
        public boolean skipSortingImports() {
            return this.skipSortingImports;
        }

        @Override
        public boolean writeReformattedFiles() {
            return this.writeReformattedFiles;
        }

        @Override
        public String processingLabel() {
            return this.processingLabel;
        }

        @Override
        public FormattingConfigurationBuilder builder() {
            return new FormattingConfigurationBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FormattingConfiguration)) {
                return false;
            }
            FormattingConfiguration that = (FormattingConfiguration)o;
            if (this.debug != that.debug()) {
                return false;
            }
            if (this.style != null ? !this.style.equals(that.style()) : that.style() != null) {
                return false;
            }
            if (this.directoriesToFormat != null ? !this.directoriesToFormat.equals(that.directoriesToFormat()) : that.directoriesToFormat() != null) {
                return false;
            }
            if (this.verbose != that.verbose()) {
                return false;
            }
            if (this.filesNamePattern != null ? !this.filesNamePattern.equals(that.filesNamePattern()) : that.filesNamePattern() != null) {
                return false;
            }
            if (this.filesPathPattern != null ? !this.filesPathPattern.equals(that.filesPathPattern()) : that.filesPathPattern() != null) {
                return false;
            }
            if (this.skipSortingImports != that.skipSortingImports()) {
                return false;
            }
            if (this.writeReformattedFiles != that.writeReformattedFiles()) {
                return false;
            }
            return !(this.processingLabel != null ? !this.processingLabel.equals(that.processingLabel()) : that.processingLabel() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.debug ? 1231 : 1237);
            result = 31 * result + (this.style != null ? this.style.hashCode() : 0);
            result = 31 * result + (this.directoriesToFormat != null ? this.directoriesToFormat.hashCode() : 0);
            result = 31 * result + (this.verbose ? 1231 : 1237);
            result = 31 * result + (this.filesNamePattern != null ? this.filesNamePattern.hashCode() : 0);
            result = 31 * result + (this.filesPathPattern != null ? this.filesPathPattern.hashCode() : 0);
            result = 31 * result + (this.skipSortingImports ? 1231 : 1237);
            result = 31 * result + (this.writeReformattedFiles ? 1231 : 1237);
            result = 31 * result + (this.processingLabel != null ? this.processingLabel.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "FormattingConfiguration{debug=" + this.debug + ", style=" + this.style + ", directoriesToFormat=" + String.valueOf(this.directoriesToFormat) + ", verbose=" + this.verbose + ", filesNamePattern=" + this.filesNamePattern + ", filesPathPattern=" + this.filesPathPattern + ", skipSortingImports=" + this.skipSortingImports + ", writeReformattedFiles=" + this.writeReformattedFiles + ", processingLabel=" + this.processingLabel + "}";
        }
    }
}

