/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.merger.standard.internal.reference;

import com.speedment.jpastreamer.merger.standard.internal.reference.IntermediateOperationReference;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperation;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class DefaultIntermediateOperationReference
implements IntermediateOperationReference {
    private final IntermediateOperation<?, ?> intermediateOperation;
    private final int index;
    private final List<IntermediateOperation<?, ?>> intermediateOperations;

    public DefaultIntermediateOperationReference(IntermediateOperation<?, ?> intermediateOperation, int index, List<IntermediateOperation<?, ?>> intermediateOperations) {
        this.intermediateOperation = Objects.requireNonNull(intermediateOperation);
        this.index = index;
        this.intermediateOperations = Collections.unmodifiableList(Objects.requireNonNull(intermediateOperations));
    }

    @Override
    public IntermediateOperation<?, ?> get() {
        return this.intermediateOperation;
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public Optional<IntermediateOperationReference> previous() {
        if (this.index - 1 < 0) {
            return Optional.empty();
        }
        IntermediateOperation<?, ?> operation = this.intermediateOperations.get(this.index - 1);
        DefaultIntermediateOperationReference reference = new DefaultIntermediateOperationReference(operation, this.index - 1, this.intermediateOperations);
        return Optional.of(reference);
    }

    @Override
    public Optional<IntermediateOperationReference> next() {
        if (this.index + 1 > this.intermediateOperations.size() - 1) {
            return Optional.empty();
        }
        IntermediateOperation<?, ?> operation = this.intermediateOperations.get(this.index + 1);
        DefaultIntermediateOperationReference reference = new DefaultIntermediateOperationReference(operation, this.index + 1, this.intermediateOperations);
        return Optional.of(reference);
    }
}

