/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.property;

import com.solacesystems.common.property.Property;
import com.solacesystems.common.property.PropertyConversionException;
import com.solacesystems.common.property.PropertySource;
import com.solacesystems.common.property.PropertyVetoException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class JMSAPIPropertyBean {
    private TreeMap<String, Property<?>> mPropertyMap = new TreeMap();

    public JMSAPIPropertyBean(Collection<Property<?>> properties) {
        for (Property<?> property : properties) {
            if (property.getSource("JMS API") == null) continue;
            this.mPropertyMap.put(property.getId(), property);
        }
    }

    public Map<String, Property<?>> getPropertyMap() {
        return this.mPropertyMap;
    }

    private Property<?> getProperty(String propertyName) {
        Property<?> property = this.mPropertyMap.get(propertyName);
        if (property == null) {
            throw new IllegalArgumentException("Property \"" + propertyName + "\" Not Found");
        }
        return property;
    }

    private PropertySource<?> getPropertySource(String propertyName) {
        Property<?> property = this.getProperty(propertyName);
        PropertySource<?> source = property.getSource("JMS API");
        if (source == null) {
            throw new IllegalArgumentException("Property \"" + propertyName + "\" Source \"JMS API\" Not Found");
        }
        return source;
    }

    public Object getValue(String propertyName) {
        return this.getPropertySource(propertyName).getValue();
    }

    public void setValue(String propertyName, Object propertyValue) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource(propertyName).setObjectValue(propertyValue);
    }

    public void setClientID(String ClientID) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("ClientID").setObjectValue(ClientID);
    }

    public void setPassword(String Password) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("Password").setObjectValue(Password);
    }

    public void setUsername(String Username) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("Username").setObjectValue(Username);
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        Iterator<String> it = this.mPropertyMap.keySet().iterator();
        while (it.hasNext()) {
            Property<?> property = this.mPropertyMap.get(it.next());
            bldr.append("property=\"" + property.getId() + "\", ");
            bldr.append(property.getSource("JMS API"));
            bldr.append("\n");
        }
        return bldr.toString();
    }
}

