/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.property;

import java.util.ArrayList;

public class HostInfo {
    public ArrayList<SMFURLInfo> urlInfo = new ArrayList();

    public HostInfo(Object smfUrlObj) {
        if (smfUrlObj == null) {
            throw new IllegalArgumentException("Invalid provider URL - null");
        }
        if (smfUrlObj instanceof String) {
            String[] hostList = ((String)smfUrlObj).split(",");
            if (hostList.length == 0) {
                throw new IllegalArgumentException("Invalid provider URL (" + this.urlInfo + ") - must contain a URL");
            }
            if (hostList.length == 1) {
                this.addSMFURLInfo(new SMFURLInfo(hostList[0]));
            } else {
                for (int i = 0; i < hostList.length; ++i) {
                    this.addSMFURLInfo(new SMFURLInfo(hostList[i]));
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid provider URL (" + this.urlInfo + ") - must be a String");
        }
    }

    public void addSMFURLInfo(SMFURLInfo smfURLInfo) {
        this.urlInfo.add(smfURLInfo);
    }

    public String getUsername() {
        for (int i = 0; i < this.urlInfo.size(); ++i) {
            SMFURLInfo smfURLInfo = this.urlInfo.get(i);
            if (smfURLInfo.username == null) continue;
            return smfURLInfo.username;
        }
        return null;
    }

    public String getPassword() {
        for (int i = 0; i < this.urlInfo.size(); ++i) {
            SMFURLInfo smfURLInfo = this.urlInfo.get(i);
            if (smfURLInfo.password == null || smfURLInfo.password.length() <= 0) continue;
            return smfURLInfo.password;
        }
        return null;
    }

    public String toHostList() {
        StringBuilder bldr = new StringBuilder();
        for (int i = 0; i < this.urlInfo.size(); ++i) {
            SMFURLInfo smfURLInfo = this.urlInfo.get(i);
            if (i > 0) {
                bldr.append(",");
            }
            if (smfURLInfo.isWebSocketClient) {
                if (smfURLInfo.secure) {
                    bldr.append("wss://");
                } else {
                    bldr.append("ws://");
                }
            } else if (smfURLInfo.secure) {
                bldr.append("tcps://");
            } else {
                bldr.append("tcp://");
            }
            bldr.append(smfURLInfo.host);
            if (smfURLInfo.port <= 0) continue;
            bldr.append(":");
            bldr.append(smfURLInfo.port);
        }
        return bldr.toString();
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("HostInfo {\n");
        this.buildString(bldr);
        bldr.append("\n}\n");
        return bldr.toString();
    }

    private void buildString(StringBuilder bldr) {
        for (int i = 0; i < this.urlInfo.size(); ++i) {
            bldr.append("\t");
            bldr.append(this.urlInfo.get(i));
            bldr.append("\n");
        }
        bldr.append("\n\tuser=");
        bldr.append(this.getString(this.getUsername()));
        bldr.append("\n\tpass=");
        bldr.append(this.getString(this.getPassword()));
        bldr.append("\n\thostList=");
        bldr.append(this.toHostList());
    }

    private String getString(Object value) {
        if (value == null) {
            return null;
        }
        return "\"" + value + "\"";
    }

    public static void test(String url) {
        try {
            HostInfo info = new HostInfo(url);
            System.out.println(url + " ---> " + info);
        }
        catch (Exception e) {
            System.err.println(url + " ---> " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        HostInfo.test(null);
        HostInfo.test("    ");
        HostInfo.test("gaga://192.168.1.1");
        HostInfo.test("192.168.1.1");
        HostInfo.test("smfss://192.168.1.1");
        HostInfo.test("smf://");
        HostInfo.test("smf://:80");
        HostInfo.test("smf://192.168.1.1");
        HostInfo.test("SMF://192.168.1.1");
        HostInfo.test("Smf://192.168.1.1");
        HostInfo.test("tcp://192.168.1.1");
        HostInfo.test("TCP://192.168.1.1");
        HostInfo.test("tcP://192.168.1.1");
        HostInfo.test("smfs://192.168.1.1");
        HostInfo.test("SMFS://192.168.1.1");
        HostInfo.test("Smfs://192.168.1.1");
        HostInfo.test("tcps://192.168.1.1");
        HostInfo.test("TCPS://192.168.1.1");
        HostInfo.test("tcPs://192.168.1.1");
        HostInfo.test("   smf://192.168.1.1");
        HostInfo.test("   smf://192.168.1.1   ");
        HostInfo.test("smf://192.168.1.1:12345");
        HostInfo.test("smfs://192.168.1.1:12345   ");
        HostInfo.test("smf://192.168.1.1:   12345");
        HostInfo.test("smfs://192.168.1.1:");
        HostInfo.test("smf://@192.168.1.1");
        HostInfo.test("smfs://:@192.168.1.1");
        HostInfo.test("smf://:192.168.1.1");
        HostInfo.test("smfs://user:pass@192.168.1.1");
        HostInfo.test("smf://user:pass:pass2@192.168.1.1");
        HostInfo.test("smfs://user:pass:pass2@192.168.1.1:12345:12346");
        HostInfo.test("smf://user:pass:pass2@server_1:12345:12346");
        HostInfo.test("smfs://user:pass:pass2@:12346");
        HostInfo.test("smf://user:pass@server_1:12345");
        HostInfo.test("smf://@[fe80::592:3922:b308:62c5%26]");
        HostInfo.test("smfs://:@[fe80::592:3922:b308:62c5%26]");
        HostInfo.test("smf://user:pass@[fe80::592:3922:b308:62c5%26]");
        HostInfo.test("smf://user:pass:pass2@[fe80::592:3922:b308:62c5%26]");
        HostInfo.test("smf://user:pass@[fe80::592:3922:b308:62c5%26]:12345");
        HostInfo.test("smf://user:pass@[fe80::592:3922:b308:62c5%26]:12345:33333");
    }

    protected static class SMFURLInfo {
        private String username = null;
        private String password = "";
        private String host = null;
        private int port = 0;
        private boolean secure = false;
        private boolean isWebSocketClient = false;

        public SMFURLInfo(String smfUrl) {
            this.parseURL(smfUrl);
        }

        private void parseURL(String smfUrl) {
            if (smfUrl == null) {
                throw new IllegalArgumentException("Invalid provider URL - null");
            }
            String trimmedSmfUrl = smfUrl.trim();
            if (trimmedSmfUrl.length() == 0) {
                throw new IllegalArgumentException("Invalid provider URL - empty string");
            }
            if (!trimmedSmfUrl.contains("://")) {
                trimmedSmfUrl = "smf://" + trimmedSmfUrl;
            }
            int endSchemeIdx = 0;
            String lowerSmfUrl = trimmedSmfUrl.toLowerCase();
            if (lowerSmfUrl.startsWith("smf://") || lowerSmfUrl.startsWith("tcp://")) {
                this.secure = false;
                endSchemeIdx = 6;
            } else if (lowerSmfUrl.startsWith("smfs://") || lowerSmfUrl.startsWith("tcps://")) {
                this.secure = true;
                endSchemeIdx = 7;
            } else if (lowerSmfUrl.startsWith("ws://")) {
                this.secure = false;
                endSchemeIdx = 5;
                this.isWebSocketClient = true;
            } else if (lowerSmfUrl.startsWith("wss://")) {
                this.secure = true;
                endSchemeIdx = 6;
                this.isWebSocketClient = true;
            } else {
                throw new IllegalArgumentException("Unsupported scheme in Provider URL (" + smfUrl + "), must be one of [smf, smfs, tcp, tcps, ws, wss]");
            }
            String hostPort = null;
            String userPass = null;
            int firstAtIdx = trimmedSmfUrl.indexOf(64);
            if (firstAtIdx == -1) {
                userPass = null;
                hostPort = trimmedSmfUrl.substring(endSchemeIdx);
            } else {
                userPass = trimmedSmfUrl.substring(endSchemeIdx, firstAtIdx);
                hostPort = trimmedSmfUrl.substring(firstAtIdx + 1);
            }
            if (userPass != null && userPass.length() > 0) {
                int userIdx = userPass.indexOf(58);
                if (userIdx == -1) {
                    this.username = userPass;
                } else {
                    this.username = userPass.substring(0, userIdx);
                    this.password = userPass.substring(userIdx + 1);
                }
            }
            if (this.username != null && this.username.length() == 0) {
                this.username = null;
            }
            if (hostPort != null && hostPort.length() > 0) {
                if (hostPort.contains("[") && hostPort.contains("]")) {
                    int start = hostPort.indexOf("[");
                    int end = hostPort.indexOf("]");
                    if (start != 0 || start + 1 > end) {
                        throw new IllegalArgumentException("Bad host address: " + hostPort);
                    }
                    String[] hostelems = hostPort.substring(end).split(":");
                    if (hostelems.length > 2) {
                        throw new IllegalArgumentException("Too many colons in host: " + hostPort);
                    }
                    if (hostelems.length == 2) {
                        this.port = Integer.parseInt(hostelems[1].trim());
                    }
                    this.host = hostPort.substring(start, end + 1);
                } else {
                    int colonIdx = hostPort.indexOf(58);
                    if (colonIdx == -1) {
                        this.host = hostPort;
                    } else {
                        this.host = hostPort.substring(0, colonIdx);
                        if (colonIdx < hostPort.length() - 1) {
                            String portStr = hostPort.substring(colonIdx + 1, hostPort.length());
                            try {
                                this.port = Integer.parseInt(portStr);
                            }
                            catch (NumberFormatException e) {
                                throw new IllegalArgumentException("Unsupported port \"" + portStr + "\" in Provider URL (" + smfUrl + ")");
                            }
                        }
                    }
                }
            }
            if (this.host == null || this.host.trim().length() == 0) {
                throw new IllegalArgumentException("No host provided in Provider URL (" + smfUrl + ")");
            }
        }

        public String toString() {
            StringBuilder bldr = new StringBuilder();
            bldr.append("host=");
            bldr.append(this.host);
            if (this.port != 0) {
                bldr.append(":");
                bldr.append(this.port);
            }
            bldr.append(", user=");
            bldr.append(this.getString(this.username));
            bldr.append(", pass=");
            bldr.append(this.getString(this.password));
            return bldr.toString();
        }

        private String getString(Object value) {
            if (value == null) {
                return null;
            }
            return "\"" + value + "\"";
        }
    }
}

