/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jms.SolConnectionIF;
import com.solacesystems.jms.SolMessageConsumerIF;
import com.solacesystems.jms.SolTemporaryTopicIF;
import com.solacesystems.jms.impl.SolJMSErrorMessages;
import com.solacesystems.jms.impl.SolTopicImpl;
import com.solacesystems.jms.impl.Validator;
import java.util.LinkedList;
import java.util.List;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;

public class SolTemporaryTopic
extends SolTopicImpl
implements SolTemporaryTopicIF {
    private static final long serialVersionUID = 8309646796980857369L;
    private static final LogWrapper log = new LogWrapper(SolTemporaryTopic.class);
    private transient SolConnectionIF mConnection;
    private boolean mDeleted;
    private final List<SolMessageConsumerIF> mConsumers;

    public SolTemporaryTopic(Topic topic) {
        super(topic);
        this.mConnection = null;
        this.mDeleted = false;
        this.mConsumers = new LinkedList<SolMessageConsumerIF>();
    }

    public SolTemporaryTopic(SolConnectionIF connection, Topic topic) {
        super(topic);
        this.mConnection = connection;
        this.mDeleted = false;
        this.mConsumers = new LinkedList<SolMessageConsumerIF>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug("Entering delete.  Topic: " + this.getTopicName());
        }
        if (!this.mDeleted) {
            Validator.checkDeleteTempDestination(this, this.mConnection);
            List<SolMessageConsumerIF> list = this.mConsumers;
            synchronized (list) {
                for (int i = 0; i < this.mConsumers.size(); ++i) {
                    if (!this.mConsumers.get(i).isTemporaryTopicUsed(this)) continue;
                    throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.temp.destination.delete", "soljms.error.tempdestination.inuse", null), "soljms.error.tempdestination.inuse");
                }
            }
            this.mDeleted = true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Leaving delete");
        }
    }

    @Override
    public SolConnectionIF getConnection() {
        return this.mConnection;
    }

    @Override
    public boolean isDeleted() {
        return this.mDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumer(SolMessageConsumerIF consumer) throws JMSException {
        List<SolMessageConsumerIF> list = this.mConsumers;
        synchronized (list) {
            if (this.mDeleted) {
                throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.consumer.create", "soljms.error.tempdestination.deleted", null), "soljms.error.tempdestination.deleted");
            }
            this.mConsumers.add(consumer);
        }
    }
}

