/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.common.util.LogWrapper;
import com.solacesystems.jms.SolMessageProducer;
import com.solacesystems.jms.SolSessionIF;
import com.solacesystems.jms.impl.Validator;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;

public class SolQueueSender
extends SolMessageProducer
implements QueueSender {
    private final LogWrapper log = new LogWrapper(SolQueueSender.class);
    private static final String Component = "QueueSender";

    SolQueueSender(SolSessionIF session, Queue queue) throws JMSException {
        super(session, (Destination)queue);
        this.log.setContextInfo(this.getLogContextInfo());
        if (this.log.isDebugEnabled()) {
            this.log.debug("SolQueueSender created.  Queue: " + (queue == null ? "null" : queue.getQueueName()));
        }
    }

    public synchronized Queue getQueue() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return (Queue)this.mDestination;
    }

    @Override
    public void send(Message message) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering send()");
        }
        Validator.checkClosed(this.mState, Component);
        Validator.checkSendDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), this.mDestination, null);
        Validator.checkMessage(message);
        this.sendMessage(this.mDestination, message, this.mDeliveryMode, this.mPriority, this.mTimeToLive);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving send()");
        }
    }

    @Override
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering send()");
        }
        Validator.checkClosed(this.mState, Component);
        Validator.checkSendDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), this.mDestination, null);
        Validator.checkMessage(message);
        Validator.checkDeliveryMode(deliveryMode);
        Validator.checkPriority(priority);
        Validator.checkTimeToLive(timeToLive);
        this.sendMessage(this.mDestination, message, deliveryMode, priority, timeToLive);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving send()");
        }
    }

    public void send(Queue queue, Message message) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering send()");
        }
        Validator.checkClosed(this.mState, Component);
        Destination destination = Validator.checkSendDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), this.mDestination, (Destination)queue);
        Validator.checkMessage(message);
        this.sendMessage(destination, message, this.mDeliveryMode, this.mPriority, this.mTimeToLive);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving send()");
        }
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering send()");
        }
        Validator.checkClosed(this.mState, Component);
        Destination destination = Validator.checkSendDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), this.mDestination, (Destination)queue);
        Validator.checkMessage(message);
        Validator.checkDeliveryMode(deliveryMode);
        Validator.checkPriority(priority);
        Validator.checkTimeToLive(timeToLive);
        this.sendMessage(destination, message, deliveryMode, priority, timeToLive);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Leaving send()");
        }
    }
}

