/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import com.solacesystems.common.util.BitTwiddleUtil;
import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.WireDecoder;
import com.solacesystems.jcsmp.protocol.smf.SmpHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.NetworkIOUtil;
import java.io.IOException;
import java.io.InputStream;

public class SmpHeaderDecoder
implements WireDecoder {
    @Override
    public void decodeHeader(InputStream in, HeaderDescriptionBean headerBean) throws IOException {
        byte[] first6 = new byte[6];
        NetworkIOUtil.readDataSafely(in, first6, 0, 6);
        int msgtype = (int)BitTwiddleUtil.extractBits(first6[0], 7L, 0L);
        int msglen = (int)NetworkByteOrderNumberUtil.fourByteToUInt(first6, 1);
        int msgflags = (int)BitTwiddleUtil.extractBits(first6[5], 4L, 0L);
        SmpHeaderBean smp = (SmpHeaderBean)headerBean;
        smp.setSmpMsgType(msgtype);
        smp.setSmpFlags(msgflags);
        byte[] subscriptionstring = null;
        byte[] queuestring = null;
        byte[] cnstring = null;
        switch (msgtype) {
            case 0: 
            case 1: {
                subscriptionstring = new byte[msglen - 6];
                NetworkIOUtil.readDataSafely(in, subscriptionstring, 0, subscriptionstring.length);
                break;
            }
            case 2: 
            case 3: {
                byte[] nm_len_b = new byte[1];
                NetworkIOUtil.readDataSafely(in, nm_len_b, 0, 1);
                int qn_len = NetworkByteOrderNumberUtil.oneTwoThreeFourByteToInt(nm_len_b);
                queuestring = new byte[qn_len];
                NetworkIOUtil.readDataSafely(in, queuestring, 0, queuestring.length);
                nm_len_b = new byte[1];
                NetworkIOUtil.readDataSafely(in, nm_len_b, 0, 1);
                int s_len = NetworkByteOrderNumberUtil.oneTwoThreeFourByteToInt(nm_len_b);
                subscriptionstring = new byte[s_len];
                NetworkIOUtil.readDataSafely(in, subscriptionstring, 0, subscriptionstring.length);
                break;
            }
            case 4: 
            case 5: {
                byte[] nm_len_b = new byte[1];
                NetworkIOUtil.readDataSafely(in, nm_len_b, 0, 1);
                int cn_len = NetworkByteOrderNumberUtil.oneTwoThreeFourByteToInt(nm_len_b);
                cnstring = new byte[cn_len];
                NetworkIOUtil.readDataSafely(in, cnstring, 0, cnstring.length);
                nm_len_b = new byte[1];
                NetworkIOUtil.readDataSafely(in, nm_len_b, 0, 1);
                int s_len = NetworkByteOrderNumberUtil.oneTwoThreeFourByteToInt(nm_len_b);
                subscriptionstring = new byte[s_len];
                NetworkIOUtil.readDataSafely(in, subscriptionstring, 0, subscriptionstring.length);
            }
        }
        smp.setEncodedUtf8Subscription(subscriptionstring);
        smp.setEncodedQueueName(queuestring);
        smp.setEncodedClientName(cnstring);
    }
}

