/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.timers;

import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimeoutHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class RedeliveryDelayTimedTask
implements JCSMPTimeoutHandler {
    private static final Log Trace = LogFactory.getLog(RedeliveryDelayTimedTask.class);
    private FlowHandleImpl consumer;

    public RedeliveryDelayTimedTask(FlowHandleImpl flow) {
        this.consumer = flow;
    }

    @Override
    public void handleTimeout() {
        block4: {
            if (Trace.isDebugEnabled()) {
                Trace.debug((Object)"Executing redelivery delay timeout");
            }
            try {
                if (this.consumer.isStoppedByApplication()) {
                    return;
                }
                this.consumer.startByDelayedDeliveryTimer();
            }
            catch (JCSMPException e) {
                if (!Trace.isInfoEnabled()) break block4;
                Trace.info((Object)"caught an exception: ", (Throwable)e);
            }
        }
    }
}

