/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.sdt;

import com.solacesystems.common.util.ByteArray;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.RawSMFMessage;
import com.solacesystems.jcsmp.SDTFormatException;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.SDTStream;
import com.solacesystems.jcsmp.impl.sdt.Formatter;
import java.math.BigInteger;

public class PermissiveFormatter
implements Formatter {
    public static final Formatter OnlyInstance = new PermissiveFormatter();

    @Override
    public Boolean getBoolean(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to Boolean");
    }

    @Override
    public Byte getByte(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            try {
                return Byte.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new SDTFormatException("Error converting from String to Byte", e);
            }
        }
        if (value instanceof Number) {
            if (this.validateIntRange(value, -128L, 127L)) {
                return ((Number)value).byteValue();
            }
            throw new SDTFormatException("No lossless conversion from " + value.getClass().getSimpleName() + " to Byte");
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to Byte");
    }

    @Override
    public byte[] getBytes(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof ByteArray) {
            return ((ByteArray)value).asBytes();
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to byte[]");
    }

    @Override
    public ByteArray getByteArray(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof ByteArray) {
            return (ByteArray)value;
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to ByteArray");
    }

    @Override
    public Character getCharacter(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to Character");
    }

    @Override
    public Destination getDestination(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof Destination) {
            return (Destination)value;
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to Destination");
    }

    @Override
    public Double getDouble(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new SDTFormatException("Error converting from String to Double", e);
            }
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to Double");
    }

    @Override
    public Float getFloat(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof String) {
            try {
                return Float.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new SDTFormatException("Error converting from String to Float", e);
            }
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to Float");
    }

    @Override
    public Integer getInteger(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new SDTFormatException("Error converting from String to Integer", e);
            }
        }
        if (value instanceof Number) {
            if (this.validateIntRange(value, Integer.MIN_VALUE, Integer.MAX_VALUE)) {
                return ((Number)value).intValue();
            }
            throw new SDTFormatException("No lossless conversion from " + value.getClass().getSimpleName() + " to Integer");
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to Integer");
    }

    @Override
    public Long getLong(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            try {
                return Long.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new SDTFormatException("Error converting from String to Long", e);
            }
        }
        if (value instanceof Number) {
            if (this.validateIntRange(value, Long.MIN_VALUE, Long.MAX_VALUE)) {
                return ((Number)value).longValue();
            }
            throw new SDTFormatException("No lossless conversion from " + value.getClass().getSimpleName() + " to Integer");
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to Long");
    }

    @Override
    public SDTMap getMap(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof SDTMap) {
            return (SDTMap)value;
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to SDTMap");
    }

    @Override
    public RawSMFMessage getMessage(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof RawSMFMessage) {
            return (RawSMFMessage)value;
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to RawSMFMessage");
    }

    @Override
    public Short getShort(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            try {
                return Short.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new SDTFormatException("Error converting from String to Short", e);
            }
        }
        if (value instanceof Number) {
            if (this.validateIntRange(value, -32768L, 32767L)) {
                return ((Number)value).shortValue();
            }
            throw new SDTFormatException("No lossless conversion from " + value.getClass().getSimpleName() + " to Integer");
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to Short");
    }

    @Override
    public SDTStream getStream(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof SDTStream) {
            return (SDTStream)value;
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to SDTStream");
    }

    @Override
    public String getString(Object value) throws SDTFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Number || value instanceof Boolean || value instanceof Character) {
            return value.toString();
        }
        throw new SDTFormatException("No conversion from " + value.getClass().getSimpleName() + " to String");
    }

    private boolean validateIntRange(Object value, long min, long max) {
        long longValue;
        if (value instanceof Byte) {
            longValue = ((Byte)value).longValue();
        } else if (value instanceof Short) {
            longValue = ((Short)value).longValue();
        } else if (value instanceof Integer) {
            longValue = ((Integer)value).longValue();
        } else if (value instanceof Long) {
            longValue = (Long)value;
        } else {
            if (value instanceof BigInteger) {
                BigInteger bi = (BigInteger)value;
                BigInteger minBI = BigInteger.valueOf(min);
                BigInteger maxBI = BigInteger.valueOf(max);
                return bi.compareTo(minBI) >= 0 && bi.compareTo(maxBI) <= 0;
            }
            return false;
        }
        return longValue >= min && longValue <= max;
    }
}

