/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

import com.solacesystems.jcsmp.Endpoint;

public class BrowserProperties {
    private Endpoint endpoint = null;
    private String selector = null;
    private int waitTimeout = 10000;
    private int transportWindowSize = 255;
    private int reconnectRetryIntervalInMsecs = 3000;
    private int reconnectTries = -1;

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public BrowserProperties setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public String getSelector() {
        return this.selector;
    }

    public BrowserProperties setSelector(String selector) {
        this.selector = selector;
        return this;
    }

    public int getWaitTimeout() {
        return this.waitTimeout;
    }

    public BrowserProperties setWaitTimeout(int waitTimeout) {
        if (waitTimeout < 50) {
            throw new IllegalArgumentException("wait timeout must be greater than or equal to 50 msecs");
        }
        this.waitTimeout = waitTimeout;
        return this;
    }

    public int getTransportWindowSize() {
        return this.transportWindowSize;
    }

    public void setTransportWindowSize(int transportWindowSize) {
        if (transportWindowSize < 1 || transportWindowSize > 255) {
            throw new IllegalArgumentException("transport window size must be in the range [1..255]");
        }
        this.transportWindowSize = transportWindowSize;
    }

    public int getReconnectTries() {
        return this.reconnectTries;
    }

    public BrowserProperties setReconnectTries(int count) {
        this.rangeCheck(count, -1, Integer.MAX_VALUE);
        this.reconnectTries = count;
        return this;
    }

    public int getReconnectRetryIntervalInMsecs() {
        return this.reconnectRetryIntervalInMsecs;
    }

    public BrowserProperties setReconnectRetryIntervalInMsecs(int val) {
        this.rangeCheck(val, 50, Integer.MAX_VALUE);
        this.reconnectRetryIntervalInMsecs = val;
        return this;
    }

    private void rangeCheck(int value, int min, int max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException(String.format("Value %s was outside valid range [%s; %s].", value, min, max));
        }
    }
}

