/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.property.impl;

import com.solacesystems.common.property.PropertyConversionException;
import com.solacesystems.common.property.PropertyConverter;
import com.solacesystems.common.property.PropertySource;
import com.solacesystems.common.property.PropertyVetoException;

public class SystemPropertySource<T>
extends PropertySource<T> {
    public static final String PROPERTY_NAME = "System Property";
    protected String mPropertyName;

    public SystemPropertySource(SystemPropertySource<T> source) {
        super(source);
        this.mPropertyName = source.mPropertyName;
    }

    public SystemPropertySource(String propertyName) {
        this(PROPERTY_NAME, propertyName, 1, DEFAULT_NULL_VALID);
    }

    public SystemPropertySource(String propertyName, int priority) {
        this(PROPERTY_NAME, propertyName, priority, DEFAULT_NULL_VALID);
    }

    public SystemPropertySource(String propertyName, int priority, boolean nullValid) {
        this(PROPERTY_NAME, propertyName, priority, nullValid);
    }

    public SystemPropertySource(String propertyName, int priority, boolean nullValid, PropertyConverter converter) {
        this(PROPERTY_NAME, propertyName, priority, nullValid, converter);
    }

    public SystemPropertySource(String name, String propertyName, int priority, boolean nullValid) {
        this(name, propertyName, priority, nullValid, null);
    }

    public SystemPropertySource(String name, String propertyName, int priority, boolean nullValid, PropertyConverter converter) {
        super(name, priority, nullValid, converter);
        if (propertyName == null) {
            throw new IllegalArgumentException("property name cannot be null");
        }
        this.mPropertyName = propertyName;
    }

    @Override
    public void initialize() throws PropertyVetoException, PropertyConversionException {
        this.setObjectValue(System.getProperty(this.mPropertyName));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new SystemPropertySource<T>(this);
    }
}

