/*
 * Decompiled with CFR 0.152.
 */
package com.solace.spring.boot.autoconfigure;

import com.solace.spring.boot.autoconfigure.SolaceJmsProperties;
import com.solacesystems.jms.SolConnectionFactory;
import com.solacesystems.jms.SolConnectionFactoryImpl;
import com.solacesystems.jms.property.JMSProperties;
import jakarta.jms.ConnectionFactory;
import java.util.Hashtable;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jndi.JndiTemplate;

@Configuration
@AutoConfigureBefore(value={JmsAutoConfiguration.class})
@ConditionalOnClass(value={ConnectionFactory.class, SolConnectionFactory.class})
@ConditionalOnMissingBean(value={ConnectionFactory.class, JndiTemplate.class})
@EnableConfigurationProperties(value={SolaceJmsProperties.class})
public class SolaceJmsAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SolaceJmsAutoConfiguration.class);
    private SolaceJmsProperties properties;

    @Autowired
    public SolaceJmsAutoConfiguration(SolaceJmsProperties properties) {
        this.properties = properties;
    }

    @Bean
    public SolConnectionFactory getSolConnectionFactory() {
        try {
            Hashtable<String, String> ht = new Hashtable<String, String>(this.properties.getApiProperties());
            JMSProperties props = new JMSProperties(ht);
            props.initialize();
            SolConnectionFactoryImpl cf = new SolConnectionFactoryImpl(props);
            cf.setHost(this.properties.getHost());
            cf.setVPN(this.properties.getMsgVpn());
            cf.setUsername(this.properties.getClientUsername());
            cf.setPassword(this.properties.getClientPassword());
            cf.setDirectTransport(Boolean.valueOf(this.properties.isDirectTransport()));
            return cf;
        }
        catch (Exception ex) {
            logger.error("Exception found during Solace Connection Factory creation.", (Throwable)ex);
            throw new IllegalStateException("Unable to create Solace connection factory, ensure that the sol-jms-jakarta-<version>.jar is the classpath", ex);
        }
    }

    @Bean
    public JndiTemplate getJndiTemplate() {
        try {
            Properties env = new Properties();
            env.putAll(this.properties.getApiProperties());
            env.put("java.naming.factory.initial", "com.solacesystems.jndi.SolJNDIInitialContextFactory");
            env.put("java.naming.provider.url", this.properties.getHost());
            env.put("java.naming.security.principal", this.properties.getClientUsername() + "@" + this.properties.getMsgVpn());
            env.put("java.naming.security.credentials", this.properties.getClientPassword());
            JndiTemplate jndiTemplate = new JndiTemplate();
            jndiTemplate.setEnvironment(env);
            return jndiTemplate;
        }
        catch (Exception ex) {
            logger.error("Exception found during Solace JNDI Initial Context creation.", (Throwable)ex);
            throw new IllegalStateException("Unable to create Solace JNDI Initial Context, ensure that the sol-jms-jakarta-<version>.jar is the classpath", ex);
        }
    }

    void setProperties(SolaceJmsProperties properties) {
        this.properties = properties;
    }
}

