/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.util.internal;

import com.solace.messaging.util.LifecycleControl;
import com.solace.messaging.util.async.ThreadFactories;
import com.solace.messaging.util.internal.Internal;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class TerminationNotificationDispatcher
implements LifecycleControl.TerminationNotificationListener {
    private static final Log logger = LogFactory.getLog(TerminationNotificationDispatcher.class);
    private final AtomicBoolean notified = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ReentrantLock closeLock = new ReentrantLock();
    private final ExecutorService terminationNotifier = Executors.newSingleThreadExecutor(new ThreadFactories.NamedDaemonThreadFactory("termination-notification-dispatcher"));
    private volatile LifecycleControl.TerminationNotificationListener terminationNotificationListener;

    public LifecycleControl.TerminationNotificationListener getTerminationNotificationListener() {
        return this.terminationNotificationListener;
    }

    public void setTerminationNotificationListener(LifecycleControl.TerminationNotificationListener terminationNotificationListener) {
        this.terminationNotificationListener = terminationNotificationListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTermination(LifecycleControl.TerminationEvent e) {
        block9: {
            TerminationNotificationTask task = new TerminationNotificationTask(e);
            ReentrantLock cLock = this.closeLock;
            cLock.lock();
            try {
                if (!this.notified.get() && !this.closed.get()) {
                    try {
                        this.terminationNotifier.submit(task);
                    }
                    catch (RejectedExecutionException ex) {
                        if (!logger.isWarnEnabled()) break block9;
                        logger.warn((Object)"Could not schedule termination notification, processing notification on a dispatcher thread", (Throwable)ex);
                        try {
                            task.call();
                            break block9;
                        }
                        catch (Exception er) {
                            if (logger.isErrorEnabled()) {
                                logger.error((Object)"termination notification operation failed", (Throwable)er);
                            }
                            break block9;
                        }
                    }
                }
                return;
            }
            finally {
                cLock.unlock();
            }
        }
    }

    public void close() {
        ReentrantLock cLock = this.closeLock;
        cLock.lock();
        try {
            try {
                if (this.closed.compareAndSet(false, true)) {
                    this.terminationNotificationListener = null;
                    if (!this.terminationNotifier.isShutdown()) {
                        this.terminationNotifier.shutdown();
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Problem with closing termination notification dispatcher", (Throwable)e);
            }
        }
        finally {
            cLock.unlock();
        }
    }

    @Internal
    @ProviderType
    class TerminationNotificationTask
    implements Callable {
        final LifecycleControl.TerminationEvent e;

        TerminationNotificationTask(LifecycleControl.TerminationEvent e) {
            this.e = e;
        }

        public Object call() throws Exception {
            LifecycleControl.TerminationNotificationListener local = TerminationNotificationDispatcher.this.terminationNotificationListener;
            if (local != null && !TerminationNotificationDispatcher.this.closed.get() && TerminationNotificationDispatcher.this.notified.compareAndSet(false, true)) {
                try {
                    local.onTermination(this.e);
                }
                catch (Exception ex) {
                    logger.warn((Object)"Application code throw an unhandled exception by processing termination notification", (Throwable)ex);
                }
                finally {
                    TerminationNotificationDispatcher.this.close();
                }
            }
            return null;
        }
    }
}

