/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.util.internal;

import com.solace.messaging.MessagingService;
import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.util.internal.Internal;
import java.time.Instant;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class ServiceEventImpl
implements MessagingService.ServiceEvent {
    final long timestamp;
    final String brokerURI;
    final String message;
    final PubSubPlusClientException cause;

    public ServiceEventImpl(String brokerURI, Exception originalException, String message, long timestamp) {
        this.timestamp = timestamp;
        this.brokerURI = brokerURI;
        this.cause = ServiceEventImpl.mapException(originalException);
        this.message = message;
    }

    public ServiceEventImpl(String brokerURI, Exception originalException, String message) {
        this(brokerURI, originalException, message, Instant.now().toEpochMilli());
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getBrokerURI() {
        return this.brokerURI;
    }

    @Override
    public PubSubPlusClientException getCause() {
        return this.cause;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Internal
    static PubSubPlusClientException mapException(Exception e) {
        if (e == null) {
            return null;
        }
        if (e instanceof PubSubPlusClientException) {
            return (PubSubPlusClientException)e;
        }
        return new PubSubPlusClientException(e);
    }

    public String toString() {
        return "ServiceEventImpl{timestamp=" + this.timestamp + ", brokerURI='" + this.brokerURI + '\'' + ", message='" + this.message + '\'' + ", cause=" + this.cause + '}';
    }
}

