/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.util.async;

import com.solace.messaging.util.internal.Internal;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class ToggleLatch
implements Serializable {
    private static final long serialVersionUID = -2492154464147857276L;
    private final Sync sync = new Sync();

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(0);
    }

    public boolean await(long waitDuration, TimeUnit timeUnit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(0, timeUnit.toNanos(waitDuration));
    }

    public void open() {
        this.sync.releaseShared(1);
    }

    public void lock() {
        this.sync.open();
    }

    public String toString() {
        return "ToggleLatch{state=" + this.sync + '}';
    }

    @Internal
    @ProviderType
    private static class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 7015214759490037592L;

        private Sync() {
        }

        @Override
        protected int tryAcquireShared(int acquires) {
            Thread queuedThread = this.getFirstQueuedThread();
            if (queuedThread != null && queuedThread != Thread.currentThread()) {
                return -1;
            }
            if (acquires == 0) {
                return this.isLocked() ? 1 : -1;
            }
            this.setState(1);
            return 1;
        }

        @Override
        public boolean tryReleaseShared(int ignored) {
            this.setState(0);
            return true;
        }

        private boolean isLocked() {
            return this.getState() == 0;
        }

        private void open() {
            this.setState(1);
        }

        @Override
        public String toString() {
            return this.getState() == 0 ? "locked" : "open";
        }
    }
}

