/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.resources;

import com.solace.messaging.resources.Destination;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.Validation;
import java.util.regex.Pattern;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface ShareName
extends Destination {
    public static ShareName of(String name) {
        ShareNameImpl.validateShareName(name);
        return new ShareNameImpl(name);
    }

    default public void validate() {
        Validation.nullIllegal(this.getName(), "ShareName can't be null");
        Validation.regexMatchIllegal(this.getName(), ShareNameImpl.ILLEGAL_CHARS, "Literals '>' and '*' are not permitted in a ShareName");
    }

    @Internal
    @ProviderType
    public static final class ShareNameImpl
    implements ShareName {
        private static final Pattern ILLEGAL_CHARS = Pattern.compile(".*[\\>\\*].*");
        private static final ShareNameImpl NO_OP = new ShareNameImpl("");
        private static final long serialVersionUID = 7661329128883375498L;
        private final String name;

        private ShareNameImpl(String n) {
            this.name = n;
        }

        public static ShareName noOp() {
            return NO_OP;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShareNameImpl shareName = (ShareNameImpl)o;
            return this.name != null ? this.name.equals(shareName.name) : shareName.name == null;
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public String toString() {
            return "ShareNameImpl{name='" + this.name + '\'' + '}';
        }

        private static void validateShareName(String name) {
            Validation.nullOrEmptyIllegal(name, "Share name can't be null or empty");
            Validation.regexMatchIllegal(name, ILLEGAL_CHARS, "Literals '>' and '*' are not permitted in a ShareName");
        }
    }
}

