/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.resources;

import com.solace.messaging.resources.TopicSubscription;
import com.solace.messaging.util.internal.Internal;
import com.solacesystems.jcsmp.CacheLiveDataAction;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public interface CachedTopicSubscription
extends TopicSubscription {
    public String getCacheName();

    public static CachedTopicSubscription asAvailable(String cacheName, TopicSubscription subscription, long cacheAccessTimeout) {
        return new CachedTopicSubscriptionImp(cacheName, subscription, cacheAccessTimeout, false, 0, 0, CacheLiveDataAction.FLOW_THRU);
    }

    public static CachedTopicSubscription asAvailable(String cacheName, TopicSubscription subscription, long cacheAccessTimeout, int maxCachedMessages, int cachedMessageAge, boolean ignoreCacheErrors) {
        return new CachedTopicSubscriptionImp(cacheName, subscription, cacheAccessTimeout, false, maxCachedMessages, cachedMessageAge, CacheLiveDataAction.FLOW_THRU, ignoreCacheErrors);
    }

    public static CachedTopicSubscription liveCancelsCached(String cacheName, TopicSubscription subscription, long cacheAccessTimeout) {
        return new CachedTopicSubscriptionImp(cacheName, subscription, cacheAccessTimeout, false, 0, 0, CacheLiveDataAction.FULFILL, true);
    }

    public static CachedTopicSubscription liveCancelsCached(String cacheName, TopicSubscription subscription, long cacheAccessTimeout, int maxCachedMessages, int cachedMessageAge, boolean ignoreCacheErrors) {
        return new CachedTopicSubscriptionImp(cacheName, subscription, cacheAccessTimeout, false, maxCachedMessages, cachedMessageAge, CacheLiveDataAction.FULFILL, ignoreCacheErrors);
    }

    public static CachedTopicSubscription cachedFirst(String cacheName, TopicSubscription subscription, long cacheAccessTimeout) {
        return new CachedTopicSubscriptionImp(cacheName, subscription, cacheAccessTimeout, false, 0, 0, CacheLiveDataAction.QUEUE);
    }

    public static CachedTopicSubscription cachedFirst(String cacheName, TopicSubscription subscription, long cacheAccessTimeout, int maxCachedMessages, int cachedMessageAge, boolean ignoreCacheErrors) {
        return new CachedTopicSubscriptionImp(cacheName, subscription, cacheAccessTimeout, false, maxCachedMessages, cachedMessageAge, CacheLiveDataAction.QUEUE, ignoreCacheErrors);
    }

    public static CachedTopicSubscription cachedOnly(String cacheName, TopicSubscription subscription, long cacheAccessTimeout) {
        return new CachedTopicSubscriptionImp(cacheName, subscription, cacheAccessTimeout, true, 0, 0, CacheLiveDataAction.FLOW_THRU);
    }

    public static CachedTopicSubscription cachedOnly(String cacheName, TopicSubscription subscription, long cacheAccessTimeout, int maxCachedMessages, int cachedMessageAge) {
        return new CachedTopicSubscriptionImp(cacheName, subscription, cacheAccessTimeout, true, maxCachedMessages, cachedMessageAge, CacheLiveDataAction.FLOW_THRU);
    }

    @Internal
    @ProviderType
    public static class CachedTopicSubscriptionImp
    implements CachedTopicSubscription {
        private static final long serialVersionUID = -2363945168094652643L;
        private final TopicSubscription topicSubscription;
        private final String cacheName;
        private final boolean temporary;
        private final int messageAge;
        private final int maxNumberMessages;
        private final long cacheAccessTimeout;
        private final CacheLiveDataAction cacheAction;
        private final boolean ignoreCacheErrors;

        private CachedTopicSubscriptionImp(String cacheName, TopicSubscription topicSubscription, long cacheAccessTimeout, boolean temporary, int maxNumberMessages, int messageAge, CacheLiveDataAction cacheAction, boolean ignoreCacheErrors) {
            this.cacheName = cacheName;
            this.topicSubscription = topicSubscription;
            this.temporary = temporary;
            this.messageAge = messageAge;
            this.maxNumberMessages = maxNumberMessages;
            this.cacheAction = cacheAction;
            this.cacheAccessTimeout = cacheAccessTimeout;
            this.ignoreCacheErrors = ignoreCacheErrors;
        }

        private CachedTopicSubscriptionImp(String cacheName, TopicSubscription topicSubscription, long cacheAccessTimeout, boolean temporary, int maxNumberMessages, int messageAge, CacheLiveDataAction cacheAction) {
            this(cacheName, topicSubscription, cacheAccessTimeout, temporary, maxNumberMessages, messageAge, cacheAction, false);
        }

        @Override
        public String getCacheName() {
            return this.cacheName;
        }

        public CacheLiveDataAction getCacheAction() {
            return this.cacheAction;
        }

        public TopicSubscription getTopicSubscription() {
            return this.topicSubscription;
        }

        public boolean isTemporary() {
            return this.temporary;
        }

        public int getMessageAge() {
            return this.messageAge;
        }

        public int getMaxNumberMessages() {
            return this.maxNumberMessages;
        }

        public long getCacheAccessTimeout() {
            return this.cacheAccessTimeout;
        }

        public boolean isIgnoreCacheErrors() {
            return this.ignoreCacheErrors;
        }

        @Override
        public String getName() {
            return this.topicSubscription.getName();
        }
    }
}

