/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.receiver;

import com.solace.messaging.MessagingService;
import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.receiver.InboundMessage;
import com.solace.messaging.receiver.MessageQueueBrowser;
import com.solace.messaging.receiver.MessageReceiver;
import com.solace.messaging.resources.ReceiverInfo;
import com.solace.messaging.util.CompletionListener;
import com.solace.messaging.util.LifecycleControl;
import com.solace.messaging.util.ManageableReceiver;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.async.ExtendedCompletableFuture;
import com.solace.messaging.util.internal.ClientSession;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.MessageReceiptFailureNotificationDispatcher;
import com.solace.messaging.util.internal.MessagingServiceInternalView;
import com.solace.messaging.util.internal.ServiceEventImpl;
import com.solace.messaging.util.internal.Task;
import com.solace.messaging.util.internal.TerminationEventImpl;
import com.solace.messaging.util.internal.TerminationNotificationDispatcher;
import com.solace.messaging.util.internal.Validation;
import com.solacesystems.common.util.DestinationUtil;
import com.solacesystems.jcsmp.Browser;
import com.solacesystems.jcsmp.BrowserProperties;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.FlowEvent;
import com.solacesystems.jcsmp.FlowEventArgs;
import com.solacesystems.jcsmp.FlowEventHandler;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.impl.QueueImpl;
import java.time.Instant;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicStampedReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class MessageQueueBrowserImpl
implements MessageQueueBrowser {
    private static final Log logger = LogFactory.getLog(MessageQueueBrowserImpl.class);
    static final int STATE_NOT_STARTED = 0;
    static final int STATE_STARTING = 1;
    static final int STATE_STARTED = 2;
    static final int STATE_TERMINATING = 3;
    static final int STATE_TERMINATED = 4;
    final AtomicStampedReference<CompletableFuture> stateHolder = new AtomicStampedReference<Object>(null, 0);
    private static final AtomicLong instanceIdGenerator = new AtomicLong(0L);
    private final long id;
    private final String instanceName;
    private final QueueBrowserInfo receiverInfo;
    private final MessagingServiceInternalView serviceInternalView;
    private final SolaceQueueHolder queue;
    private final TypedProperties browserConfiguration;
    private final BrowserProperties browserProperties;
    private final TerminationNotificationDispatcher terminationNotificationDispatcher;
    private final MessageReceiptFailureNotificationDispatcher messageReceiptFailureNotificationDispatcher;
    private final MessagingService.ServiceInterruptionListener serviceInterruptionListener;
    private final ClientSession.ClientSessionStateListener closedSessionListener;
    private final MessagingService.ReconnectionAttemptListener reconnectionAttemptListener;
    private volatile Browser solaceBrowser = null;
    private final Task<MessageQueueBrowserImpl> postTerminationTask = browser -> {
        block3: {
            if (browser.solaceBrowser != null) {
                try {
                    browser.solaceBrowser.close();
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block3;
                    logger.warn((Object)(browser.instanceName + " could not be stopped after service was interrupted."));
                }
            }
        }
    };

    public MessageQueueBrowserImpl(MessagingServiceInternalView serviceInternalView, TypedProperties queueBrowserConfiguration, com.solace.messaging.resources.Queue queue) {
        this.id = instanceIdGenerator.incrementAndGet();
        this.instanceName = "MessageQueueBrowser@" + this.id;
        this.receiverInfo = new QueueBrowserInfo();
        this.serviceInternalView = serviceInternalView;
        this.queue = SolaceQueueHolder.create(queue, this.serviceInternalView.getClientSession());
        this.browserConfiguration = queueBrowserConfiguration;
        this.browserProperties = this.createFlowConfiguration(queueBrowserConfiguration, this.queue);
        this.terminationNotificationDispatcher = new TerminationNotificationDispatcher();
        this.messageReceiptFailureNotificationDispatcher = new MessageReceiptFailureNotificationDispatcher(this.receiverInfo);
        this.serviceInterruptionListener = e -> {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)(this.instanceName + " is shutting down due to service interruption"));
            }
            this.stateHolder.set(null, 4);
            this.terminationNotificationDispatcher.onTermination(new TerminationEventImpl(e.getTimestamp(), e.getMessage(), e.getCause()));
            this.terminateOnUnsolicitedInterruption();
        };
        this.closedSessionListener = event -> {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)"Shutting down receiver due to service closure");
            }
            this.stateHolder.set(null, 4);
            this.terminationNotificationDispatcher.onTermination(new TerminationEventImpl(event.getTimestamp(), event.getMessage(), event.getCause()));
            this.terminateOnUnsolicitedInterruption();
        };
        this.reconnectionAttemptListener = e -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.instanceName + " is reconnecting."));
            }
        };
    }

    @Override
    public boolean isRunning() {
        return 2 == this.stateHolder.getStamp();
    }

    @Override
    public boolean isTerminated() {
        return 4 == this.stateHolder.getStamp();
    }

    @Override
    public boolean isTerminating() {
        return 3 == this.stateHolder.getStamp();
    }

    @Override
    public void setTerminationNotificationListener(LifecycleControl.TerminationNotificationListener listener) {
        this.terminationNotificationDispatcher.setTerminationNotificationListener(listener);
    }

    @Override
    public void setReceiveFailureListener(MessageReceiver.ReceiveFailureListener receiveFailureListener) {
        this.messageReceiptFailureNotificationDispatcher.setReceiveFailureListener(receiveFailureListener);
    }

    @Override
    public MessageQueueBrowser start() throws PubSubPlusClientException, IllegalStateException {
        try {
            this.startAsync().get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t != null) {
                if (t instanceof PubSubPlusClientException) {
                    throw (PubSubPlusClientException)t;
                }
                if (t instanceof IllegalStateException) {
                    throw (IllegalStateException)t;
                }
                throw new PubSubPlusClientException(t);
            }
            if (logger.isErrorEnabled()) {
                logger.error((Object)(this.instanceName + " failed to start"), (Throwable)e);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PubSubPlusClientException.RequestInterruptedException("Message browser start was canceled", e);
        }
        catch (CancellationException e) {
            throw new PubSubPlusClientException.RequestInterruptedException("Message browser start was canceled", e);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <MessageQueueBrowser> CompletableFuture<MessageQueueBrowser> startAsync() throws PubSubPlusClientException, IllegalStateException {
        int state = this.stateHolder.getStamp();
        if (3 == state || state == 4) {
            throw new IllegalStateException("Message browser is already terminated");
        }
        if (!this.serviceInternalView.isConnected()) {
            throw new IllegalStateException("Message browser can't be started when service is not connected");
        }
        block6: while (true) {
            if (!this.serviceInternalView.isConnected()) {
                return ExtendedCompletableFuture.failedFuture(new IllegalStateException("Message receiver can't be started when service is not connected"));
            }
            int[] currentStateHolder = new int[1];
            CompletableFuture currentFuture = this.stateHolder.get(currentStateHolder);
            int currentState = currentStateHolder[0];
            switch (currentState) {
                case 0: {
                    ExtendedCompletableFuture<MessageQueueBrowserImpl> starting;
                    boolean stateChanged;
                    if (!(stateChanged = this.stateHolder.compareAndSet(null, starting = new ExtendedCompletableFuture<MessageQueueBrowserImpl>(), 0, 1))) continue block6;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(this.instanceName + " is being started"));
                    }
                    try {
                        boolean startingToStarted = this.stateHolder.compareAndSet(starting, starting, 1, 2);
                        if (!startingToStarted) {
                            int newCurrentState = this.stateHolder.getStamp();
                            if (newCurrentState >= 3) {
                                this.onTerminate(null, null);
                                starting.completeExceptionally(new CancellationException("Starting of message receiver was interrupted"));
                                return starting;
                            }
                        } else {
                            this.onStart();
                        }
                        starting.complete(this);
                        if (!logger.isDebugEnabled()) return ExtendedCompletableFuture.onCancellation(starting, (service, throwable) -> {
                            this.stateHolder.set(null, 4);
                            this.onTerminate(null, null);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)(this.instanceName + " async start was canceled"));
                            }
                        });
                        logger.debug((Object)(this.instanceName + " is started"));
                        return ExtendedCompletableFuture.onCancellation(starting, (service, throwable) -> {
                            this.stateHolder.set(null, 4);
                            this.onTerminate(null, null);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)(this.instanceName + " async start was canceled"));
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.stateHolder.set(null, 4);
                        this.onTerminate(null, null);
                        starting.completeExceptionally(PubSubPlusClientException.of(e));
                        if (!logger.isErrorEnabled()) return ExtendedCompletableFuture.onCancellation(starting, (service, throwable) -> {
                            this.stateHolder.set(null, 4);
                            this.onTerminate(null, null);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)(this.instanceName + " async start was canceled"));
                            }
                        });
                        logger.error((Object)(this.instanceName + " failed to start and is terminating"), (Throwable)e);
                    }
                    return ExtendedCompletableFuture.onCancellation(starting, (service, throwable) -> {
                        this.stateHolder.set(null, 4);
                        this.onTerminate(null, null);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(this.instanceName + " async start was canceled"));
                        }
                    });
                }
                case 1: 
                case 2: {
                    return currentFuture;
                }
            }
            break;
        }
        return ExtendedCompletableFuture.failedFuture(new IllegalStateException("Message receiver is already terminated"));
    }

    public <MessageQueueBrowser> void startAsync(CompletionListener<MessageQueueBrowser> startListener) throws PubSubPlusClientException, IllegalStateException {
        Validation.nullIllegal(startListener, "Start listener can't be null");
        CompletableFuture<MessageQueueBrowser> onceStarted = this.startAsync();
        onceStarted.whenComplete((receiver, throwable) -> {
            block2: {
                try {
                    startListener.onCompletion(receiver, throwable == null ? null : throwable.getCause());
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block2;
                    logger.warn((Object)"Application code throw an unhandled exception by processing async start completion notification", (Throwable)e);
                }
            }
        });
    }

    @Override
    public void terminate(long gracePeriod) throws PubSubPlusClientException.IncompleteMessageDeliveryException, PubSubPlusClientException, IllegalStateException {
        block7: {
            if (gracePeriod == 0L) {
                this.terminateNow();
                return;
            }
            try {
                this.terminateAsync(gracePeriod).get();
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                if (t != null) {
                    if (t instanceof PubSubPlusClientException) {
                        throw (PubSubPlusClientException)t;
                    }
                    throw new PubSubPlusClientException(t);
                }
                throw new PubSubPlusClientException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new PubSubPlusClientException.RequestInterruptedException("Message receiver termination was interrupted", e);
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) break block7;
                logger.warn((Object)(this.instanceName + " encountered problem during termination."), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public CompletableFuture<Void> terminateAsync(long gracePeriod) throws PubSubPlusClientException, IllegalStateException {
        Validation.smallerThanNumbersIllegal(1L, gracePeriod, "Grace period < 1");
        block8: while (true) {
            currentStateHolder = new int[1];
            currentFuture = this.stateHolder.get(currentStateHolder);
            currentState = currentStateHolder[0];
            switch (currentState) {
                case 0: {
                    stateChanged = this.stateHolder.compareAndSet(null, null, 0, 4);
                    if (!stateChanged) continue block8;
                    this.onTerminate(null, null);
                    return CompletableFuture.completedFuture(null);
                }
                case 1: {
                    this.stateHolder.set(null, 4);
                    currentFuture.cancel(true);
                    return CompletableFuture.completedFuture(null);
                }
                case 2: {
                    terminating = new ExtendedCompletableFuture<Void>();
                    stateChanged = this.stateHolder.compareAndSet(currentFuture, terminating, 2, 3);
                    if (stateChanged) ** break;
                    continue block8;
                    try {
                        this.onTerminate(null, this.postTerminationTask);
                    }
                    finally {
                        this.stateHolder.set(null, 4);
                    }
                    terminating.complete(null);
                    return terminating;
                }
            }
            break;
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void terminateAsync(CompletionListener<Void> terminationListener, long gracePeriod) throws PubSubPlusClientException, IllegalStateException {
        Validation.nullIllegal(terminationListener, "Termination listener can't be null");
        CompletableFuture<Void> disconnecting = this.terminateAsync(gracePeriod);
        disconnecting.whenComplete((nothing, throwable) -> {
            block2: {
                try {
                    terminationListener.onCompletion(null, throwable == null ? null : throwable.getCause());
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block2;
                    logger.warn((Object)"Application code throw an unhandled exception by processing termination completion notification", (Throwable)e);
                }
            }
        });
    }

    @Override
    public InboundMessage receiveMessage() throws PubSubPlusClientException, PubSubPlusClientException.RequestInterruptedException {
        if ((this.isRunning() || this.isTerminating()) && this.solaceBrowser != null) {
            try {
                BytesXMLMessage solaceMessage = this.solaceBrowser.getNext(0);
                return solaceMessage == null ? null : MessageReceiver.InboundMessageImpl.toInboundMessage(solaceMessage);
            }
            catch (Exception e) {
                if (e instanceof JCSMPInterruptedException) {
                    throw new PubSubPlusClientException.RequestInterruptedException(e.getMessage());
                }
                throw new PubSubPlusClientException(e);
            }
        }
        throw new IllegalStateException("Message browser is not started");
    }

    @Override
    public InboundMessage receiveMessage(long timeOut) throws PubSubPlusClientException, PubSubPlusClientException.RequestInterruptedException {
        if (timeOut < 1L) {
            timeOut = 1L;
        }
        if ((this.isRunning() || this.isTerminating()) && this.solaceBrowser != null) {
            try {
                BytesXMLMessage solaceMessage = this.solaceBrowser.getNext((int)timeOut);
                return solaceMessage == null ? null : MessageReceiver.InboundMessageImpl.toInboundMessage(solaceMessage);
            }
            catch (Exception e) {
                if (e instanceof JCSMPInterruptedException) {
                    throw new PubSubPlusClientException.RequestInterruptedException(e.getMessage());
                }
                throw new PubSubPlusClientException(e);
            }
        }
        throw new IllegalStateException("Message browser is not started");
    }

    @Override
    public InboundMessage receiveOrElse(MessageReceiver.InboundMessageSupplier supplierOfAlternativeResponse) {
        Validation.nullIllegal(supplierOfAlternativeResponse, "Response supplier can't be null");
        if ((this.isRunning() || this.isTerminating()) && this.solaceBrowser != null) {
            try {
                BytesXMLMessage solaceMessage = this.solaceBrowser.getNextNoWait();
                return solaceMessage != null ? MessageReceiver.InboundMessageImpl.toInboundMessage(solaceMessage) : (InboundMessage)supplierOfAlternativeResponse.get();
            }
            catch (Exception e) {
                throw new PubSubPlusClientException(e);
            }
        }
        throw new IllegalStateException("Message browser is not started");
    }

    @Override
    public void remove(InboundMessage message) throws PubSubPlusClientException {
        if (message == null) {
            return;
        }
        if (this.isRunning() || this.isTerminating()) {
            try {
                ((MessageReceiver.InboundMessageImpl)message).doAck();
            }
            catch (Exception e) {
                if (e instanceof PubSubPlusClientException) {
                    throw e;
                }
                throw new PubSubPlusClientException(e);
            }
        } else {
            throw new IllegalStateException("Message browser is not started");
        }
    }

    @Override
    public ReceiverInfo receiverInfo() {
        return this.receiverInfo;
    }

    @Internal
    void onStart() throws PubSubPlusClientException.ResourceProvisioningException, PubSubPlusClientException.AuthorizationException, PubSubPlusClientException.ServiceCapabilityException, PubSubPlusClientException {
        this.serviceInternalView.addReconnectionAttemptListener(this.reconnectionAttemptListener);
        this.serviceInternalView.getClientSession().addServiceInterruptionListener(this.serviceInterruptionListener);
        this.serviceInternalView.getClientSession().addClientSessionStateListener(this.closedSessionListener);
        if (this.solaceBrowser != null) {
            this.solaceBrowser.close();
        }
        this.solaceBrowser = this.createSolaceBrowser(this.queue, this);
    }

    @Internal
    Browser createSolaceBrowser(SolaceQueueHolder queue, MessageQueueBrowserImpl browser) {
        FlowEventHandler flowEventHandler = new FlowEventHandler(){
            final String instanceReconnected;
            final String instanceReconnecting;
            {
                this.instanceReconnected = MessageQueueBrowserImpl.this.instanceName + " reconnected";
                this.instanceReconnecting = MessageQueueBrowserImpl.this.instanceName + " reconnecting";
            }

            public void handleEvent(Object source, FlowEventArgs event) {
                ClientSession session = MessageQueueBrowserImpl.this.serviceInternalView.getClientSession();
                String uri = "n/a";
                if (session != null) {
                    if (session.getClientChannel() != null && session.getClientChannel().getSmfClient() != null) {
                        uri = session.getClientChannel().getSmfClient().getRemoteHost();
                    }
                    if (event.getEvent() == FlowEvent.FLOW_DOWN) {
                        if (session.isReconnecting()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)(MessageQueueBrowserImpl.this.instanceName + " flow receiver is temporarily down while reconnecting"));
                            }
                            return;
                        }
                        MessageQueueBrowserImpl.this.stateHolder.set(null, 4);
                        MessageQueueBrowserImpl.this.terminationNotificationDispatcher.onTermination(MessageQueueBrowserImpl.this.mapFlowDownException(event.getException()));
                        MessageQueueBrowserImpl.this.terminateOnUnsolicitedInterruption();
                    } else if (event.getEvent() == FlowEvent.FLOW_UP) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(MessageQueueBrowserImpl.this.instanceName + " flow receiver is started"));
                        }
                    } else if (event.getEvent() == FlowEvent.FLOW_ACTIVE) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(MessageQueueBrowserImpl.this.instanceName + " flow receiver is active"));
                        }
                    } else if (event.getEvent() == FlowEvent.FLOW_RECONNECTING) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(MessageQueueBrowserImpl.this.instanceName + " flow receiver is reconnecting"));
                        }
                        MessageQueueBrowserImpl.this.reconnectionAttemptListener.onReconnecting(new ServiceEventImpl(uri, event.getException(), this.instanceReconnecting));
                    } else if (event.getEvent() == FlowEvent.FLOW_RECONNECTED && logger.isDebugEnabled()) {
                        logger.debug((Object)(MessageQueueBrowserImpl.this.instanceName + " flow receiver is reconnected"));
                    }
                }
            }
        };
        try {
            return this.serviceInternalView.getClientSession().createBrowser(this.browserProperties, flowEventHandler);
        }
        catch (JCSMPErrorResponseException e) {
            int errorSubCode = e.getSubcodeEx();
            if (20 == errorSubCode) {
                throw new PubSubPlusClientException.MissingResourceException(e.getMessage(), e);
            }
            throw new PubSubPlusClientException("Solace message browser could not be created", e);
        }
        catch (JCSMPException e) {
            throw new PubSubPlusClientException("Solace message browser could not be created", e);
        }
    }

    void onTerminate(Task<MessageQueueBrowserImpl> preTerminationTask, Task<MessageQueueBrowserImpl> postTerminationTask) {
        try {
            if (preTerminationTask != null) {
                preTerminationTask.run(this);
            }
            this.serviceInternalView.removeReconnectionAttemptListener(this.reconnectionAttemptListener);
            this.serviceInternalView.getClientSession().removeServiceInterruptionListener(this.serviceInterruptionListener);
            this.serviceInternalView.getClientSession().removeClientSessionStateListener(this.closedSessionListener);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.instanceName + " receiver is shutdown"));
            }
        }
        finally {
            if (postTerminationTask != null) {
                postTerminationTask.run(this);
            }
        }
    }

    void terminateOnUnsolicitedInterruption() throws PubSubPlusClientException {
        this.stateHolder.set(null, 4);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.instanceName + " is being non gracefully terminated due to service interruption"));
        }
        this.onTerminate(null, this.postTerminationTask);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.instanceName + " is terminated"));
        }
    }

    void terminateNow() throws PubSubPlusClientException.IncompleteMessageDeliveryException, PubSubPlusClientException, IllegalStateException {
        this.stateHolder.set(null, 4);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.instanceName + " is being non gracefully terminated"));
        }
        this.onTerminate(null, this.postTerminationTask);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.instanceName + " is terminated"));
        }
    }

    @Internal
    private LifecycleControl.TerminationEvent mapFlowDownException(Exception e) {
        String exMsg = "Browser flow is shut down";
        if (e instanceof JCSMPErrorResponseException) {
            return new TerminationEventImpl(Instant.now().toEpochMilli(), "Browser flow is shut down", new PubSubPlusClientException(e));
        }
        if (e instanceof PubSubPlusClientException) {
            return new TerminationEventImpl(Instant.now().toEpochMilli(), "Browser flow is shut down", (PubSubPlusClientException)e);
        }
        return new TerminationEventImpl(Instant.now().toEpochMilli(), "Browser flow is shut down", new PubSubPlusClientException(e));
    }

    @Internal
    private BrowserProperties createFlowConfiguration(TypedProperties queueBrowserConfiguration, SolaceQueueHolder queue) {
        BrowserProperties browserFlowProperties = new BrowserProperties();
        String selector = queueBrowserConfiguration.getProperty("solace.messaging.queue-browser.selector-query");
        if (selector != null && !selector.isEmpty()) {
            browserFlowProperties.setSelector(selector);
        }
        browserFlowProperties.setEndpoint((Endpoint)queue.getSolaceQueue());
        browserFlowProperties.setTransportWindowSize(queueBrowserConfiguration.getIntegerProperty("solace.messaging.queue-browser.persistent.transport-window-size").intValue());
        browserFlowProperties.setReconnectTries(queueBrowserConfiguration.getIntegerProperty("solace.messaging.queue-browser.reconnection-attempts").intValue());
        browserFlowProperties.setReconnectRetryIntervalInMsecs(queueBrowserConfiguration.getIntegerProperty("solace.messaging.queue-browser.reconnection-attempts-wait-interval").intValue());
        return browserFlowProperties;
    }

    @Internal
    @ProviderType
    static class SolaceQueueHolder
    implements com.solace.messaging.resources.Queue {
        private final boolean exclusivelyAccessible;
        private final Queue solaceQueue;

        private SolaceQueueHolder(Queue solaceQueue, boolean exclusive) {
            this.solaceQueue = solaceQueue;
            this.exclusivelyAccessible = exclusive;
        }

        @Override
        public String getName() {
            return this.solaceQueue.getName();
        }

        @Override
        public boolean isExclusivelyAccessible() {
            return this.exclusivelyAccessible;
        }

        @Override
        public boolean isDurable() {
            return this.solaceQueue.isDurable();
        }

        public Queue getSolaceQueue() {
            return this.solaceQueue;
        }

        static SolaceQueueHolder create(com.solace.messaging.resources.Queue q, ClientSession session) {
            if (!q.isDurable()) {
                if (q.getName() == null) {
                    Queue sq = QueueImpl.createWithInit((String)DestinationUtil.createNonDurQueueTrbTopic((String)session.getVirtualRouterName(), null), (boolean)false, (String)session.getVirtualRouterName());
                    return new SolaceQueueHolder(sq, q.isExclusivelyAccessible());
                }
                Queue sq = QueueImpl.createWithInit((String)DestinationUtil.createNonDurQueueTrbTopic((String)session.getVirtualRouterName(), (String)q.getName()), (boolean)false, (String)session.getVirtualRouterName());
                return new SolaceQueueHolder(sq, q.isExclusivelyAccessible());
            }
            return new SolaceQueueHolder(QueueImpl.userCreateWithInit((String)q.getName(), (boolean)true, (String)session.getVirtualRouterName()), q.isExclusivelyAccessible());
        }
    }

    @Internal
    @ProviderType
    private class QueueBrowserInfo
    implements ManageableReceiver.PersistentReceiverInfo {
        private final ManageableReceiver.PersistentReceiverInfo.ResourceInfo resourceInfo = new QueueResourceInfoImpl();

        @Override
        public long getId() {
            return MessageQueueBrowserImpl.this.id;
        }

        @Override
        public String getInstanceName() {
            return MessageQueueBrowserImpl.this.instanceName;
        }

        @Override
        public ManageableReceiver.PersistentReceiverInfo.ResourceInfo getResourceInfo() throws IllegalStateException {
            return this.resourceInfo;
        }

        @ProviderType
        private class QueueResourceInfoImpl
        implements ManageableReceiver.PersistentReceiverInfo.ResourceInfo {
            private QueueResourceInfoImpl() {
            }

            @Override
            public boolean isDurable() {
                return MessageQueueBrowserImpl.this.queue.isDurable();
            }

            @Override
            public String getName() {
                return MessageQueueBrowserImpl.this.queue.getSolaceQueue().getName();
            }
        }
    }
}

