/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.config.provider;

import com.solace.messaging.config.ReplayStrategy;
import com.solace.messaging.config.provider.ReceiverConfigurationProvider;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.Validation;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class ReceiverMessageReplayConfigurationProvider
implements ReceiverConfigurationProvider {
    final ReplayStrategy strategy;

    private ReceiverMessageReplayConfigurationProvider(ReplayStrategy strategy) {
        this.strategy = strategy;
    }

    public static ReceiverMessageReplayConfigurationProvider replay(ReplayStrategy strategy) {
        Validation.nullIllegal(strategy, "Replay strategy can't be null");
        ReceiverMessageReplayConfigurationProvider provider = new ReceiverMessageReplayConfigurationProvider(strategy);
        return provider;
    }

    @Override
    public TypedProperties getConfiguration() {
        TypedProperties.TypedPropertiesImpl output = new TypedProperties.TypedPropertiesImpl();
        if (this.strategy instanceof ReplayStrategy.AllMessagesReplay) {
            output.setProperty("solace.messaging.receiver.persistent.replay.strategy", "REPLAY_ALL");
        } else if (this.strategy instanceof ReplayStrategy.TimeBasedReplay) {
            ReplayStrategy.TimeBasedReplay s = (ReplayStrategy.TimeBasedReplay)this.strategy;
            output.setProperty("solace.messaging.receiver.persistent.replay.strategy", "REPLAY_TIME_BASED");
            output.setObjectProperty("solace.messaging.receiver.persistent.replay.timebased-start-time", s.getReplayDate());
        } else if (this.strategy instanceof ReplayStrategy.ReplicationGroupMessageIdReplay) {
            ReplayStrategy.ReplicationGroupMessageIdReplay s = (ReplayStrategy.ReplicationGroupMessageIdReplay)this.strategy;
            output.setProperty("solace.messaging.receiver.persistent.replay.strategy", "REPLAY_REPLICATION_GROUP_MESSAGE_ID_BASED");
            output.setObjectProperty("solace.messaging.receiver.persistent.replay.replication-group-message-id", s.getReplicationGroupMessageId().toString());
        }
        return output;
    }
}

