/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.config.provider;

import com.solace.messaging.config.SolaceProperties;
import com.solace.messaging.publisher.MessagePublisher;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.ExtendedSolaceProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.PropertiesKey;
import com.solace.messaging.util.internal.PropertiesKeyMapping;
import com.solace.messaging.util.internal.Validation;
import com.solacesystems.jcsmp.JCSMPProperties;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public final class PublisherPropertiesConverter {
    private static final Map<String, MappingInfo> CONVERTER_MAP;

    public static TypedProperties toTypedProperties(Properties properties) {
        Validation.nullIllegal(properties, "Argument properties can't be null");
        TypedProperties.TypedPropertiesImpl output = new TypedProperties.TypedPropertiesImpl();
        Set<String> userPropertyKeys = properties.stringPropertyNames();
        for (String nextKey : userPropertyKeys) {
            MappingInfo fieldInfo = CONVERTER_MAP.get(nextKey);
            if (fieldInfo == null) continue;
            if (String.class.equals(fieldInfo.getValueType())) {
                output.setProperty(fieldInfo.getPropertyName(), properties.getProperty(nextKey));
                continue;
            }
            if (Integer.TYPE.equals(fieldInfo.getValueType())) {
                String valueMayBeInt = properties.getProperty(nextKey);
                try {
                    output.setIntegerProperty(fieldInfo.getPropertyName(), Integer.parseInt(valueMayBeInt));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Property %s has to be of type integer, can't convert value [%s]", nextKey, valueMayBeInt));
                }
            }
            if (Long.TYPE.equals(fieldInfo.getValueType())) {
                String valueMayBeLong = properties.getProperty(nextKey);
                try {
                    output.setLongProperty(fieldInfo.getPropertyName(), Long.parseLong(valueMayBeLong));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Property %s has to be of type long, can't convert value [%s]", nextKey, valueMayBeLong));
                }
            }
            if (!Boolean.TYPE.equals(fieldInfo.getValueType())) continue;
            String valueMayBeBoolean = properties.getProperty(nextKey);
            output.setBooleanProperty(fieldInfo.getPropertyName(), Boolean.parseBoolean(valueMayBeBoolean));
        }
        return output;
    }

    static {
        Class<?>[] innerInterfaces;
        CONVERTER_MAP = new HashMap<String, MappingInfo>();
        for (Class<?> c : innerInterfaces = SolaceProperties.class.getClasses()) {
            for (Field f : c.getDeclaredFields()) {
                int hostFiledModifiers = f.getModifiers();
                if (f.isSynthetic() || !Modifier.isStatic(hostFiledModifiers) || !Modifier.isPublic(hostFiledModifiers) || !Modifier.isFinal(hostFiledModifiers) || !String.class.equals(f.getType())) continue;
                try {
                    PropertiesKey directMapper = f.getAnnotation(PropertiesKey.class);
                    if (directMapper != null) {
                        String propertyId = (String)f.get(null);
                        Class<?> targetType = directMapper.target();
                        if (!MessagePublisher.class.equals(targetType)) continue;
                        CONVERTER_MAP.put(propertyId, new MappingInfo(targetType, directMapper.valueType(), directMapper.required(), propertyId));
                        continue;
                    }
                    PropertiesKeyMapping propertyKeyMapper = f.getAnnotation(PropertiesKeyMapping.class);
                    if (propertyKeyMapper == null) continue;
                    String propertyId = (String)f.get(null);
                    try {
                        Class mappedClass = propertyKeyMapper.mappedClass();
                        if (!JCSMPProperties.class.equals((Object)mappedClass) && !ExtendedSolaceProperties.class.equals((Object)mappedClass)) continue;
                        Field directMappedField = mappedClass.getDeclaredField(propertyKeyMapper.mappedFieldName());
                        int mappedFiledModifiers = f.getModifiers();
                        if (directMappedField.isSynthetic() || !Modifier.isStatic(mappedFiledModifiers) || !Modifier.isPublic(mappedFiledModifiers) || !Modifier.isFinal(mappedFiledModifiers) || !String.class.equals(directMappedField.getType())) continue;
                        String mappedPropertyValue = (String)directMappedField.get(null);
                        CONVERTER_MAP.put(propertyId, new MappingInfo(propertyKeyMapper.mappedClass(), propertyKeyMapper.valueType(), propertyKeyMapper.required(), mappedPropertyValue));
                    }
                    catch (NoSuchFieldException noSuchFieldException) {}
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    @Internal
    @ProviderType
    private static class MappingInfo {
        final Class<?> targetClass;
        final Class<?> valueType;
        final boolean required;
        final String propertyName;

        public MappingInfo(Class<?> targetClass, Class<?> valueType, boolean required) {
            this(targetClass, valueType, required, null);
        }

        public MappingInfo(Class<?> targetClass, Class<?> valueType, boolean required, String propertyName) {
            this.targetClass = targetClass;
            this.valueType = valueType;
            this.required = required;
            this.propertyName = propertyName;
        }

        public Class<?> getValueType() {
            return this.valueType;
        }

        public Class<?> getTargetClass() {
            return this.targetClass;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

