/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.config.provider;

import com.solace.messaging.config.provider.ServiceConfigurationProvider;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.Validation;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class CompressionConfigurationProvider
implements ServiceConfigurationProvider {
    private final int compressionFactor;

    CompressionConfigurationProvider(int compressionFactor) {
        this.compressionFactor = compressionFactor;
    }

    public static CompressionConfigurationProvider of(int compressionFactor) {
        Validation.outOfRangeIllegal(1, 9, compressionFactor, "Compression factor is out of valid range between 1 and 9");
        return new CompressionConfigurationProvider(compressionFactor);
    }

    @Override
    public TypedProperties getConfiguration() {
        TypedProperties.TypedPropertiesImpl output = new TypedProperties.TypedPropertiesImpl();
        output.setIntegerProperty("ClientChannelProperties_CompressionLevel", this.compressionFactor);
        return output;
    }
}

