/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.config;

import com.solace.messaging.config.TypedConfiguration;
import com.solace.messaging.util.SecureStoreFormat;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.Validation;
import java.security.KeyStore;
import java.util.Locale;
import org.osgi.annotation.versioning.ProviderType;

@FunctionalInterface
public interface AuthenticationStrategy
extends TypedConfiguration {
    @Override
    @Internal
    default public TypedProperties getConfiguration() {
        return this.getAuthenticationConfiguration();
    }

    @Internal
    public TypedProperties getAuthenticationConfiguration();

    @ProviderType
    public static final class OAuth2
    implements AuthenticationStrategy {
        private final TypedProperties authenticationConfiguration = new TypedProperties.TypedPropertiesImpl();

        private OAuth2(String accessToken, String idToken) {
            this.authenticationConfiguration.setProperty("AUTHENTICATION_SCHEME", "AUTHENTICATION_SCHEME_OAUTH2");
            if (accessToken != null) {
                this.authenticationConfiguration.setProperty("OAUTH2_ACCESS_TOKEN", accessToken);
            }
            if (idToken != null) {
                this.authenticationConfiguration.setProperty("OIDC_ID_TOKEN", idToken);
            }
        }

        public static OAuth2 of(String accessToken) {
            Validation.nullIllegal(accessToken, "'null' is an illegal accessToken value.");
            return new OAuth2(accessToken, null);
        }

        public static OAuth2 of(String accessToken, String idToken) {
            if (accessToken == null && idToken == null) {
                throw new IllegalArgumentException("At least one OAUTH token has to be specified");
            }
            return new OAuth2(accessToken, idToken);
        }

        public OAuth2 withIssuerIdentifier(String issuerIdentifier) {
            Validation.nullIllegal(issuerIdentifier, "'null' is an illegal issuerIdentifier value.");
            this.authenticationConfiguration.setProperty("OAUTH2_ISSUER_IDENTIFIER", issuerIdentifier);
            return this;
        }

        @Override
        public TypedProperties getAuthenticationConfiguration() {
            return this.authenticationConfiguration;
        }
    }

    @ProviderType
    public static final class ClientCertificateAuthentication
    implements AuthenticationStrategy {
        private final TypedProperties properties = new TypedProperties.TypedPropertiesImpl();

        private ClientCertificateAuthentication(String keystoreURL, String keystorePassword, SecureStoreFormat keyStoreFormat) {
            this.properties.setProperty("AUTHENTICATION_SCHEME", "AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE");
            this.properties.setProperty("SSL_KEY_STORE_PASSWORD", keystorePassword);
            this.properties.setProperty("SSL_KEY_STORE", keystoreURL);
            this.properties.setProperty("SSL_KEY_STORE_FORMAT", keyStoreFormat.toString());
        }

        public static ClientCertificateAuthentication of(String keystoreURL, String keystorePassword, SecureStoreFormat keyStoreFormat) {
            return new ClientCertificateAuthentication(keystoreURL, keystorePassword, keyStoreFormat);
        }

        public static ClientCertificateAuthentication of(String keystoreURL, String keystorePassword) {
            return new ClientCertificateAuthentication(keystoreURL, keystorePassword, SecureStoreFormat.valueOf(KeyStore.getDefaultType().toUpperCase(Locale.ENGLISH)));
        }

        public ClientCertificateAuthentication withPrivateKeyPassword(String privateKeyPassword) {
            this.properties.setProperty("SSL_PRIVATE_KEY_PASSWORD", privateKeyPassword);
            return this;
        }

        public ClientCertificateAuthentication withKeyStorePrivateKeyAlias(String privateKeyAlias) {
            this.properties.setProperty("SSL_PRIVATE_KEY_ALIAS", privateKeyAlias);
            return this;
        }

        public ClientCertificateAuthentication withTrustStore(String trustStoreURL, String trustStorePassword, SecureStoreFormat trustStoreFormat) {
            this.properties.setProperty("SSL_TRUST_STORE", trustStoreURL);
            this.properties.setProperty("SSL_TRUST_STORE_PASSWORD", trustStorePassword);
            this.properties.setProperty("SSL_TRUST_STORE_FORMAT", trustStoreFormat.toString());
            return this;
        }

        public ClientCertificateAuthentication withPrivateKeyPassword(String privateKeyPassword, String privateKeyAlias) {
            this.properties.setProperty("SSL_PRIVATE_KEY_PASSWORD", privateKeyPassword);
            this.properties.setProperty("SSL_PRIVATE_KEY_ALIAS", privateKeyAlias);
            return this;
        }

        public ClientCertificateAuthentication withUserName(String userName) {
            this.properties.setProperty("client_cert_username", userName);
            return this;
        }

        @Override
        public TypedProperties getAuthenticationConfiguration() {
            return this.properties;
        }
    }

    @ProviderType
    public static final class Kerberos
    implements AuthenticationStrategy {
        private static final String DEFAULT_KERBEROS_PRINCIPAL_INSTANCE_NAME = "solace";
        private final TypedProperties authenticationConfiguration = new TypedProperties.TypedPropertiesImpl();

        private Kerberos(String kerberosPrincipalInstanceName, String jaasLoginContextName) {
            this.authenticationConfiguration.setProperty("AUTHENTICATION_SCHEME", "AUTHENTICATION_SCHEME_GSS_KRB");
            this.authenticationConfiguration.setProperty("KRB_SERVICE_NAME", kerberosPrincipalInstanceName);
            this.authenticationConfiguration.setProperty("JaasLoginContext", jaasLoginContextName);
        }

        @Override
        public TypedProperties getAuthenticationConfiguration() {
            return this.authenticationConfiguration;
        }

        public Kerberos withReloadableJaasConfiguration() {
            this.authenticationConfiguration.setBooleanProperty("JaasConfigFileReloadEnabled", true);
            return this;
        }

        public Kerberos withMutualAuthentication() {
            this.authenticationConfiguration.setBooleanProperty("KRB_MUTUAL_AUTHENTICATION", true);
            return this;
        }

        public Kerberos withUserName(String userName) {
            this.authenticationConfiguration.setProperty("username", userName);
            return this;
        }

        public static Kerberos of(String jaasLoginContextName, String kerberosPrincipalInstanceName) {
            return new Kerberos(kerberosPrincipalInstanceName, jaasLoginContextName);
        }

        public static Kerberos of(String jaasLoginContextName) {
            return Kerberos.of(jaasLoginContextName, DEFAULT_KERBEROS_PRINCIPAL_INSTANCE_NAME);
        }
    }

    @ProviderType
    public static final class BasicUserNamePassword
    implements AuthenticationStrategy {
        private final TypedProperties authenticationConfiguration = new TypedProperties.TypedPropertiesImpl();

        private BasicUserNamePassword(String username, String password) {
            this.authenticationConfiguration.setProperty("username", username);
            this.authenticationConfiguration.setProperty("password", password);
            this.authenticationConfiguration.setBooleanProperty("SSL_VALIDATE_CERTIFICATE", false);
            this.authenticationConfiguration.setProperty("AUTHENTICATION_SCHEME", "AUTHENTICATION_SCHEME_BASIC");
        }

        public static BasicUserNamePassword of(String username, String password) {
            Validation.nullIllegal(username, "'null' is an illegal username value.");
            Validation.nullIllegal(username, "'null' is an illegal password value.");
            return new BasicUserNamePassword(username, password);
        }

        @Override
        public TypedProperties getAuthenticationConfiguration() {
            return this.authenticationConfiguration;
        }
    }
}

