/*
 * Decompiled with CFR 0.152.
 */
package sttp.client3.asynchttpclient;

import java.util.concurrent.atomic.AtomicBoolean;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketListener;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import sttp.client3.internal.ws.SimpleQueue;
import sttp.client3.internal.ws.WebSocketEvent;
import sttp.ws.WebSocketFrame;

public class AddToQueueListener<F>
implements WebSocketListener {
    private final SimpleQueue<F, WebSocketEvent> queue;
    private final AtomicBoolean isOpen;

    public AddToQueueListener(SimpleQueue<F, WebSocketEvent> queue, AtomicBoolean isOpen) {
        this.queue = queue;
        this.isOpen = isOpen;
    }

    public void onOpen(WebSocket websocket) {
        throw new IllegalStateException("Should never be called!");
    }

    public void onClose(WebSocket websocket, int code, String reason) {
        if (this.isOpen.getAndSet(false)) {
            this.queue.offer((Object)WebSocketEvent.Frame$.MODULE$.apply((WebSocketFrame)WebSocketFrame.Close$.MODULE$.apply(code, reason)));
            return;
        }
    }

    public void onError(Throwable t) {
        if (this.isOpen.getAndSet(false)) {
            this.queue.offer((Object)WebSocketEvent.Error$.MODULE$.apply(t));
            return;
        }
    }

    public void onBinaryFrame(byte[] payload, boolean finalFragment, int rsv) {
        this.onFrame((WebSocketFrame)WebSocketFrame.Binary$.MODULE$.apply(payload, finalFragment, this.rsvToOption(rsv)));
    }

    public void onTextFrame(String payload, boolean finalFragment, int rsv) {
        this.onFrame((WebSocketFrame)WebSocketFrame.Text$.MODULE$.apply(payload, finalFragment, this.rsvToOption(rsv)));
    }

    public void onPingFrame(byte[] payload) {
        this.onFrame((WebSocketFrame)WebSocketFrame.Ping$.MODULE$.apply(payload));
    }

    public void onPongFrame(byte[] payload) {
        this.onFrame((WebSocketFrame)WebSocketFrame.Pong$.MODULE$.apply(payload));
    }

    private void onFrame(WebSocketFrame f) {
        try {
            this.queue.offer((Object)WebSocketEvent.Frame$.MODULE$.apply(f));
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    private Option<Object> rsvToOption(int rsv) {
        if (rsv == 0) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)rsv));
    }
}

