/*
 * Decompiled with CFR 0.152.
 */
package sttp.client3.asynchttpclient;

import io.netty.handler.codec.http.HttpHeaders;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.handler.StreamedAsyncHandler;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Try$;
import sttp.capabilities.package;
import sttp.client3.RequestT;
import sttp.client3.Response;
import sttp.client3.Response$;
import sttp.client3.SttpBackend;
import sttp.client3.SttpBackendOptions;
import sttp.client3.SttpClientException$;
import sttp.client3.asynchttpclient.AsyncHttpClientBackend$;
import sttp.client3.asynchttpclient.BodyFromAHC;
import sttp.client3.asynchttpclient.BodyToAHC;
import sttp.client3.asynchttpclient.EmptyPublisher$;
import sttp.client3.asynchttpclient.WebSocketImpl$;
import sttp.client3.internal.ws.SimpleQueue;
import sttp.client3.internal.ws.WebSocketEvent;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.Method;
import sttp.model.ResponseMetadata;
import sttp.model.StatusCode$;
import sttp.model.Uri;
import sttp.monad.Canceler$;
import sttp.monad.MonadAsyncError;
import sttp.monad.MonadError;
import sttp.monad.syntax$;
import sttp.ws.WebSocket;

public abstract class AsyncHttpClientBackend<F, S extends package.Streams<S>, P>
implements SttpBackend<F, P> {
    private final AsyncHttpClient asyncHttpClient;
    private final MonadAsyncError monad;
    private final boolean closeClient;
    private final Function1<BoundRequestBuilder, BoundRequestBuilder> customizeRequest;

    public static Option<Object> DefaultWebSocketBufferCapacity() {
        return AsyncHttpClientBackend$.MODULE$.DefaultWebSocketBufferCapacity();
    }

    public static AsyncHttpClient clientWithModifiedOptions(SttpBackendOptions sttpBackendOptions, Function1<DefaultAsyncHttpClientConfig.Builder, DefaultAsyncHttpClientConfig.Builder> function1) {
        return AsyncHttpClientBackend$.MODULE$.clientWithModifiedOptions(sttpBackendOptions, function1);
    }

    public static AsyncHttpClient defaultClient(SttpBackendOptions sttpBackendOptions) {
        return AsyncHttpClientBackend$.MODULE$.defaultClient(sttpBackendOptions);
    }

    public static DefaultAsyncHttpClientConfig.Builder defaultConfigBuilder(SttpBackendOptions sttpBackendOptions) {
        return AsyncHttpClientBackend$.MODULE$.defaultConfigBuilder(sttpBackendOptions);
    }

    public AsyncHttpClientBackend(AsyncHttpClient asyncHttpClient, MonadAsyncError<F> monad, boolean closeClient, Function1<BoundRequestBuilder, BoundRequestBuilder> customizeRequest) {
        this.asyncHttpClient = asyncHttpClient;
        this.monad = monad;
        this.closeClient = closeClient;
        this.customizeRequest = customizeRequest;
    }

    public MonadAsyncError<F> sttp$client3$asynchttpclient$AsyncHttpClientBackend$$monad() {
        return this.monad;
    }

    public abstract package.Streams<S> streams();

    public <T, R> F send(RequestT<Object, T, R> r) {
        return this.adjustExceptions(r, () -> this.send$$anonfun$1(r));
    }

    private <T, R> F sendRegular(RequestT<Object, T, R> r, BoundRequestBuilder ahcRequest) {
        return (F)this.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$monad().flatten(this.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$monad().async((Function1 & Serializable)cb -> {
            ListenableFuture lf = ahcRequest.execute(this.streamingAsyncHandler(r, (Function1<F, BoxedUnit>)(JProcedure1 & Serializable)r -> AsyncHttpClientBackend.success$3(cb, r), (Function1<Throwable, BoxedUnit>)(JProcedure1 & Serializable)t -> AsyncHttpClientBackend.error$3(cb, t)));
            return Canceler$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> lf.abort((Throwable)new InterruptedException()));
        }));
    }

    private <T, R> F sendWebSocket(RequestT<Object, T, R> r, BoundRequestBuilder ahcRequest) {
        return (F)syntax$.MODULE$.MonadErrorOps(this::sendWebSocket$$anonfun$1).flatMap((Function1 & Serializable)queue -> this.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$monad().flatten(this.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$monad().async((Function1 & Serializable)cb -> {
            WebSocketInitListener initListener = new WebSocketInitListener(this, r, queue, (JProcedure1 & Serializable)r -> cb.apply((Object)package$.MODULE$.Right().apply(r)), (Function1<Throwable, BoxedUnit>)(JProcedure1 & Serializable)t -> cb.apply((Object)package$.MODULE$.Left().apply(t)));
            WebSocketUpgradeHandler h = new WebSocketUpgradeHandler.Builder().addWebSocketListener(initListener).build();
            ListenableFuture lf = ahcRequest.execute((AsyncHandler)h);
            return Canceler$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> lf.abort((Throwable)new InterruptedException()));
        })), this.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$monad());
    }

    public MonadError<F> responseMonad() {
        return this.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$monad();
    }

    public abstract BodyFromAHC<F, S> bodyFromAHC();

    public abstract BodyToAHC<F, S> bodyToAHC();

    public abstract <T> F createSimpleQueue();

    private <T, R> AsyncHandler<BoxedUnit> streamingAsyncHandler(RequestT<Object, T, R> request, Function1<F, BoxedUnit> success, Function1<Throwable, BoxedUnit> error) {
        return new StreamedAsyncHandler<BoxedUnit>(request, success, error, this){
            private final RequestT request$1;
            private final Function1 success$1;
            private final Function1 error$1;
            private final Response.ResponseBuilder builder;
            private Option publisher;
            private boolean completed;
            public volatile boolean sttp$client3$asynchttpclient$AsyncHttpClientBackend$$anon$1$$subscribed;
            private final AsyncHttpClientBackend $outer;
            {
                this.request$1 = request$3;
                this.success$1 = success$2;
                this.error$1 = error$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.builder = new Response.ResponseBuilder();
                this.publisher = None$.MODULE$;
                this.completed = false;
                this.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$anon$1$$subscribed = false;
            }

            public AsyncHandler.State onStream(Publisher p) {
                this.publisher = Some$.MODULE$.apply((Object)new Publisher<ByteBuffer>(p, this){
                    private final Publisher p$1;
                    private final $anon$1 $outer;
                    {
                        this.p$1 = p$2;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void subscribe(Subscriber s) {
                        this.$outer.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$anon$1$$subscribed = true;
                        this.p$1.subscribe((Subscriber)new Subscriber<HttpResponseBodyPart>(s){
                            private final Subscriber s$1;
                            {
                                this.s$1 = s$2;
                            }

                            public void onError(Throwable t) {
                                this.s$1.onError(t);
                            }

                            public void onComplete() {
                                this.s$1.onComplete();
                            }

                            public void onNext(HttpResponseBodyPart t) {
                                this.s$1.onNext((Object)t.getBodyByteBuffer());
                            }

                            public void onSubscribe(Subscription v) {
                                this.s$1.onSubscribe(v);
                            }
                        });
                    }
                });
                this.doComplete();
                return AsyncHandler.State.CONTINUE;
            }

            public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) {
                throw new IllegalStateException("Requested a streaming backend, unexpected eager body parts.");
            }

            public AsyncHandler.State onHeadersReceived(HttpHeaders headers) {
                this.builder.accumulate(headers);
                return AsyncHandler.State.CONTINUE;
            }

            public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) {
                this.builder.accumulate(responseStatus);
                return AsyncHandler.State.CONTINUE;
            }

            public void onCompleted() {
                this.doComplete();
            }

            private void doComplete() {
                if (!this.completed) {
                    this.completed = true;
                    Response<BoxedUnit> baseResponse = this.$outer.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$readResponseNoBody(this.request$1, this.builder.build());
                    Publisher p = (Publisher)this.publisher.getOrElse(AsyncHttpClientBackend::sttp$client3$asynchttpclient$AsyncHttpClientBackend$$anon$1$$_$_$$anonfun$5);
                    F b = this.$outer.bodyFromAHC().apply(package$.MODULE$.Left().apply((Object)p), this.request$1.response(), (ResponseMetadata)baseResponse, (Function0<Object>)(Function0 & Serializable)() -> this.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$anon$1$$subscribed);
                    this.success$1.apply(syntax$.MODULE$.MonadErrorOps(() -> AsyncHttpClientBackend.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$anon$1$$_$doComplete$$anonfun$1(b)).map(arg_0 -> AsyncHttpClientBackend.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$anon$1$$_$doComplete$$anonfun$2(baseResponse, arg_0), this.$outer.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$monad()));
                }
            }

            public void onThrowable(Throwable t) {
                this.error$1.apply((Object)t);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{sttp$client3$asynchttpclient$AsyncHttpClientBackend$$anon$1$$_$_$$anonfun$5(), $anonfun$6(), sttp$client3$asynchttpclient$AsyncHttpClientBackend$$anon$1$$_$doComplete$$anonfun$1(java.lang.Object ), sttp$client3$asynchttpclient$AsyncHttpClientBackend$$anon$1$$_$doComplete$$anonfun$2(sttp.client3.Response java.lang.Object )}, serializedLambda);
            }
        };
    }

    private <R> F preparedRequest(RequestT<Object, ?, R> r) {
        return (F)syntax$.MODULE$.MonadErrorOps(() -> this.preparedRequest$$anonfun$1(r)).map(this.customizeRequest, this.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$monad());
    }

    private <R> Request requestToAsync(RequestT<Object, ?, R> r) {
        Duration readTimeout = r.options().readTimeout();
        RequestBuilder rb = (RequestBuilder)new RequestBuilder(((Method)r.method()).method()).setUrl(((Uri)r.uri()).toString()).setReadTimeout(readTimeout.isFinite() ? (int)readTimeout.toMillis() : -1).setRequestTimeout(readTimeout.isFinite() ? (int)readTimeout.toMillis() : -1);
        r.headers().foreach((Function1 & Serializable)header -> (RequestBuilder)rb.setHeader((CharSequence)header.name(), header.value()));
        this.bodyToAHC().apply(r, r.body(), rb);
        return rb.build();
    }

    public Response<BoxedUnit> sttp$client3$asynchttpclient$AsyncHttpClientBackend$$readResponseNoBody(RequestT<Object, ?, ?> request, org.asynchttpclient.Response response) {
        return Response$.MODULE$.apply((Object)BoxedUnit.UNIT, StatusCode$.MODULE$.unsafeApply(response.getStatusCode()), response.getStatusText(), this.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$readHeaders(response.getHeaders()), (List)package$.MODULE$.Nil(), request.onlyMetadata($less$colon$less$.MODULE$.refl()));
    }

    public Seq<Header> sttp$client3$asynchttpclient$AsyncHttpClientBackend$$readHeaders(HttpHeaders h) {
        return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(h.iteratorAsString()).asScala()).map((Function1 & Serializable)e -> Header$.MODULE$.apply((String)e.getKey(), (String)e.getValue())).toList();
    }

    public F close() {
        return (F)(this.closeClient ? this.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$monad().eval((Function0)((JFunction0.mcV.sp & Serializable)this::close$$anonfun$1)) : this.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$monad().unit((Object)BoxedUnit.UNIT));
    }

    private <T> F adjustExceptions(RequestT<Object, ?, ?> request, Function0<F> t) {
        return (F)SttpClientException$.MODULE$.adjustExceptions(this.responseMonad(), t, (Function1 & Serializable)_$2 -> SttpClientException$.MODULE$.defaultExceptionToSttpClientException(request, _$2));
    }

    private final Object send$$anonfun$1$$anonfun$1(RequestT r$2) {
        return this.preparedRequest(r$2);
    }

    private final Object send$$anonfun$1(RequestT r$1) {
        return syntax$.MODULE$.MonadErrorOps(() -> this.send$$anonfun$1$$anonfun$1(r$1)).flatMap((Function1 & Serializable)ahcRequest -> r$1.isWebSocket() ? this.sendWebSocket((RequestT)r$1, (BoundRequestBuilder)ahcRequest) : this.sendRegular((RequestT)r$1, (BoundRequestBuilder)ahcRequest), this.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$monad());
    }

    private static final void success$3(Function1 cb$1, Object r) {
        cb$1.apply((Object)package$.MODULE$.Right().apply(r));
    }

    private static final void error$3(Function1 cb$2, Throwable t) {
        cb$2.apply((Object)package$.MODULE$.Left().apply((Object)t));
    }

    private final Object sendWebSocket$$anonfun$1() {
        return this.createSimpleQueue();
    }

    public static final EmptyPublisher$ sttp$client3$asynchttpclient$AsyncHttpClientBackend$$anon$1$$_$_$$anonfun$5() {
        return EmptyPublisher$.MODULE$;
    }

    public static final Object sttp$client3$asynchttpclient$AsyncHttpClientBackend$$anon$1$$_$doComplete$$anonfun$1(Object b$1) {
        return b$1;
    }

    public static final /* synthetic */ Response sttp$client3$asynchttpclient$AsyncHttpClientBackend$$anon$1$$_$doComplete$$anonfun$2(Response baseResponse$1, Object t) {
        return baseResponse$1.copy(t, baseResponse$1.copy$default$2(), baseResponse$1.copy$default$3(), baseResponse$1.copy$default$4(), baseResponse$1.copy$default$5(), baseResponse$1.copy$default$6());
    }

    public static final /* synthetic */ boolean sttp$client3$asynchttpclient$AsyncHttpClientBackend$WebSocketInitListener$$_$_$$anonfun$7() {
        return false;
    }

    public static final Object sttp$client3$asynchttpclient$AsyncHttpClientBackend$WebSocketInitListener$$_$onOpen$$anonfun$1(Object bf$1) {
        return bf$1;
    }

    public static final /* synthetic */ Response sttp$client3$asynchttpclient$AsyncHttpClientBackend$WebSocketInitListener$$_$onOpen$$anonfun$2(Response baseResponse$2, Object b) {
        return baseResponse$2.copy(b, baseResponse$2.copy$default$2(), baseResponse$2.copy$default$3(), baseResponse$2.copy$default$4(), baseResponse$2.copy$default$5(), baseResponse$2.copy$default$6());
    }

    private final BoundRequestBuilder preparedRequest$$anonfun$1$$anonfun$1(RequestT r$8) {
        return this.asyncHttpClient.prepareRequest(this.requestToAsync(r$8));
    }

    private final Object preparedRequest$$anonfun$1(RequestT r$7) {
        return this.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$monad().fromTry(Try$.MODULE$.apply(() -> this.preparedRequest$$anonfun$1$$anonfun$1(r$7)));
    }

    private final void close$$anonfun$1() {
        this.asyncHttpClient.close();
    }

    private class WebSocketInitListener<T>
    implements WebSocketListener {
        private final RequestT<Object, T, ?> request;
        private final SimpleQueue<F, WebSocketEvent> queue;
        private final Function1<F, BoxedUnit> success;
        private final Function1<Throwable, BoxedUnit> error;
        private final AsyncHttpClientBackend<F, S, P> $outer;

        public WebSocketInitListener(AsyncHttpClientBackend $outer, RequestT<Object, T, ?> request, SimpleQueue<F, WebSocketEvent> queue, Function1<F, BoxedUnit> success, Function1<Throwable, BoxedUnit> error) {
            this.request = request;
            this.queue = queue;
            this.success = success;
            this.error = error;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public void onOpen(org.asynchttpclient.ws.WebSocket ahcWebSocket) {
            ahcWebSocket.removeWebSocketListener((WebSocketListener)this);
            WebSocket webSocket = WebSocketImpl$.MODULE$.newCoupledToAHCWebSocket(ahcWebSocket, this.queue, this.$outer.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$monad());
            this.queue.offer((Object)WebSocketEvent.Open$.MODULE$.apply());
            Response baseResponse = Response$.MODULE$.apply((Object)BoxedUnit.UNIT, StatusCode$.MODULE$.SwitchingProtocols(), "", this.$outer.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$readHeaders(ahcWebSocket.getUpgradeHeaders()), (List)package$.MODULE$.Nil(), this.request.onlyMetadata($less$colon$less$.MODULE$.refl()));
            Object bf = this.$outer.bodyFromAHC().apply((Either)package$.MODULE$.Right().apply(webSocket), this.request.response(), (ResponseMetadata)baseResponse, (Function0<Object>)((Function0 & Serializable)AsyncHttpClientBackend::sttp$client3$asynchttpclient$AsyncHttpClientBackend$WebSocketInitListener$$_$_$$anonfun$7));
            this.success.apply(syntax$.MODULE$.MonadErrorOps(() -> AsyncHttpClientBackend.sttp$client3$asynchttpclient$AsyncHttpClientBackend$WebSocketInitListener$$_$onOpen$$anonfun$1(bf)).map(arg_0 -> AsyncHttpClientBackend.sttp$client3$asynchttpclient$AsyncHttpClientBackend$WebSocketInitListener$$_$onOpen$$anonfun$2(baseResponse, arg_0), this.$outer.sttp$client3$asynchttpclient$AsyncHttpClientBackend$$monad()));
        }

        public void onClose(org.asynchttpclient.ws.WebSocket webSocket, int code, String reason) {
            throw new IllegalStateException("Should never be called, as the listener should be removed after onOpen");
        }

        public void onError(Throwable t) {
            this.error.apply((Object)t);
        }

        public final AsyncHttpClientBackend<F, S, P> sttp$client3$asynchttpclient$AsyncHttpClientBackend$WebSocketInitListener$$$outer() {
            return this.$outer;
        }
    }
}

