/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.elastic4s.http;

import com.sksamuel.elastic4s.Show$;
import com.sksamuel.elastic4s.http.ElasticRequest;
import com.sksamuel.elastic4s.http.ElasticRequest$;
import com.sksamuel.elastic4s.http.HttpClient;
import com.sksamuel.elastic4s.http.HttpEntity;
import com.sksamuel.elastic4s.http.HttpResponse;
import com.sksamuel.elastic4s.http.JavaClientExceptionWrapper;
import com.sksamuel.exts.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.JavaConverters$;
import scala.io.Codec;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u000554A\u0001C\u0005\u0001%!AQ\u0004\u0001B\u0001B\u0003%a\u0004C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0003,\u0001\u0011\u0005A\u0006C\u0003;\u0001\u0011\u00051\bC\u0003E\u0001\u0011\u0005S\tC\u0003c\u0001\u0011\u00053\rC\u0003e\u0001\u0011%QMA\u000eFY\u0006\u001cH/[2tK\u0006\u00148\r\u001b&bm\u0006\u0014Vm\u001d;DY&,g\u000e\u001e\u0006\u0003\u0015-\tA\u0001\u001b;ua*\u0011A\"D\u0001\nK2\f7\u000f^5diMT!AD\b\u0002\u0011M\\7/Y7vK2T\u0011\u0001E\u0001\u0004G>l7\u0001A\n\u0004\u0001MI\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g\r\u0005\u0002\u001b75\t\u0011\"\u0003\u0002\u001d\u0013\tQ\u0001\n\u001e;q\u00072LWM\u001c;\u0002\r\rd\u0017.\u001a8u!\tyR%D\u0001!\u0015\ti\u0012E\u0003\u0002#G\u0005iQ\r\\1ti&\u001c7/Z1sG\"T\u0011\u0001J\u0001\u0004_J<\u0017B\u0001\u0014!\u0005)\u0011Vm\u001d;DY&,g\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005%R\u0003C\u0001\u000e\u0001\u0011\u0015i\"\u00011\u0001\u001f\u00031\t\u0007/Y2iK\u0016sG/\u001b;z)\tic\u0007\u0005\u0002/i5\tqF\u0003\u00021c\u00051QM\u001c;jifT!A\u0003\u001a\u000b\u0005M\u001a\u0013AB1qC\u000eDW-\u0003\u00026_\t\u0011\u0012IY:ue\u0006\u001cG\u000f\u0013;ua\u0016sG/\u001b;z\u0011\u0015\u00014\u00011\u00018!\tQ\u0002(\u0003\u0002:\u0013\tQ\u0001\n\u001e;q\u000b:$\u0018\u000e^=\u0002\u0019\u0019\u0014x.\u001c*fgB|gn]3\u0015\u0005qz\u0004C\u0001\u000e>\u0013\tq\u0014B\u0001\u0007IiR\u0004(+Z:q_:\u001cX\rC\u0003A\t\u0001\u0007\u0011)A\u0001s!\ty\")\u0003\u0002DA\tA!+Z:q_:\u001cX-\u0001\u0003tK:$Gc\u0001$J\u001dB\u0011AcR\u0005\u0003\u0011V\u0011A!\u00168ji\")!*\u0002a\u0001\u0017\u0006\u0019!/Z9\u0011\u0005ia\u0015BA'\n\u00059)E.Y:uS\u000e\u0014V-];fgRDQaT\u0003A\u0002A\u000b\u0001bY1mY\n\f7m\u001b\t\u0005)E\u001bf)\u0003\u0002S+\tIa)\u001e8di&|g.\r\t\u0005)r{FH\u0004\u0002V5:\u0011a+W\u0007\u0002/*\u0011\u0001,E\u0001\u0007yI|w\u000e\u001e \n\u0003YI!aW\u000b\u0002\u000fA\f7m[1hK&\u0011QL\u0018\u0002\u0007\u000b&$\b.\u001a:\u000b\u0005m+\u0002C\u0001+a\u0013\t\tgLA\u0005UQJ|w/\u00192mK\u0006)1\r\\8tKR\ta)\u0001\bjg\u0016sG/\u001b;z\u000fjL\u0007/\u001a3\u0015\u0005\u0019L\u0007C\u0001\u000bh\u0013\tAWCA\u0004C_>dW-\u00198\t\u000bA:\u0001\u0019\u00016\u0011\u0005-dW\"A\u0019\n\u0005e\n\u0004")
public class ElasticsearchJavaRestClient
implements HttpClient {
    private final RestClient client;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$sksamuel$exts$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public AbstractHttpEntity apacheEntity(HttpEntity entity) {
        ByteArrayEntity byteArrayEntity;
        HttpEntity httpEntity = entity;
        if (httpEntity instanceof HttpEntity.StringEntity) {
            HttpEntity.StringEntity stringEntity = (HttpEntity.StringEntity)httpEntity;
            this.logger().debug(stringEntity.content());
            byteArrayEntity = new StringEntity(stringEntity.content(), ContentType.APPLICATION_JSON);
        } else if (httpEntity instanceof HttpEntity.ByteArrayEntity) {
            HttpEntity.ByteArrayEntity byteArrayEntity2 = (HttpEntity.ByteArrayEntity)httpEntity;
            byteArrayEntity = new ByteArrayEntity(byteArrayEntity2.content(), ContentType.APPLICATION_JSON);
        } else if (httpEntity instanceof HttpEntity.InputStreamEntity) {
            HttpEntity.InputStreamEntity inputStreamEntity = (HttpEntity.InputStreamEntity)httpEntity;
            this.logger().debug(inputStreamEntity.content().toString());
            byteArrayEntity = new InputStreamEntity(inputStreamEntity.content(), ContentType.APPLICATION_JSON);
        } else if (httpEntity instanceof HttpEntity.FileEntity) {
            HttpEntity.FileEntity fileEntity = (HttpEntity.FileEntity)httpEntity;
            this.logger().debug(fileEntity.content().toString());
            byteArrayEntity = new FileEntity(fileEntity.content(), ContentType.APPLICATION_JSON);
        } else {
            throw new MatchError((Object)httpEntity);
        }
        return byteArrayEntity;
    }

    public HttpResponse fromResponse(Response r) {
        Option entity2 = Option$.MODULE$.apply((Object)r.getEntity()).map((Function1 & Serializable)entity -> {
            Charset contentCharset = (Charset)Option$.MODULE$.apply((Object)ContentType.get((org.apache.http.HttpEntity)entity)).fold((Function0 & Serializable)() -> Charset.forName("UTF-8"), (Function1 & Serializable)x$1 -> x$1.getCharset());
            Codec codec = Codec$.MODULE$.apply(contentCharset);
            InputStream contentStream = this.isEntityGziped((org.apache.http.HttpEntity)entity) ? new GZIPInputStream(entity.getContent()) : entity.getContent();
            String body = Source$.MODULE$.fromInputStream(contentStream, codec).mkString();
            return new HttpEntity.StringEntity(body, (Option<String>)new Some((Object)contentCharset.name()));
        });
        scala.collection.immutable.Map headers = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])r.getHeaders()), (Function1 & Serializable)header -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)header.getName()), (Object)header.getValue()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.logger().debug("Http Response {}", (Object)r);
        return new HttpResponse(r.getStatusLine().getStatusCode(), (Option<HttpEntity.StringEntity>)entity2, (scala.collection.immutable.Map<String, String>)headers);
    }

    @Override
    public void send(ElasticRequest req, Function1<Either<Throwable, HttpResponse>, BoxedUnit> callback) {
        if (this.logger().isDebugEnabled()) {
            this.logger().debug("Executing elastic request {}", (Object)Show$.MODULE$.apply(ElasticRequest$.MODULE$.ElasticRequestShow()).show((Object)req));
        }
        ResponseListener l = new ResponseListener(this, callback){
            private final /* synthetic */ ElasticsearchJavaRestClient $outer;
            private final Function1 callback$1;

            public void onSuccess(Response r) {
                this.callback$1.apply((Object)package$.MODULE$.Right().apply((Object)this.$outer.fromResponse(r)));
            }

            public void onFailure(Exception e) {
                Exception exception = e;
                if (exception instanceof ResponseException) {
                    ResponseException responseException = (ResponseException)exception;
                    BoxedUnit boxedUnit = (BoxedUnit)this.callback$1.apply((Object)package$.MODULE$.Right().apply((Object)this.$outer.fromResponse(responseException.getResponse())));
                } else {
                    BoxedUnit boxedUnit = (BoxedUnit)this.callback$1.apply((Object)package$.MODULE$.Left().apply((Object)new JavaClientExceptionWrapper(exception)));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.callback$1 = callback$1;
            }
        };
        Map jparams = (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(req.params()).asJava();
        Option<HttpEntity> option = req.entity();
        if (option instanceof Some) {
            Some some = (Some)option;
            HttpEntity entity = (HttpEntity)some.value();
            this.client.performRequestAsync(req.method(), req.endpoint(), jparams, (org.apache.http.HttpEntity)this.apacheEntity(entity), l, new Header[0]);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.client.performRequestAsync(req.method(), req.endpoint(), jparams, l, new Header[0]);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    private boolean isEntityGziped(org.apache.http.HttpEntity entity) {
        return Option$.MODULE$.apply((Object)entity.getContentEncoding()).flatMap((Function1 & Serializable)x -> Option$.MODULE$.apply((Object)x.getValue())).contains((Object)"gzip");
    }

    public ElasticsearchJavaRestClient(RestClient client) {
        this.client = client;
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }
}

