/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.elastic4s.http;

import com.sksamuel.elastic4s.ElasticsearchClientUri;
import com.sksamuel.elastic4s.http.ElasticClient;
import com.sksamuel.elastic4s.http.ElasticNodeEndpoint;
import com.sksamuel.elastic4s.http.ElasticProperties;
import com.sksamuel.elastic4s.http.ElasticsearchJavaRestClient;
import com.sksamuel.elastic4s.http.Executor;
import com.sksamuel.elastic4s.http.Functor;
import com.sksamuel.elastic4s.http.HttpClient;
import com.sksamuel.elastic4s.http.NoOpHttpClientConfigCallback$;
import com.sksamuel.elastic4s.http.NoOpRequestConfigCallback$;
import com.sksamuel.exts.Logging;
import java.io.Serializable;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;

public final class ElasticClient$
implements Logging {
    public static final ElasticClient$ MODULE$ = new ElasticClient$();
    private static Logger logger;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public Logger logger() {
        return logger;
    }

    public void com$sksamuel$exts$Logging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public <F> ElasticClient apply(HttpClient hc, Functor<F> evidence$1, Executor<F> evidence$2) {
        return new ElasticClient(hc){
            private final HttpClient hc$1;

            public HttpClient client() {
                return this.hc$1;
            }

            public void close() {
                this.hc$1.close();
            }
            {
                this.hc$1 = hc$1;
            }
        };
    }

    public <F> ElasticClient fromRestClient(RestClient client, Functor<F> evidence$3, Executor<F> evidence$4) {
        return this.apply(new ElasticsearchJavaRestClient(client), evidence$3, evidence$4);
    }

    public <F> ElasticClient apply(ElasticProperties props, Functor<F> evidence$5, Executor<F> evidence$6) {
        return this.apply(props, (RestClientBuilder.RequestConfigCallback)NoOpRequestConfigCallback$.MODULE$, (RestClientBuilder.HttpClientConfigCallback)NoOpHttpClientConfigCallback$.MODULE$, evidence$5, evidence$6);
    }

    public <F> ElasticClient apply(ElasticProperties props, RestClientBuilder.RequestConfigCallback requestConfigCallback, RestClientBuilder.HttpClientConfigCallback httpClientConfigCallback, Functor<F> evidence$7, Executor<F> evidence$8) {
        Seq hosts = (Seq)props.endpoints().map((Function1 & Serializable)x0$1 -> {
            ElasticNodeEndpoint elasticNodeEndpoint = x0$1;
            if (elasticNodeEndpoint == null) {
                throw new MatchError((Object)elasticNodeEndpoint);
            }
            String protocol = elasticNodeEndpoint.protocol();
            String host = elasticNodeEndpoint.host();
            int port = elasticNodeEndpoint.port();
            HttpHost httpHost = new HttpHost(host, port, protocol);
            return httpHost;
        });
        this.logger().info(new StringBuilder(24).append("Creating HTTP client on ").append(hosts.mkString(",")).toString());
        RestClient client = RestClient.builder((HttpHost[])((HttpHost[])hosts.toArray(ClassTag$.MODULE$.apply(HttpHost.class)))).setRequestConfigCallback(requestConfigCallback).setHttpClientConfigCallback(httpClientConfigCallback).build();
        return this.fromRestClient(client, evidence$7, evidence$8);
    }

    public <F> ElasticClient apply(ElasticsearchClientUri uri, RestClientBuilder.RequestConfigCallback requestConfigCallback, RestClientBuilder.HttpClientConfigCallback httpClientConfigCallback, Functor<F> evidence$9, Executor<F> evidence$10) {
        List hosts = uri.hosts().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String host = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            Object object = uri.options().getOrElse((Object)"ssl", (Function0 & Serializable)() -> "false");
            String string = "true";
            HttpHost httpHost = new HttpHost(host, port, !(object != null ? !object.equals(string) : string != null) ? "https" : "http");
            return httpHost;
        });
        this.logger().info(new StringBuilder(24).append("Creating HTTP client on ").append(hosts.mkString(",")).toString());
        RestClient client = RestClient.builder((HttpHost[])((HttpHost[])hosts.toArray(ClassTag$.MODULE$.apply(HttpHost.class)))).setRequestConfigCallback(requestConfigCallback).setHttpClientConfigCallback(httpClientConfigCallback).build();
        return this.fromRestClient(client, evidence$9, evidence$10);
    }

    public <F> RestClientBuilder.RequestConfigCallback apply$default$2() {
        return NoOpRequestConfigCallback$.MODULE$;
    }

    public <F> RestClientBuilder.HttpClientConfigCallback apply$default$3() {
        return NoOpHttpClientConfigCallback$.MODULE$;
    }

    private ElasticClient$() {
    }
}

