/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k.serializer;

import com.sksamuel.avro4k.decoder.ExtendedDecoder;
import com.sksamuel.avro4k.encoder.ExtendedEncoder;
import com.sksamuel.avro4k.schema.AvroDescriptor;
import com.sksamuel.avro4k.schema.NamingStrategy;
import com.sksamuel.avro4k.serializer.AvroSerializer;
import java.lang.annotation.Annotation;
import java.time.LocalTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.KClassesJvm;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.Serializer;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/sksamuel/avro4k/serializer/LocalTimeSerializer;", "Lcom/sksamuel/avro4k/serializer/AvroSerializer;", "Ljava/time/LocalTime;", "Lkotlinx/serialization/KSerializer;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeAvroValue", "schema", "Lorg/apache/avro/Schema;", "decoder", "Lcom/sksamuel/avro4k/decoder/ExtendedDecoder;", "encodeAvroValue", "", "encoder", "Lcom/sksamuel/avro4k/encoder/ExtendedEncoder;", "obj", "avro4k-core"})
@Serializer(forClass=LocalTime.class)
public final class LocalTimeSerializer
extends AvroSerializer<LocalTime>
implements KSerializer<LocalTime> {
    @NotNull
    private final SerialDescriptor descriptor = new AvroDescriptor(KClassesJvm.getJvmName((KClass)Reflection.getOrCreateKotlinClass(LocalTime.class)), (SerialKind)PrimitiveKind.INT.INSTANCE){

        @NotNull
        public Schema schema(@NotNull List<? extends Annotation> annos, @NotNull SerializersModule serializersModule, @NotNull NamingStrategy namingStrategy) {
            Intrinsics.checkParameterIsNotNull(annos, (String)"annos");
            Intrinsics.checkParameterIsNotNull((Object)serializersModule, (String)"serializersModule");
            Intrinsics.checkParameterIsNotNull((Object)namingStrategy, (String)"namingStrategy");
            Schema schema = (Schema)SchemaBuilder.builder().intType();
            Schema schema2 = LogicalTypes.timeMillis().addToSchema(schema);
            Intrinsics.checkExpressionValueIsNotNull((Object)schema2, (String)"LogicalTypes.timeMillis().addToSchema(schema)");
            return schema2;
        }
    };

    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void encodeAvroValue(@NotNull Schema schema, @NotNull ExtendedEncoder encoder2, @NotNull LocalTime obj) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)encoder2, (String)"encoder");
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        encoder2.encodeInt(obj.toSecondOfDay() * 1000 + obj.getNano() / 1000);
    }

    @Override
    @NotNull
    public LocalTime decodeAvroValue(@NotNull Schema schema, @NotNull ExtendedDecoder decoder) {
        LocalTime localTime;
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        LogicalType logicalType = schema.getLogicalType();
        if (logicalType instanceof LogicalTypes.TimeMicros) {
            LocalTime localTime2 = LocalTime.ofNanoOfDay((long)decoder.decodeInt() * 1000L);
            localTime = localTime2;
            Intrinsics.checkExpressionValueIsNotNull((Object)localTime2, (String)"LocalTime.ofNanoOfDay(decoder.decodeInt() * 1000L)");
        } else if (logicalType instanceof LogicalTypes.TimeMillis) {
            LocalTime localTime3 = LocalTime.ofNanoOfDay((long)decoder.decodeInt() * 1000000L);
            localTime = localTime3;
            Intrinsics.checkExpressionValueIsNotNull((Object)localTime3, (String)"LocalTime.ofNanoOfDay(de\u2026r.decodeInt() * 1000000L)");
        } else {
            throw (Throwable)new SerializationException("Unsupported logical type for LocalTime [" + schema.getLogicalType() + ']');
        }
        return localTime;
    }
}

