/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k.serializer;

import com.sksamuel.avro4k.AnnotationExtractor;
import com.sksamuel.avro4k.decoder.ExtendedDecoder;
import com.sksamuel.avro4k.encoder.ExtendedEncoder;
import com.sksamuel.avro4k.schema.AvroDescriptor;
import com.sksamuel.avro4k.schema.NamingStrategy;
import com.sksamuel.avro4k.serializer.AvroSerializer;
import com.sksamuel.avro4k.serializer.BigDecimalSerializer$WhenMappings;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.KClassesJvm;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.Serializer;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.util.Utf8;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/sksamuel/avro4k/serializer/BigDecimalSerializer;", "Lcom/sksamuel/avro4k/serializer/AvroSerializer;", "Ljava/math/BigDecimal;", "Lkotlinx/serialization/KSerializer;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeAvroValue", "schema", "Lorg/apache/avro/Schema;", "decoder", "Lcom/sksamuel/avro4k/decoder/ExtendedDecoder;", "encodeAvroValue", "", "encoder", "Lcom/sksamuel/avro4k/encoder/ExtendedEncoder;", "obj", "avro4k-core"})
@Serializer(forClass=BigDecimal.class)
public final class BigDecimalSerializer
extends AvroSerializer<BigDecimal>
implements KSerializer<BigDecimal> {
    @NotNull
    private final SerialDescriptor descriptor = new AvroDescriptor(KClassesJvm.getJvmName((KClass)Reflection.getOrCreateKotlinClass(BigDecimal.class)), (SerialKind)PrimitiveKind.BYTE.INSTANCE){

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Schema schema(@NotNull List<? extends Annotation> annos, @NotNull SerializersModule serializersModule, @NotNull NamingStrategy namingStrategy) {
            void scale;
            Intrinsics.checkParameterIsNotNull(annos, (String)"annos");
            Intrinsics.checkParameterIsNotNull((Object)serializersModule, (String)"serializersModule");
            Intrinsics.checkParameterIsNotNull((Object)namingStrategy, (String)"namingStrategy");
            Schema schema = (Schema)SchemaBuilder.builder().bytesType();
            Pair pair = new AnnotationExtractor(annos).scalePrecision();
            if (pair == null) {
                pair = TuplesKt.to((Object)2, (Object)8);
            }
            Pair pair2 = pair;
            int n = ((Number)pair2.component1()).intValue();
            int precision = ((Number)pair2.component2()).intValue();
            Schema schema2 = LogicalTypes.decimal((int)precision, (int)scale).addToSchema(schema);
            Intrinsics.checkExpressionValueIsNotNull((Object)schema2, (String)"LogicalTypes.decimal(pre\u2026cale).addToSchema(schema)");
            return schema2;
        }
    };

    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void encodeAvroValue(@NotNull Schema schema, @NotNull ExtendedEncoder encoder2, @NotNull BigDecimal obj) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)encoder2, (String)"encoder");
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Conversions.DecimalConversion converter2 = new Conversions.DecimalConversion();
        RoundingMode rm = RoundingMode.UNNECESSARY;
        Schema.Type type = schema.getType();
        if (type == null) throw (Throwable)new SerializationException("Cannot encode BigDecimal as " + schema.getType());
        switch (BigDecimalSerializer$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                String string = obj.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"obj.toString()");
                encoder2.encodeString(string);
                return;
            }
            case 2: {
                LogicalType logical = schema.getLogicalType();
                if (!(logical instanceof LogicalTypes.Decimal)) throw (Throwable)new SerializationException("Cannot encode BigDecimal to FIXED for logical type " + logical);
                ByteBuffer byteBuffer = converter2.toBytes(obj.setScale(((LogicalTypes.Decimal)logical).getScale(), rm), schema, logical);
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"converter.toBytes(obj.se\u2026                 logical)");
                encoder2.encodeByteArray(byteBuffer);
                return;
            }
            case 3: {
                LogicalType logical = schema.getLogicalType();
                if (!(logical instanceof LogicalTypes.Decimal)) throw (Throwable)new SerializationException("Cannot encode BigDecimal to FIXED for logical type " + logical);
                GenericFixed genericFixed = converter2.toFixed(obj.setScale(((LogicalTypes.Decimal)logical).getScale(), rm), schema, logical);
                Intrinsics.checkExpressionValueIsNotNull((Object)genericFixed, (String)"converter.toFixed(obj.se\u2026                 logical)");
                encoder2.encodeFixed(genericFixed);
                return;
            }
            default: {
                throw (Throwable)new SerializationException("Cannot encode BigDecimal as " + schema.getType());
            }
        }
    }

    @Override
    @NotNull
    public BigDecimal decodeAvroValue(@NotNull Schema schema, @NotNull ExtendedDecoder decoder) {
        BigDecimal bigDecimal;
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Function0<LogicalTypes.Decimal> $fun$logical$1 = new Function0<LogicalTypes.Decimal>(schema){
            final /* synthetic */ Schema $schema;

            @NotNull
            public final LogicalTypes.Decimal invoke() {
                LogicalType l = this.$schema.getLogicalType();
                if (!(l instanceof LogicalTypes.Decimal)) {
                    throw (Throwable)new SerializationException("Cannot decode to BigDecimal when field schema [" + this.$schema + "] does not define Decimal logical type [" + l + ']');
                }
                return (LogicalTypes.Decimal)l;
            }
            {
                this.$schema = schema;
                super(0);
            }
        };
        Object v = decoder.decodeAny();
        if (v instanceof Utf8) {
            bigDecimal = new BigDecimal(decoder.decodeString());
        } else if (v instanceof byte[]) {
            BigDecimal bigDecimal2 = new Conversions.DecimalConversion().fromBytes(ByteBuffer.wrap((byte[])v), schema, (LogicalType)$fun$logical$1.invoke());
            bigDecimal = bigDecimal2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal2, (String)"Conversions.DecimalConve\u2026ap(v), schema, logical())");
        } else if (v instanceof ByteBuffer) {
            BigDecimal bigDecimal3 = new Conversions.DecimalConversion().fromBytes((ByteBuffer)v, schema, (LogicalType)$fun$logical$1.invoke());
            bigDecimal = bigDecimal3;
            Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal3, (String)"Conversions.DecimalConve\u2026tes(v, schema, logical())");
        } else if (v instanceof GenericFixed) {
            BigDecimal bigDecimal4 = new Conversions.DecimalConversion().fromFixed((GenericFixed)v, schema, (LogicalType)$fun$logical$1.invoke());
            bigDecimal = bigDecimal4;
            Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal4, (String)"Conversions.DecimalConve\u2026xed(v, schema, logical())");
        } else {
            throw (Throwable)new SerializationException("Unsupported BigDecimal type [" + v + ']');
        }
        return bigDecimal;
    }
}

