/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k.schema;

import com.sksamuel.avro4k.schema.AvroDescriptor;
import com.sksamuel.avro4k.schema.ClassSchemaFor;
import com.sksamuel.avro4k.schema.EnumSchemaFor;
import com.sksamuel.avro4k.schema.ListSchemaFor;
import com.sksamuel.avro4k.schema.MapSchemaFor;
import com.sksamuel.avro4k.schema.NamingStrategy;
import com.sksamuel.avro4k.schema.NullableSchemaFor;
import com.sksamuel.avro4k.schema.PairSchemaFor;
import com.sksamuel.avro4k.schema.SchemaFor;
import com.sksamuel.avro4k.schema.SealedClassSchemaFor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"schemaFor", "Lcom/sksamuel/avro4k/schema/SchemaFor;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "annos", "", "", "namingStrategy", "Lcom/sksamuel/avro4k/schema/NamingStrategy;", "avro4k-core"})
public final class SchemaForKt {
    @ExperimentalSerializationApi
    @NotNull
    public static final SchemaFor schemaFor(@NotNull SerializersModule serializersModule, @NotNull SerialDescriptor descriptor2, @NotNull List<? extends Annotation> annos, @NotNull NamingStrategy namingStrategy) {
        SchemaFor schemaFor;
        SerialDescriptor underlying;
        SerialDescriptor serialDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull(annos, (String)"annos");
        Intrinsics.checkParameterIsNotNull((Object)namingStrategy, (String)"namingStrategy");
        if (Intrinsics.areEqual((Object)descriptor2.getClass().getSimpleName(), (Object)"SerialDescriptorForNullable")) {
            Field field;
            Field field2 = field = descriptor2.getClass().getDeclaredField("original");
            Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"field");
            field2.setAccessible(true);
            Object object = field.get(descriptor2);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.descriptors.SerialDescriptor");
            }
            serialDescriptor = (SerialDescriptor)object;
        } else {
            serialDescriptor = descriptor2;
        }
        SerialDescriptor serialDescriptor2 = underlying = serialDescriptor;
        if (serialDescriptor2 instanceof AvroDescriptor) {
            schemaFor = SchemaFor.Companion.const(((AvroDescriptor)underlying).schema(annos, serializersModule, namingStrategy));
        } else {
            SerialKind serialKind = descriptor2.getKind();
            if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.STRING.INSTANCE)) {
                schemaFor = SchemaFor.Companion.getStringSchemaFor();
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.LONG.INSTANCE)) {
                schemaFor = SchemaFor.Companion.getLongSchemaFor();
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.INT.INSTANCE)) {
                schemaFor = SchemaFor.Companion.getIntSchemaFor();
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.SHORT.INSTANCE)) {
                schemaFor = SchemaFor.Companion.getShortSchemaFor();
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.BYTE.INSTANCE)) {
                schemaFor = SchemaFor.Companion.getByteSchemaFor();
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.DOUBLE.INSTANCE)) {
                schemaFor = SchemaFor.Companion.getDoubleSchemaFor();
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.FLOAT.INSTANCE)) {
                schemaFor = SchemaFor.Companion.getFloatSchemaFor();
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.BOOLEAN.INSTANCE)) {
                schemaFor = SchemaFor.Companion.getBooleanSchemaFor();
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)SerialKind.ENUM.INSTANCE)) {
                schemaFor = new EnumSchemaFor(descriptor2);
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)PolymorphicKind.SEALED.INSTANCE)) {
                schemaFor = new SealedClassSchemaFor(descriptor2, namingStrategy, serializersModule);
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE)) {
                String string = descriptor2.getSerialName();
                switch (string.hashCode()) {
                    case -1706987577: {
                        if (string.equals("kotlin.Pair")) {
                            schemaFor = new PairSchemaFor(descriptor2, namingStrategy, serializersModule);
                            break;
                        }
                    }
                    default: {
                        schemaFor = new ClassSchemaFor(descriptor2, namingStrategy, serializersModule);
                        break;
                    }
                }
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
                schemaFor = new ListSchemaFor(descriptor2, serializersModule, namingStrategy);
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
                schemaFor = new MapSchemaFor(descriptor2, serializersModule, namingStrategy);
            } else {
                throw (Throwable)new SerializationException("Unsupported type " + descriptor2.getSerialName() + " of " + descriptor2.getKind());
            }
        }
        SchemaFor schemaFor2 = schemaFor;
        return descriptor2.isNullable() ? (SchemaFor)new NullableSchemaFor(schemaFor2, annos) : schemaFor2;
    }
}

