/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k.schema;

import com.sksamuel.avro4k.schema.NamingStrategy;
import com.sksamuel.avro4k.schema.SchemaFor;
import com.sksamuel.avro4k.schema.SchemaForKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/sksamuel/avro4k/schema/MapSchemaFor;", "Lcom/sksamuel/avro4k/schema/SchemaFor;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "namingStrategy", "Lcom/sksamuel/avro4k/schema/NamingStrategy;", "(Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlinx/serialization/modules/SerializersModule;Lcom/sksamuel/avro4k/schema/NamingStrategy;)V", "schema", "Lorg/apache/avro/Schema;", "avro4k-core"})
public final class MapSchemaFor
implements SchemaFor {
    private final SerialDescriptor descriptor;
    private final SerializersModule serializersModule;
    private final NamingStrategy namingStrategy;

    @Override
    @NotNull
    public Schema schema() {
        SerialDescriptor keyType = this.descriptor.getElementDescriptor(0);
        SerialKind serialKind = keyType.getKind();
        if (serialKind instanceof PrimitiveKind.STRING) {
            SerialDescriptor valueType = this.descriptor.getElementDescriptor(1);
            Schema valueSchema = SchemaForKt.schemaFor(this.serializersModule, valueType, this.descriptor.getElementAnnotations(1), this.namingStrategy).schema();
            Schema schema = Schema.createMap((Schema)valueSchema);
            Intrinsics.checkExpressionValueIsNotNull((Object)schema, (String)"Schema.createMap(valueSchema)");
            return schema;
        }
        throw (Throwable)new RuntimeException("Avro only supports STRING as the key type in a MAP");
    }

    public MapSchemaFor(@NotNull SerialDescriptor descriptor2, @NotNull SerializersModule serializersModule, @NotNull NamingStrategy namingStrategy) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkParameterIsNotNull((Object)namingStrategy, (String)"namingStrategy");
        this.descriptor = descriptor2;
        this.serializersModule = serializersModule;
        this.namingStrategy = namingStrategy;
    }
}

