/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k.io;

import com.sksamuel.avro4k.io.AvroInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u000f\u0010\u0015\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/sksamuel/avro4k/io/SchemalessAvroInputStream;", "T", "Lcom/sksamuel/avro4k/io/AvroInputStream;", "input", "Ljava/io/InputStream;", "converter", "Lkotlin/Function1;", "", "writerSchema", "Lorg/apache/avro/Schema;", "readerSchema", "(Ljava/io/InputStream;Lkotlin/jvm/functions/Function1;Lorg/apache/avro/Schema;Lorg/apache/avro/Schema;)V", "datumReader", "Lorg/apache/avro/generic/GenericDatumReader;", "Lorg/apache/avro/generic/GenericRecord;", "decoder", "Lorg/apache/avro/io/Decoder;", "getDecoder", "()Lorg/apache/avro/io/Decoder;", "close", "", "next", "()Ljava/lang/Object;", "avro4k-core"})
public abstract class SchemalessAvroInputStream<T>
implements AvroInputStream<T> {
    private final GenericDatumReader<GenericRecord> datumReader;
    private final InputStream input;
    private final Function1<Object, T> converter;

    @NotNull
    public abstract Decoder getDecoder();

    @Override
    public void close() {
        this.input.close();
    }

    @Override
    @Nullable
    public T next() {
        GenericRecord record;
        GenericRecord genericRecord;
        try {
            genericRecord = (GenericRecord)this.datumReader.read(null, this.getDecoder());
        }
        catch (EOFException e) {
            genericRecord = null;
        }
        genericRecord = record = genericRecord;
        return (T)(genericRecord == null ? null : this.converter.invoke((Object)record));
    }

    public SchemalessAvroInputStream(@NotNull InputStream input, @NotNull Function1<Object, ? extends T> converter2, @NotNull Schema writerSchema, @Nullable Schema readerSchema) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull(converter2, (String)"converter");
        Intrinsics.checkParameterIsNotNull((Object)writerSchema, (String)"writerSchema");
        this.input = input;
        this.converter = converter2;
        Schema schema = readerSchema;
        this.datumReader = schema == null ? new GenericDatumReader(writerSchema) : new GenericDatumReader(writerSchema, readerSchema);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return AvroInputStream.DefaultImpls.iterator(this);
    }

    @Override
    public T nextOrThrow() {
        return AvroInputStream.DefaultImpls.nextOrThrow(this);
    }
}

