/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k.io;

import com.sksamuel.avro4k.io.AvroOutputStream;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Encoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/sksamuel/avro4k/io/DefaultAvroOutputStream;", "T", "Lcom/sksamuel/avro4k/io/AvroOutputStream;", "output", "Ljava/io/OutputStream;", "converter", "Lkotlin/Function1;", "Lorg/apache/avro/generic/GenericRecord;", "schema", "Lorg/apache/avro/Schema;", "(Ljava/io/OutputStream;Lkotlin/jvm/functions/Function1;Lorg/apache/avro/Schema;)V", "datumWriter", "Lorg/apache/avro/generic/GenericDatumWriter;", "encoder", "Lorg/apache/avro/io/Encoder;", "getEncoder", "()Lorg/apache/avro/io/Encoder;", "close", "", "fSync", "flush", "write", "t", "(Ljava/lang/Object;)Lcom/sksamuel/avro4k/io/AvroOutputStream;", "avro4k-core"})
public abstract class DefaultAvroOutputStream<T>
implements AvroOutputStream<T> {
    private final GenericDatumWriter<GenericRecord> datumWriter;
    private final OutputStream output;
    private final Function1<T, GenericRecord> converter;

    @NotNull
    public abstract Encoder getEncoder();

    @Override
    public void close() {
        this.flush();
        this.output.close();
    }

    @Override
    public void flush() {
        this.getEncoder().flush();
    }

    @Override
    public void fSync() {
    }

    @Override
    @NotNull
    public AvroOutputStream<T> write(T t) {
        this.datumWriter.write(this.converter.invoke(t), this.getEncoder());
        return this;
    }

    public DefaultAvroOutputStream(@NotNull OutputStream output, @NotNull Function1<? super T, ? extends GenericRecord> converter2, @NotNull Schema schema) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull(converter2, (String)"converter");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        this.output = output;
        this.converter = converter2;
        this.datumWriter = new GenericDatumWriter(schema);
    }

    @Override
    @NotNull
    public AvroOutputStream<T> write(@NotNull List<? extends T> ts) {
        Intrinsics.checkParameterIsNotNull(ts, (String)"ts");
        return AvroOutputStream.DefaultImpls.write(this, ts);
    }
}

