/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k.io;

import com.sksamuel.avro4k.io.AvroBinaryOutputStream;
import com.sksamuel.avro4k.io.AvroDataOutputStream;
import com.sksamuel.avro4k.io.AvroFormat;
import com.sksamuel.avro4k.io.AvroJsonOutputStream;
import com.sksamuel.avro4k.io.AvroOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.generic.GenericRecord;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="Create an instance of [AvroOutputStream] using the openOutputStream method on Avro.default")
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u0013\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/sksamuel/avro4k/io/AvroOutputStreamBuilder;", "T", "", "schema", "Lorg/apache/avro/Schema;", "converter", "Lkotlin/Function1;", "Lorg/apache/avro/generic/GenericRecord;", "format", "Lcom/sksamuel/avro4k/io/AvroFormat;", "codec", "Lorg/apache/avro/file/CodecFactory;", "(Lorg/apache/avro/Schema;Lkotlin/jvm/functions/Function1;Lcom/sksamuel/avro4k/io/AvroFormat;Lorg/apache/avro/file/CodecFactory;)V", "to", "Lcom/sksamuel/avro4k/io/AvroOutputStream;", "file", "Ljava/io/File;", "output", "Ljava/io/OutputStream;", "path", "Ljava/nio/file/Path;", "", "withCodec", "avro4k-core"})
public final class AvroOutputStreamBuilder<T> {
    private final Schema schema;
    private final Function1<T, GenericRecord> converter;
    private final AvroFormat format;
    private final CodecFactory codec;

    @NotNull
    public final AvroOutputStreamBuilder<T> withCodec(@NotNull CodecFactory codec) {
        Intrinsics.checkParameterIsNotNull((Object)codec, (String)"codec");
        return new AvroOutputStreamBuilder<T>(this.schema, this.converter, this.format, codec);
    }

    @NotNull
    public final AvroOutputStream<T> to(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"Files.newOutputStream(path)");
        return this.to(outputStream);
    }

    @NotNull
    public final AvroOutputStream<T> to(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(path)");
        return this.to(path2);
    }

    @NotNull
    public final AvroOutputStream<T> to(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Path path = file.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file.toPath()");
        return this.to(path);
    }

    @NotNull
    public final AvroOutputStream<T> to(@NotNull OutputStream output) {
        AvroOutputStream avroOutputStream;
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        AvroFormat avroFormat = this.format;
        if (Intrinsics.areEqual((Object)avroFormat, (Object)AvroFormat.DataFormat.INSTANCE)) {
            avroOutputStream = new AvroDataOutputStream<T>(output, this.converter, this.schema, this.codec);
        } else if (Intrinsics.areEqual((Object)avroFormat, (Object)AvroFormat.JsonFormat.INSTANCE)) {
            avroOutputStream = new AvroJsonOutputStream<T>(output, this.converter, this.schema);
        } else if (Intrinsics.areEqual((Object)avroFormat, (Object)AvroFormat.BinaryFormat.INSTANCE)) {
            avroOutputStream = new AvroBinaryOutputStream<T>(output, this.converter, this.schema);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return avroOutputStream;
    }

    public AvroOutputStreamBuilder(@NotNull Schema schema, @NotNull Function1<? super T, ? extends GenericRecord> converter2, @NotNull AvroFormat format, @NotNull CodecFactory codec) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull(converter2, (String)"converter");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)codec, (String)"codec");
        this.schema = schema;
        this.converter = converter2;
        this.format = format;
        this.codec = codec;
    }

    public /* synthetic */ AvroOutputStreamBuilder(Schema schema, Function1 function1, AvroFormat avroFormat, CodecFactory codecFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            CodecFactory codecFactory2 = CodecFactory.nullCodec();
            Intrinsics.checkExpressionValueIsNotNull((Object)codecFactory2, (String)"CodecFactory.nullCodec()");
            codecFactory = codecFactory2;
        }
        this(schema, function1, avroFormat, codecFactory);
    }
}

