/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k.io;

import com.sksamuel.avro4k.Avro;
import com.sksamuel.avro4k.io.DefaultAvroOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationStrategy;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/sksamuel/avro4k/io/AvroJsonOutputStream;", "T", "Lcom/sksamuel/avro4k/io/DefaultAvroOutputStream;", "output", "Ljava/io/OutputStream;", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "schema", "Lorg/apache/avro/Schema;", "avro", "Lcom/sksamuel/avro4k/Avro;", "(Ljava/io/OutputStream;Lkotlinx/serialization/SerializationStrategy;Lorg/apache/avro/Schema;Lcom/sksamuel/avro4k/Avro;)V", "converter", "Lkotlin/Function1;", "Lorg/apache/avro/generic/GenericRecord;", "(Ljava/io/OutputStream;Lkotlin/jvm/functions/Function1;Lorg/apache/avro/Schema;)V", "encoder", "Lorg/apache/avro/io/JsonEncoder;", "getEncoder", "()Lorg/apache/avro/io/JsonEncoder;", "avro4k-core"})
public final class AvroJsonOutputStream<T>
extends DefaultAvroOutputStream<T> {
    @NotNull
    private final JsonEncoder encoder;

    @NotNull
    public JsonEncoder getEncoder() {
        return this.encoder;
    }

    public AvroJsonOutputStream(@NotNull OutputStream output, @NotNull Function1<? super T, ? extends GenericRecord> converter2, @NotNull Schema schema) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull(converter2, (String)"converter");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        super(output, converter2, schema);
        JsonEncoder jsonEncoder = EncoderFactory.get().jsonEncoder(schema, output, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonEncoder, (String)"EncoderFactory.get().jso\u2026der(schema, output, true)");
        this.encoder = jsonEncoder;
    }

    public AvroJsonOutputStream(@NotNull OutputStream output, final @NotNull SerializationStrategy<? super T> serializer, @NotNull Schema schema, final @NotNull Avro avro) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)avro, (String)"avro");
        this(output, (Function1)new Function1<T, GenericRecord>(){

            @NotNull
            public final GenericRecord invoke(T it) {
                return avro.toRecord(serializer, it);
            }
        }, schema);
    }

    public /* synthetic */ AvroJsonOutputStream(OutputStream outputStream, SerializationStrategy serializationStrategy, Schema schema, Avro avro, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            avro = Avro.Companion.getDefault();
        }
        this(outputStream, serializationStrategy, schema, avro);
    }
}

