/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k.io;

import com.sksamuel.avro4k.io.AvroBinaryInputStream;
import com.sksamuel.avro4k.io.AvroDataInputStream;
import com.sksamuel.avro4k.io.AvroFormat;
import com.sksamuel.avro4k.io.AvroInputStream;
import com.sksamuel.avro4k.io.AvroJsonInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B5\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\u0013\u001a\u00020\u0017J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0019\u001a\u00020\bJ\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0019\u001a\u00020\bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/sksamuel/avro4k/io/AvroInputStreamBuilder;", "T", "", "converter", "Lkotlin/Function1;", "format", "Lcom/sksamuel/avro4k/io/AvroFormat;", "wschema", "Lorg/apache/avro/Schema;", "rschema", "(Lkotlin/jvm/functions/Function1;Lcom/sksamuel/avro4k/io/AvroFormat;Lorg/apache/avro/Schema;Lorg/apache/avro/Schema;)V", "from", "Lcom/sksamuel/avro4k/io/AvroInputStream;", "file", "Ljava/io/File;", "source", "Ljava/io/InputStream;", "buffer", "Ljava/nio/ByteBuffer;", "path", "Ljava/nio/file/Path;", "bytes", "", "", "withReaderSchema", "schema", "withWriterSchema", "avro4k-core"})
public final class AvroInputStreamBuilder<T> {
    private final Function1<Object, T> converter;
    private final AvroFormat format;
    private final Schema wschema;
    private final Schema rschema;

    @NotNull
    public final AvroInputStreamBuilder<T> withWriterSchema(@NotNull Schema schema) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return new AvroInputStreamBuilder<T>(this.converter, this.format, schema, this.rschema);
    }

    @NotNull
    public final AvroInputStreamBuilder<T> withReaderSchema(@NotNull Schema schema) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return new AvroInputStreamBuilder<T>(this.converter, this.format, this.wschema, schema);
    }

    @NotNull
    public final AvroInputStream<T> from(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"Files.newInputStream(path)");
        return this.from(inputStream);
    }

    @NotNull
    public final AvroInputStream<T> from(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(path)");
        return this.from(path2);
    }

    @NotNull
    public final AvroInputStream<T> from(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Path path = file.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file.toPath()");
        return this.from(path);
    }

    @NotNull
    public final AvroInputStream<T> from(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        return this.from(new ByteArrayInputStream(bytes));
    }

    @NotNull
    public final AvroInputStream<T> from(@NotNull ByteBuffer buffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        return this.from(new ByteArrayInputStream(buffer.array()));
    }

    @NotNull
    public final AvroInputStream<T> from(@NotNull InputStream source) {
        AvroInputStream avroInputStream;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        AvroFormat avroFormat = this.format;
        if (Intrinsics.areEqual((Object)avroFormat, (Object)AvroFormat.BinaryFormat.INSTANCE)) {
            Schema schema = this.wschema;
            if (schema == null) {
                Intrinsics.throwNpe();
            }
            avroInputStream = new AvroBinaryInputStream<T>(source, this.converter, schema, this.rschema);
        } else if (Intrinsics.areEqual((Object)avroFormat, (Object)AvroFormat.JsonFormat.INSTANCE)) {
            Schema schema = this.wschema;
            if (schema == null) {
                Intrinsics.throwNpe();
            }
            avroInputStream = new AvroJsonInputStream<T>(source, this.converter, schema, this.rschema);
        } else if (Intrinsics.areEqual((Object)avroFormat, (Object)AvroFormat.DataFormat.INSTANCE)) {
            avroInputStream = this.wschema != null && this.rschema != null ? new AvroDataInputStream<T>(source, this.converter, this.wschema, this.rschema) : (this.wschema != null ? new AvroDataInputStream<T>(source, this.converter, this.wschema, this.wschema) : new AvroDataInputStream<T>(source, this.converter, null, null));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return avroInputStream;
    }

    public AvroInputStreamBuilder(@NotNull Function1<Object, ? extends T> converter2, @NotNull AvroFormat format, @Nullable Schema wschema, @Nullable Schema rschema) {
        Intrinsics.checkParameterIsNotNull(converter2, (String)"converter");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        this.converter = converter2;
        this.format = format;
        this.wschema = wschema;
        this.rschema = rschema;
    }
}

