/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k.io;

import com.sksamuel.avro4k.io.AvroOutputStream;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\u001b\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00070\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/sksamuel/avro4k/io/AvroDataOutputStream;", "T", "Lcom/sksamuel/avro4k/io/AvroOutputStream;", "output", "Ljava/io/OutputStream;", "converter", "Lkotlin/Function1;", "Lorg/apache/avro/generic/GenericRecord;", "schema", "Lorg/apache/avro/Schema;", "codec", "Lorg/apache/avro/file/CodecFactory;", "(Ljava/io/OutputStream;Lkotlin/jvm/functions/Function1;Lorg/apache/avro/Schema;Lorg/apache/avro/file/CodecFactory;)V", "datumWriter", "Lorg/apache/avro/generic/GenericDatumWriter;", "writer", "Lorg/apache/avro/file/DataFileWriter;", "kotlin.jvm.PlatformType", "close", "", "fSync", "flush", "write", "t", "(Ljava/lang/Object;)Lcom/sksamuel/avro4k/io/AvroOutputStream;", "avro4k-core"})
public final class AvroDataOutputStream<T>
implements AvroOutputStream<T> {
    private final GenericDatumWriter<GenericRecord> datumWriter;
    private final DataFileWriter<GenericRecord> writer;
    private final OutputStream output;
    private final Function1<T, GenericRecord> converter;
    private final Schema schema;
    private final CodecFactory codec;

    @Override
    public void close() {
        this.flush();
        this.writer.close();
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public void fSync() {
        this.writer.fSync();
    }

    @Override
    @NotNull
    public AvroOutputStream<T> write(T t) {
        this.writer.append(this.converter.invoke(t));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public AvroDataOutputStream(@NotNull OutputStream output, @NotNull Function1<? super T, ? extends GenericRecord> converter2, @NotNull Schema schema, @NotNull CodecFactory codec) {
        void $this$apply;
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull(converter2, (String)"converter");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)codec, (String)"codec");
        this.output = output;
        this.converter = converter2;
        this.schema = schema;
        this.codec = codec;
        this.datumWriter = new GenericDatumWriter(this.schema);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)this.datumWriter);
        boolean bl = false;
        boolean bl2 = false;
        DataFileWriter dataFileWriter2 = dataFileWriter;
        AvroDataOutputStream avroDataOutputStream = this;
        boolean bl3 = false;
        $this$apply.setCodec(this.codec);
        $this$apply.create(this.schema, this.output);
        Unit unit = Unit.INSTANCE;
        avroDataOutputStream.writer = dataFileWriter;
    }

    @Override
    @NotNull
    public AvroOutputStream<T> write(@NotNull List<? extends T> ts) {
        Intrinsics.checkParameterIsNotNull(ts, (String)"ts");
        return AvroOutputStream.DefaultImpls.write(this, ts);
    }
}

