/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k.io;

import com.sksamuel.avro4k.io.AvroInputStream;
import java.io.InputStream;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000f\u0010\u0013\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u000e\u001a\"\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00070\u0007 \u0010*\u000b\u0012\u0002\b\u0003\u0018\u00010\u000f\u00a8\u0006\u00010\u000f\u00a8\u0006\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/sksamuel/avro4k/io/AvroDataInputStream;", "T", "Lcom/sksamuel/avro4k/io/AvroInputStream;", "source", "Ljava/io/InputStream;", "converter", "Lkotlin/Function1;", "", "writerSchema", "Lorg/apache/avro/Schema;", "readerSchema", "(Ljava/io/InputStream;Lkotlin/jvm/functions/Function1;Lorg/apache/avro/Schema;Lorg/apache/avro/Schema;)V", "dataFileReader", "Lorg/apache/avro/file/DataFileStream;", "datumReader", "Lorg/apache/avro/io/DatumReader;", "kotlin.jvm.PlatformType", "close", "", "next", "()Ljava/lang/Object;", "avro4k-core"})
public final class AvroDataInputStream<T>
implements AvroInputStream<T> {
    private final DatumReader<Object> datumReader;
    private final DataFileStream<Object> dataFileReader;
    private final InputStream source;
    private final Function1<Object, T> converter;

    @Override
    @Nullable
    public T next() {
        Object object;
        if (this.dataFileReader.hasNext()) {
            Object obj;
            Object object2 = obj = this.dataFileReader.next(null);
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"obj");
            object = this.converter.invoke(object2);
        } else {
            object = null;
        }
        return (T)object;
    }

    @Override
    public void close() {
        this.source.close();
    }

    public AvroDataInputStream(@NotNull InputStream source, @NotNull Function1<Object, ? extends T> converter2, @Nullable Schema writerSchema, @Nullable Schema readerSchema) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(converter2, (String)"converter");
        this.source = source;
        this.converter = converter2;
        this.datumReader = writerSchema == null && readerSchema == null ? GenericData.get().createDatumReader(null) : (readerSchema == null ? GenericData.get().createDatumReader(writerSchema) : (writerSchema == null ? GenericData.get().createDatumReader(readerSchema) : GenericData.get().createDatumReader(writerSchema, readerSchema)));
        this.dataFileReader = new DataFileStream(this.source, this.datumReader);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return AvroInputStream.DefaultImpls.iterator(this);
    }

    @Override
    public T nextOrThrow() {
        return AvroInputStream.DefaultImpls.nextOrThrow(this);
    }
}

