/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k.encoder;

import com.sksamuel.avro4k.Record;
import com.sksamuel.avro4k.encoder.RecordEncoder;
import com.sksamuel.avro4k.encoder.SealedClassEncoder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/sksamuel/avro4k/encoder/RootRecordEncoder;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "schema", "Lorg/apache/avro/Schema;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "callback", "Lkotlin/Function1;", "Lcom/sksamuel/avro4k/Record;", "", "(Lorg/apache/avro/Schema;Lkotlinx/serialization/modules/SerializersModule;Lkotlin/jvm/functions/Function1;)V", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "endStructure", "avro4k-core"})
public final class RootRecordEncoder
extends AbstractEncoder {
    private final Schema schema;
    @NotNull
    private final SerializersModule serializersModule;
    private final Function1<Record, Unit> callback;

    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        CompositeEncoder compositeEncoder;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        SerialKind serialKind = descriptor2.getKind();
        if (serialKind instanceof StructureKind.CLASS) {
            compositeEncoder = (CompositeEncoder)new RecordEncoder(this.schema, this.getSerializersModule(), this.callback);
        } else if (serialKind instanceof PolymorphicKind.SEALED) {
            compositeEncoder = (CompositeEncoder)new SealedClassEncoder(this.schema, this.getSerializersModule(), this.callback);
        } else {
            throw (Throwable)new SerializationException("Unsupported root element passed to root record encoder");
        }
        return compositeEncoder;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public RootRecordEncoder(@NotNull Schema schema, @NotNull SerializersModule serializersModule, @NotNull Function1<? super Record, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.schema = schema;
        this.serializersModule = serializersModule;
        this.callback = callback;
    }
}

