/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k.encoder;

import com.sksamuel.avro4k.AnnotationExtractor;
import com.sksamuel.avro4k.Record;
import com.sksamuel.avro4k.encoder.RecordBuilder;
import com.sksamuel.avro4k.encoder.StringToAvroValue;
import com.sksamuel.avro4k.encoder.StructureEncoder;
import com.sksamuel.avro4k.encoder.ValueToEnum;
import com.sksamuel.avro4k.schema.SchemasKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericFixed;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0011H\u0016J\u0018\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0011H\u0016J\u0010\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\nH\u0016J\u0010\u0010'\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010*\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010+\u001a\u00020\u0004H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006,"}, d2={"Lcom/sksamuel/avro4k/encoder/RecordEncoder;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "Lcom/sksamuel/avro4k/encoder/StructureEncoder;", "schema", "Lorg/apache/avro/Schema;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "callback", "Lkotlin/Function1;", "Lcom/sksamuel/avro4k/Record;", "", "(Lorg/apache/avro/Schema;Lkotlinx/serialization/modules/SerializersModule;Lkotlin/jvm/functions/Function1;)V", "builder", "Lcom/sksamuel/avro4k/encoder/RecordBuilder;", "getCallback", "()Lkotlin/jvm/functions/Function1;", "currentIndex", "", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "addValue", "value", "", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "encodeByteArray", "buffer", "Ljava/nio/ByteBuffer;", "encodeElement", "", "index", "encodeEnum", "enumDescriptor", "encodeFixed", "fixed", "Lorg/apache/avro/generic/GenericFixed;", "encodeNull", "encodeString", "", "encodeValue", "endStructure", "fieldSchema", "avro4k-core"})
public final class RecordEncoder
extends AbstractEncoder
implements StructureEncoder {
    private final RecordBuilder builder;
    private int currentIndex;
    private final Schema schema;
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final Function1<Record, Unit> callback;

    @Override
    @NotNull
    public Schema fieldSchema() {
        Schema currentFieldSchema;
        Schema schema = currentFieldSchema = ((Schema.Field)this.schema.getFields().get(this.currentIndex)).schema();
        Intrinsics.checkExpressionValueIsNotNull((Object)schema, (String)"currentFieldSchema");
        return schema.isNullable() ? SchemasKt.extractNonNull(currentFieldSchema) : currentFieldSchema;
    }

    @Override
    public void addValue(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.builder.add(value);
    }

    public void encodeString(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.builder.add(StringToAvroValue.INSTANCE.toValue(this.fieldSchema(), value));
    }

    public void encodeValue(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.builder.add(value);
    }

    public boolean encodeElement(@NotNull SerialDescriptor descriptor2, int index) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        this.currentIndex = index;
        return true;
    }

    @Override
    public void encodeByteArray(@NotNull ByteBuffer buffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        this.builder.add(buffer);
    }

    @Override
    public void encodeFixed(@NotNull GenericFixed fixed) {
        Intrinsics.checkParameterIsNotNull((Object)fixed, (String)"fixed");
        this.builder.add(fixed);
    }

    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkParameterIsNotNull((Object)enumDescriptor, (String)"enumDescriptor");
        this.builder.add(ValueToEnum.INSTANCE.toValue(this.fieldSchema(), enumDescriptor, index));
    }

    @Override
    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        return new AnnotationExtractor(descriptor2.getAnnotations()).valueType() ? (CompositeEncoder)this : StructureEncoder.DefaultImpls.beginStructure(this, descriptor2);
    }

    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        this.callback.invoke((Object)this.builder.record());
    }

    public void encodeNull() {
        this.builder.add(null);
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @NotNull
    public final Function1<Record, Unit> getCallback() {
        return this.callback;
    }

    public RecordEncoder(@NotNull Schema schema, @NotNull SerializersModule serializersModule, @NotNull Function1<? super Record, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.schema = schema;
        this.serializersModule = serializersModule;
        this.callback = callback;
        this.builder = new RecordBuilder(this.schema);
        this.currentIndex = -1;
    }
}

