/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k.encoder;

import com.sksamuel.avro4k.encoder.StringToAvroValue;
import com.sksamuel.avro4k.encoder.StructureEncoder;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.util.Utf8;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u001c\u0010\b\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u0010\u0010$\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010%\u001a\u00020\u0005H\u0016R$\u0010\b\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/sksamuel/avro4k/encoder/MapEncoder;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "Lkotlinx/serialization/encoding/CompositeEncoder;", "Lcom/sksamuel/avro4k/encoder/StructureEncoder;", "schema", "Lorg/apache/avro/Schema;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "callback", "Lkotlin/Function1;", "", "Lorg/apache/avro/util/Utf8;", "", "(Lorg/apache/avro/Schema;Lkotlinx/serialization/modules/SerializersModule;Lkotlin/jvm/functions/Function1;)V", "key", "map", "", "", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "valueSchema", "kotlin.jvm.PlatformType", "addValue", "value", "beginStructure", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "encodeByteArray", "buffer", "Ljava/nio/ByteBuffer;", "encodeFixed", "fixed", "Lorg/apache/avro/generic/GenericFixed;", "encodeString", "", "encodeValue", "endStructure", "fieldSchema", "avro4k-core"})
public final class MapEncoder
extends AbstractEncoder
implements CompositeEncoder,
StructureEncoder {
    private final Map<Utf8, Object> map;
    private Utf8 key;
    private final Schema valueSchema;
    @NotNull
    private final SerializersModule serializersModule;
    private final Function1<Map<Utf8, ?>, Unit> callback;

    public void encodeString(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Utf8 k = this.key;
        if (k == null) {
            this.key = new Utf8(value);
        } else {
            Schema schema = this.valueSchema;
            Intrinsics.checkExpressionValueIsNotNull((Object)schema, (String)"valueSchema");
            this.map.put(k, StringToAvroValue.INSTANCE.toValue(schema, value));
            this.key = null;
        }
    }

    public void encodeValue(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Utf8 k = this.key;
        if (k == null) {
            throw (Throwable)new SerializationException("Expected key but received value " + value);
        }
        this.map.put(k, value);
        this.key = null;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        this.callback.invoke((Object)MapsKt.toMap(this.map));
    }

    @Override
    public void encodeByteArray(@NotNull ByteBuffer buffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        this.encodeValue(buffer);
    }

    @Override
    public void encodeFixed(@NotNull GenericFixed fixed) {
        Intrinsics.checkParameterIsNotNull((Object)fixed, (String)"fixed");
        this.encodeValue(fixed);
    }

    @Override
    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        return StructureEncoder.DefaultImpls.beginStructure(this, descriptor2);
    }

    @Override
    public void addValue(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.encodeValue(value);
    }

    @Override
    @NotNull
    public Schema fieldSchema() {
        Schema schema = this.valueSchema;
        Intrinsics.checkExpressionValueIsNotNull((Object)schema, (String)"valueSchema");
        return schema;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public MapEncoder(@NotNull Schema schema, @NotNull SerializersModule serializersModule, @NotNull Function1<? super Map<Utf8, ?>, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.serializersModule = serializersModule;
        this.callback = callback;
        boolean bl = false;
        this.map = new LinkedHashMap();
        this.valueSchema = schema.getValueType();
    }
}

