/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.avro4k.encoder;

import com.sksamuel.avro4k.encoder.ByteArrayEncoder$WhenMappings;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/sksamuel/avro4k/encoder/ByteArrayEncoder;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "schema", "Lorg/apache/avro/Schema;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "callback", "Lkotlin/Function1;", "", "", "(Lorg/apache/avro/Schema;Lkotlinx/serialization/modules/SerializersModule;Lkotlin/jvm/functions/Function1;)V", "bytes", "", "", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "encodeByte", "value", "endStructure", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "avro4k-core"})
public final class ByteArrayEncoder
extends AbstractEncoder {
    private final List<Byte> bytes;
    private final Schema schema;
    @NotNull
    private final SerializersModule serializersModule;
    private final Function1<Object, Unit> callback;

    public void encodeByte(byte value) {
        this.bytes.add(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Schema.Type type = this.schema.getType();
        if (type == null) throw (Throwable)new SerializationException("Cannot encode byte array when schema is " + this.schema.getType());
        switch (ByteArrayEncoder$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                byte[] byArray;
                int padding = this.schema.getFixedSize() - this.bytes.size();
                ByteBuffer byteBuffer = ByteBuffer.allocate(this.schema.getFixedSize());
                byte[] byArray2 = new byte[padding];
                int n = 0;
                while (n < padding) {
                    byte by;
                    int n2 = n;
                    int n3 = n++;
                    byArray = byArray2;
                    boolean bl = false;
                    byArray[n3] = by = 0;
                }
                byArray = byArray2;
                byte[] padded = byteBuffer.put(byArray).put(CollectionsKt.toByteArray((Collection)this.bytes)).array();
                Object object = GenericData.get().createFixed(null, padded, this.schema);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"GenericData.get().create\u2026xed(null, padded, schema)");
                this.callback.invoke(object);
                return;
            }
            case 2: {
                ByteBuffer byteBuffer = ByteBuffer.wrap(CollectionsKt.toByteArray((Collection)this.bytes));
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(bytes.toByteArray())");
                this.callback.invoke((Object)byteBuffer);
                return;
            }
            default: {
                throw (Throwable)new SerializationException("Cannot encode byte array when schema is " + this.schema.getType());
            }
        }
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public ByteArrayEncoder(@NotNull Schema schema, @NotNull SerializersModule serializersModule, @NotNull Function1<Object, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.schema = schema;
        this.serializersModule = serializersModule;
        this.callback = callback;
        boolean bl = false;
        this.bytes = new ArrayList();
    }
}

